/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.compiere.model.MPeriod;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CacheMgt;
import org.compiere.util.DB;

public class PeriodStatus
extends SvrProcess {
    private int p_C_Period_ID = 0;
    private String p_PeriodAction = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("PeriodAction")) {
                    this.p_PeriodAction = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_C_Period_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("C_Period_ID=" + this.p_C_Period_ID + ", PeriodAction=" + this.p_PeriodAction);
        MPeriod period = new MPeriod(this.getCtx(), this.p_C_Period_ID, this.get_TrxName());
        if (period.get_ID() == 0) {
            throw new AdempiereUserError("@NotFound@  @C_Period_ID@=" + this.p_C_Period_ID);
        }
        if (!this.preRequitos(period)) {
            if ("O".equals(this.p_PeriodAction)) {
                throw new AdempiereUserError("No se puede abrir el periodo si existen periodos superiores cerrados");
            }
            if ("C".equals(this.p_PeriodAction)) {
                throw new AdempiereUserError("No se puede cerrar el periodo si existen periodos inferiores abiertos");
            }
        }
        StringBuffer sql = new StringBuffer("UPDATE C_PeriodControl ");
        sql.append("SET PeriodStatus='");
        if ("O".equals(this.p_PeriodAction)) {
            sql.append("O");
        } else if ("C".equals(this.p_PeriodAction)) {
            sql.append("C");
        } else if ("P".equals(this.p_PeriodAction)) {
            sql.append("P");
        } else {
            return "-";
        }
        sql.append("', PeriodAction='N', Updated=SysDate,UpdatedBy=").append(this.getAD_User_ID());
        sql.append(" WHERE C_Period_ID=").append(period.getC_Period_ID()).append(" AND PeriodStatus<>'P'").append(" AND PeriodStatus<>'").append(this.p_PeriodAction).append("'");
        int no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        CacheMgt.get().reset("C_PeriodControl", 0);
        CacheMgt.get().reset("C_Period", this.p_C_Period_ID);
        if ("O".equals(this.p_PeriodAction)) {
            period.set_CustomColumn("PeriodStatus", "O");
            period.save();
        } else if ("C".equals(this.p_PeriodAction)) {
            period.set_CustomColumn("PeriodStatus", "C");
            period.save();
        }
        return "@Updated@ #" + no;
    }

    private boolean preRequitos(MPeriod p) {
        int i;
        if (this.p_PeriodAction.equals("O") && (i = DB.getSQLValue(this.get_TrxName(), "Select COUNT(1) from C_Period p Inner Join C_PeriodControl pc on (p.C_Period_ID=pc.C_Period_ID) where C_Year_ID=? and PeriodNo>? and pc.periodstatus='C' ", p.getC_Year_ID(), p.getPeriodNo())) > 0) {
            return false;
        }
        return !this.p_PeriodAction.equals("C") || (i = DB.getSQLValue(this.get_TrxName(), "Select COUNT(1) from C_Period p Inner Join C_PeriodControl pc on (p.C_Period_ID=pc.C_Period_ID) where C_Year_ID=? and PeriodNo<? and pc.periodstatus='O' ", p.getC_Year_ID(), p.getPeriodNo())) <= 0;
    }
}

