/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.compiere.model.MInOut;
import org.compiere.model.MPackage;
import org.compiere.model.MShipper;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class PackageCreate
extends SvrProcess {
    private int p_M_Shipper_ID = 0;
    private int p_M_InOut_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("M_Shipper_ID")) {
                this.p_M_Shipper_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("M_InOut_ID")) {
                this.p_M_InOut_ID = para[i2].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("doIt - M_InOut_ID=" + this.p_M_InOut_ID + ", M_Shipper_ID=" + this.p_M_Shipper_ID);
        if (this.p_M_InOut_ID == 0) {
            throw new IllegalArgumentException("No Shipment");
        }
        if (this.p_M_Shipper_ID == 0) {
            throw new IllegalArgumentException("No Shipper");
        }
        MInOut shipment = new MInOut(this.getCtx(), this.p_M_InOut_ID, null);
        if (shipment.get_ID() != this.p_M_InOut_ID) {
            throw new IllegalArgumentException("Cannot find Shipment ID=" + this.p_M_InOut_ID);
        }
        MShipper shipper = new MShipper(this.getCtx(), this.p_M_Shipper_ID, this.get_TrxName());
        if (shipper.get_ID() != this.p_M_Shipper_ID) {
            throw new IllegalArgumentException("Cannot find Shipper ID=" + this.p_M_InOut_ID);
        }
        MPackage pack = MPackage.create(shipment, shipper, null);
        return pack.getDocumentNo();
    }
}

