/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.X_MP_Maintain;
import org.compiere.model.X_MP_Prognosis;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.ofb.model.OFBForward;

public class MPAssetPlanning
extends SvrProcess {
    int periodNo = 0;
    private int p_PInstance_ID;
    String stringDate;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("PeriodNo")) {
                    this.periodNo = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_PInstance_ID = this.getAD_PInstance_ID();
        this.stringDate = DB.isOracle() ? "sysdate" : "now()";
    }

    @Override
    protected String doIt() throws Exception {
        if (this.periodNo <= 0) {
            throw new AdempiereException("No se puede ejecutar proceso para 0 periodos");
        }
        DB.executeUpdate("DELETE FROM MP_Prognosis", this.get_TrxName());
        StringBuffer byCalendar = new StringBuffer();
        byCalendar.append("SELECT MA.AD_CLIENT_ID,MA.AD_ORG_ID,MA.MP_MAINTAIN_ID,MA.DESCRIPTION,MA.PROGRAMMINGTYPE, A.A_ASSET_ID,DATENEXTRUN ,MA.DATELASTRUN,MA.INTERVAL, MA.MP_MAINTAINDetail_ID");
        byCalendar.append(" FROM MP_MAINTAINDetail MA");
        byCalendar.append(" INNER JOIN A_ASSET A ON (MA.A_ASSET_ID=A.A_ASSET_ID)");
        if (DB.isOracle()) {
            byCalendar.append(" WHERE PROGRAMMINGTYPE='C' AND DATENEXTRUN BETWEEN SYSDATE-60 AND SYSDATE+(7*" + this.periodNo + ")");
        } else {
            byCalendar.append(" WHERE PROGRAMMINGTYPE='C' AND DATENEXTRUN BETWEEN now()-60 AND now()+(7*" + this.periodNo + ")");
        }
        byCalendar.append(" AND MA.DOCSTATUS<>'IT' Order by DATENEXTRUN asc");
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(byCalendar.toString(), this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Calendar datefrom = Calendar.getInstance();
                Calendar dateto = Calendar.getInstance();
                int diaA = 0;
                int period = 1;
                int ciclo = 0;
                while (period <= this.periodNo) {
                    Timestamp currentDate = rs.getTimestamp("DATENEXTRUN");
                    datefrom.add(5, diaA * 7);
                    dateto.add(5, (diaA + 1) * 7);
                    if (currentDate.compareTo(datefrom.getTime()) >= 0 && currentDate.compareTo(dateto.getTime()) <= 0) {
                        ciclo = period;
                    }
                    ++period;
                    ++diaA;
                }
                X_MP_Prognosis mp = new X_MP_Prognosis(this.getCtx(), 0, this.get_TrxName());
                mp.setA_Asset_ID(rs.getInt("A_ASSET_ID"));
                mp.setAD_Org_ID(rs.getInt("AD_ORG_ID"));
                mp.setAD_PInstance_ID(this.p_PInstance_ID);
                mp.setCiclo(ciclo);
                mp.setDateTrx(rs.getTimestamp("DATENEXTRUN"));
                mp.setDescription("Por Calendario :" + rs.getString("DATENEXTRUN"));
                mp.setMP_Maintain_ID(rs.getInt("MP_MAINTAIN_ID"));
                mp.setProgrammingType(rs.getString("PROGRAMMINGTYPE"));
                mp.setSelected(false);
                mp.set_CustomColumn("MP_MaintainDetail_ID", rs.getInt("MP_MaintainDetail_ID"));
                mp.saveEx();
            }
            rs.close();
            pstmt.close();
            pstmt = null;
            this.commitEx();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        StringBuffer byMeter = new StringBuffer();
        byMeter.append("SELECT MA.AD_CLIENT_ID,MA.AD_ORG_ID,MA.MP_MAINTAIN_ID,MA.DESCRIPTION,MA.PROGRAMMINGTYPE, A.A_ASSET_ID,MA.MP_METER_ID, MA.RANGE, MA.NEXTMP");
        byMeter.append(", (select MIN(log2.DateTrx) from MP_AssetMeter_Log log2 where  ME.MP_ASSETMETER_ID=log2.MP_ASSETMETER_ID");
        byMeter.append(" and log2.DateTrx BETWEEN (Sysdate-40) AND sysdate)as FirstDay, ");
        byMeter.append(" (select MAX(log2.DateTrx) from MP_AssetMeter_Log log2 where  ME.MP_ASSETMETER_ID=log2.MP_ASSETMETER_ID");
        byMeter.append(" and log2.DateTrx BETWEEN (Sysdate-40) AND sysdate) as LastDay, ");
        byMeter.append(" Count(1)as Qty,ME.MP_ASSETMETER_ID,MS.Name, MA.MP_MAINTAINDetail_ID");
        byMeter.append(" FROM MP_MAINTAINDetail MA");
        byMeter.append(" INNER JOIN MP_Maintain mp2 ON (MA.MP_Maintain_ID = mp2.MP_Maintain_ID)");
        byMeter.append(" INNER JOIN A_ASSET A ON (MA.A_ASSET_ID=A.A_ASSET_ID)");
        byMeter.append(" INNER JOIN MP_METER MS ON (MA.MP_METER_ID=MS.MP_METER_ID)");
        byMeter.append(" INNER JOIN MP_ASSETMETER ME ON (MS.MP_METER_ID=ME.MP_METER_ID and a.a_asset_id= me.a_asset_id)");
        byMeter.append(" INNER JOIN MP_AssetMeter_Log MLOG ON (ME.MP_ASSETMETER_ID=MLOG.MP_ASSETMETER_ID)");
        byMeter.append(" WHERE MA.PROGRAMMINGTYPE='M' AND MA.DOCSTATUS<>'IT'");
        byMeter.append(" AND MA.ISACTIVE = 'Y' AND mp2.ISACTIVE = 'Y' ");
        byMeter.append(" AND A.ISACTIVE = 'Y' ");
        if (DB.isOracle()) {
            byMeter.append(" AND Mlog.DateTrx BETWEEN (Sysdate-40) AND sysdate");
        } else {
            byMeter.append(" AND Mlog.DateTrx BETWEEN (now()-40) AND now()");
        }
        byMeter.append(" AND MA.NEXTMP IS NOT NULL ");
        byMeter.append(" AND MS.IsActive = 'Y' AND ME.IsActive = 'Y' ");
        byMeter.append(" Group by MA.AD_CLIENT_ID,MA.AD_ORG_ID,MA.MP_MAINTAIN_ID,MA.DESCRIPTION,MA.PROGRAMMINGTYPE, A.A_ASSET_ID,MA.MP_METER_ID,MA.RANGE, MA.NEXTMP,ME.MP_ASSETMETER_ID,MS.Name, MA.MP_MAINTAINDetail_ID");
        pstmt = null;
        try {
            pstmt = DB.prepareStatement(byMeter.toString(), this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if (rs.getInt("A_ASSET_ID") == 1000702) {
                    this.log.config("stop para debug");
                }
                boolean cumple = false;
                float lastM = 0.0f;
                float firstM = 0.0f;
                float prom = 0.0f;
                if (rs.getInt("Qty") <= 1) continue;
                this.log.info("ReadingLastM");
                Object[] params = new Object[]{rs.getInt("A_ASSET_ID"), rs.getInt("MP_Meter_ID"), rs.getTimestamp("LastDay")};
                this.log.info("ReadingFirstM:" + rs.getInt("A_ASSET_ID") + "-" + rs.getInt("MP_Meter_ID") + "-" + rs.getTimestamp("LastDay"));
                lastM = DB.getSQLValueBD(this.get_TrxName(), " SELECT mlog.CurrentAmt FROM MP_AssetMeter_Log mlog Inner join MP_AssetMeter met on (mlog.MP_AssetMeter_ID=met.MP_AssetMeter_ID) WHERE met.A_ASSET_ID=? AND met.MP_Meter_ID=? AND mlog.DATETRX=? ", params).floatValue();
                this.log.info("ReadingFirstM:" + rs.getInt("A_ASSET_ID") + "-" + rs.getInt("MP_Meter_ID") + "-" + rs.getTimestamp("FIRSTDAY"));
                params = new Object[]{rs.getInt("A_ASSET_ID"), rs.getInt("MP_Meter_ID"), rs.getTimestamp("FIRSTDAY")};
                firstM = DB.getSQLValueBD(this.get_TrxName(), "SELECT mlog.CurrentAmt  FROM MP_AssetMeter_Log mlog Inner join MP_AssetMeter met on (mlog.MP_AssetMeter_ID=met.MP_AssetMeter_ID) WHERE met.A_ASSET_ID=? AND met.MP_Meter_ID=? AND mlog.DATETRX=?", params).floatValue();
                float days = Math.abs(rs.getTimestamp("LastDay").getTime() - rs.getTimestamp("FIRSTDAY").getTime());
                prom = (lastM - firstM) / (days / 8.64E7f);
                if ((double)prom == Double.NaN) {
                    this.log.config("Activo con problemas" + rs.getInt("A_ASSET_ID"));
                    throw new AdempiereException("Activo con problemas: " + rs.getInt("A_ASSET_ID") + " Favor Revisar");
                }
                StringBuffer update = new StringBuffer();
                update.append("UPDATE MP_MAINTAINDetail ");
                update.append(" SET PROMUSE=" + prom + ", lastread=" + lastM);
                update.append(" WHERE MP_MAINTAINDetail_ID=" + rs.getInt("MP_MAINTAINDetail_ID"));
                DB.executeUpdate(update.toString(), this.get_TrxName());
                int cont = 0;
                cumple = false;
                Calendar dateExe = Calendar.getInstance();
                dateExe.setTime(rs.getTimestamp("LastDay"));
                this.log.info("LoopMedidor");
                do {
                    if (lastM >= rs.getFloat("NEXTMP") - rs.getFloat("RANGE") && lastM <= rs.getFloat("NEXTMP") + rs.getFloat("RANGE") || lastM > rs.getFloat("NEXTMP")) {
                        cumple = true;
                        dateExe.add(5, cont);
                        continue;
                    }
                    lastM += prom;
                    ++cont;
                } while (!cumple && cont != 10 * this.periodNo);
                Timestamp currentDate = new Timestamp(dateExe.getTimeInMillis());
                if (!cumple && !(lastM > rs.getFloat("NEXTMP"))) continue;
                int ciclo = 0;
                int period = 1;
                Calendar datefrom = Calendar.getInstance();
                Calendar dateto = Calendar.getInstance();
                int diaA = 0;
                while (period <= this.periodNo) {
                    datefrom.add(5, diaA * 7);
                    dateto.add(5, (diaA + 1) * 7);
                    if (currentDate.compareTo(datefrom.getTime()) >= 0 && currentDate.compareTo(dateto.getTime()) <= 0) {
                        ciclo = period;
                    }
                    ++period;
                    ++diaA;
                }
                this.log.info("Insertmeter");
                X_MP_Prognosis mp = new X_MP_Prognosis(this.getCtx(), 0, this.get_TrxName());
                mp.setA_Asset_ID(rs.getInt("A_ASSET_ID"));
                mp.setAD_Org_ID(rs.getInt("AD_ORG_ID"));
                mp.setAD_PInstance_ID(this.p_PInstance_ID);
                mp.setCiclo(ciclo);
                mp.setDateTrx(currentDate);
                mp.setDescription(String.valueOf(ciclo == 0 ? "by Meter behind schedule" : "by Meter") + rs.getString("name") + ":" + lastM);
                mp.setMP_Maintain_ID(rs.getInt("MP_MAINTAIN_ID"));
                mp.setProgrammingType(rs.getString("PROGRAMMINGTYPE"));
                mp.setSelected(false);
                mp.set_CustomColumn("MP_MaintainDetail_ID", rs.getInt("MP_MaintainDetail_ID"));
                mp.saveEx();
            }
            this.commitEx();
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        this.log.info("Correccion para anidados");
        String sql = "select * from MP_Prognosis where AD_PINSTANCE_ID=" + this.p_PInstance_ID + " and PROGRAMMINGTYPE='M' " + " ORDER BY MP_Maintain_ID DESC";
        String upMParent = "";
        pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if (OFBForward.NewUpdateMaintainceParent()) {
                    X_MP_Maintain mainUp = new X_MP_Maintain(this.getCtx(), rs.getInt("MP_MAINTAIN_ID"), this.get_TrxName());
                    upMParent = "UPDATE MP_Prognosis SET SELECTED='Y' WHERE MP_MAINTAIN_ID IN (SELECT MP_MaintainRef_ID FROM MP_MaintainParent mp INNER JOIN MP_Maintain m ON (mp.MP_MaintainRef_ID = m.MP_Maintain_ID)  WHERE mp.MP_Maintain_ID = " + rs.getInt("MP_MAINTAIN_ID") + " AND m.interval < " + mainUp.getInterval().intValue() + ")" + " AND A_Asset_ID = " + rs.getInt("A_ASSET_ID") + " AND AD_PINSTANCE_ID = " + this.p_PInstance_ID;
                    this.log.config("sql update maintaince parent tsm: " + upMParent);
                    DB.executeUpdate(upMParent, this.get_TrxName());
                    continue;
                }
                int MP_ID = DB.getSQLValue(this.get_TrxName(), "SELECT P.MP_MAINTAIN_ID  FROM MP_Prognosis P INNER JOIN MP_MAINTAINDetail M ON (P.MP_MAINTAINDetail_ID=M.MP_MAINTAINDetail_ID) WHERE M.MP_MAINTAINPARENT_ID=" + rs.getInt("MP_MAINTAIN_ID") + "AND P.A_ASSET_ID=" + rs.getInt("A_ASSET_ID") + " AND P.AD_PINSTANCE_ID=" + this.p_PInstance_ID);
                while (MP_ID > 0) {
                    DB.executeUpdate("UPDATE MP_Prognosis SET SELECTED='Y' WHERE A_ASSET_ID=" + rs.getInt("A_ASSET_ID") + "AND " + "MP_MAINTAIN_ID=" + MP_ID + " AND " + "AD_PINSTANCE_ID=" + this.p_PInstance_ID + " AND CICLO=" + rs.getInt("ciclo"), this.get_TrxName());
                    MP_ID = DB.getSQLValue(this.get_TrxName(), "SELECT P.MP_MAINTAIN_ID  FROM MP_Prognosis P INNER JOIN MP_MAINTAINDetail M ON (P.MP_MAINTAINDetail_ID=M.MP_MAINTAINDetail_ID) WHERE M.MP_MAINTAINPARENT_ID=" + MP_ID + "AND P.A_ASSET_ID=" + rs.getInt("A_ASSET_ID") + " AND P.AD_PINSTANCE_ID=" + this.p_PInstance_ID);
                }
            }
            rs.close();
            pstmt.close();
            pstmt = null;
            this.commitEx();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return "";
    }
}

