/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MPeriod;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;

public class LibroMayor
extends SvrProcess {
    private int Org_ID = 0;
    private int Period_ID = 0;
    private int p_PInstance_ID = 0;
    private int p_Account_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Org_ID")) {
                    this.Org_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_Period_ID")) {
                    this.Period_ID = para[i].getParameterAsInt();
                } else if (name.equals("Account_ID")) {
                    this.p_Account_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_PInstance_ID = this.getAD_PInstance_ID();
    }

    @Override
    protected String doIt() throws AdempiereSystemError {
        DB.executeUpdate("DELETE FROM T_LIBROMAYOR", this.get_TrxName());
        String accountlist = new String("SELECT AD_CLIENT_ID,AD_ORG_ID,ACCOUNT_ID,ACCOUNTVALUE ,NAME, Account_ID FROM RV_FACT_ACCT rf WHERE DateAcct BETWEEN ? AND ? AND (AD_Org_ID=" + this.Org_ID + " OR AD_Org_ID in (Select oi.AD_ORG_ID from AD_orginfo oi where oi.PARENT_ORG_ID=" + this.Org_ID + ") )" + "GROUP BY AD_CLIENT_ID,AD_ORG_ID,ACCOUNT_ID,ACCOUNTVALUE ,NAME " + "ORDER BY ACCOUNTVALUE ASC");
        String PeriodMov = new String("SELECT ACCOUNT_ID,TRUNC(DATEACCT)AS DATEACCT,SUM(AMTACCTDR) AS AMTACCTDR,SUM(AMTACCTCR) AS AMTACCTCR,ACCOUNTVALUE ,NAME FROM RV_FACT_ACCT rf WHERE C_PERIOD_ID=? AND ACCOUNT_ID=? AND (AD_Org_ID=" + this.Org_ID + " OR AD_Org_ID in (Select oi.AD_ORG_ID from AD_orginfo oi where oi.PARENT_ORG_ID=" + this.Org_ID + ") )" + "GROUP BY ACCOUNT_ID,TRUNC(DATEACCT),ACCOUNTVALUE ,NAME " + "ORDER BY DATEACCT ASC");
        MPeriod periodEnd = new MPeriod(this.getCtx(), this.Period_ID, this.get_TrxName());
        MPeriod periodStart = MPeriod.getFirstInYear(this.getCtx(), periodEnd.getStartDate());
        MPeriod periodAnt = null;
        if (periodEnd.getPeriodNo() > 1) {
            periodAnt = this.getPeriodAnt(periodEnd);
        }
        int LineNo = 1;
        double ACUMD = 0.0;
        double ACUMC = 0.0;
        BigDecimal BACUMD = new BigDecimal(0);
        BigDecimal BACUMC = new BigDecimal(0);
        double SALDOD = 0.0;
        double SALDOC = 0.0;
        double TOTALD = 0.0;
        double TOTALC = 0.0;
        double SALDOFD = 0.0;
        double SALDOFC = 0.0;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(accountlist, this.get_TrxName());
            pstmt.setTimestamp(1, periodStart.getStartDate());
            pstmt.setTimestamp(2, periodEnd.getEndDate());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String sysdate = "TO_DATE('" + TimeUtil.getToday().get(1) + "-" + TimeUtil.getToday().get(2) + "-" + TimeUtil.getToday().get(5) + "','YYYY-MM-DD')";
                String Insert = new String("INSERT INTO T_LIBROMAYOR(AD_CLIENT_ID,AD_ORG_ID,CREATED,UPDATED,CREATEDBY,UPDATEDBY,DESCRIP1,DESCRIP2,AMTACCTDR,AMTACCTCR,LINENO,C_PERIOD_ID) VALUES (" + rs.getInt("AD_CLIENT_ID") + "," + this.Org_ID + "," + sysdate + "," + sysdate + ",100,100,'" + rs.getString("ACCOUNTVALUE") + "','" + rs.getString("NAME") + "',NULL,NULL," + LineNo + "," + this.Period_ID + ")");
                DB.executeUpdate(Insert, this.get_TrxName());
                ++LineNo;
                ACUMD = 0.0;
                ACUMC = 0.0;
                if (periodEnd.getPeriodNo() > 1) {
                    BACUMD = new BigDecimal(0);
                    BACUMC = new BigDecimal(0);
                    BigDecimal[] valAcums = this.getAcum(periodStart.getStartDate(), periodAnt.getEndDate(), rs.getInt("Account_ID"));
                    BACUMD = valAcums[0];
                    BACUMC = valAcums[1];
                    ACUMD = BACUMD.doubleValue();
                    ACUMC = BACUMC.doubleValue();
                } else {
                    ACUMD = 0.0;
                    ACUMC = 0.0;
                }
                Insert = "INSERT INTO T_LIBROMAYOR(AD_CLIENT_ID,AD_ORG_ID,CREATED,UPDATED,CREATEDBY,UPDATEDBY,DESCRIP1,DESCRIP2,AMTACCTDR,AMTACCTCR,LINENO,C_PERIOD_ID) VALUES (" + rs.getInt("AD_CLIENT_ID") + "," + this.Org_ID + "," + sysdate + "," + sysdate + ",100,100,NULL," + "'ACUMULADO AL : " + periodAnt.getEndDate().toString().substring(0, 10) + "'," + ACUMD + "," + ACUMC + "," + LineNo + "," + this.Period_ID + ")";
                DB.executeUpdate(Insert, this.get_TrxName());
                ++LineNo;
                SALDOD = 0.0;
                SALDOC = 0.0;
                if (ACUMD > ACUMC) {
                    SALDOD = 0.0;
                    SALDOC = ACUMD - ACUMC;
                } else {
                    SALDOD = ACUMC - ACUMD;
                    SALDOC = 0.0;
                }
                Insert = "INSERT INTO T_LIBROMAYOR(AD_CLIENT_ID,AD_ORG_ID,CREATED,UPDATED,CREATEDBY,UPDATEDBY,DESCRIP1,DESCRIP2,AMTACCTDR,AMTACCTCR,LINENO,C_PERIOD_ID) VALUES (" + rs.getInt("AD_CLIENT_ID") + "," + this.Org_ID + "," + sysdate + "," + sysdate + ",100,100,NULL," + "'SALDO AL : " + periodAnt.getEndDate().toString().substring(0, 10) + "'," + SALDOD + "," + SALDOC + "," + LineNo + "," + this.Period_ID + ")";
                DB.executeUpdate(Insert, this.get_TrxName());
                ++LineNo;
                TOTALD = ACUMD;
                TOTALC = ACUMC;
                CPreparedStatement pstmt2 = DB.prepareStatement(PeriodMov, this.get_TrxName());
                pstmt2.setInt(1, this.Period_ID);
                pstmt2.setInt(2, rs.getInt("Account_ID"));
                ResultSet rs2 = pstmt2.executeQuery();
                while (rs2.next()) {
                    String tempDate = rs2.getString("DATEACCT");
                    if (tempDate.length() > 10) {
                        tempDate = tempDate.substring(0, 10);
                    }
                    Insert = "INSERT INTO T_LIBROMAYOR(AD_CLIENT_ID,AD_ORG_ID,CREATED,UPDATED,CREATEDBY,UPDATEDBY,DESCRIP1,DESCRIP2,AMTACCTDR,AMTACCTCR,LINENO,C_PERIOD_ID) VALUES (" + rs.getInt("AD_CLIENT_ID") + "," + this.Org_ID + "," + sysdate + "," + sysdate + ",100,100,'" + tempDate + "','" + rs2.getString("NAME") + "'," + rs2.getDouble("AMTACCTDR") + "," + rs2.getDouble("AMTACCTCR") + "," + LineNo + "," + this.Period_ID + ")";
                    DB.executeUpdate(Insert, this.get_TrxName());
                    ++LineNo;
                    TOTALD += rs2.getDouble("AMTACCTDR");
                    TOTALC += rs2.getDouble("AMTACCTCR");
                }
                rs2.close();
                pstmt2.close();
                pstmt2 = null;
                Insert = "INSERT INTO T_LIBROMAYOR(AD_CLIENT_ID,AD_ORG_ID,CREATED,UPDATED,CREATEDBY,UPDATEDBY,DESCRIP1,DESCRIP2,AMTACCTDR,AMTACCTCR,LINENO,C_PERIOD_ID) VALUES (" + rs.getInt("AD_CLIENT_ID") + "," + this.Org_ID + "," + sysdate + "," + sysdate + ",100,100,NULL,'" + "TOTAL AL : " + periodEnd.getEndDate().toString().substring(0, 10) + "'," + TOTALD + "," + TOTALC + "," + LineNo + "," + this.Period_ID + ")";
                DB.executeUpdate(Insert, this.get_TrxName());
                ++LineNo;
                SALDOFD = 0.0;
                SALDOFC = 0.0;
                if (TOTALD > TOTALC) {
                    SALDOFD = 0.0;
                    SALDOFC = TOTALD - TOTALC;
                } else {
                    SALDOFD = TOTALC - TOTALD;
                    SALDOFC = 0.0;
                }
                Insert = "INSERT INTO T_LIBROMAYOR(AD_CLIENT_ID,AD_ORG_ID,CREATED,UPDATED,CREATEDBY,UPDATEDBY,DESCRIP1,DESCRIP2,AMTACCTDR,AMTACCTCR,LINENO,C_PERIOD_ID) VALUES (" + rs.getInt("AD_CLIENT_ID") + "," + this.Org_ID + "," + sysdate + "," + sysdate + ",100,100,NULL,'" + "SALDO AL : " + periodEnd.getEndDate().toString().substring(0, 10) + "'," + SALDOFD + "," + SALDOFC + "," + LineNo + "," + this.Period_ID + ")";
                DB.executeUpdate(Insert, this.get_TrxName());
                Insert = "INSERT INTO T_LIBROMAYOR(AD_CLIENT_ID,AD_ORG_ID,CREATED,UPDATED,CREATEDBY,UPDATEDBY,DESCRIP1,DESCRIP2,AMTACCTDR,AMTACCTCR,LINENO,C_PERIOD_ID) VALUES (" + rs.getInt("AD_CLIENT_ID") + "," + this.Org_ID + "," + sysdate + "," + sysdate + ",100,100,NULL, NULL ,NULL,NULL," + ++LineNo + "," + this.Period_ID + ")";
                DB.executeUpdate(Insert, this.get_TrxName());
                ++LineNo;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        DB.executeUpdate("UPDATE T_LIBROMAYOR SET AD_PInstance_ID=" + this.p_PInstance_ID, this.get_TrxName());
        return "";
    }

    public BigDecimal[] getAcum(Timestamp dateFrom, Timestamp dateTo, int Account_ID) {
        CPreparedStatement pstmt = null;
        BigDecimal[] reValue = new BigDecimal[]{new BigDecimal(0), new BigDecimal(0)};
        String mysql = "SELECT coalesce(SUM(AMTACCTDR),0), coalesce(SUM(AMTACCTCR),0) \tFROM RV_FACT_ACCT\tWHERE DateAcct BETWEEN ? AND ? AND Account_ID=? AND (AD_Org_ID=" + this.Org_ID + " OR AD_Org_ID in (Select oi.AD_ORG_ID from AD_orginfo oi where oi.PARENT_ORG_ID=" + this.Org_ID + ") )";
        try {
            pstmt = DB.prepareStatement(mysql, this.get_TrxName());
            pstmt.setTimestamp(1, dateFrom);
            pstmt.setTimestamp(2, dateTo);
            pstmt.setInt(3, Account_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                reValue[0] = rs.getBigDecimal(1);
                reValue[1] = rs.getBigDecimal(2);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return reValue;
    }

    public MPeriod getPeriodAnt(MPeriod actual) {
        MPeriod retValue = null;
        CPreparedStatement pstmt = null;
        String mysql = "SELECT * from C_Period where C_Year_ID=? and PeriodNo=?";
        try {
            pstmt = DB.prepareStatement(mysql, this.get_TrxName());
            pstmt.setInt(1, actual.getC_Year_ID());
            pstmt.setInt(2, actual.getPeriodNo() - 1);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MPeriod(this.getCtx(), rs, this.get_TrxName());
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return retValue;
    }
}

