/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MBankStatement;
import org.compiere.model.MCash;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MInventory;
import org.compiere.model.MInvoice;
import org.compiere.model.MJournal;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MMovement;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.MProjectIssue;
import org.compiere.model.MRequisition;
import org.compiere.model.X_M_Production;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;
import org.eevolution.model.X_DD_Order;
import org.eevolution.model.X_HR_Process;
import org.eevolution.model.X_PP_Order;

public class FactAcctReset
extends SvrProcess {
    private int p_AD_Client_ID = 0;
    private int p_AD_Table_ID = 0;
    private boolean p_DeletePosting = false;
    private int m_countReset = 0;
    private int m_countDelete = 0;
    private Timestamp p_DateAcct_From = null;
    private Timestamp p_DateAcct_To = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("AD_Client_ID")) {
                this.p_AD_Client_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("AD_Table_ID")) {
                this.p_AD_Table_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("DeletePosting")) {
                this.p_DeletePosting = "Y".equals(para[i2].getParameter());
                continue;
            }
            if (name.equals("DateAcct")) {
                this.p_DateAcct_From = (Timestamp)para[i2].getParameter();
                this.p_DateAcct_To = (Timestamp)para[i2].getParameter_To();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("AD_Client_ID=" + this.p_AD_Client_ID + ", AD_Table_ID=" + this.p_AD_Table_ID + ", DeletePosting=" + this.p_DeletePosting);
        String sql = "SELECT AD_Table_ID, TableName FROM AD_Table t WHERE t.IsView='N'";
        if (this.p_AD_Table_ID > 0) {
            sql = sql + " AND t.AD_Table_ID=" + this.p_AD_Table_ID;
        }
        sql = sql + " AND EXISTS (SELECT * FROM AD_Column c WHERE t.AD_Table_ID=c.AD_Table_ID AND c.ColumnName='Posted' AND c.IsActive='Y')";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int AD_Table_ID = rs.getInt(1);
                String TableName = rs.getString(2);
                if (this.p_DeletePosting) {
                    this.delete(TableName, AD_Table_ID);
                    continue;
                }
                this.reset(TableName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return "@Updated@ = " + this.m_countReset + ", @Deleted@ = " + this.m_countDelete;
    }

    private void reset(String TableName) {
        int invalid;
        String sql = "UPDATE " + TableName + " SET Processing='N' WHERE AD_Client_ID=" + this.p_AD_Client_ID + " AND (Processing<>'N' OR Processing IS NULL)";
        int unlocked = DB.executeUpdate(sql, this.get_TrxName());
        if (unlocked + (invalid = DB.executeUpdate(sql = "UPDATE " + TableName + " SET Posted='N' WHERE AD_Client_ID=" + this.p_AD_Client_ID + " AND (Posted NOT IN ('Y','N') OR Posted IS NULL) AND Processed='Y'", this.get_TrxName())) != 0) {
            this.log.fine(TableName + " - Unlocked=" + unlocked + " - Invalid=" + invalid);
        }
        this.m_countReset += unlocked + invalid;
    }

    private void delete(String TableName, int AD_Table_ID) {
        boolean autoPeriod;
        Timestamp today = TimeUtil.trunc(new Timestamp(System.currentTimeMillis()), "D");
        MAcctSchema as = MClient.get(this.getCtx(), this.getAD_Client_ID()).getAcctSchema();
        boolean bl = autoPeriod = as != null && as.isAutoPeriodControl();
        if (autoPeriod) {
            Timestamp temp = TimeUtil.addDays(today, -as.getPeriod_OpenHistory());
            if (this.p_DateAcct_From == null || this.p_DateAcct_From.before(temp)) {
                this.p_DateAcct_From = temp;
                this.log.info("DateAcct From set to: " + this.p_DateAcct_From);
            }
            temp = TimeUtil.addDays(today, as.getPeriod_OpenFuture());
            if (this.p_DateAcct_To == null || this.p_DateAcct_To.after(temp)) {
                this.p_DateAcct_To = temp;
                this.log.info("DateAcct To set to: " + this.p_DateAcct_To);
            }
        }
        this.reset(TableName);
        this.m_countReset = 0;
        String docBaseType = null;
        if (AD_Table_ID == MInvoice.Table_ID) {
            docBaseType = "IN ('API','APC','ARI','ARC','ARF')";
        } else if (AD_Table_ID == MInOut.Table_ID) {
            docBaseType = "IN ('MMS','MMR')";
        } else if (AD_Table_ID == MPayment.Table_ID) {
            docBaseType = "IN ('APP','ARR')";
        } else if (AD_Table_ID == MOrder.Table_ID) {
            docBaseType = "IN ('SOO','POO')";
        } else if (AD_Table_ID == MProjectIssue.Table_ID) {
            docBaseType = "= 'PJI'";
        } else if (AD_Table_ID == MBankStatement.Table_ID) {
            docBaseType = "= 'CMB'";
        } else if (AD_Table_ID == MCash.Table_ID) {
            docBaseType = "= 'CMC'";
        } else if (AD_Table_ID == MAllocationHdr.Table_ID) {
            docBaseType = "= 'CMA'";
        } else if (AD_Table_ID == MJournal.Table_ID) {
            docBaseType = "= 'GLJ'";
        } else if (AD_Table_ID == MMovement.Table_ID) {
            docBaseType = "= 'MMM'";
        } else if (AD_Table_ID == MRequisition.Table_ID) {
            docBaseType = "= 'POR'";
        } else if (AD_Table_ID == MInventory.Table_ID) {
            docBaseType = "= 'MMI'";
        } else if (AD_Table_ID == X_M_Production.Table_ID) {
            docBaseType = "= 'MMP'";
        } else if (AD_Table_ID == MMatchInv.Table_ID) {
            docBaseType = "= 'MXI'";
        } else if (AD_Table_ID == MMatchPO.Table_ID) {
            docBaseType = "= 'MXP'";
        } else if (AD_Table_ID == X_PP_Order.Table_ID) {
            docBaseType = "IN ('MOP','MOF','MQO')";
        } else if (AD_Table_ID == X_DD_Order.Table_ID) {
            docBaseType = "= 'DOO'";
        } else if (AD_Table_ID == X_HR_Process.Table_ID) {
            docBaseType = "= 'HRP'";
        }
        if (docBaseType == null) {
            String s = TableName + ": Unknown DocBaseType";
            this.log.severe(s);
            this.addLog(s);
            docBaseType = "";
            return;
        }
        docBaseType = " AND pc.DocBaseType " + docBaseType;
        String sql1 = "UPDATE " + TableName + " SET Posted='N', Processing='N' " + "WHERE AD_Client_ID=" + this.p_AD_Client_ID + " AND (Posted<>'N' OR Posted IS NULL OR Processing<>'N' OR Processing IS NULL)" + " AND EXISTS (SELECT 1 FROM C_PeriodControl pc" + " INNER JOIN Fact_Acct fact ON (fact.C_Period_ID=pc.C_Period_ID) " + " WHERE fact.AD_Table_ID=" + AD_Table_ID + " AND fact.Record_ID=" + TableName + "." + TableName + "_ID";
        if (!autoPeriod) {
            sql1 = sql1 + " AND pc.PeriodStatus = 'O'" + docBaseType;
        }
        if (this.p_DateAcct_From != null) {
            sql1 = sql1 + " AND TRUNC(fact.DateAcct) >= " + DB.TO_DATE(this.p_DateAcct_From);
        }
        if (this.p_DateAcct_To != null) {
            sql1 = sql1 + " AND TRUNC(fact.DateAcct) <= " + DB.TO_DATE(this.p_DateAcct_To);
        }
        sql1 = sql1 + ")";
        this.log.log(Level.FINE, sql1);
        int reset = DB.executeUpdate(sql1, this.get_TrxName());
        String sql2 = "DELETE Fact_Acct WHERE AD_Client_ID=" + this.p_AD_Client_ID + " AND AD_Table_ID=" + AD_Table_ID;
        sql2 = !autoPeriod ? sql2 + " AND EXISTS (SELECT 1 FROM C_PeriodControl pc WHERE pc.PeriodStatus = 'O'" + docBaseType + " AND Fact_Acct.C_Period_ID=pc.C_Period_ID)" : sql2 + " AND EXISTS (SELECT 1 FROM C_PeriodControl pc WHERE Fact_Acct.C_Period_ID=pc.C_Period_ID)";
        if (this.p_DateAcct_From != null) {
            sql2 = sql2 + " AND TRUNC(Fact_Acct.DateAcct) >= " + DB.TO_DATE(this.p_DateAcct_From);
        }
        if (this.p_DateAcct_To != null) {
            sql2 = sql2 + " AND TRUNC(Fact_Acct.DateAcct) <= " + DB.TO_DATE(this.p_DateAcct_To);
        }
        this.log.log(Level.FINE, sql2);
        int deleted = DB.executeUpdate(sql2, this.get_TrxName());
        this.log.info(TableName + "(" + AD_Table_ID + ") - Reset=" + reset + " - Deleted=" + deleted);
        String s = TableName + " - Reset=" + reset + " - Deleted=" + deleted;
        this.addLog(s);
        this.m_countReset += reset;
        this.m_countDelete += deleted;
    }
}

