/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.M_Element;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;

public class CopyColumnsFromTable
extends SvrProcess {
    private int p_target_AD_Table_ID = 0;
    private int p_source_AD_Table_ID = 0;
    private int m_count = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("AD_Table_ID")) {
                this.p_source_AD_Table_ID = para[i2].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_target_AD_Table_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        if (this.p_target_AD_Table_ID == 0) {
            throw new AdempiereSystemError("@NotFound@ @AD_Table_ID@ " + this.p_target_AD_Table_ID);
        }
        if (this.p_source_AD_Table_ID == 0) {
            throw new AdempiereSystemError("@NotFound@ @AD_Table_ID@ " + this.p_source_AD_Table_ID);
        }
        this.log.info("Source AD_Table_ID=" + this.p_source_AD_Table_ID + ", Target AD_Table_ID=" + this.p_target_AD_Table_ID);
        MTable targetTable = new MTable(this.getCtx(), this.p_target_AD_Table_ID, this.get_TrxName());
        MColumn[] targetColumns = targetTable.getColumns(true);
        if (targetColumns.length > 0) {
            throw new AdempiereSystemError("Target table must not have columns");
        }
        MTable sourceTable = new MTable(this.getCtx(), this.p_source_AD_Table_ID, this.get_TrxName());
        MColumn[] sourceColumns = sourceTable.getColumns(true);
        for (int i2 = 0; i2 < sourceColumns.length; ++i2) {
            MColumn colTarget = new MColumn(targetTable);
            if (sourceColumns[i2].getColumnName().equals(sourceTable.getTableName() + "_ID")) {
                String targetColumnName = new String(targetTable.getTableName() + "_ID");
                colTarget.setColumnName(targetColumnName);
                M_Element element = M_Element.get(this.getCtx(), targetColumnName);
                if (element == null) {
                    element = new M_Element(this.getCtx(), targetColumnName, targetTable.getEntityType(), this.get_TrxName());
                    if (targetColumnName.equalsIgnoreCase(targetTable.getTableName() + "_ID")) {
                        element.setColumnName(targetTable.getTableName() + "_ID");
                        element.setName(targetTable.getName());
                        element.setPrintName(targetTable.getName());
                    }
                    element.save(this.get_TrxName());
                }
                colTarget.setAD_Element_ID(element.getAD_Element_ID());
                colTarget.setName(targetTable.getName());
                colTarget.setDescription(targetTable.getDescription());
                colTarget.setHelp(targetTable.getHelp());
            } else {
                colTarget.setColumnName(sourceColumns[i2].getColumnName());
                colTarget.setAD_Element_ID(sourceColumns[i2].getAD_Element_ID());
                colTarget.setName(sourceColumns[i2].getName());
                colTarget.setDescription(sourceColumns[i2].getDescription());
                colTarget.setHelp(sourceColumns[i2].getHelp());
            }
            colTarget.setVersion(sourceColumns[i2].getVersion());
            colTarget.setAD_Val_Rule_ID(sourceColumns[i2].getAD_Val_Rule_ID());
            colTarget.setDefaultValue(sourceColumns[i2].getDefaultValue());
            colTarget.setFieldLength(sourceColumns[i2].getFieldLength());
            colTarget.setIsKey(sourceColumns[i2].isKey());
            colTarget.setIsParent(sourceColumns[i2].isParent());
            colTarget.setIsMandatory(sourceColumns[i2].isMandatory());
            colTarget.setIsTranslated(sourceColumns[i2].isTranslated());
            colTarget.setIsIdentifier(sourceColumns[i2].isIdentifier());
            colTarget.setSeqNo(sourceColumns[i2].getSeqNo());
            colTarget.setIsEncrypted(sourceColumns[i2].getIsEncrypted());
            colTarget.setAD_Reference_ID(sourceColumns[i2].getAD_Reference_ID());
            colTarget.setAD_Reference_Value_ID(sourceColumns[i2].getAD_Reference_Value_ID());
            colTarget.setIsActive(sourceColumns[i2].isActive());
            colTarget.setVFormat(sourceColumns[i2].getVFormat());
            colTarget.setCallout(sourceColumns[i2].getCallout());
            colTarget.setIsUpdateable(sourceColumns[i2].isUpdateable());
            colTarget.setAD_Process_ID(sourceColumns[i2].getAD_Process_ID());
            colTarget.setValueMin(sourceColumns[i2].getValueMin());
            colTarget.setValueMax(sourceColumns[i2].getValueMax());
            colTarget.setIsSelectionColumn(sourceColumns[i2].isSelectionColumn());
            colTarget.setReadOnlyLogic(sourceColumns[i2].getReadOnlyLogic());
            colTarget.setIsSyncDatabase(sourceColumns[i2].getIsSyncDatabase());
            colTarget.setIsAlwaysUpdateable(sourceColumns[i2].isAlwaysUpdateable());
            colTarget.setColumnSQL(sourceColumns[i2].getColumnSQL());
            colTarget.save(this.get_TrxName());
            ++this.m_count;
        }
        return "#" + this.m_count;
    }
}

