/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print.layout;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Properties;
import org.compiere.model.MQuery;
import org.compiere.print.layout.PrintElement;
import org.compiere.util.Msg;

public class Page {
    public static final String CONTEXT_PAGE = "*Page";
    public static final String CONTEXT_PAGECOUNT = "*PageCount";
    public static final String CONTEXT_MULTIPAGE = "*MultiPageInfo";
    public static final String CONTEXT_COPY = "*CopyInfo";
    public static final String CONTEXT_REPORTNAME = "*ReportName";
    public static final String CONTEXT_HEADER = "*Header";
    public static final String CONTEXT_DATE = "*CurrentDate";
    public static final String CONTEXT_TIME = "*CurrentDateTime";
    private int m_pageNo;
    private int m_pageCount = 1;
    private String m_pageInfo;
    private Properties m_ctx;
    private ArrayList<PrintElement> m_elements = new ArrayList();
    private Image m_image = null;

    public Page(Properties ctx, int pageNo) {
        this.m_ctx = ctx;
        this.m_pageNo = pageNo;
        if (this.m_pageInfo == null || this.m_pageInfo.length() == 0) {
            this.m_pageInfo = String.valueOf(this.m_pageNo);
        }
    }

    public int getPageNo() {
        return this.m_pageNo;
    }

    public String getPageInfo() {
        return this.m_pageInfo;
    }

    public void setPageInfo(String pageInfo) {
        if (this.m_pageInfo == null || this.m_pageInfo.length() == 0) {
            this.m_pageInfo = String.valueOf(this.m_pageNo);
        }
        this.m_pageInfo = pageInfo;
    }

    public void setPageCount(int pageCount) {
        this.m_pageCount = pageCount;
    }

    public void addElement(PrintElement element) {
        if (element != null) {
            this.m_elements.add(element);
        }
    }

    public void paint(Graphics2D g2D, Rectangle bounds, boolean isView, boolean isCopy) {
        this.m_ctx.put(CONTEXT_PAGE, this.m_pageInfo);
        StringBuffer sb = new StringBuffer();
        if (this.m_pageCount != 1) {
            sb.append(Msg.getMsg(this.m_ctx, "Page")).append(" ").append(this.m_pageNo).append(" ").append(Msg.getMsg(this.m_ctx, "of")).append(" ").append(this.m_pageCount);
        } else {
            sb.append(" ");
        }
        this.m_ctx.put(CONTEXT_MULTIPAGE, sb.toString());
        sb = new StringBuffer();
        if (isCopy) {
            sb.append("(").append(Msg.getMsg(this.m_ctx, "DocumentCopy")).append(")");
        } else {
            sb.append(" ");
        }
        this.m_ctx.put(CONTEXT_COPY, sb.toString());
        g2D.setColor(Color.white);
        g2D.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        if (this.m_image != null) {
            int x = bounds.width / 2 - this.m_image.getWidth(null) / 2;
            int y = bounds.height / 2 - this.m_image.getHeight(null) / 2;
            g2D.drawImage(this.m_image, x, y, null);
        }
        Point pageStart = new Point(bounds.getLocation());
        for (int i2 = 0; i2 < this.m_elements.size(); ++i2) {
            PrintElement e = this.m_elements.get(i2);
            e.paint(g2D, this.m_pageNo, pageStart, this.m_ctx, isView);
        }
    }

    public MQuery getDrillDown(Point relativePoint) {
        MQuery retValue = null;
        for (int i2 = 0; i2 < this.m_elements.size() && retValue == null; ++i2) {
            PrintElement element = this.m_elements.get(i2);
            retValue = element.getDrillDown(relativePoint, this.m_pageNo);
        }
        return retValue;
    }

    public MQuery getDrillAcross(Point relativePoint) {
        MQuery retValue = null;
        for (int i2 = 0; i2 < this.m_elements.size() && retValue == null; ++i2) {
            PrintElement element = this.m_elements.get(i2);
            retValue = element.getDrillAcross(relativePoint, this.m_pageNo);
        }
        return retValue;
    }

    public void setBackgroundImage(Image image) {
        this.m_image = image;
    }

    public Image getBackgroundImage() {
        return this.m_image;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Page[");
        sb.append(this.m_pageNo).append(",Elements=").append(this.m_elements.size());
        sb.append("]");
        return sb.toString();
    }
}

