/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.compiere.model.MLocation;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.NamePair;

public class PrintDataElement {
    private String m_columnName;
    private Object m_value;
    private int m_displayType;
    private boolean m_isPKey;
    private boolean m_isPageBreak;
    private String m_formatPattern;
    public static final String XML_TAG = "element";
    public static final String XML_ATTRIBUTE_NAME = "name";
    public static final String XML_ATTRIBUTE_KEY = "key";

    public PrintDataElement(String columnName, Object value, int displayType, boolean isPKey, boolean isPageBreak, String format) {
        if (columnName == null) {
            throw new IllegalArgumentException("PrintDataElement - Name cannot be null");
        }
        this.m_columnName = columnName;
        this.m_value = value;
        this.m_displayType = displayType;
        this.m_isPKey = isPKey;
        this.m_isPageBreak = isPageBreak;
        this.m_formatPattern = format;
    }

    public PrintDataElement(String columnName, Object value, int displayType, String pattern) {
        this(columnName, value, displayType, false, false, pattern);
    }

    public String getColumnName() {
        return this.m_columnName;
    }

    public Object getValue() {
        return this.m_value;
    }

    public BigDecimal getFunctionValue() {
        if (this.m_value == null) {
            return Env.ZERO;
        }
        if (this.m_value instanceof BigDecimal) {
            return (BigDecimal)this.m_value;
        }
        if (this.m_value instanceof Number) {
            return new BigDecimal(((Number)this.m_value).doubleValue());
        }
        if (this.m_value instanceof Boolean) {
            if (((Boolean)this.m_value).booleanValue()) {
                return Env.ONE;
            }
            return Env.ZERO;
        }
        String s = this.m_value.toString();
        return new BigDecimal(s.length());
    }

    public String getValueDisplay(Language language) {
        if (this.m_value == null) {
            return "";
        }
        String retValue = this.m_value.toString();
        if (this.m_displayType == 21) {
            return this.getValueDisplay_Location();
        }
        if (13 == this.m_displayType && this.m_value instanceof KeyNamePair) {
            return ((KeyNamePair)this.m_value).getID();
        }
        if (this.m_columnName.equals("C_BPartner_Location_ID") || this.m_columnName.equals("Bill_Location_ID")) {
            return this.getValueDisplay_BPLocation();
        }
        if (this.m_displayType != 0 && !(this.m_value instanceof String) && !(this.m_value instanceof NamePair) && language != null) {
            if (DisplayType.isNumeric(this.m_displayType)) {
                retValue = DisplayType.getNumberFormat(this.m_displayType, language, this.m_formatPattern).format(this.m_value);
            } else if (DisplayType.isDate(this.m_displayType)) {
                retValue = DisplayType.getDateFormat(this.m_displayType, language, this.m_formatPattern).format(this.m_value);
            }
        }
        return retValue;
    }

    public String getValueAsString() {
        if (this.m_value == null) {
            return "";
        }
        String retValue = this.m_value.toString();
        if (this.m_value instanceof NamePair) {
            retValue = ((NamePair)this.m_value).getID();
        }
        return retValue;
    }

    private String getValueDisplay_BPLocation() {
        try {
            MLocation loc;
            int C_BPartner_Location_ID = Integer.parseInt(this.getValueKey());
            if (C_BPartner_Location_ID != 0 && (loc = MLocation.getBPLocation(Env.getCtx(), C_BPartner_Location_ID, null)) != null) {
                return loc.toStringCR();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.m_value.toString();
    }

    private String getValueDisplay_Location() {
        try {
            MLocation loc;
            int C_Location_ID = Integer.parseInt(this.getValueKey());
            if (C_Location_ID != 0 && (loc = new MLocation(Env.getCtx(), C_Location_ID, null)) != null) {
                return loc.toStringCR();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.m_value.toString();
    }

    public String getValueKey() {
        if (this.m_value == null) {
            return "";
        }
        if (this.m_value instanceof NamePair) {
            return ((NamePair)this.m_value).getID();
        }
        return "";
    }

    public boolean isNull() {
        return this.m_value == null;
    }

    public int getDisplayType() {
        return this.m_displayType;
    }

    public boolean isNumeric() {
        if (this.m_displayType == 0) {
            return this.m_value instanceof BigDecimal;
        }
        return DisplayType.isNumeric(this.m_displayType);
    }

    public boolean isDate() {
        if (this.m_displayType == 0) {
            return this.m_value instanceof Timestamp;
        }
        return DisplayType.isDate(this.m_displayType);
    }

    public boolean isID() {
        if (13 == this.m_displayType) {
            return false;
        }
        return DisplayType.isID(this.m_displayType);
    }

    public boolean isYesNo() {
        if (this.m_displayType == 0) {
            return this.m_value instanceof Boolean;
        }
        return 20 == this.m_displayType;
    }

    public boolean isPKey() {
        return this.m_isPKey;
    }

    public boolean isPageBreak() {
        return this.m_isPageBreak;
    }

    public int hashCode() {
        if (this.m_value == null) {
            return this.m_columnName.hashCode();
        }
        return this.m_columnName.hashCode() + this.m_value.hashCode();
    }

    public boolean equals(Object compare) {
        PrintDataElement pde;
        if (compare instanceof PrintDataElement && (pde = (PrintDataElement)compare).getColumnName().equals(this.m_columnName)) {
            if (pde.getValue() != null && pde.getValue().equals(this.m_value)) {
                return true;
            }
            if (pde.getValue() == null && this.m_value == null) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.m_columnName).append("=").append(this.m_value);
        if (this.m_isPKey) {
            sb.append("(PK)");
        }
        return sb.toString();
    }

    public boolean hasKey() {
        return this.m_value instanceof NamePair;
    }

    public String toStringX() {
        if (this.m_value instanceof NamePair) {
            NamePair pp = (NamePair)this.m_value;
            StringBuffer sb = new StringBuffer(this.m_columnName);
            sb.append("(").append(pp.getID()).append(")").append("=").append(pp.getName());
            if (this.m_isPKey) {
                sb.append("(PK)");
            }
            return sb.toString();
        }
        return this.toString();
    }

    public String getM_formatPattern() {
        return this.m_formatPattern;
    }

    public void setM_formatPattern(String pattern) {
        this.m_formatPattern = pattern;
    }
}

