/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.DefaultComboBoxModel;
import org.compiere.swing.CComboBox;
import org.compiere.util.CLogger;
import org.compiere.util.Ini;

public class CPrinter
extends CComboBox
implements ActionListener {
    private static final long serialVersionUID = -6366208617152587573L;
    private static PrintService[] s_services = PrintServiceLookup.lookupPrintServices(null, null);
    private static CLogger log = CLogger.getCLogger(CPrinter.class);

    public static String[] getPrinterNames() {
        s_services = PrintServiceLookup.lookupPrintServices(null, null);
        String[] retValue = new String[s_services.length];
        for (int i2 = 0; i2 < s_services.length; ++i2) {
            retValue[i2] = s_services[i2].getName();
        }
        return retValue;
    }

    public static PrinterJob getPrinterJob() {
        return CPrinter.getPrinterJob(Ini.getProperty("Printer"));
    }

    public static PrinterJob getPrinterJob(String printerName) {
        PrinterJob pj = null;
        PrintService ps = null;
        try {
            String serviceName;
            pj = PrinterJob.getPrinterJob();
            if (printerName == null || printerName.length() == 0) {
                printerName = Ini.getProperty("Printer");
            }
            if (printerName != null && printerName.length() != 0) {
                for (int i2 = 0; i2 < s_services.length; ++i2) {
                    serviceName = s_services[i2].getName();
                    if (!printerName.equals(serviceName)) continue;
                    ps = s_services[i2];
                    break;
                }
            }
            try {
                if (ps != null) {
                    pj.setPrintService(ps);
                }
            }
            catch (Exception e) {
                log.warning("Could not set Print Service: " + e.toString());
            }
            PrintService psUsed = pj.getPrintService();
            if (psUsed == null) {
                log.warning("Print Service not Found");
            } else {
                serviceName = psUsed.getName();
                if (printerName != null && !printerName.equals(serviceName)) {
                    log.warning("Not found: " + printerName + " - Used: " + serviceName);
                }
            }
        }
        catch (Exception e) {
            log.warning("Could not create for " + printerName + ": " + e.toString());
        }
        return pj;
    }

    public CPrinter() {
        super(CPrinter.getPrinterNames());
        this.setValue(Ini.getProperty("Printer"));
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public PrintService getPrintService() {
        String currentService = (String)this.getSelectedItem();
        for (int i2 = 0; i2 < s_services.length; ++i2) {
            if (!s_services[i2].getName().equals(currentService)) continue;
            return s_services[i2];
        }
        return PrintServiceLookup.lookupDefaultPrintService();
    }

    public void refresh() {
        String current = (String)this.getSelectedItem();
        this.removeAllItems();
        this.setModel(new DefaultComboBoxModel<String>(CPrinter.getPrinterNames()));
        if (current != null) {
            for (int i2 = 0; i2 < this.getItemCount(); ++i2) {
                String item = (String)this.getItemAt(i2);
                if (!item.equals(current)) continue;
                this.setSelectedIndex(i2);
            }
        }
    }
}

