/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.compiere.apps.ConfirmPanel;
import org.compiere.grid.ed.VDate;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.pos.PosPanel;
import org.compiere.pos.PosSubPanel;
import org.compiere.pos.QueryProduct;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class QueryTicket
extends PosSubPanel
implements ActionListener,
MouseListener,
ListSelectionListener {
    private static final long serialVersionUID = 7713957495649128816L;
    private MiniTable m_table;
    private CPanel northPanel;
    private CScrollPane centerScroll;
    private ConfirmPanel confirm;
    private CTextField f_c_order_id;
    private CTextField f_documentno;
    private VDate f_date;
    private CButton f_up;
    private CButton f_down;
    private int m_c_order_id;
    private static CLogger log = CLogger.getCLogger(QueryProduct.class);
    private static ColumnInfo[] s_layout = new ColumnInfo[]{new ColumnInfo(" ", "C_Order_ID", IDColumn.class), new ColumnInfo(Msg.translate(Env.getCtx(), "DocumentNo"), "DocumentNo", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "TotalLines"), "TotalLines", BigDecimal.class), new ColumnInfo(Msg.translate(Env.getCtx(), "GrandTotal"), "GrandTotal", BigDecimal.class), new ColumnInfo(Msg.translate(Env.getCtx(), "C_BPartner_ID"), "Name", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "DocStatus"), "DocStatus", String.class)};

    public QueryTicket(PosPanel posPanel) {
        super(posPanel);
    }

    @Override
    protected void init() {
        this.setLayout(new BorderLayout(5, 5));
        this.setVisible(false);
        this.northPanel = new CPanel(new GridBagLayout());
        this.add((Component)this.northPanel, "North");
        this.northPanel.setBorder(new TitledBorder(Msg.getMsg(this.p_ctx, "Query")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = PosSubPanel.INSETS2;
        gbc.gridy = 0;
        gbc.gridx = -1;
        CLabel lorder_id = new CLabel(Msg.translate(this.p_ctx, "C_Order_ID"));
        gbc.anchor = 13;
        this.northPanel.add((Component)lorder_id, gbc);
        this.f_c_order_id = new CTextField(20);
        lorder_id.setLabelFor(this.f_c_order_id);
        gbc.anchor = 17;
        this.northPanel.add((Component)this.f_c_order_id, gbc);
        this.f_c_order_id.addActionListener(this);
        CLabel ldoc = new CLabel(Msg.translate(this.p_ctx, "DocumentNo"));
        gbc.anchor = 13;
        this.northPanel.add((Component)ldoc, gbc);
        this.f_documentno = new CTextField(15);
        ldoc.setLabelFor(this.f_documentno);
        gbc.anchor = 17;
        this.northPanel.add((Component)this.f_documentno, gbc);
        this.f_documentno.addActionListener(this);
        gbc.gridy = 1;
        CLabel ldate = new CLabel(Msg.translate(this.p_ctx, "DateOrdered"));
        gbc.anchor = 13;
        this.northPanel.add((Component)ldate, gbc);
        this.f_date = new VDate();
        this.f_date.setValue(Env.getContextAsDate(Env.getCtx(), "#Date"));
        ldate.setLabelFor(this.f_date);
        gbc.anchor = 17;
        this.northPanel.add((Component)this.f_date, gbc);
        this.f_date.addActionListener(this);
        gbc.gridy = 0;
        gbc.gridheight = 2;
        gbc.anchor = 13;
        gbc.weightx = 0.1;
        this.f_up = this.createButtonAction("Previous", KeyStroke.getKeyStroke(38, 0));
        this.northPanel.add((Component)this.f_up, gbc);
        gbc.weightx = 0.0;
        this.f_down = this.createButtonAction("Next", KeyStroke.getKeyStroke(40, 0));
        this.northPanel.add((Component)this.f_down, gbc);
        this.confirm = new ConfirmPanel(true, true, true, false, false, false, false);
        this.add((Component)this.confirm, "South");
        this.confirm.addActionListener(this);
        this.m_table = new MiniTable();
        String sql = String.valueOf(this.m_table.prepareTable(s_layout, "C_Order", "C_DocTypeTarget_ID" + this.p_pos.getC_DocType_ID(), false, "C_Order")) + " ORDER BY Margin, QtyAvailable";
        this.m_table.setRowSelectionAllowed(true);
        this.m_table.setColumnSelectionAllowed(false);
        this.m_table.setMultiSelection(false);
        this.m_table.addMouseListener(this);
        this.m_table.getSelectionModel().addListSelectionListener(this);
        this.enableButtons();
        this.centerScroll = new CScrollPane(this.m_table);
        this.add((Component)this.centerScroll, "Center");
    }

    @Override
    protected GridBagConstraints getGridBagConstraints() {
        GridBagConstraints gbc = super.getGridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.weightx = 0.1;
        gbc.weighty = 0.5;
        return gbc;
    }

    @Override
    public void dispose() {
        this.removeAll();
        this.northPanel = null;
        this.centerScroll = null;
        this.confirm = null;
        this.m_table = null;
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (aFlag) {
            this.f_c_order_id.requestFocus();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.info("PosQueryProduct.actionPerformed - " + e.getActionCommand());
        if ("Refresh".equals(e.getActionCommand()) || e.getSource() == this.f_c_order_id || e.getSource() == this.f_documentno || e.getSource() == this.f_date) {
            this.setResults(this.p_ctx, this.f_c_order_id.getText(), this.f_documentno.getText(), this.f_date.getTimestamp());
            return;
        }
        if ("Reset".equals(e.getActionCommand())) {
            this.reset();
            return;
        }
        if ("Previous".equalsIgnoreCase(e.getActionCommand())) {
            int rows = this.m_table.getRowCount();
            if (rows == 0) {
                return;
            }
            int row = this.m_table.getSelectedRow();
            if (--row < 0) {
                row = 0;
            }
            this.m_table.getSelectionModel().setSelectionInterval(row, row);
            return;
        }
        if ("Next".equalsIgnoreCase(e.getActionCommand())) {
            int rows = this.m_table.getRowCount();
            if (rows == 0) {
                return;
            }
            int row = this.m_table.getSelectedRow();
            if (++row >= rows) {
                row = rows - 1;
            }
            this.m_table.getSelectionModel().setSelectionInterval(row, row);
            return;
        }
        this.close();
    }

    public void reset() {
        this.f_c_order_id.setText(null);
        this.f_documentno.setText(null);
        this.f_date.setValue(Env.getContextAsDate(Env.getCtx(), "#Date"));
        this.setResults(this.p_ctx, this.f_c_order_id.getText(), this.f_documentno.getText(), this.f_date.getTimestamp());
    }

    public void setResults(Properties ctx, String id, String doc, Timestamp date) {
        String sql = "";
        try {
            sql = "SELECT o.C_Order_ID, o.DocumentNo, o.TotalLines, o.GrandTotal, b.Name , o.DocStatus FROM C_Order o INNER JOIN C_BPartner b ON o.C_BPartner_ID=b.C_BPartner_ID WHERE o.C_DocTypeTarget_ID = " + this.p_pos.getC_DocType_ID();
            if (id != null && !id.equalsIgnoreCase("")) {
                sql = String.valueOf(sql) + " AND o.C_Order_ID = " + id;
            }
            if (doc != null && !doc.equalsIgnoreCase("")) {
                sql = String.valueOf(sql) + " AND o.DocumentNo = '" + doc + "'";
            }
            sql = String.valueOf(sql) + " AND o.DateOrdered = ? Order By o.DocumentNo";
            CPreparedStatement pstm = DB.prepareStatement(sql, null);
            pstm.setTimestamp(1, date);
            ResultSet rs = pstm.executeQuery();
            this.m_table.loadTable(rs);
            this.enableButtons();
        }
        catch (Exception e) {
            log.severe("QueryTicket.setResults: " + e + " -> " + sql);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.enableButtons();
    }

    private void enableButtons() {
        Integer ID;
        boolean enabled;
        this.m_c_order_id = -1;
        int row = this.m_table.getSelectedRow();
        boolean bl = enabled = row != -1;
        if (enabled && (ID = this.m_table.getSelectedRowKey()) != null) {
            this.m_c_order_id = ID;
        }
        this.confirm.getOKButton().setEnabled(enabled);
        log.info("ID=" + this.m_c_order_id);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1 && this.m_table.getSelectedRow() != -1) {
            this.enableButtons();
            this.close();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private void close() {
        log.info("C_Order_ID=" + this.m_c_order_id);
        if (this.m_c_order_id > 0) {
            this.p_posPanel.f_curLine.setOrder(this.m_c_order_id);
            this.p_posPanel.updateInfo();
        }
        this.p_posPanel.closeQuery(this);
    }
}

