/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.acct.DocLine;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MCost;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostElement;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalLine;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProductCategoryAcct;
import org.compiere.model.MStorage;
import org.compiere.model.Query;
import org.compiere.model.X_M_Production;
import org.compiere.model.X_M_ProductionLine;
import org.compiere.model.X_M_ProductionPlan;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class OFBProductCost {
    private static CLogger log = CLogger.getCLogger(OFBProductCost.class);

    public static BigDecimal getProductOrderCost(int Product_ID, int OrderLine_ID, BigDecimal qty, String trxName, Properties ctx) {
        BigDecimal returnCost = Env.ZERO;
        if (OrderLine_ID > 0) {
            MOrderLine line = new MOrderLine(Env.getCtx(), OrderLine_ID, trxName);
            returnCost = line.getLineNetAmt();
        }
        return returnCost;
    }

    public static BigDecimal getProductCost(int Product_ID, int Org_ID, BigDecimal qty, String trxName, Properties ctx) {
        BigDecimal returnCost = Env.ZERO;
        MProduct product = MProduct.get(ctx, Product_ID);
        MAcctSchema ass = MAcctSchema.getClientAcctSchema(ctx, Env.getAD_Client_ID(ctx))[0];
        OFBProductCost.processCost(Product_ID, trxName, ctx);
        MCost cost = null;
        cost = product.getCostingLevel(ass).equals("O") ? OFBProductCost.getMCost(Product_ID, OFBProductCost.getParentOrg(Org_ID, trxName, ctx), 0, ass.getC_AcctSchema_ID(), ass.getM_CostType_ID(), trxName, ctx) : OFBProductCost.getMCost(Product_ID, 0, 0, ass.getC_AcctSchema_ID(), ass.getM_CostType_ID(), trxName, ctx);
        returnCost = cost.getCurrentCostPrice().signum() <= 0 ? cost.getFutureCostPrice() : cost.getCurrentCostPrice();
        returnCost = returnCost.multiply(qty);
        return returnCost;
    }

    public static BigDecimal getProductCostQty(int Product_ID, int Org_ID, String trxName, Properties ctx) {
        BigDecimal returnCost = Env.ZERO;
        MProduct product = MProduct.get(Env.getCtx(), Product_ID);
        MAcctSchema ass = MAcctSchema.getClientAcctSchema(Env.getCtx(), Env.getAD_Client_ID(Env.getCtx()))[0];
        OFBProductCost.processCost(Product_ID, trxName, ctx);
        returnCost = product.getCostingLevel(ass).equals("O") ? OFBProductCost.getMCost(Product_ID, OFBProductCost.getParentOrg(Org_ID, trxName, ctx), 0, ass.getC_AcctSchema_ID(), ass.getM_CostType_ID(), trxName, ctx).getCurrentQty() : OFBProductCost.getMCost(Product_ID, 0, 0, ass.getC_AcctSchema_ID(), ass.getM_CostType_ID(), trxName, ctx).getCurrentQty();
        return returnCost;
    }

    public static void processCost(int Product_ID, String trxName, Properties ctx) {
        block6: {
            String sql = "select * from M_CostDetail where processed='N' and Enabled='Y' and M_Product_ID = ? and C_AcctSchema_ID=? ";
            sql = String.valueOf(sql) + " order by DateAcct";
            MAcctSchema schema = MAcctSchema.getClientAcctSchema(ctx, Env.getAD_Client_ID(ctx))[0];
            log.fine("schema :" + schema);
            log.fine("sql: " + sql.toString());
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), trxName);
                    pstmt.setInt(1, Product_ID);
                    pstmt.setInt(2, schema.getC_AcctSchema_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MCostDetail detail = new MCostDetail(Env.getCtx(), rs, trxName);
                        log.fine("detail :" + detail);
                        OFBProductCost.processDetail(detail, schema, ctx);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql.toString(), e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }

    public static void processDetail(MCostDetail detail, MAcctSchema schema, Properties ctx) {
        MProductCategoryAcct category = MProductCategoryAcct.get(ctx, detail.getM_Product().getM_Product_Category_ID(), schema.getC_AcctSchema_ID(), detail.get_TrxName());
        if (detail.isProcessed()) {
            return;
        }
        String costingMethod = new String();
        String costingLevel = new String();
        costingLevel = category.getCostingLevel() == null || category.getCostingLevel().length() == 0 ? schema.getCostingLevel() : category.getCostingLevel();
        MCost cost = null;
        log.config("Product_ID :" + detail.getM_Product_ID() + "- Detail_ID: " + detail.getM_CostDetail_ID());
        if (detail.getC_OrderLine_ID() > 0) {
            detail.setProcessed(true);
            detail.save();
            return;
        }
        if ((costingMethod.equals("I") || costingMethod.equals("i")) && (detail.getC_InvoiceLine_ID() == 0 || detail.isSOTrx()) && detail.get_ValueAsInt("GL_JournalLine_ID") == 0) {
            detail.setProcessed(true);
            detail.save();
            return;
        }
        cost = costingLevel.equals("C") ? OFBProductCost.getMCost(detail.getM_Product_ID(), 0, detail.getM_CostElement_ID(), schema.getC_AcctSchema_ID(), schema.getM_CostType_ID(), detail.get_TrxName(), ctx) : OFBProductCost.getMCost(detail.getM_Product_ID(), detail.getAD_Org_ID(), detail.getM_CostElement_ID(), schema.getC_AcctSchema_ID(), schema.getM_CostType_ID(), detail.get_TrxName(), ctx);
        log.config("Processing Cost :" + cost);
        BigDecimal oldAmt = cost.getCumulatedAmt();
        if (costingMethod.equals("i")) {
            cost.add(detail.getAmt(), detail.getQty());
            cost.setCurrentCostPrice(detail.getAmt().divide(detail.getQty(), 4));
        } else {
            BigDecimal TemCost;
            log.config("Costo Standard");
            MJournal journal = null;
            if (detail.get_ValueAsInt("GL_JournalLine_ID") > 0) {
                log.config("journal");
                MJournalLine line = new MJournalLine(ctx, detail.get_ValueAsInt("GL_JournalLine_ID"), detail.get_TrxName());
                journal = line.getParent();
                if (journal.getDescription() != null && journal.getDescription().toUpperCase().indexOf("INICIAL") < 0) {
                    cost.add(detail.getAmt().setScale(4, 4), detail.getQty());
                }
            } else if (detail.getC_InvoiceLine_ID() > 0) {
                log.config("factura");
                if (detail.getDeltaAmt().signum() != 0) {
                    cost.add(detail.getDeltaAmt().setScale(4, 4), Env.ZERO);
                } else {
                    cost.add(detail.getAmt().setScale(4, 4), Env.ZERO);
                }
            } else {
                log.config("entregas - recibos - inventario");
                if (detail.getDeltaAmt().signum() != 0) {
                    cost.add(detail.getDeltaAmt().setScale(4, 4), detail.getDeltaQty());
                } else {
                    cost.add(detail.getAmt().setScale(4, 4), detail.getQty());
                }
            }
            if (journal != null && journal.getDescription() != null && journal.getDescription().toUpperCase().indexOf("INICIAL") >= 0) {
                log.config("journal inicial");
                TemCost = detail.getAmt();
                if (detail.getQty().signum() > 0) {
                    cost.setCurrentQty(detail.getQty());
                    cost.setCumulatedQty(detail.getQty());
                    TemCost = TemCost.divide(detail.getQty().setScale(4, 6));
                }
                if (detail.getAmt().signum() > 0) {
                    cost.setCumulatedAmt(detail.getAmt());
                }
            } else {
                if (detail.getQty().signum() > 0 && detail.getAmt().signum() > 0 && (detail.getM_InOutLine_ID() > 0 || detail.getM_ProductionLine_ID() > 0) && cost.getCumulatedQty().longValue() < -4L && cost.getCumulatedAmt().signum() < 0) {
                    cost.setCumulatedAmt(detail.getAmt());
                    cost.setCumulatedQty(detail.getQty());
                    cost.setCurrentQty(detail.getQty());
                }
                if ((double)cost.getCumulatedQty().longValue() > 0.7 && cost.getCumulatedAmt().signum() > 0) {
                    TemCost = cost.getCumulatedAmt().divide(cost.getCumulatedQty(), 4, 4);
                } else {
                    TemCost = cost.getCurrentCostPrice();
                    cost.setCumulatedAmt(Env.ZERO);
                    cost.setCurrentQty(Env.ZERO);
                    cost.setCumulatedQty(Env.ZERO);
                }
            }
            cost.setCurrentCostPrice(TemCost.setScale(4, 4));
        }
        detail.setCurrentCostPrice(cost.getCurrentCostPrice());
        detail.setCurrentQty(cost.getCurrentQty());
        detail.setCumulatedAmt(cost.getCumulatedAmt());
        detail.setDescription(String.valueOf(detail.getDescription()) + " / Old:" + oldAmt + " A:" + cost.getCumulatedAmt() + "| Q:" + cost.getCumulatedQty() + " / CA:" + cost.getCurrentCostPrice());
        detail.setProcessed(true);
        detail.save();
        cost.save();
    }

    public static MCost getMCost(int Product_ID, int Org_ID, int CostElement_ID, int AcctSchema_ID, int CostType_ID, String trxName, Properties ctx) {
        if (Org_ID > 0) {
            Org_ID = OFBProductCost.getParentOrg(Org_ID, trxName, ctx);
        }
        if (CostElement_ID == 0) {
            CostElement_ID = OFBProductCost.getStandarCostelement(ctx).getM_CostElement_ID();
        }
        log.config("getMCost :" + Org_ID + "-" + Product_ID);
        MCost cost = OFBProductCost.get(ctx, Env.getAD_Client_ID(ctx), Org_ID, Product_ID, CostType_ID, AcctSchema_ID, CostElement_ID, 0, trxName);
        log.config("getMCost :" + cost);
        if (cost == null) {
            cost = OFBProductCost.createMCost(Product_ID, Org_ID, CostElement_ID, AcctSchema_ID, trxName, ctx);
        }
        return cost;
    }

    public static MCost createMCost(int Product_ID, int Org_ID, int CostElement_ID, int AcctSchema_ID, String trxName, Properties ctx) {
        MProduct product = new MProduct(ctx, Product_ID, trxName);
        MAcctSchema as = MAcctSchema.get(ctx, AcctSchema_ID);
        MCost cost = new MCost(product, 0, as, Org_ID, CostElement_ID);
        if (cost.save()) {
            return cost;
        }
        return null;
    }

    public static int getParentOrg(int Org_ID, String trxName, Properties ctx) {
        log.config("getParentOrg : Begin :" + Org_ID);
        MOrg org = MOrg.get(ctx, Org_ID);
        if (org.get_ValueAsBoolean("IsCostCenter")) {
            MOrgInfo info = MOrgInfo.get(ctx, Org_ID, trxName);
            log.config("getParentOrg : isCostcenter :" + info);
            if (info.getParent_Org_ID() > 0) {
                return OFBProductCost.getParentOrg(info.getParent_Org_ID(), trxName, ctx);
            }
            return 0;
        }
        log.config("getParentOrg : Return :" + Org_ID);
        return Org_ID;
    }

    public static boolean sameOrg(int Org1_ID, int Org2_ID, Properties ctx) {
        return OFBProductCost.getParentOrg(Org1_ID, null, ctx) == OFBProductCost.getParentOrg(Org2_ID, null, ctx);
    }

    public static boolean createOrder(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int C_OrderLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        MClient client;
        boolean ok;
        MProductCategory cat;
        boolean noCost;
        MCostDetail cd;
        String sql = "DELETE  From M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND C_OrderLine_ID=" + C_OrderLine_ID + " AND C_AcctSchema_ID =" + as.getC_AcctSchema_ID() + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate(sql, trxName);
        if (no != 0) {
            log.config("Deleted #" + no);
        }
        if ((cd = OFBProductCost.get(as.getCtx(), "C_OrderLine_ID=?", C_OrderLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName)) == null) {
            Amt = Amt.setScale(0, 4);
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setC_OrderLine_ID(C_OrderLine_ID);
            MOrder order = new MOrderLine(as.getCtx(), C_OrderLine_ID, trxName).getParent();
            cd.set_CustomColumn("DateAcct", order.getDateAcct());
            cd.set_CustomColumn("Enabled", false);
            if (Qty.signum() != 0) {
                cd.setDescription("C_Cost:" + Amt.divide(Qty, 0, 4).setScale(0));
            }
        } else {
            cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
            cd.setDeltaQty(Qty.subtract(cd.getQty()));
            if (Qty.signum() != 0) {
                cd.setDescription(String.valueOf(cd.getDescription()) + " U_Cost:" + Amt.divide(Qty, 0, 4).setScale(0));
            }
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else {
                return true;
            }
        }
        if (noCost = ((Boolean)(cat = new MProductCategory(as.getCtx(), new MProduct(as.getCtx(), M_Product_ID, trxName).getM_Product_Category_ID(), trxName)).get_Value("NoCost")).booleanValue()) {
            cd.set_CustomColumn("Enabled", false);
        }
        if ((ok = cd.save()) && !cd.isProcessed() && (client = MClient.get(as.getCtx(), as.getAD_Client_ID())).isCostImmediate()) {
            log.config("Ctx: " + as.getCtx());
            OFBProductCost.processCost(M_Product_ID, trxName, as.getCtx());
        }
        log.config("(" + ok + ") " + cd);
        return ok;
    }

    public static boolean createInvoice(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int C_InvoiceLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        MClient client;
        boolean ok;
        MProductCategory cat;
        boolean noCost;
        MInvoice invoice;
        int no;
        log.config("start - C_InvoiceLine_ID:" + C_InvoiceLine_ID + " M_Product_ID:" + M_Product_ID + "  M_AttributeSetInstance_ID:" + M_AttributeSetInstance_ID);
        String sql = "DELETE  From M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND C_InvoiceLine_ID=" + C_InvoiceLine_ID + " AND C_AcctSchema_ID =" + as.getC_AcctSchema_ID() + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        if (M_Product_ID > 0) {
            sql = String.valueOf(sql) + " AND M_Product_ID=" + M_Product_ID;
        }
        if ((no = DB.executeUpdate(sql, trxName)) != 0) {
            log.config("Deleted #" + no);
        }
        MCostDetail cd = null;
        cd = M_Product_ID > 0 ? OFBProductCost.getP(as.getCtx(), "C_InvoiceLine_ID=?", C_InvoiceLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), M_Product_ID, trxName) : OFBProductCost.get(as.getCtx(), "C_InvoiceLine_ID=?", C_InvoiceLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName);
        log.config("cd-found:" + cd);
        if (cd == null) {
            Amt = Amt.setScale(0, 4);
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setC_InvoiceLine_ID(C_InvoiceLine_ID);
            invoice = new MInvoiceLine(as.getCtx(), C_InvoiceLine_ID, trxName).getParent();
            cd.set_CustomColumn("DateAcct", invoice.getDateAcct());
            cd.set_CustomColumn("Enabled", true);
            if (Qty.signum() != 0) {
                cd.setDescription("C_Cost:" + Amt.divide(Qty, 0, 4).setScale(0));
            }
        } else {
            cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
            cd.setDeltaQty(Qty.subtract(cd.getQty()));
            invoice = new MInvoiceLine(as.getCtx(), C_InvoiceLine_ID, trxName).getParent();
            cd.set_CustomColumn("DateAcct", invoice.getDateAcct());
            cd.setDescription(String.valueOf(Description) + " Old:" + cd.getAmt().setScale(0, 4));
            if (Qty.signum() != 0) {
                cd.setDescription(String.valueOf(cd.getDescription()) + " U_Cost:" + Amt.divide(Qty, 0, 4).setScale(0));
            }
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else {
                return true;
            }
        }
        if (noCost = ((Boolean)(cat = new MProductCategory(as.getCtx(), new MProduct(as.getCtx(), M_Product_ID, trxName).getM_Product_Category_ID(), trxName)).get_Value("NoCost")).booleanValue()) {
            cd.set_CustomColumn("Enabled", false);
        }
        if ((ok = cd.save()) && !cd.isProcessed() && (client = MClient.get(as.getCtx(), as.getAD_Client_ID())).isCostImmediate()) {
            log.config("Ctx: " + as.getCtx());
            OFBProductCost.processCost(M_Product_ID, trxName, as.getCtx());
        }
        log.config("(" + ok + ") " + cd);
        return ok;
    }

    public static boolean createShipment(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_InOutLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, boolean IsSOTrx, String trxName) {
        MClient client;
        boolean ok;
        MProductCategory cat;
        boolean noCost;
        MInOut InOut;
        MCostDetail cd;
        String sql = "DELETE  From M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND M_InOutLine_ID=" + M_InOutLine_ID + " AND C_AcctSchema_ID =" + as.getC_AcctSchema_ID() + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate(sql, trxName);
        if (no != 0) {
            log.config("Deleted #" + no);
        }
        if ((cd = OFBProductCost.get(as.getCtx(), "M_InOutLine_ID=?", M_InOutLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName)) == null) {
            Amt = Amt.setScale(0, 4);
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setM_InOutLine_ID(M_InOutLine_ID);
            cd.setIsSOTrx(IsSOTrx);
            log.config("seteo variable Enabled: true");
            InOut = new MInOutLine(as.getCtx(), M_InOutLine_ID, trxName).getParent();
            cd.set_CustomColumn("DateAcct", InOut.getDateAcct());
            cd.set_CustomColumn("Enabled", true);
            log.config("despues seteo variable Enabled: true");
            if (Qty.signum() != 0) {
                cd.setDescription("C_Cost:" + Amt.divide(Qty, 0, 4).setScale(0));
            }
        } else {
            cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
            cd.setDeltaQty(Qty.subtract(cd.getQty()));
            InOut = new MInOutLine(as.getCtx(), M_InOutLine_ID, trxName).getParent();
            cd.set_CustomColumn("DateAcct", InOut.getDateAcct());
            cd.setDescription(String.valueOf(Description) + " Old:" + cd.getAmt().setScale(0, 4));
            if (Qty.signum() != 0) {
                cd.setDescription(String.valueOf(cd.getDescription()) + " U_Cost:" + Amt.divide(Qty, 0, 4).setScale(0));
            }
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else {
                return true;
            }
        }
        if (noCost = ((Boolean)(cat = new MProductCategory(as.getCtx(), new MProduct(as.getCtx(), M_Product_ID, trxName).getM_Product_Category_ID(), trxName)).get_Value("NoCost")).booleanValue()) {
            cd.set_CustomColumn("Enabled", false);
        }
        if ((ok = cd.save()) && !cd.isProcessed() && (client = MClient.get(as.getCtx(), as.getAD_Client_ID())).isCostImmediate()) {
            log.config("Ctx: " + as.getCtx());
            OFBProductCost.processCost(M_Product_ID, trxName, as.getCtx());
        }
        log.config("(" + ok + ") " + cd);
        return ok;
    }

    public static boolean createInventory(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_InventoryLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        MClient client;
        boolean ok;
        MProductCategory cat;
        boolean noCost;
        MInventory Inventory;
        MCostDetail cd;
        String sql = "DELETE  From M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND M_InventoryLine_ID=" + M_InventoryLine_ID + " AND C_AcctSchema_ID =" + as.getC_AcctSchema_ID() + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate(sql, trxName);
        if (no != 0) {
            log.config("Deleted #" + no);
        }
        if ((cd = OFBProductCost.get(as.getCtx(), "M_InventoryLine_ID=?", M_InventoryLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName)) == null) {
            Amt = Amt.setScale(0, 4);
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setM_InventoryLine_ID(M_InventoryLine_ID);
            Inventory = new MInventoryLine(as.getCtx(), M_InventoryLine_ID, trxName).getParent();
            cd.set_CustomColumn("DateAcct", Inventory.getMovementDate());
            cd.set_CustomColumn("Enabled", true);
            if (Qty.signum() != 0) {
                cd.setDescription("C_Cost:" + Amt.divide(Qty, 0, 4).setScale(0));
            }
        } else {
            cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
            cd.setDeltaQty(Qty.subtract(cd.getQty()));
            Inventory = new MInventoryLine(as.getCtx(), M_InventoryLine_ID, trxName).getParent();
            cd.set_CustomColumn("DateAcct", Inventory.getMovementDate());
            if (Qty.signum() != 0) {
                cd.setDescription(String.valueOf(cd.getDescription()) + " U_Cost:" + Amt.divide(Qty, 0, 4).setScale(0, 4));
            }
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else {
                return true;
            }
        }
        if (noCost = ((Boolean)(cat = new MProductCategory(as.getCtx(), new MProduct(as.getCtx(), M_Product_ID, trxName).getM_Product_Category_ID(), trxName)).get_Value("NoCost")).booleanValue()) {
            cd.set_CustomColumn("Enabled", false);
        }
        if ((ok = cd.save()) && !cd.isProcessed() && (client = MClient.get(as.getCtx(), as.getAD_Client_ID())).isCostImmediate()) {
            log.config("Ctx: " + as.getCtx());
            OFBProductCost.processCost(M_Product_ID, trxName, as.getCtx());
        }
        log.config("(" + ok + ") " + cd);
        return ok;
    }

    public static boolean createMovement(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_MovementLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, boolean from, String Description, String trxName) {
        MClient client;
        boolean ok;
        MProductCategory cat;
        boolean noCost;
        MMovement Movement;
        MCostDetail cd;
        String sql = "DELETE  From M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND M_MovementLine_ID=" + M_MovementLine_ID + " AND IsSOTrx=" + (from ? "'Y'" : "'N'") + " AND C_AcctSchema_ID =" + as.getC_AcctSchema_ID() + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate(sql, trxName);
        if (no != 0) {
            log.config("Deleted #" + no);
        }
        if ((cd = OFBProductCost.get(as.getCtx(), "M_MovementLine_ID=? AND IsSOTrx=" + (from ? "'Y'" : "'N'"), M_MovementLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName)) == null) {
            Amt = Amt.setScale(0, 4);
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setM_MovementLine_ID(M_MovementLine_ID);
            cd.setIsSOTrx(from);
            Movement = new MMovementLine(as.getCtx(), M_MovementLine_ID, trxName).getParent();
            cd.set_CustomColumn("DateAcct", Movement.getMovementDate());
            cd.set_CustomColumn("Enabled", true);
            if (Qty.signum() != 0) {
                cd.setDescription("C_Cost:" + Amt.divide(Qty, 0, 4).setScale(0));
            }
        } else {
            cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
            cd.setDeltaQty(Qty.subtract(cd.getQty()));
            Movement = new MMovementLine(as.getCtx(), M_MovementLine_ID, trxName).getParent();
            cd.set_CustomColumn("DateAcct", Movement.getMovementDate());
            if (Qty.signum() != 0) {
                cd.setDescription(String.valueOf(cd.getDescription()) + " U_Cost:" + Amt.divide(Qty, 0, 4).setScale(0));
            }
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else {
                return true;
            }
        }
        if (noCost = ((Boolean)(cat = new MProductCategory(as.getCtx(), new MProduct(as.getCtx(), M_Product_ID, trxName).getM_Product_Category_ID(), trxName)).get_Value("NoCost")).booleanValue()) {
            cd.set_CustomColumn("Enabled", false);
        }
        if ((ok = cd.save()) && !cd.isProcessed() && (client = MClient.get(as.getCtx(), as.getAD_Client_ID())).isCostImmediate()) {
            log.config("Ctx: " + as.getCtx());
            OFBProductCost.processCost(M_Product_ID, trxName, as.getCtx());
        }
        log.config("(" + ok + ") " + cd);
        return ok;
    }

    public static boolean createProduction(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_ProductionLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        MCostDetail cd;
        String sql = "DELETE M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND M_ProductionLine_ID=" + M_ProductionLine_ID + " AND C_AcctSchema_ID =" + as.getC_AcctSchema_ID() + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate(sql, trxName);
        if (no != 0) {
            log.config("Deleted #" + no);
        }
        if ((cd = OFBProductCost.get(as.getCtx(), "M_ProductionLine_ID=?", M_ProductionLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName)) == null) {
            Amt = Amt.setScale(0, 4);
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.setM_ProductionLine_ID(M_ProductionLine_ID);
            log.config("seteo variable Enabled: true");
            X_M_ProductionLine MProdL = new X_M_ProductionLine(as.getCtx(), M_ProductionLine_ID, trxName);
            X_M_ProductionPlan MProdP = new X_M_ProductionPlan(as.getCtx(), MProdL.getM_ProductionPlan_ID(), trxName);
            X_M_Production MProdC = new X_M_Production(as.getCtx(), MProdP.getM_Production_ID(), trxName);
            cd.set_CustomColumn("DateAcct", MProdC.getMovementDate());
            cd.set_CustomColumn("Enabled", true);
            log.config("despues seteo variable Enabled: true");
        } else {
            cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
            cd.setDeltaQty(Qty.subtract(cd.getQty()));
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else {
                return true;
            }
        }
        MProductCategory cat = new MProductCategory(as.getCtx(), new MProduct(as.getCtx(), M_Product_ID, trxName).getM_Product_Category_ID(), trxName);
        boolean noCost = (Boolean)cat.get_Value("NoCost");
        if (noCost) {
            cd.set_CustomColumn("Enabled", false);
        }
        log.config("antes de guardar cd ");
        boolean ok = cd.save();
        log.config("despues de guardar cd y antes de if");
        if (ok && !cd.isProcessed()) {
            log.config("despues de if1");
            MClient client = MClient.get(as.getCtx(), as.getAD_Client_ID());
            log.config("antes de if 2");
            if (client.isCostImmediate()) {
                log.config("despues de if 2");
                log.config("Ctx: " + as.getCtx());
                OFBProductCost.processCost(M_Product_ID, trxName, as.getCtx());
            }
        }
        log.config("(" + ok + ") " + cd);
        return ok;
    }

    public static boolean createJournal(MAcctSchema as, int AD_Org_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int GL_JournalLine_ID, int M_CostElement_ID, BigDecimal Amt, BigDecimal Qty, String Description, String trxName) {
        MClient client;
        MJournalLine jl;
        MCostDetail cd;
        String sql = "DELETE  From M_CostDetail WHERE Processed='N' AND COALESCE(DeltaAmt,0)=0 AND COALESCE(DeltaQty,0)=0 AND GL_JournalLine_ID=" + GL_JournalLine_ID + " AND M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        int no = DB.executeUpdate(sql, trxName);
        if (no != 0) {
            log.config("Deleted #" + no);
        }
        if ((cd = OFBProductCost.get(as.getCtx(), "GL_JournalLine_ID=? ", GL_JournalLine_ID, M_AttributeSetInstance_ID, as.getC_AcctSchema_ID(), trxName)) == null) {
            Amt = Amt.setScale(0, 4);
            cd = new MCostDetail(as, AD_Org_ID, M_Product_ID, M_AttributeSetInstance_ID, M_CostElement_ID, Amt, Qty, Description, trxName);
            cd.set_Value("GL_JournalLine_ID", (Object)GL_JournalLine_ID);
            jl = new MJournalLine(as.getCtx(), GL_JournalLine_ID, trxName);
            cd.set_CustomColumn("DateAcct", jl.getDateAcct());
            cd.set_CustomColumn("Enabled", true);
        } else {
            cd.setDeltaAmt(Amt.subtract(cd.getAmt()));
            cd.setDeltaQty(Qty.subtract(cd.getQty()));
            jl = new MJournalLine(as.getCtx(), GL_JournalLine_ID, trxName);
            cd.set_CustomColumn("DateAcct", jl.getDateAcct());
            if (cd.isDelta()) {
                cd.setProcessed(false);
                cd.setAmt(Amt);
                cd.setQty(Qty);
            } else {
                return true;
            }
        }
        boolean ok = cd.save();
        if (ok && !cd.isProcessed() && (client = MClient.get(as.getCtx(), as.getAD_Client_ID())).isCostImmediate()) {
            log.config("Ctx: " + as.getCtx());
            OFBProductCost.processCost(M_Product_ID, trxName, as.getCtx());
        }
        log.config("(" + ok + ") " + cd);
        return ok;
    }

    public static MCostDetail get(Properties ctx, String whereClause, int ID, int M_AttributeSetInstance_ID, int C_AcctSchema_ID, String trxName) {
        String localWhereClause = String.valueOf(whereClause) + " AND C_AcctSchema_ID=?";
        MCostDetail retValue = (MCostDetail)new Query(ctx, "M_CostDetail", localWhereClause, trxName).setParameters(ID, C_AcctSchema_ID).first();
        return retValue;
    }

    public static MCostDetail getP(Properties ctx, String whereClause, int ID, int M_AttributeSetInstance_ID, int C_AcctSchema_ID, int M_Product_ID, String trxName) {
        String localWhereClause = String.valueOf(whereClause) + " AND C_AcctSchema_ID=? AND M_Product_ID=? AND (M_AttributeSetInstance_ID is null or M_AttributeSetInstance_ID=?)";
        MCostDetail retValue = (MCostDetail)new Query(ctx, "M_CostDetail", localWhereClause, trxName).setParameters(ID, C_AcctSchema_ID, M_Product_ID, M_AttributeSetInstance_ID).first();
        return retValue;
    }

    public static void resetCostToInvoice(int Product_ID, BigDecimal margen, int Org_ID, boolean updateQty, int Warehouse_ID, String trxName, Properties ctx) {
        MInvoiceLine[] lines;
        if (MProduct.get(ctx, Product_ID).isBOM()) {
            return;
        }
        OFBProductCost.processCost(Product_ID, trxName, ctx);
        BigDecimal currentCost = OFBProductCost.getProductCost(Product_ID, Org_ID, Env.ONE, trxName, ctx);
        BigDecimal currentQty = OFBProductCost.getProductCostQty(Product_ID, Org_ID, trxName, ctx);
        BigDecimal lastCost = Env.ZERO;
        MInvoice invoice = null;
        if (Org_ID > 0) {
            Org_ID = OFBProductCost.getParentOrg(Org_ID, trxName, ctx);
        }
        if ((invoice = OFBProductCost.getLastInvoice(Product_ID, Org_ID, trxName)) == null) {
            return;
        }
        MInvoiceLine[] mInvoiceLineArray = lines = invoice.getLines();
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            MInvoiceLine line = mInvoiceLineArray[n2];
            if (line.getM_Product_ID() == Product_ID) {
                lastCost = line.getPriceActual();
            }
            ++n2;
        }
        margen = margen.divide(Env.ONEHUNDRED);
        if (currentCost.compareTo(lastCost.add(margen = lastCost.multiply(margen))) > 0 || currentCost.compareTo(lastCost.subtract(margen)) < 0) {
            BigDecimal qty = Env.ZERO;
            if (updateQty) {
                qty = MStorage.getQtyAvailable(Warehouse_ID, 0, Product_ID, 0, trxName);
            }
            MCostDetail cd = new MCostDetail(MAcctSchema.getClientAcctSchema(Env.getCtx(), Env.getAD_Client_ID(Env.getCtx()))[0], Org_ID, Product_ID, 0, 0, lastCost.subtract(currentCost), qty.subtract(currentQty), "Correccion Costo Ultima Factura", trxName);
            cd.set_CustomColumn("Enabled", true);
            cd.save();
            OFBProductCost.processCost(Product_ID, trxName, ctx);
        }
    }

    public static void resetCostBOMToInvoice(int Product_ID, BigDecimal margen, int Org_ID, boolean updateQty, int Warehouse_ID, String trxName, Properties ctx) {
        if (!MProduct.get(Env.getCtx(), Product_ID).isBOM()) {
            return;
        }
        OFBProductCost.processCost(Product_ID, trxName, ctx);
        BigDecimal currentCost = OFBProductCost.getProductCost(Product_ID, Org_ID, Env.ONE, trxName, ctx);
        BigDecimal lastCost = Env.ZERO;
        if (Org_ID > 0) {
            Org_ID = OFBProductCost.getParentOrg(Org_ID, trxName, ctx);
        }
        margen = margen.divide(Env.ONEHUNDRED);
        if (currentCost.compareTo(lastCost.add(margen = lastCost.multiply(margen))) > 0 || currentCost.compareTo(lastCost.subtract(margen)) < 0) {
            BigDecimal qty = Env.ZERO;
            if (updateQty) {
                qty = MStorage.getQtyAvailable(Warehouse_ID, 0, Product_ID, 0, trxName);
            }
            MCostDetail cd = new MCostDetail(MAcctSchema.getClientAcctSchema(Env.getCtx(), Env.getAD_Client_ID(Env.getCtx()))[0], Org_ID, Product_ID, 0, 0, lastCost.subtract(currentCost), qty, "Correccion Costo Ultima Factura", trxName);
            cd.save();
            OFBProductCost.processCost(Product_ID, trxName, ctx);
        }
    }

    public static void resetCostToPO(int Product_ID, BigDecimal margen, int Org_ID, boolean updateQty, int Warehouse_ID, String trxName, Properties ctx) {
        MOrderLine[] lines;
        OFBProductCost.processCost(Product_ID, trxName, ctx);
        BigDecimal currentCost = OFBProductCost.getProductCost(Product_ID, Org_ID, Env.ONE, trxName, ctx);
        BigDecimal currentQty = OFBProductCost.getProductCostQty(Product_ID, Org_ID, trxName, ctx);
        BigDecimal lastCost = Env.ZERO;
        MOrder order = null;
        if (Org_ID > 0) {
            Org_ID = OFBProductCost.getParentOrg(Org_ID, trxName, ctx);
        }
        if ((order = OFBProductCost.getLastPO(Product_ID, Org_ID, trxName)) == null) {
            return;
        }
        MOrderLine[] mOrderLineArray = lines = order.getLines();
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            MOrderLine line = mOrderLineArray[n2];
            if (line.getM_Product_ID() == Product_ID) {
                lastCost = line.getPriceActual();
            }
            ++n2;
        }
        margen = margen.divide(Env.ONEHUNDRED);
        if (currentCost.compareTo(lastCost.add(margen = lastCost.multiply(margen))) > 0 || currentCost.compareTo(lastCost.subtract(margen)) < 0) {
            BigDecimal qty = Env.ZERO;
            if (updateQty) {
                qty = MStorage.getQtyAvailable(Warehouse_ID, 0, Product_ID, 0, trxName);
            }
            MCostDetail cd = new MCostDetail(MAcctSchema.getClientAcctSchema(Env.getCtx(), Env.getAD_Client_ID(Env.getCtx()))[0], Org_ID, Product_ID, 0, 0, lastCost.subtract(currentCost), qty.subtract(currentQty), "Correccion Costo Ultima PO", trxName);
            cd.set_CustomColumn("Enabled", true);
            cd.save();
            OFBProductCost.processCost(Product_ID, trxName, ctx);
        }
    }

    public static MInvoice getLastInvoice(int Product_ID, int Org_ID, String trxName) {
        String sqlWhere = " C_Invoice.docstatus IN ('CO','CL') and C_Invoice.IsSoTrx='N'  and exists (select * from c_invoiceline where c_invoiceline.c_invoice_id=c_invoice.c_invoice_id and c_invoiceline.m_product_id=? and c_invoiceline.qtyinvoiced>0)";
        if (Org_ID > 0) {
            sqlWhere = String.valueOf(sqlWhere) + " and C_Invoice.AD_Org_ID=" + Org_ID;
        }
        Query qy = new Query(Env.getCtx(), "C_Invoice", sqlWhere, trxName);
        qy = qy.setParameters(Product_ID);
        qy = qy.setOrderBy(" C_Invoice.DateInvoiced Desc");
        MInvoice invoice = (MInvoice)qy.first();
        return invoice;
    }

    public static MOrder getLastPO(int Product_ID, int Org_ID, String trxName) {
        String sqlWhere = " C_Order.docstatus IN ('CO','CL') and C_Order.IsSoTrx='N'  and exists (select * from C_Orderline where C_Orderline.C_Order_id=C_Order.C_Order_id and C_Orderline.m_product_id=? and C_Orderline.qtyOrdered>0)";
        if (Org_ID > 0) {
            sqlWhere = String.valueOf(sqlWhere) + " and C_Order.AD_Org_ID=" + Org_ID;
        }
        Query qy = new Query(Env.getCtx(), "C_Order", sqlWhere, trxName);
        qy = qy.setParameters(Product_ID);
        qy = qy.setOrderBy(" C_Invoice.DateOrdered Desc");
        MOrder order = (MOrder)qy.first();
        return order;
    }

    public static MCostElement getStandarCostelement(Properties ctx) {
        return MCostElement.getByCostingMethod(ctx, "S").get(0);
    }

    public static MCost get(Properties ctx, int AD_Client_ID, int AD_Org_ID, int M_Product_ID, int M_CostType_ID, int C_AcctSchema_ID, int M_CostElement_ID, int M_AttributeSetInstance_ID, String trxName) {
        String whereClause = "AD_Client_ID=? AND AD_Org_ID=? AND M_Product_ID=? AND M_CostType_ID=? AND C_AcctSchema_ID=? AND M_CostElement_ID=?";
        Object[] params = new Object[]{AD_Client_ID, AD_Org_ID, M_Product_ID, M_CostType_ID, C_AcctSchema_ID, M_CostElement_ID};
        return (MCost)new Query(ctx, "M_Cost", "AD_Client_ID=? AND AD_Org_ID=? AND M_Product_ID=? AND M_CostType_ID=? AND C_AcctSchema_ID=? AND M_CostElement_ID=?", trxName).setOnlyActiveRecords(true).setParameters(params).first();
    }

    public static BigDecimal getProductCosts(MAcctSchema as, String whereClause, DocLine line, int C_AcctSchema_ID, String trxName, Properties ctx) {
        MCostDetail cd;
        if (whereClause != null && (cd = MCostDetail.get(ctx, whereClause, line.get_ID(), line.getM_AttributeSetInstance_ID(), C_AcctSchema_ID, trxName)) != null) {
            return cd.getAmt();
        }
        return OFBProductCost.getProductCost(line.getM_Product_ID(), line.getAD_Org_ID(), line.getQty(), trxName, ctx);
    }
}

