/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.model.MCalendar;
import org.compiere.model.MClient;
import org.compiere.model.MPeriod;
import org.compiere.model.X_C_Year;
import org.compiere.util.Env;
import org.compiere.util.Language;

public class MYear
extends X_C_Year {
    private static final long serialVersionUID = 2110541427179611810L;

    public MYear(Properties ctx, int C_Year_ID, String trxName) {
        super(ctx, C_Year_ID, trxName);
        if (C_Year_ID == 0) {
            this.setProcessing(false);
        }
    }

    public MYear(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MYear(MCalendar calendar) {
        this(calendar.getCtx(), 0, calendar.get_TrxName());
        this.setClientOrg(calendar);
        this.setC_Calendar_ID(calendar.getC_Calendar_ID());
        this.setYear();
    }

    private void setYear() {
        GregorianCalendar cal = new GregorianCalendar(Language.getLoginLanguage().getLocale());
        String Year = String.valueOf(cal.get(1));
        super.setFiscalYear(Year);
    }

    public int getYearAsInt() {
        String year = this.getFiscalYear();
        try {
            return Integer.parseInt(year);
        }
        catch (Exception e) {
            StringTokenizer st = new StringTokenizer(year, "/-, \t\n\r\f");
            if (st.hasMoreTokens()) {
                String year2 = st.nextToken();
                try {
                    return Integer.parseInt(year2);
                }
                catch (Exception e2) {
                    this.log.log(Level.WARNING, year + "->" + year2 + " - " + e2.toString());
                }
            } else {
                this.log.log(Level.WARNING, year + " - " + e.toString());
            }
            return 0;
        }
    }

    public String getYY() {
        int yy = this.getYearAsInt();
        String year = String.valueOf(yy);
        if (year.length() == 4) {
            return year.substring(2, 4);
        }
        return this.getFiscalYear();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MYear[");
        sb.append(this.get_ID()).append("-").append(this.getFiscalYear()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        int yy = this.getYearAsInt();
        if (yy == 0) {
            throw new FillMandatoryException(new String[]{"FiscalYear"});
        }
        return true;
    }

    public void createStdPeriods(Locale locale) {
        this.createStdPeriods(locale, null, null);
    }

    public boolean createStdPeriods(Locale locale, Timestamp startDate, String dateFormat) {
        if (locale == null) {
            MClient client = MClient.get(this.getCtx());
            locale = client.getLocale();
        }
        if (locale == null && Language.getLoginLanguage() != null) {
            locale = Language.getLoginLanguage().getLocale();
        }
        if (locale == null) {
            locale = Env.getLanguage(this.getCtx()).getLocale();
        }
        if (dateFormat == null || dateFormat.equals("")) {
            dateFormat = "MMM-yy";
        }
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat, locale);
        int year = this.getYearAsInt();
        GregorianCalendar cal = new GregorianCalendar(locale);
        if (startDate != null) {
            cal.setTime(startDate);
            if (cal.get(1) != year) {
                year = cal.get(1);
            }
        } else {
            cal.set(1, year);
            cal.set(2, 0);
            cal.set(5, 1);
        }
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        for (int month = 0; month < 12; ++month) {
            Timestamp start = new Timestamp(cal.getTimeInMillis());
            String name = formatter.format(start);
            cal.add(2, 1);
            cal.add(6, -1);
            Timestamp end = new Timestamp(cal.getTimeInMillis());
            MPeriod period = MPeriod.findByCalendar(this.getCtx(), start, this.getC_Calendar_ID(), this.get_TrxName());
            if (period == null) {
                period = new MPeriod(this, month + 1, name, start, end);
            } else {
                period.setC_Year_ID(this.getC_Year_ID());
                period.setPeriodNo(month + 1);
                period.setName(name);
                period.setStartDate(start);
                period.setEndDate(end);
            }
            period.saveEx(this.get_TrxName());
            cal.add(6, 1);
        }
        return true;
    }
}

