/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.AccessSqlParser;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MColumnAccess;
import org.compiere.model.MOrg;
import org.compiere.model.MPrivateAccess;
import org.compiere.model.MRecordAccess;
import org.compiere.model.MRoleOrgAccess;
import org.compiere.model.MTable;
import org.compiere.model.MTableAccess;
import org.compiere.model.MTree_Base;
import org.compiere.model.MUserOrgAccess;
import org.compiere.model.MUserRoles;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Role;
import org.compiere.model.X_AD_Role_Included;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.Trace;

public final class MRole
extends X_AD_Role {
    private static final long serialVersionUID = 3684323160980498188L;
    private static CCache<String, MRole> s_roles = new CCache("AD_Role", 5);
    private static CLogger s_log = CLogger.getCLogger(MRole.class);
    public static final boolean SQL_RW = true;
    public static final boolean SQL_RO = false;
    public static final boolean SQL_FULLYQUALIFIED = true;
    public static final boolean SQL_NOTQUALIFIED = false;
    public static final int SUPERUSER_USER_ID = 100;
    public static final int SYSTEM_USER_ID = 0;
    private static final String ROLE_KEY = "org.compiere.model.DefaultRole";
    private int m_AD_User_ID = -1;
    private OrgAccess[] m_orgAccess = null;
    private MTableAccess[] m_tableAccess = null;
    private MColumnAccess[] m_columnAccess = null;
    private MRecordAccess[] m_recordAccess = null;
    private MRecordAccess[] m_recordDependentAccess = null;
    private HashMap<Integer, String> m_tableAccessLevel = null;
    private HashMap<String, Integer> m_tableName = null;
    private Set<String> m_viewName = null;
    private HashMap<String, String> m_tableIdName = null;
    private HashMap<Integer, Boolean> m_windowAccess = null;
    private HashMap<Integer, Boolean> m_processAccess = null;
    private HashMap<Integer, Boolean> m_taskAccess = null;
    private HashMap<Integer, Boolean> m_workflowAccess = null;
    private HashMap<Integer, Boolean> m_formAccess = null;
    private List<MRole> m_includedRoles = null;
    private MRole m_parent = null;
    private int m_includedSeqNo = -1;

    public static MRole getDefault() {
        return MRole.getDefault(Env.getCtx(), false);
    }

    public static MRole getDefault(Properties ctx, boolean reload) {
        int AD_Role_ID = Env.getContextAsInt(ctx, "#AD_Role_ID");
        int AD_User_ID = Env.getContextAsInt(ctx, "#AD_User_ID");
        MRole defaultRole = MRole.getDefaultRole();
        if (reload || defaultRole == null) {
            defaultRole = MRole.get(ctx, AD_Role_ID, AD_User_ID, reload);
            MRole.setDefaultRole(defaultRole);
        } else if (defaultRole.getAD_Role_ID() != AD_Role_ID || defaultRole.getAD_User_ID() != AD_User_ID) {
            defaultRole = MRole.get(ctx, AD_Role_ID, AD_User_ID, reload);
            MRole.setDefaultRole(defaultRole);
        }
        return defaultRole;
    }

    private static void setDefaultRole(MRole defaultRole) {
        Env.getCtx().remove(ROLE_KEY);
        Env.getCtx().put(ROLE_KEY, defaultRole);
    }

    private static MRole getDefaultRole() {
        return (MRole)Env.getCtx().get(ROLE_KEY);
    }

    public static MRole get(Properties ctx, int AD_Role_ID, int AD_User_ID, boolean reload) {
        s_log.info("AD_Role_ID=" + AD_Role_ID + ", AD_User_ID=" + AD_User_ID + ", reload=" + reload);
        String key = AD_Role_ID + "_" + AD_User_ID;
        MRole role = s_roles.get(key);
        if (role == null || reload) {
            role = new MRole(ctx, AD_Role_ID, null);
            s_roles.put(key, role);
            if (AD_Role_ID == 0) {
                String trxName = null;
                role.load(trxName);
            }
            role.setAD_User_ID(AD_User_ID);
            role.loadAccess(reload);
            s_log.info(role.toString());
        }
        return role;
    }

    public static MRole get(Properties ctx, int AD_Role_ID) {
        return MRole.get(ctx, AD_Role_ID, Env.getAD_User_ID(ctx), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MRole[] getOfClient(Properties ctx) {
        String sql = "SELECT * FROM AD_Role WHERE AD_Client_ID=?";
        ArrayList<MRole> list = new ArrayList<MRole>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, Env.getAD_Client_ID(ctx));
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MRole(ctx, rs, null));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MRole[] retValue = new MRole[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MRole[] getOf(Properties ctx, String whereClause) {
        String sql = "SELECT * FROM AD_Role";
        if (whereClause != null && whereClause.length() > 0) {
            sql = sql + " WHERE " + whereClause;
        }
        ArrayList<MRole> list = new ArrayList<MRole>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MRole(ctx, rs, null));
            }
        }
        catch (Exception e) {
            try {
                s_log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        MRole[] retValue = new MRole[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MRole(Properties ctx, int AD_Role_ID, String trxName) {
        super(ctx, AD_Role_ID, trxName);
        if (AD_Role_ID == 0) {
            this.setIsCanExport(true);
            this.setIsCanReport(true);
            this.setIsManual(false);
            this.setIsPersonalAccess(false);
            this.setIsPersonalLock(false);
            this.setIsShowAcct(false);
            this.setIsAccessAllOrgs(false);
            this.setUserLevel("  O");
            this.setPreferenceType("O");
            this.setIsChangeLog(false);
            this.setOverwritePriceLimit(false);
            this.setIsUseUserOrgAccess(false);
            this.setMaxQueryRecords(0);
            this.setConfirmQueryRecords(0);
        }
    }

    public MRole(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public int getConfirmQueryRecords() {
        int no = super.getConfirmQueryRecords();
        if (no == 0) {
            return 500;
        }
        return no;
    }

    public boolean isQueryRequire(int noRecords) {
        if (noRecords < 2) {
            return false;
        }
        int max = this.getMaxQueryRecords();
        if (max > 0 && noRecords > max) {
            return true;
        }
        int qu = this.getConfirmQueryRecords();
        return noRecords > qu;
    }

    public boolean isQueryMax(int noRecords) {
        int max = this.getMaxQueryRecords();
        return max > 0 && noRecords > max;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getAD_Client_ID() == 0) {
            this.setUserLevel("S  ");
        } else if (this.getUserLevel().equals("S  ")) {
            this.log.saveWarning("AccessTableNoUpdate", Msg.getElement(this.getCtx(), "UserLevel"));
            return false;
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord && success) {
            MUserRoles su = new MUserRoles(this.getCtx(), 100, this.getAD_Role_ID(), this.get_TrxName());
            su.save();
            if (this.getCreatedBy() != 100) {
                MUserRoles ur = new MUserRoles(this.getCtx(), this.getCreatedBy(), this.getAD_Role_ID(), this.get_TrxName());
                ur.save();
            }
            this.updateAccessRecords();
        } else if (this.is_ValueChanged("UserLevel")) {
            this.updateAccessRecords();
        }
        if (MRole.getDefaultRole() != null && MRole.getDefaultRole().get_ID() == this.get_ID()) {
            MRole.setDefaultRole(this);
        }
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success) {
            this.deleteAccessRecords();
        }
        return success;
    }

    public String updateAccessRecords() {
        if (this.isManual()) {
            return "-";
        }
        String roleClientOrgUser = this.getAD_Role_ID() + "," + this.getAD_Client_ID() + "," + this.getAD_Org_ID() + ",'Y', SysDate," + this.getUpdatedBy() + ", SysDate," + this.getUpdatedBy() + ",'Y' ";
        String sqlWindow = "INSERT INTO AD_Window_Access (AD_Window_ID, AD_Role_ID, AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,IsReadWrite) SELECT DISTINCT w.AD_Window_ID, " + roleClientOrgUser + "FROM AD_Window w" + " INNER JOIN AD_Tab t ON (w.AD_Window_ID=t.AD_Window_ID)" + " INNER JOIN AD_Table tt ON (t.AD_Table_ID=tt.AD_Table_ID) " + "WHERE t.SeqNo=(SELECT MIN(SeqNo) FROM AD_Tab xt " + "WHERE xt.AD_Window_ID=w.AD_Window_ID)" + "AND tt.AccessLevel IN ";
        String sqlProcess = "INSERT INTO AD_Process_Access (AD_Process_ID, AD_Role_ID, AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,IsReadWrite) SELECT DISTINCT p.AD_Process_ID, " + roleClientOrgUser + "FROM AD_Process p " + "WHERE AccessLevel IN ";
        String sqlForm = "INSERT INTO AD_Form_Access (AD_Form_ID, AD_Role_ID, AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,IsReadWrite) SELECT f.AD_Form_ID, " + roleClientOrgUser + "FROM AD_Form f " + "WHERE AccessLevel IN ";
        String sqlWorkflow = "INSERT INTO AD_WorkFlow_Access (AD_WorkFlow_ID, AD_Role_ID, AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,IsReadWrite) SELECT w.AD_WorkFlow_ID, " + roleClientOrgUser + "FROM AD_WorkFlow w " + "WHERE AccessLevel IN ";
        String sqlDocAction = "INSERT INTO AD_Document_Action_Access (AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy,C_DocType_ID , AD_Ref_List_ID, AD_Role_ID) (SELECT " + this.getAD_Client_ID() + ",0,'Y', SysDate," + this.getUpdatedBy() + ", SysDate," + this.getUpdatedBy() + ", doctype.C_DocType_ID, action.AD_Ref_List_ID, rol.AD_Role_ID " + "FROM AD_Client client " + "INNER JOIN C_DocType doctype ON (doctype.AD_Client_ID=client.AD_Client_ID) " + "INNER JOIN AD_Ref_List action ON (action.AD_Reference_ID=135) " + "INNER JOIN AD_Role rol ON (rol.AD_Client_ID=client.AD_Client_ID " + "AND rol.AD_Role_ID=" + this.getAD_Role_ID() + ") )";
        String roleAccessLevel = null;
        String roleAccessLevelWin = null;
        if ("S  ".equals(this.getUserLevel())) {
            roleAccessLevel = "('4','7','6')";
        } else if (" C ".equals(this.getUserLevel())) {
            roleAccessLevel = "('7','6','3','2')";
        } else if (" CO".equals(this.getUserLevel())) {
            roleAccessLevel = "('7','6','3','2','1')";
        } else {
            roleAccessLevel = "('3','1','7')";
            roleAccessLevelWin = roleAccessLevel + " AND w.Name NOT LIKE '%(all)%'";
        }
        if (roleAccessLevelWin == null) {
            roleAccessLevelWin = roleAccessLevel;
        }
        String whereDel = " WHERE AD_Role_ID=" + this.getAD_Role_ID();
        int winDel = DB.executeUpdate("DELETE FROM AD_Window_Access" + whereDel, this.get_TrxName());
        int win = DB.executeUpdate(sqlWindow + roleAccessLevelWin, this.get_TrxName());
        int procDel = DB.executeUpdate("DELETE FROM AD_Process_Access" + whereDel, this.get_TrxName());
        int proc = DB.executeUpdate(sqlProcess + roleAccessLevel, this.get_TrxName());
        int formDel = DB.executeUpdate("DELETE FROM AD_Form_Access" + whereDel, this.get_TrxName());
        int form = DB.executeUpdate(sqlForm + roleAccessLevel, this.get_TrxName());
        int wfDel = DB.executeUpdate("DELETE FROM AD_WorkFlow_Access" + whereDel, this.get_TrxName());
        int wf = DB.executeUpdate(sqlWorkflow + roleAccessLevel, this.get_TrxName());
        int docactDel = DB.executeUpdate("DELETE FROM AD_Document_Action_Access" + whereDel, this.get_TrxName());
        int docact = DB.executeUpdate(sqlDocAction, this.get_TrxName());
        this.log.fine("AD_Window_ID=" + winDel + "+" + win + ", AD_Process_ID=" + procDel + "+" + proc + ", AD_Form_ID=" + formDel + "+" + form + ", AD_Workflow_ID=" + wfDel + "+" + wf + ", AD_Document_Action_Access=" + docactDel + "+" + docact);
        this.loadAccess(true);
        return "@AD_Window_ID@ #" + win + " -  @AD_Process_ID@ #" + proc + " -  @AD_Form_ID@ #" + form + " -  @AD_Workflow_ID@ #" + wf + " -  @DocAction@ #" + docact;
    }

    private void deleteAccessRecords() {
        String whereDel = " WHERE AD_Role_ID=" + this.getAD_Role_ID();
        int winDel = DB.executeUpdate("DELETE FROM AD_Window_Access" + whereDel, this.get_TrxName());
        int procDel = DB.executeUpdate("DELETE FROM AD_Process_Access" + whereDel, this.get_TrxName());
        int formDel = DB.executeUpdate("DELETE FROM AD_Form_Access" + whereDel, this.get_TrxName());
        int wfDel = DB.executeUpdate("DELETE FROM AD_WorkFlow_Access" + whereDel, this.get_TrxName());
        int docactDel = DB.executeUpdate("DELETE FROM AD_Document_Action_Access" + whereDel, this.get_TrxName());
        this.log.fine("AD_Window_Access=" + winDel + ", AD_Process_Access=" + procDel + ", AD_Form_Access=" + formDel + ", AD_Workflow_Access=" + wfDel + ", AD_Document_Action_Access=" + docactDel);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MRole[");
        sb.append(this.getAD_Role_ID()).append(",").append(this.getName()).append(",UserLevel=").append(this.getUserLevel()).append(",").append(this.getClientWhere(false)).append(",").append(this.getOrgWhere(false)).append("]");
        return sb.toString();
    }

    public String toStringX(Properties ctx) {
        int i2;
        StringBuffer sb = new StringBuffer();
        sb.append(Msg.translate(ctx, "AD_Role_ID")).append("=").append(this.getName()).append(" - ").append(Msg.translate(ctx, "IsCanExport")).append("=").append(this.isCanExport()).append(" - ").append(Msg.translate(ctx, "IsCanReport")).append("=").append(this.isCanReport()).append(Env.NL).append(Env.NL);
        for (i2 = 0; i2 < this.m_orgAccess.length; ++i2) {
            sb.append(this.m_orgAccess[i2].toString()).append(Env.NL);
        }
        sb.append(Env.NL);
        this.loadTableAccess(false);
        for (i2 = 0; i2 < this.m_tableAccess.length; ++i2) {
            sb.append(this.m_tableAccess[i2].toStringX(ctx)).append(Env.NL);
        }
        if (this.m_tableAccess.length > 0) {
            sb.append(Env.NL);
        }
        this.loadColumnAccess(false);
        for (i2 = 0; i2 < this.m_columnAccess.length; ++i2) {
            sb.append(this.m_columnAccess[i2].toStringX(ctx)).append(Env.NL);
        }
        if (this.m_columnAccess.length > 0) {
            sb.append(Env.NL);
        }
        this.loadRecordAccess(false);
        for (i2 = 0; i2 < this.m_recordAccess.length; ++i2) {
            sb.append(this.m_recordAccess[i2].toStringX(ctx)).append(Env.NL);
        }
        return sb.toString();
    }

    public void setAD_User_ID(int AD_User_ID) {
        this.m_AD_User_ID = AD_User_ID;
    }

    public int getAD_User_ID() {
        return this.m_AD_User_ID;
    }

    public void loadAccess(boolean reload) {
        this.loadOrgAccess(reload);
        this.loadTableAccess(reload);
        this.loadTableInfo(reload);
        this.loadColumnAccess(reload);
        this.loadRecordAccess(reload);
        if (reload) {
            this.m_windowAccess = null;
            this.m_processAccess = null;
            this.m_taskAccess = null;
            this.m_workflowAccess = null;
            this.m_formAccess = null;
        }
        this.loadIncludedRoles(reload);
    }

    private void loadOrgAccess(boolean reload) {
        if (!reload && this.m_orgAccess != null) {
            return;
        }
        ArrayList<OrgAccess> list = new ArrayList<OrgAccess>();
        if (this.isUseUserOrgAccess()) {
            this.loadOrgAccessUser(list);
        } else {
            this.loadOrgAccessRole(list);
        }
        this.m_orgAccess = new OrgAccess[list.size()];
        list.toArray(this.m_orgAccess);
        this.log.fine("#" + this.m_orgAccess.length + (reload ? " - reload" : ""));
        if (Ini.isClient()) {
            StringBuffer sb = new StringBuffer();
            for (int i2 = 0; i2 < this.m_orgAccess.length; ++i2) {
                if (i2 > 0) {
                    sb.append(",");
                }
                sb.append(this.m_orgAccess[i2].AD_Org_ID);
            }
            Env.setContext(Env.getCtx(), "#User_Org", sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadOrgAccessUser(ArrayList<OrgAccess> list) {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "SELECT * FROM AD_User_OrgAccess WHERE AD_User_ID=? AND IsActive='Y'";
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_User_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MUserOrgAccess oa = new MUserOrgAccess(this.getCtx(), rs, this.get_TrxName());
                this.loadOrgAccessAdd(list, new OrgAccess(oa.getAD_Client_ID(), oa.getAD_Org_ID(), oa.isReadOnly()));
            }
            DB.close(rs, pstmt);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadOrgAccessRole(ArrayList<OrgAccess> list) {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "SELECT * FROM AD_Role_OrgAccess WHERE AD_Role_ID=? AND IsActive='Y'";
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_Role_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MRoleOrgAccess oa = new MRoleOrgAccess(this.getCtx(), rs, this.get_TrxName());
                this.loadOrgAccessAdd(list, new OrgAccess(oa.getAD_Client_ID(), oa.getAD_Org_ID(), oa.isReadOnly()));
            }
            DB.close(rs, pstmt);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadOrgAccessAdd(ArrayList<OrgAccess> list, OrgAccess oa) {
        if (list.contains(oa)) {
            return;
        }
        list.add(oa);
        if (this.getAD_Tree_Org_ID() == 0) {
            return;
        }
        MOrg org = MOrg.get(this.getCtx(), oa.AD_Org_ID);
        if (!org.isSummary()) {
            return;
        }
        MTree_Base tree = MTree_Base.get(this.getCtx(), this.getAD_Tree_Org_ID(), this.get_TrxName());
        String sql = "SELECT AD_Client_ID, AD_Org_ID FROM AD_Org WHERE IsActive='Y' AND AD_Org_ID IN (SELECT Node_ID FROM " + tree.getNodeTableName() + " WHERE AD_Tree_ID=? AND Parent_ID=? AND IsActive='Y')";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, tree.getAD_Tree_ID());
            pstmt.setInt(2, org.getAD_Org_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int AD_Client_ID = rs.getInt(1);
                int AD_Org_ID = rs.getInt(2);
                this.loadOrgAccessAdd(list, new OrgAccess(AD_Client_ID, AD_Org_ID, oa.readOnly));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTableAccess(boolean reload) {
        if (this.m_tableAccess != null && !reload) {
            return;
        }
        ArrayList<MTableAccess> list = new ArrayList<MTableAccess>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "SELECT * FROM AD_Table_Access WHERE AD_Role_ID=? AND IsActive='Y'";
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_Role_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MTableAccess(this.getCtx(), rs, this.get_TrxName()));
            }
            DB.close(rs, pstmt);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
        }
        this.m_tableAccess = new MTableAccess[list.size()];
        list.toArray(this.m_tableAccess);
        this.log.fine("#" + this.m_tableAccess.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTableInfo(boolean reload) {
        if (this.m_tableAccessLevel != null && this.m_tableName != null && !reload) {
            return;
        }
        this.m_tableAccessLevel = new HashMap(300);
        this.m_tableName = new HashMap(300);
        this.m_viewName = new HashSet<String>(300);
        this.m_tableIdName = new HashMap(300);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "SELECT AD_Table_ID, AccessLevel, TableName, IsView, (SELECT ColumnName FROM AD_COLUMN WHERE AD_COLUMN.AD_TABLE_ID = AD_TABLE.AD_TABLE_ID AND AD_COLUMN.COLUMNNAME = AD_TABLE.TABLENAME || '_ID') FROM AD_Table WHERE IsActive='Y'";
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String idColumn;
                Integer ii = new Integer(rs.getInt(1));
                this.m_tableAccessLevel.put(ii, rs.getString(2));
                String tableName = rs.getString(3);
                this.m_tableName.put(tableName, ii);
                String isView = rs.getString(4);
                if ("Y".equals(isView)) {
                    this.m_viewName.add(tableName.toUpperCase());
                }
                if ((idColumn = rs.getString(5)) == null || idColumn.trim().length() <= 0) continue;
                this.m_tableIdName.put(tableName.toUpperCase(), idColumn);
            }
        }
        catch (Exception e) {
            try {
                this.log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close(rs, pstmt);
        }
        DB.close(rs, pstmt);
        this.log.fine("#" + this.m_tableAccessLevel.size());
    }

    private boolean isView(String tableName) {
        if (this.m_viewName == null) {
            this.loadAccess(true);
        }
        return this.m_viewName.contains(tableName.toUpperCase());
    }

    private String getIdColumnName(String tableName) {
        return this.m_tableIdName.get(tableName.toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadColumnAccess(boolean reload) {
        if (this.m_columnAccess != null && !reload) {
            return;
        }
        ArrayList<MColumnAccess> list = new ArrayList<MColumnAccess>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "SELECT * FROM AD_Column_Access WHERE AD_Role_ID=? AND IsActive='Y'";
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_Role_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MColumnAccess(this.getCtx(), rs, this.get_TrxName()));
            }
            DB.close(rs, pstmt);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
        }
        this.m_columnAccess = new MColumnAccess[list.size()];
        list.toArray(this.m_columnAccess);
        this.log.fine("#" + this.m_columnAccess.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRecordAccess(boolean reload) {
        if (!reload && this.m_recordAccess != null && this.m_recordDependentAccess != null) {
            return;
        }
        ArrayList<MRecordAccess> list = new ArrayList<MRecordAccess>();
        ArrayList<MRecordAccess> dependent = new ArrayList<MRecordAccess>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "SELECT * FROM AD_Record_Access WHERE AD_Role_ID=? AND IsActive='Y' ORDER BY AD_Table_ID";
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_Role_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                MRecordAccess ra = new MRecordAccess(this.getCtx(), rs, this.get_TrxName());
                list.add(ra);
                if (!ra.isDependentEntities()) continue;
                dependent.add(ra);
            }
            DB.close(rs, pstmt);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
        }
        this.m_recordAccess = new MRecordAccess[list.size()];
        list.toArray(this.m_recordAccess);
        this.m_recordDependentAccess = new MRecordAccess[dependent.size()];
        dependent.toArray(this.m_recordDependentAccess);
        this.log.fine("#" + this.m_recordAccess.length + " - Dependent #" + this.m_recordDependentAccess.length);
    }

    public String getClientWhere(boolean rw) {
        if (this.isAccessAllOrgs()) {
            if (rw || this.getAD_Client_ID() == 0) {
                return "AD_Client_ID=" + this.getAD_Client_ID();
            }
            return "AD_Client_ID IN (0," + this.getAD_Client_ID() + ")";
        }
        this.loadOrgAccess(false);
        HashSet<String> set = new HashSet<String>();
        if (!rw) {
            set.add("0");
        }
        for (int i2 = 0; i2 < this.m_orgAccess.length; ++i2) {
            set.add(String.valueOf(this.m_orgAccess[i2].AD_Client_ID));
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = set.iterator();
        boolean oneOnly = true;
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(",");
                oneOnly = false;
            }
            sb.append((String)it.next());
        }
        if (oneOnly) {
            if (sb.length() > 0) {
                return "AD_Client_ID=" + sb.toString();
            }
            this.log.log(Level.SEVERE, "No Access Org records");
            return "AD_Client_ID=-1";
        }
        return "AD_Client_ID IN(" + sb.toString() + ")";
    }

    public boolean isClientAccess(int AD_Client_ID, boolean rw) {
        if (AD_Client_ID == 0 && !rw) {
            return true;
        }
        if (this.isAccessAllOrgs()) {
            return this.getAD_Client_ID() == AD_Client_ID;
        }
        this.loadOrgAccess(false);
        for (int i2 = 0; i2 < this.m_orgAccess.length; ++i2) {
            if (this.m_orgAccess[i2].AD_Client_ID != AD_Client_ID) continue;
            if (!rw) {
                return true;
            }
            if (this.m_orgAccess[i2].readOnly) continue;
            return true;
        }
        return false;
    }

    public String getOrgWhere(boolean rw) {
        if (this.isAccessAllOrgs()) {
            return null;
        }
        this.loadOrgAccess(false);
        HashSet<String> set = new HashSet<String>();
        if (!rw) {
            set.add("0");
        }
        for (int i2 = 0; i2 < this.m_orgAccess.length; ++i2) {
            if (!rw) {
                set.add(String.valueOf(this.m_orgAccess[i2].AD_Org_ID));
                continue;
            }
            if (this.m_orgAccess[i2].readOnly) continue;
            set.add(String.valueOf(this.m_orgAccess[i2].AD_Org_ID));
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = set.iterator();
        boolean oneOnly = true;
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(",");
                oneOnly = false;
            }
            sb.append((String)it.next());
        }
        if (oneOnly) {
            if (sb.length() > 0) {
                return "AD_Org_ID=" + sb.toString();
            }
            this.log.log(Level.SEVERE, "No Access Org records");
            return "AD_Org_ID=-1";
        }
        return "AD_Org_ID IN(" + sb.toString() + ")";
    }

    public boolean isOrgAccess(int AD_Org_ID, boolean rw) {
        if (this.isAccessAllOrgs()) {
            return true;
        }
        if (AD_Org_ID == 0 && !rw) {
            return true;
        }
        this.loadOrgAccess(false);
        for (int i2 = 0; i2 < this.m_orgAccess.length; ++i2) {
            if (this.m_orgAccess[i2].AD_Org_ID != AD_Org_ID) continue;
            if (!rw) {
                return true;
            }
            return !this.m_orgAccess[i2].readOnly;
        }
        return false;
    }

    public boolean isCanReport(int AD_Table_ID) {
        if (!this.isCanReport()) {
            this.log.warning("Role denied");
            return false;
        }
        if (!this.isTableAccess(AD_Table_ID, true)) {
            return false;
        }
        boolean canReport = true;
        for (int i2 = 0; i2 < this.m_tableAccess.length; ++i2) {
            if (!"R".equals(this.m_tableAccess[i2].getAccessTypeRule())) continue;
            if (this.m_tableAccess[i2].isExclude()) {
                if (this.m_tableAccess[i2].getAD_Table_ID() != AD_Table_ID) continue;
                canReport = this.m_tableAccess[i2].isCanReport();
                this.log.fine("Exclude " + AD_Table_ID + " - " + canReport);
                return canReport;
            }
            canReport = false;
            if (this.m_tableAccess[i2].getAD_Table_ID() != AD_Table_ID) continue;
            canReport = this.m_tableAccess[i2].isCanReport();
            this.log.fine("Include " + AD_Table_ID + " - " + canReport);
            return canReport;
        }
        this.log.fine(AD_Table_ID + " - " + canReport);
        return canReport;
    }

    public boolean isCanExport(int AD_Table_ID) {
        if (!this.isCanExport()) {
            this.log.warning("Role denied");
            return false;
        }
        if (!this.isTableAccess(AD_Table_ID, true)) {
            return false;
        }
        if (!this.isCanReport(AD_Table_ID)) {
            return false;
        }
        boolean canExport = true;
        for (int i2 = 0; i2 < this.m_tableAccess.length; ++i2) {
            if (!"E".equals(this.m_tableAccess[i2].getAccessTypeRule())) continue;
            if (this.m_tableAccess[i2].isExclude()) {
                canExport = this.m_tableAccess[i2].isCanExport();
                this.log.fine("Exclude " + AD_Table_ID + " - " + canExport);
                return canExport;
            }
            canExport = false;
            canExport = this.m_tableAccess[i2].isCanExport();
            this.log.fine("Include " + AD_Table_ID + " - " + canExport);
            return canExport;
        }
        this.log.fine(AD_Table_ID + " - " + canExport);
        return canExport;
    }

    public boolean isTableAccess(int AD_Table_ID, boolean ro) {
        if (!this.isTableAccessLevel(AD_Table_ID, ro)) {
            return false;
        }
        this.loadTableAccess(false);
        boolean hasAccess = true;
        for (int i2 = 0; i2 < this.m_tableAccess.length; ++i2) {
            if (!"A".equals(this.m_tableAccess[i2].getAccessTypeRule())) continue;
            if (this.m_tableAccess[i2].isExclude()) {
                if (this.m_tableAccess[i2].getAD_Table_ID() != AD_Table_ID) continue;
                hasAccess = ro ? this.m_tableAccess[i2].isReadOnly() : false;
                this.log.fine("Exclude AD_Table_ID=" + AD_Table_ID + " (ro=" + ro + ",TableAccessRO=" + this.m_tableAccess[i2].isReadOnly() + ") = " + hasAccess);
                return hasAccess;
            }
            hasAccess = false;
            if (this.m_tableAccess[i2].getAD_Table_ID() != AD_Table_ID) continue;
            hasAccess = !ro ? !this.m_tableAccess[i2].isReadOnly() : true;
            this.log.fine("Include AD_Table_ID=" + AD_Table_ID + " (ro=" + ro + ",TableAccessRO=" + this.m_tableAccess[i2].isReadOnly() + ") = " + hasAccess);
            return hasAccess;
        }
        if (!hasAccess) {
            this.log.fine("AD_Table_ID=" + AD_Table_ID + "(ro=" + ro + ") = " + hasAccess);
        }
        return hasAccess;
    }

    public boolean isTableAccessLevel(int AD_Table_ID, boolean ro) {
        if (ro) {
            return true;
        }
        this.loadTableInfo(false);
        String roleAccessLevel = this.m_tableAccessLevel.get(new Integer(AD_Table_ID));
        if (roleAccessLevel == null) {
            this.log.fine("NO - No AccessLevel - AD_Table_ID=" + AD_Table_ID);
            return false;
        }
        if (roleAccessLevel.equals("7")) {
            return true;
        }
        String userLevel = this.getUserLevel();
        if (userLevel.charAt(0) == 'S' && (roleAccessLevel.equals("4") || roleAccessLevel.equals("6"))) {
            return true;
        }
        if (userLevel.charAt(1) == 'C' && (roleAccessLevel.equals("2") || roleAccessLevel.equals("6"))) {
            return true;
        }
        if (userLevel.charAt(2) == 'O' && (roleAccessLevel.equals("1") || roleAccessLevel.equals("3"))) {
            return true;
        }
        this.log.fine("NO - AD_Table_ID=" + AD_Table_ID + ", UserLevel=" + userLevel + ", AccessLevel=" + roleAccessLevel);
        return false;
    }

    public boolean isColumnAccess(int AD_Table_ID, int AD_Column_ID, boolean ro) {
        if (!this.isTableAccess(AD_Table_ID, ro)) {
            return false;
        }
        this.loadColumnAccess(false);
        boolean retValue = true;
        for (int i2 = 0; i2 < this.m_columnAccess.length; ++i2) {
            if (this.m_columnAccess[i2].isExclude()) {
                if (this.m_columnAccess[i2].getAD_Table_ID() != AD_Table_ID || this.m_columnAccess[i2].getAD_Column_ID() != AD_Column_ID) continue;
                retValue = ro ? this.m_columnAccess[i2].isReadOnly() : false;
                if (!retValue) {
                    this.log.fine("Exclude AD_Table_ID=" + AD_Table_ID + ", AD_Column_ID=" + AD_Column_ID + " (ro=" + ro + ",ColumnAccessRO=" + this.m_columnAccess[i2].isReadOnly() + ") = " + retValue);
                }
                return retValue;
            }
            if (this.m_columnAccess[i2].getAD_Table_ID() != AD_Table_ID) continue;
            retValue = false;
            if (this.m_columnAccess[i2].getAD_Column_ID() != AD_Column_ID) continue;
            retValue = !ro ? !this.m_columnAccess[i2].isReadOnly() : true;
            if (!retValue) {
                this.log.fine("Include AD_Table_ID=" + AD_Table_ID + ", AD_Column_ID=" + AD_Column_ID + " (ro=" + ro + ",ColumnAccessRO=" + this.m_columnAccess[i2].isReadOnly() + ") = " + retValue);
            }
            return retValue;
        }
        if (!retValue) {
            this.log.fine("AD_Table_ID=" + AD_Table_ID + ", AD_Column_ID=" + AD_Column_ID + " (ro=" + ro + ") = " + retValue);
        }
        return retValue;
    }

    public boolean isRecordAccess(int AD_Table_ID, int Record_ID, boolean ro) {
        this.loadRecordAccess(false);
        boolean negativeList = true;
        for (int i2 = 0; i2 < this.m_recordAccess.length; ++i2) {
            MRecordAccess ra = this.m_recordAccess[i2];
            if (ra.getAD_Table_ID() != AD_Table_ID) continue;
            if (ra.isExclude()) {
                if (ra.getRecord_ID() != Record_ID) continue;
                if (ro) {
                    return ra.isReadOnly();
                }
                return false;
            }
            negativeList = false;
            if (ra.getRecord_ID() != Record_ID) continue;
            if (!ro) {
                return !ra.isReadOnly();
            }
            return true;
        }
        return negativeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getWindowAccess(int AD_Window_ID) {
        Boolean retValue;
        block10: {
            MRole includedRole;
            if (this.m_windowAccess == null) {
                this.m_windowAccess = new HashMap(100);
                MClient client = MClient.get(this.getCtx(), this.getAD_Client_ID());
                String ASPFilter = "";
                if (client.isUseASP()) {
                    ASPFilter = "   AND (   AD_Window_ID IN (               SELECT w.AD_Window_ID                 FROM ASP_Window w, ASP_Level l, ASP_ClientLevel cl                WHERE w.ASP_Level_ID = l.ASP_Level_ID                  AND cl.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND cl.ASP_Level_ID = l.ASP_Level_ID " + "                 AND w.IsActive = 'Y' " + "                 AND l.IsActive = 'Y' " + "                 AND cl.IsActive = 'Y' " + "                 AND w.ASP_Status = 'S') " + "        OR AD_Window_ID IN ( " + "              SELECT AD_Window_ID " + "                FROM ASP_ClientException ce " + "               WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND ce.IsActive = 'Y' " + "                 AND ce.AD_Window_ID IS NOT NULL " + "                 AND ce.AD_Tab_ID IS NULL " + "                 AND ce.AD_Field_ID IS NULL " + "                 AND ce.ASP_Status = 'S') " + "       ) " + "   AND AD_Window_ID NOT IN ( " + "          SELECT AD_Window_ID " + "            FROM ASP_ClientException ce " + "           WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "             AND ce.IsActive = 'Y' " + "             AND ce.AD_Window_ID IS NOT NULL " + "             AND ce.AD_Tab_ID IS NULL " + "             AND ce.AD_Field_ID IS NULL " + "             AND ce.ASP_Status = 'H')";
                }
                String sql = "SELECT AD_Window_ID, IsReadWrite FROM AD_Window_Access WHERE AD_Role_ID=? AND IsActive='Y'" + ASPFilter;
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getAD_Role_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this.m_windowAccess.put(new Integer(rs.getInt(1)), new Boolean("Y".equals(rs.getString(2))));
                    }
                    DB.close(rs, pstmt);
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                }
                finally {
                    DB.close(rs, pstmt);
                }
                this.log.fine("#" + this.m_windowAccess.size());
                this.mergeIncludedAccess("m_windowAccess");
            }
            if ((retValue = this.m_windowAccess.get(AD_Window_ID)) != null) break block10;
            Iterator<MRole> i$ = this.getIncludedRoles(false).iterator();
            while (i$.hasNext() && (retValue = (includedRole = i$.next()).getWindowAccess(AD_Window_ID)) == null) {
            }
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getProcessAccess(int AD_Process_ID) {
        if (this.m_processAccess == null) {
            this.m_processAccess = new HashMap(50);
            MClient client = MClient.get(this.getCtx(), this.getAD_Client_ID());
            String ASPFilter = "";
            if (client.isUseASP()) {
                ASPFilter = "   AND (   AD_Process_ID IN (               SELECT p.AD_Process_ID                 FROM ASP_Process p, ASP_Level l, ASP_ClientLevel cl                WHERE p.ASP_Level_ID = l.ASP_Level_ID                  AND cl.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND cl.ASP_Level_ID = l.ASP_Level_ID " + "                 AND p.IsActive = 'Y' " + "                 AND l.IsActive = 'Y' " + "                 AND cl.IsActive = 'Y' " + "                 AND p.ASP_Status = 'S') " + "        OR AD_Process_ID IN ( " + "              SELECT AD_Process_ID " + "                FROM ASP_ClientException ce " + "               WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND ce.IsActive = 'Y' " + "                 AND ce.AD_Process_ID IS NOT NULL " + "                 AND ce.AD_Process_Para_ID IS NULL " + "                 AND ce.ASP_Status = 'S') " + "       ) " + "   AND AD_Process_ID NOT IN ( " + "          SELECT AD_Process_ID " + "            FROM ASP_ClientException ce " + "           WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "             AND ce.IsActive = 'Y' " + "             AND ce.AD_Process_ID IS NOT NULL " + "             AND ce.AD_Process_Para_ID IS NULL " + "             AND ce.ASP_Status = 'H')";
            }
            String sql = "SELECT AD_Process_ID, IsReadWrite FROM AD_Process_Access WHERE AD_Role_ID=? AND IsActive='Y'" + ASPFilter;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, this.getAD_Role_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    this.m_processAccess.put(new Integer(rs.getInt(1)), new Boolean("Y".equals(rs.getString(2))));
                }
                DB.close(rs, pstmt);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, e);
            }
            finally {
                DB.close(rs, pstmt);
            }
            this.mergeIncludedAccess("m_processAccess");
        }
        Boolean retValue = this.m_processAccess.get(AD_Process_ID);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getTaskAccess(int AD_Task_ID) {
        if (this.m_taskAccess == null) {
            this.m_taskAccess = new HashMap(10);
            MClient client = MClient.get(this.getCtx(), this.getAD_Client_ID());
            String ASPFilter = "";
            if (client.isUseASP()) {
                ASPFilter = "   AND (   AD_Task_ID IN (               SELECT t.AD_Task_ID                 FROM ASP_Task t, ASP_Level l, ASP_ClientLevel cl                WHERE t.ASP_Level_ID = l.ASP_Level_ID                  AND cl.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND cl.ASP_Level_ID = l.ASP_Level_ID " + "                 AND t.IsActive = 'Y' " + "                 AND l.IsActive = 'Y' " + "                 AND cl.IsActive = 'Y' " + "                 AND t.ASP_Status = 'S') " + "        OR AD_Task_ID IN ( " + "              SELECT AD_Task_ID " + "                FROM ASP_ClientException ce " + "               WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND ce.IsActive = 'Y' " + "                 AND ce.AD_Task_ID IS NOT NULL " + "                 AND ce.ASP_Status = 'S') " + "       ) " + "   AND AD_Task_ID NOT IN ( " + "          SELECT AD_Task_ID " + "            FROM ASP_ClientException ce " + "           WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "             AND ce.IsActive = 'Y' " + "             AND ce.AD_Task_ID IS NOT NULL " + "             AND ce.ASP_Status = 'H')";
            }
            String sql = "SELECT AD_Task_ID, IsReadWrite FROM AD_Task_Access WHERE AD_Role_ID=? AND IsActive='Y'" + ASPFilter;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, this.getAD_Role_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    this.m_taskAccess.put(new Integer(rs.getInt(1)), new Boolean("Y".equals(rs.getString(2))));
                }
                DB.close(rs, pstmt);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, e);
            }
            finally {
                DB.close(rs, pstmt);
            }
            this.mergeIncludedAccess("m_taskAccess");
        }
        Boolean retValue = this.m_taskAccess.get(AD_Task_ID);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getFormAccess(int AD_Form_ID) {
        Boolean retValue;
        block10: {
            MRole includedRole;
            if (this.m_formAccess == null) {
                this.m_formAccess = new HashMap(20);
                MClient client = MClient.get(this.getCtx(), this.getAD_Client_ID());
                String ASPFilter = "";
                if (client.isUseASP()) {
                    ASPFilter = "   AND (   AD_Form_ID IN (               SELECT f.AD_Form_ID                 FROM ASP_Form f, ASP_Level l, ASP_ClientLevel cl                WHERE f.ASP_Level_ID = l.ASP_Level_ID                  AND cl.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND cl.ASP_Level_ID = l.ASP_Level_ID " + "                 AND f.IsActive = 'Y' " + "                 AND l.IsActive = 'Y' " + "                 AND cl.IsActive = 'Y' " + "                 AND f.ASP_Status = 'S') " + "        OR AD_Form_ID IN ( " + "              SELECT AD_Form_ID " + "                FROM ASP_ClientException ce " + "               WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND ce.IsActive = 'Y' " + "                 AND ce.AD_Form_ID IS NOT NULL " + "                 AND ce.ASP_Status = 'S') " + "       ) " + "   AND AD_Form_ID NOT IN ( " + "          SELECT AD_Form_ID " + "            FROM ASP_ClientException ce " + "           WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "             AND ce.IsActive = 'Y' " + "             AND ce.AD_Form_ID IS NOT NULL " + "             AND ce.ASP_Status = 'H')";
                }
                String sql = "SELECT AD_Form_ID, IsReadWrite FROM AD_Form_Access WHERE AD_Role_ID=? AND IsActive='Y'" + ASPFilter;
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getAD_Role_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this.m_formAccess.put(new Integer(rs.getInt(1)), new Boolean("Y".equals(rs.getString(2))));
                    }
                    DB.close(rs, pstmt);
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                }
                finally {
                    DB.close(rs, pstmt);
                }
                this.mergeIncludedAccess("m_formAccess");
            }
            if ((retValue = this.m_formAccess.get(AD_Form_ID)) != null) break block10;
            Iterator<MRole> i$ = this.getIncludedRoles(false).iterator();
            while (i$.hasNext() && (retValue = (includedRole = i$.next()).getFormAccess(AD_Form_ID)) == null) {
            }
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean getWorkflowAccess(int AD_Workflow_ID) {
        if (this.m_workflowAccess == null) {
            this.m_workflowAccess = new HashMap(20);
            MClient client = MClient.get(this.getCtx(), this.getAD_Client_ID());
            String ASPFilter = "";
            if (client.isUseASP()) {
                ASPFilter = "   AND (   AD_Workflow_ID IN (               SELECT w.AD_Workflow_ID                 FROM ASP_Workflow w, ASP_Level l, ASP_ClientLevel cl                WHERE w.ASP_Level_ID = l.ASP_Level_ID                  AND cl.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND cl.ASP_Level_ID = l.ASP_Level_ID " + "                 AND w.IsActive = 'Y' " + "                 AND l.IsActive = 'Y' " + "                 AND cl.IsActive = 'Y' " + "                 AND w.ASP_Status = 'S') " + "        OR AD_Workflow_ID IN ( " + "              SELECT AD_Workflow_ID " + "                FROM ASP_ClientException ce " + "               WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND ce.IsActive = 'Y' " + "                 AND ce.AD_Workflow_ID IS NOT NULL " + "                 AND ce.ASP_Status = 'S') " + "       ) " + "   AND AD_Workflow_ID NOT IN ( " + "          SELECT AD_Workflow_ID " + "            FROM ASP_ClientException ce " + "           WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "             AND ce.IsActive = 'Y' " + "             AND ce.AD_Workflow_ID IS NOT NULL " + "             AND ce.ASP_Status = 'H')";
            }
            String sql = "SELECT AD_Workflow_ID, IsReadWrite FROM AD_Workflow_Access WHERE AD_Role_ID=? AND IsActive='Y'" + ASPFilter;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, this.getAD_Role_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    this.m_workflowAccess.put(new Integer(rs.getInt(1)), new Boolean("Y".equals(rs.getString(2))));
                }
                DB.close(rs, pstmt);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, e);
            }
            finally {
                DB.close(rs, pstmt);
            }
            this.mergeIncludedAccess("m_workflowAccess");
        }
        Boolean retValue = this.m_workflowAccess.get(AD_Workflow_ID);
        return retValue;
    }

    public String addAccessSQL(String SQL, String TableNameIn, boolean fullyQualified, boolean rw) {
        StringBuffer retSQL = new StringBuffer();
        String orderBy = "";
        int posOrder = SQL.lastIndexOf(" ORDER BY ");
        if (posOrder != -1) {
            orderBy = SQL.substring(posOrder);
            retSQL.append(SQL.substring(0, posOrder));
        } else {
            retSQL.append(SQL);
        }
        AccessSqlParser asp = new AccessSqlParser(retSQL.toString());
        AccessSqlParser.TableInfo[] ti = asp.getTableInfo(asp.getMainSqlIndex());
        if (asp.getMainSql().indexOf(" WHERE ") == -1) {
            retSQL.append(" WHERE ");
        } else {
            retSQL.append(" AND ");
        }
        String tableName = "";
        if (ti.length > 0 && (tableName = ti[0].getSynonym()).length() == 0) {
            tableName = ti[0].getTableName();
        }
        if (TableNameIn != null && !tableName.equals(TableNameIn)) {
            String msg = "TableName not correctly parsed - TableNameIn=" + TableNameIn + " - " + asp;
            if (ti.length > 0) {
                msg = msg + " - #1 " + ti[0];
            }
            msg = msg + "\n = " + SQL;
            this.log.log(Level.SEVERE, msg);
            Trace.printStack();
            tableName = TableNameIn;
        }
        if (!tableName.equals("AD_PInstance_Log")) {
            if (fullyQualified) {
                retSQL.append(tableName).append(".");
            }
            retSQL.append(this.getClientWhere(rw));
            if (!this.isAccessAllOrgs()) {
                retSQL.append(" AND ");
                if (fullyQualified) {
                    retSQL.append(tableName).append(".");
                }
                retSQL.append(this.getOrgWhere(rw));
            }
        } else {
            retSQL.append("1=1");
        }
        for (int i2 = 0; i2 < ti.length; ++i2) {
            String recordWhere;
            String TableName = ti[i2].getTableName();
            if (TableName.toUpperCase().endsWith("_TRL") || this.isView(TableName)) continue;
            int AD_Table_ID = this.getAD_Table_ID(TableName);
            if (AD_Table_ID != 0 && !this.isTableAccess(AD_Table_ID, !rw)) {
                retSQL.append(" AND 1=3");
                this.log.fine("No access to AD_Table_ID=" + AD_Table_ID + " - " + TableName + " - " + retSQL);
                break;
            }
            String keyColumnName = "";
            if (fullyQualified) {
                keyColumnName = ti[i2].getSynonym();
                if (keyColumnName.length() == 0) {
                    keyColumnName = TableName;
                }
                keyColumnName = keyColumnName + ".";
            }
            if (this.getIdColumnName(TableName) == null || (recordWhere = this.getRecordWhere(AD_Table_ID, keyColumnName = keyColumnName + this.getIdColumnName(TableName), rw)).length() <= 0) continue;
            retSQL.append(" AND ").append(recordWhere);
            this.log.finest("Record access - " + recordWhere);
        }
        String mainSql = asp.getMainSql();
        this.loadRecordAccess(false);
        int AD_Table_ID = 0;
        String whereColumnName = null;
        ArrayList<Integer> includes = new ArrayList<Integer>();
        ArrayList<Integer> excludes = new ArrayList<Integer>();
        for (int i3 = 0; i3 < this.m_recordDependentAccess.length; ++i3) {
            MColumn column;
            MTable table2;
            char charCheck;
            int posColumn;
            String columnName = this.m_recordDependentAccess[i3].getKeyColumnName(asp.getTableInfo(asp.getMainSqlIndex()));
            if (columnName == null || (!mainSql.toUpperCase().startsWith("SELECT COUNT(*) FROM ") ? (posColumn = mainSql.indexOf(columnName)) == -1 || (charCheck = mainSql.charAt(posColumn - 1)) != ',' && charCheck != '.' && charCheck != ' ' && charCheck != '(' || (charCheck = mainSql.charAt(posColumn + columnName.length())) != ',' && charCheck != ' ' && charCheck != ')' : (table2 = MTable.get(this.getCtx(), tableName)) == null || (column = table2.getColumn(columnName)) == null || column.isVirtualColumn() || !column.isActive())) continue;
            if (AD_Table_ID != 0 && AD_Table_ID != this.m_recordDependentAccess[i3].getAD_Table_ID()) {
                retSQL.append(this.getDependentAccess(whereColumnName, includes, excludes));
            }
            AD_Table_ID = this.m_recordDependentAccess[i3].getAD_Table_ID();
            if (this.m_recordDependentAccess[i3].isExclude()) {
                excludes.add(this.m_recordDependentAccess[i3].getRecord_ID());
                this.log.fine("Exclude " + columnName + " - " + this.m_recordDependentAccess[i3]);
            } else if (!rw || !this.m_recordDependentAccess[i3].isReadOnly()) {
                includes.add(this.m_recordDependentAccess[i3].getRecord_ID());
                this.log.fine("Include " + columnName + " - " + this.m_recordDependentAccess[i3]);
            }
            whereColumnName = this.getDependentRecordWhereColumn(mainSql, columnName);
        }
        retSQL.append(this.getDependentAccess(whereColumnName, includes, excludes));
        retSQL.append(orderBy);
        this.log.finest(retSQL.toString());
        return retSQL.toString();
    }

    private String getDependentAccess(String whereColumnName, ArrayList<Integer> includes, ArrayList<Integer> excludes) {
        if (includes.size() == 0 && excludes.size() == 0) {
            return "";
        }
        if (includes.size() != 0 && excludes.size() != 0) {
            this.log.warning("Mixing Include and Excluse rules - Will not return values");
        }
        StringBuffer where = new StringBuffer(" AND ");
        if (includes.size() == 1) {
            where.append(whereColumnName).append("=").append(includes.get(0));
        } else if (includes.size() > 1) {
            where.append(whereColumnName).append(" IN (");
            for (int ii = 0; ii < includes.size(); ++ii) {
                if (ii > 0) {
                    where.append(",");
                }
                where.append(includes.get(ii));
            }
            where.append(")");
        } else if (excludes.size() == 1) {
            where.append(whereColumnName).append("<>").append(excludes.get(0));
        } else if (excludes.size() > 1) {
            where.append(whereColumnName).append(" NOT IN (");
            for (int ii = 0; ii < excludes.size(); ++ii) {
                if (ii > 0) {
                    where.append(",");
                }
                where.append(excludes.get(ii));
            }
            where.append(")");
        }
        this.log.finest(where.toString());
        return where.toString();
    }

    private String getDependentRecordWhereColumn(String mainSql, String columnName) {
        String retValue = columnName;
        int index = mainSql.indexOf(columnName);
        if (index == -1) {
            return retValue;
        }
        int offset = index - 1;
        char c = mainSql.charAt(offset);
        if (c == '.') {
            StringBuffer sb = new StringBuffer();
            while (c != ' ' && c != ',' && c != '(') {
                sb.insert(0, c);
                c = mainSql.charAt(--offset);
            }
            sb.append(columnName);
            return sb.toString();
        }
        return retValue;
    }

    public boolean canUpdate(int AD_Client_ID, int AD_Org_ID, int AD_Table_ID, int Record_ID, boolean createError) {
        String userLevel = this.getUserLevel();
        if (userLevel.indexOf(83) != -1) {
            return true;
        }
        boolean retValue = true;
        String whatMissing = "";
        if (AD_Client_ID == 0 && AD_Org_ID == 0 && userLevel.charAt(0) != 'S') {
            retValue = false;
            whatMissing = whatMissing + "S";
        } else if (AD_Client_ID != 0 && AD_Org_ID == 0 && userLevel.charAt(1) != 'C') {
            if (userLevel.charAt(2) != 'O' || !this.isOrgAccess(AD_Org_ID, true)) {
                retValue = false;
                whatMissing = whatMissing + "C";
            }
        } else if (AD_Client_ID != 0 && AD_Org_ID != 0 && userLevel.charAt(2) != 'O') {
            retValue = false;
            whatMissing = whatMissing + "O";
        }
        if (retValue) {
            retValue = this.isClientAccess(AD_Client_ID, true);
        }
        if (retValue) {
            retValue = this.isOrgAccess(AD_Org_ID, true);
            whatMissing = "W";
        }
        if (retValue) {
            retValue = this.isTableAccess(AD_Table_ID, false);
        }
        if (retValue && Record_ID != 0) {
            retValue = this.isRecordAccess(AD_Table_ID, Record_ID, false);
        }
        if (!retValue && createError) {
            this.log.saveWarning("AccessTableNoUpdate", "AD_Client_ID=" + AD_Client_ID + ", AD_Org_ID=" + AD_Org_ID + ", UserLevel=" + userLevel + " => missing=" + whatMissing);
            this.log.warning(this.toString());
        }
        return retValue;
    }

    public boolean canView(Properties ctx, String TableLevel) {
        String userLevel = this.getUserLevel();
        boolean retValue = true;
        if ("7".equals(TableLevel)) {
            retValue = true;
        } else if ("4".equals(TableLevel) && userLevel.charAt(0) != 'S') {
            retValue = false;
        } else if ("2".equals(TableLevel) && userLevel.charAt(1) != 'C') {
            retValue = false;
        } else if ("1".equals(TableLevel) && userLevel.charAt(2) != 'O') {
            retValue = false;
        } else if ("3".equals(TableLevel) && userLevel.charAt(1) != 'C' && userLevel.charAt(2) != 'O') {
            retValue = false;
        } else if ("6".equals(TableLevel) && userLevel.charAt(0) != 'S' && userLevel.charAt(1) != 'C') {
            retValue = false;
        }
        if (retValue) {
            return retValue;
        }
        this.log.saveWarning("AccessTableNoView", "Required=" + TableLevel + "(" + this.getTableLevelString(Env.getAD_Language(ctx), TableLevel) + ") != UserLevel=" + userLevel);
        this.log.info(this.toString());
        return retValue;
    }

    private String getTableLevelString(String AD_Language, String TableLevel) {
        String level = TableLevel + "??";
        if (TableLevel.equals("1")) {
            level = "AccessOrg";
        } else if (TableLevel.equals("2")) {
            level = "AccessClient";
        } else if (TableLevel.equals("3")) {
            level = "AccessClientOrg";
        } else if (TableLevel.equals("4")) {
            level = "AccessSystem";
        } else if (TableLevel.equals("6")) {
            level = "AccessSystemClient";
        } else if (TableLevel.equals("7")) {
            level = "AccessShared";
        }
        return Msg.getMsg(AD_Language, level);
    }

    private int getAD_Table_ID(String tableName) {
        this.loadTableInfo(false);
        Integer ii = this.m_tableName.get(tableName);
        if (ii != null) {
            return ii;
        }
        return 0;
    }

    private String getRecordWhere(int AD_Table_ID, String keyColumnName, boolean rw) {
        String lockedIDs;
        this.loadRecordAccess(false);
        StringBuffer sbInclude = new StringBuffer();
        StringBuffer sbExclude = new StringBuffer();
        for (int i2 = 0; i2 < this.m_recordAccess.length; ++i2) {
            if (this.m_recordAccess[i2].getAD_Table_ID() != AD_Table_ID) continue;
            if (this.m_recordAccess[i2].isExclude()) {
                if (sbExclude.length() == 0) {
                    sbExclude.append(keyColumnName).append(" NOT IN (");
                } else {
                    sbExclude.append(",");
                }
                sbExclude.append(this.m_recordAccess[i2].getRecord_ID());
                continue;
            }
            if (rw && this.m_recordAccess[i2].isReadOnly()) continue;
            if (sbInclude.length() == 0) {
                sbInclude.append(keyColumnName).append(" IN (");
            } else {
                sbInclude.append(",");
            }
            sbInclude.append(this.m_recordAccess[i2].getRecord_ID());
        }
        StringBuffer sb = new StringBuffer();
        if (sbExclude.length() > 0) {
            sb.append(sbExclude).append(")");
        }
        if (sbInclude.length() > 0) {
            if (sb.length() > 0) {
                sb.append(" AND ");
            }
            sb.append(sbInclude).append(")");
        }
        if (!this.isPersonalAccess() && (lockedIDs = MPrivateAccess.getLockedRecordWhere(AD_Table_ID, this.m_AD_User_ID)) != null) {
            if (sb.length() > 0) {
                sb.append(" AND ");
            }
            sb.append(keyColumnName).append(lockedIDs);
        }
        return sb.toString();
    }

    public boolean isShowPreference() {
        return !"N".equals(this.getPreferenceType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkActionAccess(int clientId, int docTypeId, String[] options, int maxIndex) {
        if (maxIndex <= 0) {
            return maxIndex;
        }
        Vector<String> validOptions = new Vector<String>();
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(clientId);
        params.add(docTypeId);
        StringBuffer sql_values = new StringBuffer();
        for (int i2 = 0; i2 < maxIndex; ++i2) {
            if (sql_values.length() > 0) {
                sql_values.append(",");
            }
            sql_values.append("?");
            params.add(options[i2]);
        }
        String sql = "SELECT rl.Value FROM AD_Document_Action_Access a INNER JOIN AD_Ref_List rl ON (rl.AD_Reference_ID=135 and rl.AD_Ref_List_ID=a.AD_Ref_List_ID) WHERE a.IsActive='Y' AND a.AD_Client_ID=? AND a.C_DocType_ID=? AND rl.Value IN (" + sql_values + ")" + " AND " + this.getIncludedRolesWhereClause("a.AD_Role_ID", params);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            DB.setParameters((PreparedStatement)pstmt, params);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String op = rs.getString(1);
                validOptions.add(op);
            }
            validOptions.toArray(options);
        }
        catch (SQLException e) {
            try {
                this.log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        int newMaxIndex = validOptions.size();
        return newMaxIndex;
    }

    private void includeRole(MRole role, int seqNo) {
        if (this.getAD_Role_ID() == role.getAD_Role_ID()) {
            return;
        }
        if (this.m_includedRoles == null) {
            this.m_includedRoles = new ArrayList<MRole>();
        }
        for (MRole r : this.m_includedRoles) {
            if (r.getAD_Role_ID() != role.getAD_Role_ID()) continue;
            return;
        }
        System.out.println("Include " + role);
        this.m_includedRoles.add(role);
        role.setParentRole(this);
        role.m_includedSeqNo = seqNo;
    }

    public List<MRole> getIncludedRoles(boolean recursive) {
        if (!recursive) {
            List<MRole> list = this.m_includedRoles;
            if (list == null) {
                list = new ArrayList<MRole>();
            }
            return Collections.unmodifiableList(list);
        }
        ArrayList<MRole> list = new ArrayList<MRole>();
        if (this.m_includedRoles != null) {
            for (MRole role : this.m_includedRoles) {
                list.add(role);
                list.addAll(role.getIncludedRoles(true));
            }
        }
        return list;
    }

    private void loadIncludedRoles(boolean reload) {
        this.loadChildRoles(reload);
        this.loadSubstitutedRoles(reload);
        if (this.m_parent == null) {
            this.mergeAccesses(reload);
        }
    }

    private void mergeAccesses(boolean reload) {
        OrgAccess[] orgAccess = new OrgAccess[]{};
        MTableAccess[] tableAccess = new MTableAccess[]{};
        MColumnAccess[] columnAccess = new MColumnAccess[]{};
        MRecordAccess[] recordAccess = new MRecordAccess[]{};
        MRecordAccess[] recordDependentAccess = new MRecordAccess[]{};
        MRole last_role = null;
        for (MRole role : this.getIncludedRoles(false)) {
            boolean override = false;
            if (last_role != null && last_role.m_includedSeqNo >= 0 && role.m_includedSeqNo >= 0 && last_role.m_includedSeqNo == role.m_includedSeqNo) {
                override = true;
            }
            role.loadAccess(reload);
            role.mergeAccesses(reload);
            orgAccess = MRole.mergeAccess(orgAccess, role.m_orgAccess, override);
            tableAccess = MRole.mergeAccess(tableAccess, role.m_tableAccess, override);
            columnAccess = MRole.mergeAccess(columnAccess, role.m_columnAccess, override);
            recordAccess = MRole.mergeAccess(recordAccess, role.m_recordAccess, override);
            recordDependentAccess = MRole.mergeAccess(recordDependentAccess, role.m_recordDependentAccess, override);
            last_role = role;
        }
        this.m_orgAccess = MRole.mergeAccess(this.m_orgAccess, orgAccess, false);
        this.m_tableAccess = MRole.mergeAccess(this.m_tableAccess, tableAccess, false);
        this.m_columnAccess = MRole.mergeAccess(this.m_columnAccess, columnAccess, false);
        this.m_recordAccess = MRole.mergeAccess(this.m_recordAccess, recordAccess, false);
        this.m_recordDependentAccess = MRole.mergeAccess(this.m_recordDependentAccess, recordDependentAccess, false);
    }

    private void loadChildRoles(boolean reload) {
        this.m_includedRoles = null;
        int AD_User_ID = this.getAD_User_ID();
        if (AD_User_ID < 0) {
            return;
        }
        String whereClause = "AD_Role_ID=?";
        List list = new Query(this.getCtx(), "AD_Role_Included", "AD_Role_ID=?", this.get_TrxName()).setParameters(this.getAD_Role_ID()).setOnlyActiveRecords(true).setOrderBy("SeqNo,Included_Role_ID").list();
        for (X_AD_Role_Included includedRole : list) {
            MRole role = MRole.get(this.getCtx(), includedRole.getIncluded_Role_ID());
            this.includeRole(role, includedRole.getSeqNo());
        }
    }

    private void loadSubstitutedRoles(boolean reload) {
        if (this.m_parent != null) {
            return;
        }
        int AD_User_ID = this.getAD_User_ID();
        if (AD_User_ID < 0) {
            return;
        }
        String whereClause = "EXISTS ( SELECT 1 FROM AD_User_Roles ur INNER JOIN AD_User_Substitute us ON (us.AD_User_ID=ur.AD_User_ID) WHERE ur.AD_Role_ID=AD_Role.AD_Role_ID AND ur.IsActive='Y' AND us.IsActive='Y' AND (us.ValidFrom IS NULL OR us.ValidFrom <= getdate()) AND (us.ValidTo IS NULL OR us.ValidTo >= getdate()) AND us.Substitute_ID=?)";
        List list = new Query(this.getCtx(), "AD_Role", "EXISTS ( SELECT 1 FROM AD_User_Roles ur INNER JOIN AD_User_Substitute us ON (us.AD_User_ID=ur.AD_User_ID) WHERE ur.AD_Role_ID=AD_Role.AD_Role_ID AND ur.IsActive='Y' AND us.IsActive='Y' AND (us.ValidFrom IS NULL OR us.ValidFrom <= getdate()) AND (us.ValidTo IS NULL OR us.ValidTo >= getdate()) AND us.Substitute_ID=?)", this.get_TrxName()).setParameters(AD_User_ID).setClient_ID().setOrderBy("AD_Role_ID").list();
        for (MRole role : list) {
            this.includeRole(role, -1);
        }
    }

    private void setParentRole(MRole parent) {
        this.setAD_User_ID(parent.getAD_User_ID());
        this.m_parent = parent;
    }

    private static final <T> T[] mergeAccess(T[] array1, T[] array2, boolean override) {
        if (array1 == null) {
            System.out.println("null !!!");
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T po : array1) {
            list.add(po);
        }
        for (T o2 : array2) {
            boolean found = false;
            for (int i2 = 0; i2 < array1.length; ++i2) {
                T o1 = array1[i2];
                if (o1 instanceof OrgAccess) {
                    OrgAccess oa1 = (OrgAccess)o1;
                    OrgAccess oa2 = (OrgAccess)o2;
                    found = oa1.equals(oa2);
                    if (found && override && !oa2.readOnly) {
                        oa1.readOnly = false;
                    }
                } else if (o1 instanceof MTableAccess) {
                    MTableAccess ta1 = (MTableAccess)o1;
                    MTableAccess ta2 = (MTableAccess)o2;
                    boolean bl = found = ta1.getAD_Table_ID() == ta2.getAD_Table_ID();
                    if (found && override) {
                        if (ta2.isCanReport()) {
                            ta1.setIsCanExport(true);
                        }
                        if (ta2.isCanReport()) {
                            ta1.setIsCanReport(true);
                        }
                        if (!ta2.isReadOnly()) {
                            ta1.setIsCanExport(false);
                        }
                        if (!ta2.isExclude()) {
                            ta1.setIsExclude(false);
                        }
                    }
                } else if (o1 instanceof MColumnAccess) {
                    MColumnAccess ca1 = (MColumnAccess)o1;
                    MColumnAccess ca2 = (MColumnAccess)o2;
                    boolean bl = found = ca1.getAD_Column_ID() == ca2.getAD_Column_ID();
                    if (found && override) {
                        if (!ca2.isReadOnly()) {
                            ca1.setIsReadOnly(false);
                        }
                        if (!ca2.isExclude()) {
                            ca1.setIsExclude(false);
                        }
                    }
                } else if (o1 instanceof MRecordAccess) {
                    MRecordAccess ra1 = (MRecordAccess)o1;
                    MRecordAccess ra2 = (MRecordAccess)o2;
                    boolean bl = found = ra1.getAD_Table_ID() == ra2.getAD_Table_ID() && ra1.getRecord_ID() == ra2.getRecord_ID();
                    if (found && override) {
                        if (!ra2.isReadOnly()) {
                            ra1.setIsReadOnly(false);
                        }
                        if (!ra2.isDependentEntities()) {
                            ra1.setIsDependentEntities(false);
                        }
                        if (!ra2.isExclude()) {
                            ra1.setIsExclude(false);
                        }
                    }
                } else {
                    throw new AdempiereException("Not supported objects - " + o1 + ", " + o2);
                }
                if (found) break;
            }
            if (found) continue;
            list.add(o2);
        }
        Object[] arr = (Object[])Array.newInstance(array1.getClass().getComponentType(), list.size());
        return list.toArray(arr);
    }

    private static final HashMap<Integer, Boolean> mergeAccess(HashMap<Integer, Boolean> map1, HashMap<Integer, Boolean> map2, boolean override) {
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        if (map1 != null) {
            map.putAll(map1);
        }
        for (Map.Entry<Integer, Boolean> e : map2.entrySet()) {
            Integer key = e.getKey();
            Boolean b2 = e.getValue();
            if (b2 == null) continue;
            Boolean b1 = map.get(key);
            if (b1 == null) {
                map.put(key, b2);
                continue;
            }
            if (!override || !b2.booleanValue() || b1.booleanValue()) continue;
            map.put(key, b2);
        }
        return map;
    }

    private void mergeIncludedAccess(String varname) {
        HashMap<Integer, Boolean> includedAccess = new HashMap<Integer, Boolean>();
        MRole last_role = null;
        for (MRole role : this.getIncludedRoles(false)) {
            boolean override = false;
            if (last_role != null && last_role.m_includedSeqNo >= 0 && role.m_includedSeqNo >= 0 && last_role.m_includedSeqNo == role.m_includedSeqNo) {
                override = true;
            }
            includedAccess = MRole.mergeAccess(includedAccess, role.getAccessMap(varname), override);
            last_role = role;
        }
        this.setAccessMap(varname, MRole.mergeAccess(this.getAccessMap(varname), includedAccess, false));
    }

    private HashMap<Integer, Boolean> getAccessMap(String varname) {
        if ("m_windowAccess".equals(varname)) {
            this.getWindowAccess(-1);
            return this.m_windowAccess;
        }
        if ("m_processAccess".equals(varname)) {
            this.getProcessAccess(-1);
            return this.m_processAccess;
        }
        if ("m_taskAccess".equals(varname)) {
            this.getTaskAccess(-1);
            return this.m_taskAccess;
        }
        if ("m_workflowAccess".equals(varname)) {
            this.getWorkflowAccess(-1);
            return this.m_workflowAccess;
        }
        if ("m_formAccess".equals(varname)) {
            this.getFormAccess(-1);
            return this.m_formAccess;
        }
        throw new IllegalArgumentException("varname not supported - " + varname);
    }

    private void setAccessMap(String varname, HashMap<Integer, Boolean> map) {
        if ("m_windowAccess".equals(varname)) {
            this.m_windowAccess = map;
        } else if ("m_processAccess".equals(varname)) {
            this.m_processAccess = map;
        } else if ("m_taskAccess".equals(varname)) {
            this.m_taskAccess = map;
        } else if ("m_workflowAccess".equals(varname)) {
            this.m_workflowAccess = map;
        } else if ("m_formAccess".equals(varname)) {
            this.m_formAccess = map;
        } else {
            throw new IllegalArgumentException("varname not supported - " + varname);
        }
    }

    public String getIncludedRolesWhereClause(String roleColumnSQL, List<Object> params) {
        StringBuffer whereClause = new StringBuffer();
        if (params != null) {
            whereClause.append("?");
            params.add(this.getAD_Role_ID());
        } else {
            whereClause.append(this.getAD_Role_ID());
        }
        for (MRole role : this.getIncludedRoles(true)) {
            if (params != null) {
                whereClause.append(",?");
                params.add(role.getAD_Role_ID());
                continue;
            }
            whereClause.append(",").append(role.getAD_Role_ID());
        }
        whereClause.insert(0, roleColumnSQL + " IN (").append(")");
        return whereClause.toString();
    }

    class OrgAccess
    implements Serializable {
        private static final long serialVersionUID = -4880665261978385315L;
        public int AD_Client_ID = 0;
        public int AD_Org_ID = 0;
        public boolean readOnly = true;

        public OrgAccess(int ad_Client_ID, int ad_Org_ID, boolean readonly) {
            this.AD_Client_ID = ad_Client_ID;
            this.AD_Org_ID = ad_Org_ID;
            this.readOnly = readonly;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof OrgAccess) {
                OrgAccess comp = (OrgAccess)obj;
                return comp.AD_Client_ID == this.AD_Client_ID && comp.AD_Org_ID == this.AD_Org_ID;
            }
            return false;
        }

        public int hashCode() {
            return this.AD_Client_ID * 7 + this.AD_Org_ID;
        }

        public String toString() {
            String clientName = "System";
            if (this.AD_Client_ID != 0) {
                clientName = MClient.get(MRole.this.getCtx(), this.AD_Client_ID).getName();
            }
            String orgName = "*";
            if (this.AD_Org_ID != 0) {
                orgName = MOrg.get(MRole.this.getCtx(), this.AD_Org_ID).getName();
            }
            StringBuffer sb = new StringBuffer();
            sb.append(Msg.translate(MRole.this.getCtx(), "AD_Client_ID")).append("=").append(clientName).append(" - ").append(Msg.translate(MRole.this.getCtx(), "AD_Org_ID")).append("=").append(orgName);
            if (this.readOnly) {
                sb.append(" r/o");
            }
            return sb.toString();
        }
    }
}

