/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.model.X_M_Product_Category;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MProductCategory
extends X_M_Product_Category {
    private static final long serialVersionUID = -1290361229726779892L;
    private static CCache<Integer, MProductCategory> s_cache = new CCache("M_Product_Category", 20);
    private static CCache<Integer, Integer> s_products = new CCache("M_Product", 100);
    private static CLogger s_log = CLogger.getCLogger(MProductCategory.class);

    public static MProductCategory get(Properties ctx, int M_Product_Category_ID) {
        Integer ii = new Integer(M_Product_Category_ID);
        MProductCategory pc = s_cache.get(ii);
        if (pc == null) {
            pc = new MProductCategory(ctx, M_Product_Category_ID, null);
        }
        return pc;
    }

    public static boolean isCategory(int M_Product_Category_ID, int M_Product_ID) {
        if (M_Product_ID == 0 || M_Product_Category_ID == 0) {
            return false;
        }
        Integer product = new Integer(M_Product_ID);
        Integer category = s_products.get(product);
        if (category != null) {
            return category == M_Product_Category_ID;
        }
        String sql = "SELECT M_Product_Category_ID FROM M_Product WHERE M_Product_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, M_Product_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                category = new Integer(rs.getInt(1));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (category != null) {
            s_products.put(product, category);
            s_log.fine("M_Product_ID=" + M_Product_ID + "(" + category + ") in M_Product_Category_ID=" + M_Product_Category_ID + " - " + (category == M_Product_Category_ID));
            return category == M_Product_Category_ID;
        }
        s_log.log(Level.SEVERE, "Not found M_Product_ID=" + M_Product_ID);
        return false;
    }

    public MProductCategory(Properties ctx, int M_Product_Category_ID, String trxName) {
        super(ctx, M_Product_Category_ID, trxName);
        if (M_Product_Category_ID == 0) {
            this.setMMPolicy("F");
            this.setPlannedMargin(Env.ZERO);
            this.setIsDefault(false);
            this.setIsSelfService(true);
        }
    }

    public MProductCategory(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.hasLoopInTree()) {
            this.log.saveError("Error", Msg.getMsg(this.getCtx(), "ProductCategoryLoopDetected"));
            return false;
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord && success) {
            this.insert_Accounting("M_Product_Category_Acct", "C_AcctSchema_Default", null);
        }
        return success;
    }

    @Override
    protected boolean beforeDelete() {
        return this.delete_Accounting("M_Product_Category_Acct");
    }

    public boolean isFiFo() {
        return "F".equals(this.getMMPolicy());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasLoopInTree() {
        CPreparedStatement pstmt;
        ResultSet rs;
        block8: {
            int productCategoryId = this.getM_Product_Category_ID();
            int newParentCategoryId = this.getM_Product_Category_Parent_ID();
            rs = null;
            pstmt = null;
            String sql = " SELECT M_Product_Category_ID, M_Product_Category_Parent_ID FROM M_Product_Category";
            Vector<SimpleTreeNode> categories = new Vector<SimpleTreeNode>(100);
            try {
                pstmt = DB.prepareStatement(sql, null);
                rs = pstmt.executeQuery();
                while (true) {
                    if (!rs.next()) {
                        if (this.hasLoop(newParentCategoryId, categories, productCategoryId)) {
                            break;
                        }
                        break block8;
                    }
                    if (rs.getInt(1) == productCategoryId) {
                        categories.add(new SimpleTreeNode(rs.getInt(1), newParentCategoryId));
                    }
                    categories.add(new SimpleTreeNode(rs.getInt(1), rs.getInt(2)));
                }
            }
            catch (SQLException e) {
                try {
                    s_log.log(Level.SEVERE, sql, e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                return true;
            }
            DB.close(rs, pstmt);
            return true;
        }
        DB.close(rs, pstmt);
        return false;
    }

    private boolean hasLoop(int parentCategoryId, Vector<SimpleTreeNode> categories, int loopIndicatorId) {
        Iterator<SimpleTreeNode> iter = categories.iterator();
        boolean ret = false;
        while (iter.hasNext()) {
            SimpleTreeNode node = iter.next();
            if (node.getNodeId() != parentCategoryId) continue;
            if (node.getParentId() == 0) {
                return false;
            }
            if (node.getNodeId() == loopIndicatorId) {
                return true;
            }
            ret = this.hasLoop(node.getParentId(), categories, loopIndicatorId);
        }
        return ret;
    }

    public boolean CreatelostAcct() {
        this.insert_Accounting("M_Product_Category_Acct", "C_AcctSchema_Default", null);
        return true;
    }

    private class SimpleTreeNode {
        private int nodeId;
        private int parentId;

        public SimpleTreeNode(int nodeId, int parentId) {
            this.nodeId = nodeId;
            this.parentId = parentId;
        }

        public int getNodeId() {
            return this.nodeId;
        }

        public int getParentId() {
            return this.parentId;
        }
    }
}

