/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MLocator;
import org.compiere.model.MMovementConfirm;
import org.compiere.model.MMovementLine;
import org.compiere.model.MMovementLineMA;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.model.MTransaction;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.model.X_M_Movement;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MMovement
extends X_M_Movement
implements DocAction {
    private static final long serialVersionUID = -1628932946440487727L;
    private MMovementLine[] m_lines = null;
    private MMovementConfirm[] m_confirms = null;
    public static String REVERSE_INDICATOR = "^";
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private boolean m_reversal = false;

    public MMovement(Properties ctx, int M_Movement_ID, String trxName) {
        super(ctx, M_Movement_ID, trxName);
        if (M_Movement_ID == 0) {
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setIsApproved(false);
            this.setIsInTransit(false);
            this.setMovementDate(new Timestamp(System.currentTimeMillis()));
            this.setPosted(false);
            super.setProcessed(false);
        }
    }

    public MMovement(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MMovementLine[] getLines(boolean requery) {
        if (this.m_lines != null && !requery) {
            MMovement.set_TrxName(this.m_lines, this.get_TrxName());
            return this.m_lines;
        }
        String whereClause = "M_Movement_ID=?";
        List<MMovementLine> list = new Query(this.getCtx(), "M_MovementLine", "M_Movement_ID=?", this.get_TrxName()).setParameters(this.getM_Movement_ID()).setOrderBy("Line").list();
        this.m_lines = new MMovementLine[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    public MMovementConfirm[] getConfirmations(boolean requery) {
        if (this.m_confirms != null && !requery) {
            return this.m_confirms;
        }
        List<MMovementConfirm> list = new Query(this.getCtx(), "M_MovementConfirm", "M_Movement_ID=?", this.get_TrxName()).setParameters(this.get_ID()).list();
        this.m_confirms = list.toArray(new MMovementConfirm[list.size()]);
        return this.m_confirms;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(String.valueOf(desc) + " | " + description);
        }
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return String.valueOf(dt.getName()) + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(String.valueOf(this.get_TableName()) + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getC_DocType_ID() == 0) {
            MDocType[] types = MDocType.getOfDocBaseType(this.getCtx(), "MMM");
            if (types.length > 0) {
                this.setC_DocType_ID(types[0].getC_DocType_ID());
            } else {
                this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@NotFound@ @C_DocType_ID@"));
                return false;
            }
        }
        return true;
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String sql = "UPDATE M_MovementLine SET Processed=? WHERE M_Movement_ID=?";
        int noLine = DB.executeUpdateEx("UPDATE M_MovementLine SET Processed=? WHERE M_Movement_ID=?", new Object[]{processed, this.get_ID()}, this.get_TrxName());
        this.m_lines = null;
        this.log.fine("Processed=" + processed + " - Lines=" + noLine);
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info(this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info(this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getMovementDate(), dt.getDocBaseType(), this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        MMovementLine[] lines = this.getLines(false);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        lines = this.getLinesProduct();
        int lastProduct_ID = 0;
        int lastLoc_ID = 0;
        int lastAtt = 0;
        BigDecimal acumQty = new BigDecimal("0.0");
        MMovementLine[] mMovementLineArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            MMovementLine ll = mMovementLineArray[n2];
            int abastLoc_ID = this.getLocatorTo(ll.getM_LocatorTo().getM_Warehouse_ID());
            if (ll.getM_LocatorTo_ID() == abastLoc_ID) {
                this.m_processMsg = "No Valid Locator line " + ll.getLine();
                return "IN";
            }
            if (ll.getM_LocatorTo_ID() <= 0) {
                this.m_processMsg = "No LocatorTO";
                return "IN";
            }
            if (ll.getM_Locator_ID() == ll.getM_LocatorTo_ID()) {
                this.m_processMsg = "Same Locator line " + ll.getLine();
                return "IN";
            }
            if (ll.getM_Product_ID() != lastProduct_ID || lastAtt != ll.getM_AttributeSetInstance_ID() || lastLoc_ID != ll.getM_Locator_ID()) {
                lastProduct_ID = ll.getM_Product_ID();
                lastAtt = ll.getM_AttributeSetInstance_ID();
                lastLoc_ID = ll.getM_Locator_ID();
                acumQty = ll.getMovementQty();
            } else {
                acumQty = acumQty.add(ll.getMovementQty());
            }
            MProduct prodV = new MProduct(this.getCtx(), ll.getM_Product_ID(), this.get_TrxName());
            if (acumQty.compareTo(this.getStock(ll.getM_Product_ID(), ll.getM_Locator_ID(), ll.getM_AttributeSetInstance_ID())) > 0 && !prodV.getProductType().equalsIgnoreCase("S")) {
                this.m_processMsg = "Stock Insuficiente linea " + ll.getLine();
                return "IN";
            }
            ++n2;
        }
        if (dt.isInTransit()) {
            this.createConfirmation();
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    private void createConfirmation() {
        MMovementConfirm[] confirmations = this.getConfirmations(false);
        if (confirmations.length > 0) {
            return;
        }
        MMovementConfirm.create(this, false);
    }

    @Override
    public boolean approveIt() {
        this.log.info(this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info(this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MMovementConfirm[] confirmations = this.getConfirmations(true);
        int i = 0;
        while (i < confirmations.length) {
            MMovementConfirm confirm = confirmations[i];
            if (!confirm.isProcessed()) {
                this.m_processMsg = "Open: @M_MovementConfirm_ID@ - " + confirm.getDocumentNo();
                return "IP";
            }
            ++i;
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        MMovementLine[] lines = this.getLines(false);
        int i2 = 0;
        while (i2 < lines.length) {
            MMovementLine line = lines[i2];
            MTransaction trxFrom = null;
            MProduct product = line.getProduct();
            if (product != null && product.isStocked()) {
                if (!this.isReversal()) {
                    this.checkMaterialPolicy(line);
                }
                if (line.getM_AttributeSetInstance_ID() == 0) {
                    MMovementLineMA[] mas = MMovementLineMA.get(this.getCtx(), line.getM_MovementLine_ID(), this.get_TrxName());
                    int j = 0;
                    while (j < mas.length) {
                        MMovementLineMA ma = mas[j];
                        MLocator locator = new MLocator(this.getCtx(), line.getM_Locator_ID(), this.get_TrxName());
                        if (!MStorage.add(this.getCtx(), locator.getM_Warehouse_ID(), line.getM_Locator_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), 0, ma.getMovementQty().negate(), Env.ZERO, Env.ZERO, this.get_TrxName())) {
                            this.m_processMsg = "Cannot correct Inventory (MA)";
                            return "IN";
                        }
                        int M_AttributeSetInstanceTo_ID = line.getM_AttributeSetInstanceTo_ID();
                        if (M_AttributeSetInstanceTo_ID == 0 && line.getM_Locator_ID() != line.getM_LocatorTo_ID()) {
                            M_AttributeSetInstanceTo_ID = ma.getM_AttributeSetInstance_ID();
                        }
                        if (!MStorage.add(this.getCtx(), locator.getM_Warehouse_ID(), line.getM_LocatorTo_ID(), line.getM_Product_ID(), M_AttributeSetInstanceTo_ID, 0, ma.getMovementQty(), Env.ZERO, Env.ZERO, this.get_TrxName())) {
                            this.m_processMsg = "Cannot correct Inventory (MA)";
                            return "IN";
                        }
                        trxFrom = new MTransaction(this.getCtx(), line.getAD_Org_ID(), "M-", line.getM_Locator_ID(), line.getM_Product_ID(), ma.getM_AttributeSetInstance_ID(), ma.getMovementQty().negate(), this.getMovementDate(), this.get_TrxName());
                        trxFrom.setM_MovementLine_ID(line.getM_MovementLine_ID());
                        if (!trxFrom.save()) {
                            this.m_processMsg = "Transaction From not inserted (MA)";
                            return "IN";
                        }
                        MTransaction trxTo = new MTransaction(this.getCtx(), line.getAD_Org_ID(), "M+", line.getM_LocatorTo_ID(), line.getM_Product_ID(), M_AttributeSetInstanceTo_ID, ma.getMovementQty(), this.getMovementDate(), this.get_TrxName());
                        trxTo.setM_MovementLine_ID(line.getM_MovementLine_ID());
                        if (!trxTo.save()) {
                            this.m_processMsg = "Transaction To not inserted (MA)";
                            return "IN";
                        }
                        ++j;
                    }
                }
                if (trxFrom == null) {
                    MLocator locator = new MLocator(this.getCtx(), line.getM_Locator_ID(), this.get_TrxName());
                    if (!MStorage.add(this.getCtx(), locator.getM_Warehouse_ID(), line.getM_Locator_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), 0, line.getMovementQty().negate(), Env.ZERO, Env.ZERO, this.get_TrxName())) {
                        this.m_processMsg = "Cannot correct Inventory (MA)";
                        return "IN";
                    }
                    if (!MStorage.add(this.getCtx(), locator.getM_Warehouse_ID(), line.getM_LocatorTo_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstanceTo_ID(), 0, line.getMovementQty(), Env.ZERO, Env.ZERO, this.get_TrxName())) {
                        this.m_processMsg = "Cannot correct Inventory (MA)";
                        return "IN";
                    }
                    trxFrom = new MTransaction(this.getCtx(), line.getAD_Org_ID(), "M-", line.getM_Locator_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), line.getMovementQty().negate(), this.getMovementDate(), this.get_TrxName());
                    trxFrom.setM_MovementLine_ID(line.getM_MovementLine_ID());
                    if (!trxFrom.save()) {
                        this.m_processMsg = "Transaction From not inserted";
                        return "IN";
                    }
                    MTransaction trxTo = new MTransaction(this.getCtx(), line.getAD_Org_ID(), "M+", line.getM_LocatorTo_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstanceTo_ID(), line.getMovementQty(), this.getMovementDate(), this.get_TrxName());
                    trxTo.setM_MovementLine_ID(line.getM_MovementLine_ID());
                    if (!trxTo.save()) {
                        this.m_processMsg = "Transaction To not inserted";
                        return "IN";
                    }
                }
            }
            ++i2;
        }
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.processShipment();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        String value;
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setMovementDate(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete() && (value = DB.getDocumentNo(this.getC_DocType_ID(), this.get_TrxName(), true, (PO)this)) != null) {
            this.setDocumentNo(value);
        }
    }

    private void checkMaterialPolicy(MMovementLine line) {
        int no = MMovementLineMA.deleteMovementMA(this.getM_Movement_ID(), this.get_TrxName());
        if (no > 0) {
            this.log.config("Delete old #" + no);
        }
        boolean needSave = false;
        if (line.getM_AttributeSetInstance_ID() == 0) {
            MProduct product = MProduct.get(this.getCtx(), line.getM_Product_ID());
            String MMPolicy = product.getMMPolicy();
            MStorage[] storages = MStorage.getWarehouse(this.getCtx(), 0, line.getM_Product_ID(), 0, null, "F".equals(MMPolicy), true, line.getM_Locator_ID(), this.get_TrxName());
            BigDecimal qtyToDeliver = line.getMovementQty();
            MStorage[] mStorageArray = storages;
            int n = storages.length;
            int n2 = 0;
            while (n2 < n) {
                MMovementLineMA ma;
                MStorage storage = mStorageArray[n2];
                if (storage.getQtyOnHand().compareTo(qtyToDeliver) >= 0) {
                    ma = new MMovementLineMA(line, storage.getM_AttributeSetInstance_ID(), qtyToDeliver);
                    ma.saveEx();
                    qtyToDeliver = Env.ZERO;
                    this.log.fine(ma + ", QtyToDeliver=" + qtyToDeliver);
                } else {
                    ma = new MMovementLineMA(line, storage.getM_AttributeSetInstance_ID(), storage.getQtyOnHand());
                    ma.saveEx();
                    qtyToDeliver = qtyToDeliver.subtract(storage.getQtyOnHand());
                    this.log.fine(ma + ", QtyToDeliver=" + qtyToDeliver);
                }
                if (qtyToDeliver.signum() == 0) break;
                ++n2;
            }
            if (qtyToDeliver.signum() != 0) {
                MAttributeSetInstance asi = MAttributeSetInstance.create(this.getCtx(), product, this.get_TrxName());
                int M_AttributeSetInstance_ID = asi.getM_AttributeSetInstance_ID();
                MMovementLineMA ma = new MMovementLineMA(line, M_AttributeSetInstance_ID, qtyToDeliver);
                ma.saveEx();
                this.log.fine("##: " + ma);
            }
        }
        if (needSave) {
            line.saveEx();
        }
    }

    @Override
    public boolean voidIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            return false;
        }
        if (this.getShipments() > 0) {
            this.m_processMsg = "Documento Con Entregas Relacionadas Procesadas";
            return false;
        }
        this.delShipment();
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus())) {
            MMovementLine[] lines = this.getLines(false);
            int i = 0;
            while (i < lines.length) {
                MMovementLine line = lines[i];
                BigDecimal old = line.getMovementQty();
                if (old.compareTo(Env.ZERO) != 0) {
                    line.setMovementQty(Env.ZERO);
                    line.addDescription("Void (" + old + ")");
                    line.save(this.get_TrxName());
                }
                ++i;
            }
        } else {
            return this.reverseCorrectIt();
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getMovementDate(), dt.getDocBaseType(), this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return false;
        }
        MMovement reversal = new MMovement(this.getCtx(), 0, this.get_TrxName());
        MMovement.copyValues(this, reversal, this.getAD_Client_ID(), this.getAD_Org_ID());
        reversal.setDocStatus("DR");
        reversal.setDocAction("CO");
        reversal.setIsApproved(false);
        reversal.setIsInTransit(false);
        reversal.setPosted(false);
        reversal.setProcessed(false);
        reversal.setDocumentNo(String.valueOf(this.getDocumentNo()) + REVERSE_INDICATOR);
        reversal.addDescription("{->" + this.getDocumentNo() + ")");
        reversal.setReversal_ID(this.getM_Movement_ID());
        if (!reversal.save()) {
            this.m_processMsg = "Could not create Movement Reversal";
            return false;
        }
        reversal.setReversal(true);
        MMovementLine[] oLines = this.getLines(true);
        int i = 0;
        while (i < oLines.length) {
            MMovementLine oLine = oLines[i];
            MMovementLine rLine = new MMovementLine(this.getCtx(), 0, this.get_TrxName());
            MMovement.copyValues(oLine, rLine, oLine.getAD_Client_ID(), oLine.getAD_Org_ID());
            rLine.setM_Movement_ID(reversal.getM_Movement_ID());
            rLine.setReversalLine_ID(oLine.getM_MovementLine_ID());
            rLine.setMovementQty(rLine.getMovementQty().negate());
            rLine.setTargetQty(Env.ZERO);
            rLine.setScrappedQty(Env.ZERO);
            rLine.setConfirmedQty(Env.ZERO);
            rLine.setProcessed(false);
            if (!rLine.save()) {
                this.m_processMsg = "Could not create Movement Reversal Line";
                return false;
            }
            ++i;
        }
        if (!reversal.processIt("CO")) {
            this.m_processMsg = "Reversal ERROR: " + reversal.getProcessMsg();
            return false;
        }
        reversal.closeIt();
        reversal.setDocStatus("RE");
        reversal.setDocAction("--");
        reversal.save();
        this.m_processMsg = reversal.getDocumentNo();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        this.addDescription("(" + reversal.getDocumentNo() + "<-)");
        this.setReversal_ID(reversal.getM_Movement_ID());
        this.setProcessed(true);
        this.setDocStatus("RE");
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate(this.getCtx(), "ApprovalAmt")).append("=").append(this.getApprovalAmt()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    private void setReversal(boolean reversal) {
        this.m_reversal = reversal;
    }

    private boolean isReversal() {
        return this.m_reversal;
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }

    public int copyLinesFrom(MMovement from, boolean counter, boolean copyASI) {
        MMovementLine[] fromLines = from.getLines(false);
        int count = 0;
        int i = 0;
        while (i < fromLines.length) {
            MMovementLine line = new MMovementLine(this);
            PO.copyValues(fromLines[i], line, this.getAD_Client_ID(), this.getAD_Org_ID());
            line.setM_Movement_ID(this.getM_Movement_ID());
            line.setProcessed(false);
            if (line.save()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private void processShipment() {
        block7: {
            MMovementLine[] lines;
            MMovementLine[] mMovementLineArray = lines = this.getLines(true);
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                MMovementLine line = mMovementLineArray[n2];
                DB.executeUpdate("update m_inoutline set m_locator_id=" + line.getM_LocatorTo_ID() + " where M_MovementLine_ID=" + line.getM_MovementLine_ID(), this.get_TrxName());
                ++n2;
            }
            String sql = "select * from m_inout  where docstatus='DR' and M_Movement_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getM_Movement_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MInOut out = new MInOut(this.getCtx(), rs, this.get_TrxName());
                        out.processIt("PR");
                        out.save();
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }

    private void delShipment() {
        block6: {
            String sql = "select * from m_inout  where docstatus='DR' and M_Movement_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getM_Movement_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MInOut out = new MInOut(this.getCtx(), rs, this.get_TrxName());
                        out.deleteEx(true, this.get_TrxName());
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }

    private int getShipments() {
        int val;
        block6: {
            val = 0;
            String sql = "select count(1) from m_inout  where docstatus IN ('CO','IP') and M_Movement_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getM_Movement_ID());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        val = rs.getInt(1);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return val;
    }

    private int getLocatorTo(int Warehouse_ID) {
        String sql = "select M_locator_ID from M_Locator where upper(value) = 'ABASTECIMIENTO' and M_Warehouse_ID=" + Warehouse_ID;
        int LocatorTO_ID = DB.getSQLValue(this.get_TrxName(), sql);
        if (LocatorTO_ID < 0) {
            LocatorTO_ID = 0;
        }
        return LocatorTO_ID;
    }

    private BigDecimal getStock(int M_Product_ID, int M_Locator_ID, int M_AttributeSetInstance_ID) {
        BigDecimal stock;
        String mySQL = "select SUM(QtyOnHand) from M_Storage where M_Locator_ID=? and M_Product_ID=?";
        if (M_AttributeSetInstance_ID > 0) {
            mySQL = String.valueOf(mySQL) + " and M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID;
        }
        if ((stock = DB.getSQLValueBD(this.get_TrxName(), mySQL, M_Locator_ID, M_Product_ID)) == null) {
            stock = Env.ZERO;
        }
        return stock;
    }

    public MMovementLine[] getLinesProduct() {
        String whereClause = "M_Movement_ID=?";
        List<MMovementLine> list = new Query(this.getCtx(), "M_MovementLine", "M_Movement_ID=?", this.get_TrxName()).setParameters(this.getM_Movement_ID()).setOrderBy("M_Product_ID, M_Locator_ID").list();
        this.m_lines = new MMovementLine[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }
}

