/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.model.MImage;
import org.compiere.model.MWebProject;
import org.compiere.model.X_CM_Media;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MMedia
extends X_CM_Media {
    private static final long serialVersionUID = -2292852420984727096L;
    private static CLogger s_log = CLogger.getCLogger(MMedia.class);
    private MWebProject m_project = null;

    public static MMedia[] getMedia(MWebProject project) {
        ArrayList<MMedia> list = new ArrayList<MMedia>();
        CPreparedStatement pstmt = null;
        String sql = "SELECT * FROM CM_Media WHERE CM_WebProject_ID=? ORDER BY CM_Media_ID";
        try {
            pstmt = DB.prepareStatement(sql, project.get_TrxName());
            pstmt.setInt(1, project.getCM_WebProject_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MMedia(project.getCtx(), rs, project.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MMedia[] retValue = new MMedia[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MMedia(Properties ctx, int CM_Media_ID, String trxName) {
        super(ctx, CM_Media_ID, trxName);
    }

    public MMedia(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MWebProject getWebProject() {
        if (this.m_project == null) {
            this.m_project = MWebProject.get(this.getCtx(), this.getCM_WebProject_ID());
        }
        return this.m_project;
    }

    public int getAD_Tree_ID() {
        return this.getWebProject().getAD_TreeCMM_ID();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.isSummary()) {
            this.setMediaType(null);
            this.setAD_Image_ID(0);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        if (newRecord) {
            StringBuffer sb = new StringBuffer("INSERT INTO AD_TreeNodeCMM (AD_Client_ID,AD_Org_ID, IsActive,Created,CreatedBy,Updated,UpdatedBy, AD_Tree_ID, Node_ID, Parent_ID, SeqNo) VALUES (").append(this.getAD_Client_ID()).append(",0, 'Y', SysDate, 0, SysDate, 0,").append(this.getAD_Tree_ID()).append(",").append(this.get_ID()).append(", 0, 999)");
            int no = DB.executeUpdate(sb.toString(), this.get_TrxName());
            if (no > 0) {
                this.log.fine("#" + no + " - TreeType=CMM");
            } else {
                this.log.warning("#" + no + " - TreeType=CMM");
            }
            return no > 0;
        }
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        StringBuffer sb = new StringBuffer("DELETE FROM AD_TreeNodeCMM ").append(" WHERE Node_ID=").append(this.get_IDOld()).append(" AND AD_Tree_ID=").append(this.getAD_Tree_ID());
        int no = DB.executeUpdate(sb.toString(), this.get_TrxName());
        if (no > 0) {
            this.log.fine("#" + no + " - TreeType=CMM");
        } else {
            this.log.warning("#" + no + " - TreeType=CMM");
        }
        return no > 0;
    }

    public String getFileName() {
        return this.get_ID() + this.getExtension();
    }

    public String getExtension() {
        String mt = this.getMediaType();
        if ("PDF".equals(mt)) {
            return ".pdf";
        }
        if ("GIF".equals(mt)) {
            return ".gif";
        }
        if ("JPG".equals(mt)) {
            return ".jpg";
        }
        if ("PNG".equals(mt)) {
            return ".png";
        }
        if ("CSS".equals(mt)) {
            return ".css";
        }
        return ".dat";
    }

    public MImage getImage() {
        if (this.getAD_Image_ID() != 0) {
            return MImage.get(this.getCtx(), this.getAD_Image_ID());
        }
        return null;
    }

    public byte[] getData() {
        MAttachmentEntry entry;
        MAttachment att;
        byte[] data;
        MImage image = this.getImage();
        if (image != null && ((data = image.getData()) == null || data.length == 0)) {
            this.log.config("No Image Data");
        }
        if ((att = this.getAttachment()) == null || att.getEntryCount() == 0) {
            this.log.config("No Attachment");
            return null;
        }
        if (att.getEntryCount() > 1) {
            this.log.warning(this.getName() + " - more then one attachment - " + att.getEntryCount());
        }
        if ((entry = att.getEntry(0)) == null) {
            this.log.config("No Attachment Entry");
            return null;
        }
        byte[] buffer = entry.getData();
        if (buffer == null || buffer.length == 0) {
            this.log.config("No Attachment Entry Data");
            return null;
        }
        return buffer;
    }

    public InputStream getInputStream() {
        byte[] buffer = this.getData();
        ByteArrayInputStream is = new ByteArrayInputStream(buffer);
        return is;
    }

    public Timestamp getAttachmentUpdated() {
        MAttachment att = this.getAttachment();
        if (att == null) {
            return null;
        }
        return att.getUpdated();
    }
}

