/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.FillMandatoryException;
import org.adempiere.exceptions.WarehouseLocatorConflictException;
import org.compiere.model.MCharge;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLineMA;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MStorage;
import org.compiere.model.MUOM;
import org.compiere.model.MWarehouse;
import org.compiere.model.Query;
import org.compiere.model.X_M_InOutLine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MInOutLine
extends X_M_InOutLine {
    private static final long serialVersionUID = 8630611882798722864L;
    private MProduct m_product = null;
    private int m_M_Warehouse_ID = 0;
    private MInOut m_parent = null;

    public static MInOutLine[] getOfOrderLine(Properties ctx, int C_OrderLine_ID, String where, String trxName) {
        String whereClause = "C_OrderLine_ID=?" + (!Util.isEmpty(where, true) ? " AND " + where : "");
        List<MInOutLine> list = new Query(ctx, "M_InOutLine", whereClause, trxName).setParameters(C_OrderLine_ID).list();
        return list.toArray(new MInOutLine[list.size()]);
    }

    public static MInOutLine[] getOfRMALine(Properties ctx, int M_RMALine_ID, String where, String trxName) {
        String whereClause = "M_RMALine_ID=? " + (!Util.isEmpty(where, true) ? " AND " + where : "");
        List<MInOutLine> list = new Query(ctx, "M_InOutLine", whereClause, trxName).setParameters(M_RMALine_ID).list();
        return list.toArray(new MInOutLine[list.size()]);
    }

    public static MInOutLine[] get(Properties ctx, int C_OrderLine_ID, String trxName) {
        return MInOutLine.getOfOrderLine(ctx, C_OrderLine_ID, null, trxName);
    }

    public MInOutLine(Properties ctx, int M_InOutLine_ID, String trxName) {
        super(ctx, M_InOutLine_ID, trxName);
        if (M_InOutLine_ID == 0) {
            this.setM_AttributeSetInstance_ID(0);
            this.setConfirmedQty(Env.ZERO);
            this.setPickedQty(Env.ZERO);
            this.setScrappedQty(Env.ZERO);
            this.setTargetQty(Env.ZERO);
            this.setIsInvoiced(false);
            this.setIsDescription(false);
        }
    }

    public MInOutLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInOutLine(MInOut inout) {
        this(inout.getCtx(), 0, inout.get_TrxName());
        this.setClientOrg(inout);
        this.setM_InOut_ID(inout.getM_InOut_ID());
        this.setM_Warehouse_ID(inout.getM_Warehouse_ID());
        this.setC_Project_ID(inout.getC_Project_ID());
        this.m_parent = inout;
    }

    public MInOut getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MInOut(this.getCtx(), this.getM_InOut_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public void setOrderLine(MOrderLine oLine, int M_Locator_ID, BigDecimal Qty) {
        this.setC_OrderLine_ID(oLine.getC_OrderLine_ID());
        this.setLine(oLine.getLine());
        this.setC_UOM_ID(oLine.getC_UOM_ID());
        MProduct product = oLine.getProduct();
        if (product == null) {
            this.set_ValueNoCheck("M_Product_ID", null);
            this.set_ValueNoCheck("M_AttributeSetInstance_ID", null);
            this.set_ValueNoCheck("M_Locator_ID", null);
        } else {
            this.setM_Product_ID(oLine.getM_Product_ID());
            this.setM_AttributeSetInstance_ID(oLine.getM_AttributeSetInstance_ID());
            if (product.isItem()) {
                if (M_Locator_ID == 0) {
                    this.setM_Locator_ID(Qty);
                } else {
                    this.setM_Locator_ID(M_Locator_ID);
                }
            } else {
                this.set_ValueNoCheck("M_Locator_ID", null);
            }
        }
        this.setC_Charge_ID(oLine.getC_Charge_ID());
        this.setDescription(oLine.getDescription());
        this.setIsDescription(oLine.isDescription());
        this.setC_Project_ID(oLine.getC_Project_ID());
        this.setC_ProjectPhase_ID(oLine.getC_ProjectPhase_ID());
        this.setC_ProjectTask_ID(oLine.getC_ProjectTask_ID());
        this.setC_Activity_ID(oLine.getC_Activity_ID());
        this.setC_Campaign_ID(oLine.getC_Campaign_ID());
        this.setAD_OrgTrx_ID(oLine.getAD_OrgTrx_ID());
        this.setUser1_ID(oLine.getUser1_ID());
        this.setUser2_ID(oLine.getUser2_ID());
    }

    public void setInvoiceLine(MInvoiceLine iLine, int M_Locator_ID, BigDecimal Qty) {
        this.setC_OrderLine_ID(iLine.getC_OrderLine_ID());
        this.setLine(iLine.getLine());
        this.setC_UOM_ID(iLine.getC_UOM_ID());
        int M_Product_ID = iLine.getM_Product_ID();
        if (M_Product_ID == 0) {
            this.set_ValueNoCheck("M_Product_ID", null);
            this.set_ValueNoCheck("M_Locator_ID", null);
            this.set_ValueNoCheck("M_AttributeSetInstance_ID", null);
        } else {
            this.setM_Product_ID(M_Product_ID);
            this.setM_AttributeSetInstance_ID(iLine.getM_AttributeSetInstance_ID());
            if (M_Locator_ID == 0) {
                this.setM_Locator_ID(Qty);
            } else {
                this.setM_Locator_ID(M_Locator_ID);
            }
        }
        this.setC_Charge_ID(iLine.getC_Charge_ID());
        this.setDescription(iLine.getDescription());
        this.setIsDescription(iLine.isDescription());
        this.setC_Project_ID(iLine.getC_Project_ID());
        this.setC_ProjectPhase_ID(iLine.getC_ProjectPhase_ID());
        this.setC_ProjectTask_ID(iLine.getC_ProjectTask_ID());
        this.setC_Activity_ID(iLine.getC_Activity_ID());
        this.setC_Campaign_ID(iLine.getC_Campaign_ID());
        this.setAD_OrgTrx_ID(iLine.getAD_OrgTrx_ID());
        this.setUser1_ID(iLine.getUser1_ID());
        this.setUser2_ID(iLine.getUser2_ID());
    }

    public int getM_Warehouse_ID() {
        if (this.m_M_Warehouse_ID == 0) {
            this.m_M_Warehouse_ID = this.getParent().getM_Warehouse_ID();
        }
        return this.m_M_Warehouse_ID;
    }

    public void setM_Warehouse_ID(int warehouse_ID) {
        this.m_M_Warehouse_ID = warehouse_ID;
    }

    @Override
    public void setM_Locator_ID(int M_Locator_ID) {
        if (M_Locator_ID < 0) {
            throw new IllegalArgumentException("M_Locator_ID is mandatory.");
        }
        this.set_Value("M_Locator_ID", (Object)new Integer(M_Locator_ID));
    }

    public void setM_Locator_ID(BigDecimal Qty) {
        if (this.getM_Locator_ID() != 0) {
            return;
        }
        if (this.getM_Product_ID() == 0) {
            this.set_ValueNoCheck("M_Locator_ID", null);
            return;
        }
        int M_Locator_ID = MStorage.getM_Locator_ID(this.getM_Warehouse_ID(), this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), Qty, this.get_TrxName());
        if (M_Locator_ID == 0) {
            MWarehouse wh = MWarehouse.get(this.getCtx(), this.getM_Warehouse_ID());
            M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
        }
        this.setM_Locator_ID(M_Locator_ID);
    }

    public void setQty(BigDecimal Qty) {
        this.setQtyEntered(Qty);
        this.setMovementQty(this.getQtyEntered());
    }

    @Override
    public void setQtyEntered(BigDecimal QtyEntered) {
        if (QtyEntered != null && this.getC_UOM_ID() != 0) {
            int precision = MUOM.getPrecision(this.getCtx(), this.getC_UOM_ID());
            QtyEntered = QtyEntered.setScale(precision, 4);
        }
        super.setQtyEntered(QtyEntered);
    }

    @Override
    public void setMovementQty(BigDecimal MovementQty) {
        MProduct product = this.getProduct();
        if (MovementQty != null && product != null) {
            int precision = product.getUOMPrecision();
            MovementQty = MovementQty.setScale(precision, 4);
        }
        super.setMovementQty(MovementQty);
    }

    public MProduct getProduct() {
        if (this.m_product == null && this.getM_Product_ID() != 0) {
            this.m_product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        }
        return this.m_product;
    }

    public void setProduct(MProduct product) {
        this.m_product = product;
        if (this.m_product != null) {
            this.setM_Product_ID(this.m_product.getM_Product_ID());
            this.setC_UOM_ID(this.m_product.getC_UOM_ID());
        } else {
            this.setM_Product_ID(0);
            this.setC_UOM_ID(0);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int M_Product_ID, boolean setUOM) {
        if (setUOM) {
            this.setProduct(MProduct.get(this.getCtx(), M_Product_ID));
        } else {
            super.setM_Product_ID(M_Product_ID);
        }
        this.setM_AttributeSetInstance_ID(0);
    }

    public void setM_Product_ID(int M_Product_ID, int C_UOM_ID) {
        if (M_Product_ID != 0) {
            super.setM_Product_ID(M_Product_ID);
        }
        super.setC_UOM_ID(C_UOM_ID);
        this.setM_AttributeSetInstance_ID(0);
        this.m_product = null;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(String.valueOf(desc) + " | " + description);
        }
    }

    @Override
    public int getC_Project_ID() {
        int ii = super.getC_Project_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Project_ID();
        }
        return ii;
    }

    @Override
    public int getC_Activity_ID() {
        int ii = super.getC_Activity_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Activity_ID();
        }
        return ii;
    }

    @Override
    public int getC_Campaign_ID() {
        int ii = super.getC_Campaign_ID();
        if (ii == 0) {
            ii = this.getParent().getC_Campaign_ID();
        }
        return ii;
    }

    @Override
    public int getUser1_ID() {
        int ii = super.getUser1_ID();
        if (ii == 0) {
            ii = this.getParent().getUser1_ID();
        }
        return ii;
    }

    @Override
    public int getUser2_ID() {
        int ii = super.getUser2_ID();
        if (ii == 0) {
            ii = this.getParent().getUser2_ID();
        }
        return ii;
    }

    @Override
    public int getAD_OrgTrx_ID() {
        int ii = super.getAD_OrgTrx_ID();
        if (ii == 0) {
            ii = this.getParent().getAD_OrgTrx_ID();
        }
        return ii;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MCharge charge;
        int C_UOM_ID;
        this.log.fine("");
        if (newRecord && this.getParent().isComplete()) {
            this.log.saveError("ParentComplete", Msg.translate(this.getCtx(), "M_InOutLine"));
            return false;
        }
        if (this.getProduct() != null && "I".equals(this.getProduct().getProductType()) && this.getM_Locator_ID() <= 0 && this.getC_Charge_ID() <= 0) {
            throw new FillMandatoryException(new String[]{"M_Locator_ID"});
        }
        if (this.getLine() == 0) {
            String sql = "SELECT COALESCE(MAX(Line),0)+10 FROM M_InOutLine WHERE M_InOut_ID=?";
            int ii = DB.getSQLValueEx(this.get_TrxName(), sql, this.getM_InOut_ID());
            this.setLine(ii);
        }
        if (this.getC_UOM_ID() == 0) {
            this.setC_UOM_ID(Env.getContextAsInt(this.getCtx(), "#C_UOM_ID"));
        }
        if (this.getC_UOM_ID() == 0 && (C_UOM_ID = MUOM.getDefault_UOM_ID(this.getCtx())) > 0) {
            this.setC_UOM_ID(C_UOM_ID);
        }
        if (newRecord || this.is_ValueChanged("QtyEntered")) {
            this.setQtyEntered(this.getQtyEntered());
        }
        if (newRecord || this.is_ValueChanged("MovementQty")) {
            this.setMovementQty(this.getMovementQty());
        }
        if (this.getC_OrderLine_ID() == 0 && this.getM_RMALine_ID() == 0 && this.getParent().isSOTrx()) {
            this.log.saveError("FillMandatory", Msg.translate(this.getCtx(), "C_Order_ID"));
            return false;
        }
        if (this.getM_Locator_ID() > 0) {
            MLocator locator = MLocator.get(this.getCtx(), this.getM_Locator_ID());
            if (this.getM_Warehouse_ID() != locator.getM_Warehouse_ID()) {
                throw new WarehouseLocatorConflictException(MWarehouse.get(this.getCtx(), this.getM_Warehouse_ID()), locator, this.getLine());
            }
        }
        int group_IDAsset = 0;
        int group_IDAssetReceipt = this.get_ValueAsInt("A_Asset_Group_ID");
        boolean IsSetedAG = false;
        if (this.getC_OrderLine_ID() > 0) {
            MOrderLine oline = new MOrderLine(this.getCtx(), this.getC_OrderLine_ID(), this.get_TrxName());
            this.set_Value("PriceActual", (Object)oline.getPriceActual());
            if (oline.get_ValueAsString("Help") != null && !oline.get_ValueAsString("Help").equals("")) {
                this.set_CustomColumn("Help", oline.get_ValueAsString("Help"));
            }
            this.set_CustomColumn("A_CapvsExp", oline.get_Value("A_CapvsExp"));
            if (group_IDAssetReceipt > 0) {
                IsSetedAG = true;
            }
            if ((group_IDAsset = oline.get_ValueAsInt("A_Asset_Group_ID")) > 0 && !IsSetedAG) {
                this.set_CustomColumn("A_Asset_Group_ID", oline.get_ValueAsInt("A_Asset_Group_ID"));
                IsSetedAG = true;
            }
            this.set_CustomColumn("A_CreateAsset", oline.get_Value("A_CreateAsset"));
            if (this.get_ValueAsInt("A_Asset_ID") <= 0) {
                this.set_CustomColumn("A_Asset_ID", oline.get_Value("A_Asset_ID"));
            }
        }
        if (this.getC_Charge_ID() != 0 && (charge = MCharge.get(this.getCtx(), this.getC_Charge_ID())).getC_ChargeType_ID() > 0 && charge.getC_ChargeType().getValue().equals("TCAF")) {
            if (this.get_ValueAsString("A_CapvsExp").equals("")) {
                this.log.saveError("Activo", "se debe indicar si es compra o gasto de activo");
                return false;
            }
            if (this.get_ValueAsString("A_CapvsExp").equals("Exp") && this.get_ValueAsInt("A_Asset_ID") <= 0) {
                this.log.saveError("Activo", "Para gastos relacionados con un activos, el activo es obligatorio");
                return false;
            }
            if (this.get_ValueAsString("A_CapvsExp").equals("Cap") && !IsSetedAG) {
                int group_ID = DB.getSQLValue(this.get_TrxName(), "select a_asset_group_id from a_asset_group where isdefault='Y' and ad_client_id=" + this.getAD_Client_ID());
                if (group_ID > 0) {
                    this.set_CustomColumn("A_Asset_Group_ID", group_ID);
                } else {
                    this.log.saveError("Activo", "No existe un grupo por defecto para activos, debe indicar un grupo");
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        if (this.getParent().getDocStatus().equals("DR")) {
            return true;
        }
        this.log.saveError("Error", Msg.getMsg(this.getCtx(), "CannotDelete"));
        return false;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MInOutLine[").append(this.get_ID()).append(",M_Product_ID=").append(this.getM_Product_ID()).append(",QtyEntered=").append(this.getQtyEntered()).append(",MovementQty=").append(this.getMovementQty()).append(",M_AttributeSetInstance_ID=").append(this.getM_AttributeSetInstance_ID()).append("]");
        return sb.toString();
    }

    public BigDecimal getBase(String CostDistribution) {
        if ("C".equals(CostDistribution)) {
            if (this.getParent().getC_Order_ID() == 0) {
                this.log.severe("Not Purchase Order");
                return Env.ZERO;
            }
            MOrder puo = new MOrder(this.getCtx(), this.getParent().getC_Order_ID(), this.get_TrxName());
            BigDecimal total = puo.getTotalLines();
            BigDecimal totalp = new BigDecimal("0.0");
            MOrderLine[] lines = puo.getLines("And M_Product_ID=" + this.getM_Product_ID(), "");
            int i = 0;
            while (i < lines.length) {
                totalp = totalp.add(lines[i].getLineNetAmt());
                ++i;
            }
            return totalp.multiply(Env.ONEHUNDRED).divide(total, 10, 4);
        }
        if ("L".equals(CostDistribution)) {
            return Env.ONE;
        }
        if ("Q".equals(CostDistribution)) {
            return this.getMovementQty();
        }
        if ("V".equals(CostDistribution)) {
            MProduct product = this.getProduct();
            if (product == null) {
                this.log.severe("No Product");
                return Env.ZERO;
            }
            return this.getMovementQty().multiply(product.getVolume());
        }
        if ("W".equals(CostDistribution)) {
            MProduct product = this.getProduct();
            if (product == null) {
                this.log.severe("No Product");
                return Env.ZERO;
            }
            return this.getMovementQty().multiply(product.getWeight());
        }
        this.log.severe("Invalid Criteria: " + CostDistribution);
        return Env.ZERO;
    }

    public boolean sameOrderLineUOM() {
        if (this.getC_OrderLine_ID() <= 0) {
            return false;
        }
        MOrderLine oLine = new MOrderLine(this.getCtx(), this.getC_OrderLine_ID(), this.get_TrxName());
        return oLine.getC_UOM_ID() == this.getC_UOM_ID();
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (MInOutLineMA.get(this.getCtx(), this.getM_InOutLine_ID(), this.get_TrxName()).length > 0) {
            return true;
        }
        if (this.getM_AttributeSetInstance_ID() != 0 && (this.getM_InOut().getMovementType().equals("C-") || this.getM_InOut().getMovementType().equals("V-"))) {
            MInOutLineMA ma = new MInOutLineMA(this, this.getM_AttributeSetInstance_ID(), this.getMovementQty());
            ma.saveEx();
        }
        return true;
    }
}

