/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.I_C_DunningLevel;
import org.compiere.model.MConversionRate;
import org.compiere.model.MDunningRunEntry;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.X_C_DunningRunLine;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MDunningRunLine
extends X_C_DunningRunLine {
    private static final long serialVersionUID = -6329441027195611155L;
    private MDunningRunEntry m_parent = null;
    private MInvoice m_invoice = null;
    private MPayment m_payment = null;
    private int m_C_CurrencyFrom_ID = 0;
    private int m_C_CurrencyTo_ID = 0;

    public MDunningRunLine(Properties ctx, int C_DunningRunLine_ID, String trxName) {
        super(ctx, C_DunningRunLine_ID, trxName);
        if (C_DunningRunLine_ID == 0) {
            this.setAmt(Env.ZERO);
            this.setOpenAmt(Env.ZERO);
            this.setConvertedAmt(Env.ZERO);
            this.setFeeAmt(Env.ZERO);
            this.setInterestAmt(Env.ZERO);
            this.setTotalAmt(Env.ZERO);
            this.setDaysDue(0);
            this.setTimesDunned(0);
            this.setIsInDispute(false);
            this.setProcessed(false);
        }
    }

    public MDunningRunLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MDunningRunLine(MDunningRunEntry parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setC_DunningRunEntry_ID(parent.getC_DunningRunEntry_ID());
        this.m_parent = parent;
        this.m_C_CurrencyTo_ID = parent.getC_Currency_ID();
    }

    public MDunningRunEntry getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MDunningRunEntry(this.getCtx(), this.getC_DunningRunEntry_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public MInvoice getInvoice() {
        if (this.getC_Invoice_ID() == 0) {
            this.m_invoice = null;
        } else if (this.m_invoice == null) {
            this.m_invoice = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
        }
        return this.m_invoice;
    }

    public void setInvoice(MInvoice invoice) {
        this.m_invoice = invoice;
        if (invoice != null) {
            this.m_C_CurrencyFrom_ID = invoice.getC_Currency_ID();
            this.setAmt(invoice.getGrandTotal());
            this.setOpenAmt(this.getAmt());
            this.setConvertedAmt(MConversionRate.convert(this.getCtx(), this.getOpenAmt(), this.getC_CurrencyFrom_ID(), this.getC_CurrencyTo_ID(), this.getAD_Client_ID(), this.getAD_Org_ID()));
        } else {
            this.m_C_CurrencyFrom_ID = 0;
            this.setAmt(Env.ZERO);
            this.setOpenAmt(Env.ZERO);
            this.setConvertedAmt(Env.ZERO);
        }
    }

    public void setInvoice(int C_Invoice_ID, int C_Currency_ID, BigDecimal GrandTotal, BigDecimal Open, BigDecimal FeeAmount, int DaysDue, boolean IsInDispute, int TimesDunned, int DaysAfterLast) {
        this.setC_Invoice_ID(C_Invoice_ID);
        this.m_C_CurrencyFrom_ID = C_Currency_ID;
        this.setAmt(GrandTotal);
        this.setOpenAmt(Open);
        this.setFeeAmt(FeeAmount);
        this.setConvertedAmt(MConversionRate.convert(this.getCtx(), this.getOpenAmt(), C_Currency_ID, this.getC_CurrencyTo_ID(), this.getAD_Client_ID(), this.getAD_Org_ID()));
        this.setIsInDispute(IsInDispute);
        this.setDaysDue(DaysDue);
        this.setTimesDunned(TimesDunned);
    }

    public void setFee(int C_Currency_ID, BigDecimal FeeAmount) {
        this.m_C_CurrencyFrom_ID = C_Currency_ID;
        this.setAmt(FeeAmount);
        this.setOpenAmt(FeeAmount);
        this.setFeeAmt(FeeAmount);
        this.setConvertedAmt(MConversionRate.convert(this.getCtx(), this.getOpenAmt(), C_Currency_ID, this.getC_CurrencyTo_ID(), this.getAD_Client_ID(), this.getAD_Org_ID()));
    }

    public MPayment getPayment() {
        if (this.getC_Payment_ID() == 0) {
            this.m_payment = null;
        } else if (this.m_payment == null) {
            this.m_payment = new MPayment(this.getCtx(), this.getC_Payment_ID(), this.get_TrxName());
        }
        return this.m_payment;
    }

    public void setPayment(int C_Payment_ID, int C_Currency_ID, BigDecimal PayAmt, BigDecimal OpenAmt) {
        this.setC_Payment_ID(C_Payment_ID);
        this.m_C_CurrencyFrom_ID = C_Currency_ID;
        this.setAmt(PayAmt);
        this.setOpenAmt(OpenAmt);
        this.setConvertedAmt(MConversionRate.convert(this.getCtx(), this.getOpenAmt(), C_Currency_ID, this.getC_CurrencyTo_ID(), this.getAD_Client_ID(), this.getAD_Org_ID()));
    }

    public int getC_CurrencyFrom_ID() {
        if (this.m_C_CurrencyFrom_ID == 0) {
            if (this.getC_Invoice_ID() != 0) {
                this.m_C_CurrencyFrom_ID = this.getInvoice().getC_Currency_ID();
            } else if (this.getC_Payment_ID() != 0) {
                this.m_C_CurrencyFrom_ID = this.getPayment().getC_Currency_ID();
            }
        }
        return this.m_C_CurrencyFrom_ID;
    }

    public int getC_CurrencyTo_ID() {
        if (this.m_C_CurrencyTo_ID == 0) {
            this.m_C_CurrencyTo_ID = this.getParent().getC_Currency_ID();
        }
        return this.m_C_CurrencyTo_ID;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        I_C_DunningLevel level;
        if (this.getC_Invoice_ID() == 0 && this.getC_Payment_ID() == 0) {
            this.setAmt(Env.ZERO);
            this.setOpenAmt(Env.ZERO);
        }
        if (Env.ZERO.compareTo(this.getOpenAmt()) == 0) {
            this.setConvertedAmt(Env.ZERO);
        } else if (Env.ZERO.compareTo(this.getConvertedAmt()) == 0) {
            this.setConvertedAmt(MConversionRate.convert(this.getCtx(), this.getOpenAmt(), this.getC_CurrencyFrom_ID(), this.getC_CurrencyTo_ID(), this.getAD_Client_ID(), this.getAD_Org_ID()));
        }
        this.setTotalAmt(this.getConvertedAmt().add(this.getFeeAmt()).add(this.getInterestAmt()));
        if (this.isProcessed() && this.getInvoice() != null && (level = this.getParent().getC_DunningLevel()) != null) {
            this.getInvoice().setC_DunningLevel_ID(level.getC_DunningLevel_ID());
            if (level.getInvoiceCollectionType() != null) {
                this.getInvoice().setInvoiceCollectionType(level.getInvoiceCollectionType());
            } else if (!level.isStatement()) {
                this.getInvoice().setInvoiceCollectionType("D");
            }
            this.getInvoice().saveEx();
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        this.updateEntry();
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        this.updateEntry();
        return success;
    }

    private void updateEntry() {
        String sql = "UPDATE C_DunningRunEntry e SET Amt=NVL((SELECT SUM(ConvertedAmt)+SUM(FeeAmt)+SUM(InterestAmt) FROM C_DunningRunLine l WHERE e.C_DunningRunEntry_ID=l.C_DunningRunEntry_ID), 0), QTY=(SELECT COUNT(*) FROM C_DunningRunLine l WHERE e.C_DunningRunEntry_ID=l.C_DunningRunEntry_ID  AND (NOT C_Invoice_ID IS NULL OR NOT C_Payment_ID IS NULL)) WHERE C_DunningRunEntry_ID=" + this.getC_DunningRunEntry_ID();
        DB.executeUpdate(sql, this.get_TrxName());
    }
}

