/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.AdempiereProcessorLog;
import org.compiere.model.MAlert;
import org.compiere.model.MAlertProcessorLog;
import org.compiere.model.Query;
import org.compiere.model.X_AD_AlertProcessor;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class MAlertProcessor
extends X_AD_AlertProcessor
implements AdempiereProcessor {
    private static final long serialVersionUID = 9060358751064718910L;
    private static CLogger s_log = CLogger.getCLogger(MAlertProcessor.class);
    private static CCache<Integer, MAlert[]> s_cacheAlerts = new CCache("AD_Alert_ForProcessor", 10);

    public static MAlertProcessor[] getActive(Properties ctx) {
        List<MAlertProcessor> list = new Query(ctx, "AD_AlertProcessor", null, null).setOnlyActiveRecords(true).list();
        MAlertProcessor[] retValue = new MAlertProcessor[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MAlertProcessor(Properties ctx, int AD_AlertProcessorLog_ID, String trxName) {
        super(ctx, AD_AlertProcessorLog_ID, trxName);
    }

    public MAlertProcessor(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String getServerID() {
        return "AlertProcessor" + this.get_ID();
    }

    @Override
    public Timestamp getDateNextRun(boolean requery) {
        if (requery) {
            this.load(this.get_TrxName());
        }
        return this.getDateNextRun();
    }

    @Override
    public AdempiereProcessorLog[] getLogs() {
        String whereClause = "AD_AlertProcessor_ID=?";
        List<AdempiereProcessorLog> list = new Query(this.getCtx(), "AD_AlertProcessorLog", "AD_AlertProcessor_ID=?", null).setParameters(this.getAD_AlertProcessor_ID()).setOrderBy("Created DESC").list();
        AdempiereProcessorLog[] retValue = new MAlertProcessorLog[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int deleteLog() {
        if (this.getKeepLogDays() < 1) {
            return 0;
        }
        String sql = "DELETE AD_AlertProcessorLog WHERE AD_AlertProcessor_ID=" + this.getAD_AlertProcessor_ID() + " AND (Created+" + this.getKeepLogDays() + ") < SysDate";
        int no = DB.executeUpdate(sql, this.get_TrxName());
        return no;
    }

    public MAlert[] getAlerts(boolean reload) {
        MAlert[] alerts = s_cacheAlerts.get(this.get_ID());
        if (alerts != null && !reload) {
            return alerts;
        }
        String whereClause = "AD_AlertProcessor_ID=?";
        List<MAlert> list = new Query(this.getCtx(), "AD_Alert", "AD_AlertProcessor_ID=?", null).setParameters(this.getAD_AlertProcessor_ID()).setOnlyActiveRecords(true).list();
        alerts = new MAlert[list.size()];
        list.toArray(alerts);
        s_cacheAlerts.put(this.get_ID(), alerts);
        return alerts;
    }
}

