/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutPayment
extends CalloutEngine {
    public String invoice(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Timestamp ts;
        Integer C_Invoice_ID = (Integer)value;
        if (this.isCalloutActive() || C_Invoice_ID == null || C_Invoice_ID == 0) {
            return "";
        }
        mTab.setValue("C_Order_ID", null);
        mTab.setValue("C_Charge_ID", null);
        mTab.setValue("IsPrepayment", (Object)Boolean.FALSE);
        mTab.setValue("DiscountAmt", (Object)Env.ZERO);
        mTab.setValue("WriteOffAmt", (Object)Env.ZERO);
        mTab.setValue("IsOverUnderPayment", (Object)Boolean.FALSE);
        mTab.setValue("OverUnderAmt", (Object)Env.ZERO);
        int C_InvoicePaySchedule_ID = 0;
        if (Env.getContextAsInt(ctx, WindowNo, 1113, "C_Invoice_ID") == C_Invoice_ID && Env.getContextAsInt(ctx, WindowNo, 1113, "C_InvoicePaySchedule_ID") != 0) {
            C_InvoicePaySchedule_ID = Env.getContextAsInt(ctx, WindowNo, 1113, "C_InvoicePaySchedule_ID");
        }
        if ((ts = (Timestamp)mTab.getValue("DateTrx")) == null) {
            ts = new Timestamp(System.currentTimeMillis());
        }
        String sql = "SELECT C_BPartner_ID,C_Currency_ID, invoiceOpen(C_Invoice_ID, ?), invoiceDiscount(C_Invoice_ID,?,?), IsSOTrx FROM C_Invoice WHERE C_Invoice_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, C_InvoicePaySchedule_ID);
                pstmt.setTimestamp(2, ts);
                pstmt.setInt(3, C_InvoicePaySchedule_ID);
                pstmt.setInt(4, C_Invoice_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    mTab.setValue("C_BPartner_ID", (Object)new Integer(rs.getInt(1)));
                    int C_Currency_ID = rs.getInt(2);
                    mTab.setValue("C_Currency_ID", (Object)new Integer(C_Currency_ID));
                    BigDecimal InvoiceOpen = rs.getBigDecimal(3);
                    if (InvoiceOpen == null) {
                        InvoiceOpen = Env.ZERO;
                    }
                    BigDecimal DiscountAmt = rs.getBigDecimal(4);
                    if (InvoiceOpen.signum() == 0) {
                        mTab.fireDataStatusEEvent("Factura Pagada", "Este Documento ya a sido pagado", false);
                    }
                    if (DiscountAmt == null) {
                        DiscountAmt = Env.ZERO;
                    }
                    mTab.setValue("PayAmt", (Object)InvoiceOpen.subtract(DiscountAmt));
                    mTab.setValue("DiscountAmt", (Object)DiscountAmt);
                    Env.setContext(ctx, WindowNo, "C_Invoice_ID", C_Invoice_ID.toString());
                    mTab.setValue("C_Invoice_ID", (Object)C_Invoice_ID);
                    mTab.setValue("C_InvoicePaySchedule_ID", (Object)C_InvoicePaySchedule_ID);
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
                String string = e.getLocalizedMessage();
                DB.close(rs, pstmt);
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close(rs, pstmt);
        return this.docType(ctx, WindowNo, mTab, mField, value);
    }

    public String order(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_Order_ID = (Integer)value;
        if (this.isCalloutActive() || C_Order_ID == null || C_Order_ID == 0) {
            return "";
        }
        mTab.setValue("C_Invoice_ID", null);
        mTab.setValue("C_Charge_ID", null);
        mTab.setValue("IsPrepayment", (Object)Boolean.TRUE);
        mTab.setValue("DiscountAmt", (Object)Env.ZERO);
        mTab.setValue("WriteOffAmt", (Object)Env.ZERO);
        mTab.setValue("IsOverUnderPayment", (Object)Boolean.FALSE);
        mTab.setValue("OverUnderAmt", (Object)Env.ZERO);
        Timestamp ts = (Timestamp)mTab.getValue("DateTrx");
        if (ts == null) {
            ts = new Timestamp(System.currentTimeMillis());
        }
        String sql = "SELECT COALESCE(Bill_BPartner_ID, C_BPartner_ID) as C_BPartner_ID , C_Currency_ID , GrandTotal FROM C_Order WHERE C_Order_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, C_Order_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    mTab.setValue("C_BPartner_ID", (Object)new Integer(rs.getInt(1)));
                    int C_Currency_ID = rs.getInt(2);
                    mTab.setValue("C_Currency_ID", (Object)new Integer(C_Currency_ID));
                    BigDecimal GrandTotal = rs.getBigDecimal(3);
                    if (GrandTotal == null) {
                        GrandTotal = Env.ZERO;
                    }
                    mTab.setValue("PayAmt", (Object)GrandTotal);
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
                String string = e.getLocalizedMessage();
                DB.close(rs, pstmt);
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close(rs, pstmt);
        return this.docType(ctx, WindowNo, mTab, mField, value);
    }

    public String charge(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_Charge_ID = (Integer)value;
        if (this.isCalloutActive() || C_Charge_ID == null || C_Charge_ID == 0) {
            return "";
        }
        mTab.setValue("C_Invoice_ID", null);
        mTab.setValue("C_Order_ID", null);
        mTab.setValue("IsPrepayment", (Object)Boolean.FALSE);
        mTab.setValue("DiscountAmt", (Object)Env.ZERO);
        mTab.setValue("WriteOffAmt", (Object)Env.ZERO);
        mTab.setValue("IsOverUnderPayment", (Object)Boolean.FALSE);
        mTab.setValue("OverUnderAmt", (Object)Env.ZERO);
        return "";
    }

    public String docType(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        int C_Invoice_ID = Env.getContextAsInt(ctx, WindowNo, "C_Invoice_ID");
        int C_Order_ID = Env.getContextAsInt(ctx, WindowNo, "C_Order_ID");
        int C_DocType_ID = Env.getContextAsInt(ctx, WindowNo, "C_DocType_ID");
        this.log.fine("Payment_DocType - C_Invoice_ID=" + C_Invoice_ID + ", C_DocType_ID=" + C_DocType_ID);
        MDocType dt = null;
        if (C_DocType_ID != 0) {
            dt = MDocType.get(ctx, C_DocType_ID);
            Env.setContext(ctx, WindowNo, "IsSOTrx", dt.isSOTrx() ? "Y" : "N");
        }
        if (C_Invoice_ID != 0) {
            MInvoice inv = new MInvoice(ctx, C_Invoice_ID, null);
            if (dt != null && inv.isSOTrx() != dt.isSOTrx()) {
                return "PaymentDocTypeInvoiceInconsistent";
            }
        }
        if (C_Order_ID != 0) {
            MOrder ord = new MOrder(ctx, C_Order_ID, null);
            if (dt != null && ord.isSOTrx() != dt.isSOTrx()) {
                return "PaymentDocTypeInvoiceInconsistent";
            }
        }
        return "";
    }

    public String amounts(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        if (this.isCalloutActive()) {
            return "";
        }
        int C_Invoice_ID = Env.getContextAsInt(ctx, WindowNo, "C_Invoice_ID");
        if (Env.getContextAsInt(ctx, WindowNo, "C_Payment_ID") == 0 && Env.getContextAsInt(ctx, WindowNo, "C_BPartner_ID") == 0 && C_Invoice_ID == 0) {
            return "";
        }
        String colName = mField.getColumnName();
        if (colName.equals("IsOverUnderPayment") || !"Y".equals(Env.getContext(ctx, WindowNo, "IsOverUnderPayment"))) {
            mTab.setValue("OverUnderAmt", (Object)Env.ZERO);
        }
        int C_InvoicePaySchedule_ID = 0;
        if (Env.getContextAsInt(ctx, WindowNo, 1113, "C_Invoice_ID") == C_Invoice_ID && Env.getContextAsInt(ctx, WindowNo, 1113, "C_InvoicePaySchedule_ID") != 0) {
            C_InvoicePaySchedule_ID = Env.getContextAsInt(ctx, WindowNo, 1113, "C_InvoicePaySchedule_ID");
        }
        BigDecimal InvoiceOpenAmt = Env.ZERO;
        int C_Currency_Invoice_ID = 0;
        if (C_Invoice_ID != 0) {
            Timestamp ts = (Timestamp)mTab.getValue("DateTrx");
            if (ts == null) {
                ts = new Timestamp(System.currentTimeMillis());
            }
            String sql = "SELECT C_BPartner_ID,C_Currency_ID, invoiceOpen(C_Invoice_ID,?), invoiceDiscount(C_Invoice_ID,?,?), IsSOTrx FROM C_Invoice WHERE C_Invoice_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, C_InvoicePaySchedule_ID);
                    pstmt.setTimestamp(2, ts);
                    pstmt.setInt(3, C_InvoicePaySchedule_ID);
                    pstmt.setInt(4, C_Invoice_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        C_Currency_Invoice_ID = rs.getInt(2);
                        InvoiceOpenAmt = rs.getBigDecimal(3);
                        if (InvoiceOpenAmt == null) {
                            InvoiceOpenAmt = Env.ZERO;
                        }
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, e);
                    String string = e.getLocalizedMessage();
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    return string;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.log.fine("Open=" + InvoiceOpenAmt + ", C_Invoice_ID=" + C_Invoice_ID + ", C_Currency_ID=" + C_Currency_Invoice_ID);
        BigDecimal PayAmt = (BigDecimal)mTab.getValue("PayAmt");
        BigDecimal DiscountAmt = (BigDecimal)mTab.getValue("DiscountAmt");
        BigDecimal WriteOffAmt = (BigDecimal)mTab.getValue("WriteOffAmt");
        BigDecimal OverUnderAmt = (BigDecimal)mTab.getValue("OverUnderAmt");
        this.log.fine("Pay=" + PayAmt + ", Discount=" + DiscountAmt + ", WriteOff=" + WriteOffAmt + ", OverUnderAmt=" + OverUnderAmt);
        int C_Currency_ID = (Integer)mTab.getValue("C_Currency_ID");
        MCurrency currency = MCurrency.get(ctx, C_Currency_ID);
        Timestamp ConvDate = (Timestamp)mTab.getValue("DateTrx");
        int C_ConversionType_ID = 0;
        Integer ii = (Integer)mTab.getValue("C_ConversionType_ID");
        if (ii != null) {
            C_ConversionType_ID = ii;
        }
        int AD_Client_ID = Env.getContextAsInt(ctx, WindowNo, "AD_Client_ID");
        int AD_Org_ID = Env.getContextAsInt(ctx, WindowNo, "AD_Org_ID");
        BigDecimal CurrencyRate = Env.ONE;
        if (C_Currency_ID > 0 && C_Currency_Invoice_ID > 0 && C_Currency_ID != C_Currency_Invoice_ID || colName.equals("C_Currency_ID") || colName.equals("C_ConversionType_ID")) {
            this.log.fine("InvCurrency=" + C_Currency_Invoice_ID + ", PayCurrency=" + C_Currency_ID + ", Date=" + ConvDate + ", Type=" + C_ConversionType_ID);
            CurrencyRate = MConversionRate.getRate(C_Currency_Invoice_ID, C_Currency_ID, ConvDate, C_ConversionType_ID, AD_Client_ID, AD_Org_ID);
            if (CurrencyRate == null || CurrencyRate.compareTo(Env.ZERO) == 0) {
                if (C_Currency_Invoice_ID == 0) {
                    return "";
                }
                return "NoCurrencyConversion";
            }
            InvoiceOpenAmt = InvoiceOpenAmt.multiply(CurrencyRate).setScale(currency.getStdPrecision(), 4);
            this.log.fine("Rate=" + CurrencyRate + ", InvoiceOpenAmt=" + InvoiceOpenAmt);
        }
        if (colName.equals("C_Currency_ID") || colName.equals("C_ConversionType_ID")) {
            PayAmt = PayAmt.multiply(CurrencyRate).setScale(currency.getStdPrecision(), 4);
            mTab.setValue("PayAmt", (Object)PayAmt);
            DiscountAmt = DiscountAmt.multiply(CurrencyRate).setScale(currency.getStdPrecision(), 4);
            mTab.setValue("DiscountAmt", (Object)DiscountAmt);
            WriteOffAmt = WriteOffAmt.multiply(CurrencyRate).setScale(currency.getStdPrecision(), 4);
            mTab.setValue("WriteOffAmt", (Object)WriteOffAmt);
            OverUnderAmt = OverUnderAmt.multiply(CurrencyRate).setScale(currency.getStdPrecision(), 4);
            mTab.setValue("OverUnderAmt", (Object)OverUnderAmt);
        } else if (C_Invoice_ID == 0) {
            if (Env.ZERO.compareTo(DiscountAmt) != 0) {
                mTab.setValue("DiscountAmt", (Object)Env.ZERO);
            }
            if (Env.ZERO.compareTo(WriteOffAmt) != 0) {
                mTab.setValue("WriteOffAmt", (Object)Env.ZERO);
            }
            if (Env.ZERO.compareTo(OverUnderAmt) != 0) {
                mTab.setValue("OverUnderAmt", (Object)Env.ZERO);
            }
        } else if (colName.equals("PayAmt") && mTab.get_ValueAsString("DocStatus").equals("DR") && "Y".equals(Env.getContext(ctx, WindowNo, "IsOverUnderPayment"))) {
            OverUnderAmt = InvoiceOpenAmt.subtract(PayAmt).subtract(DiscountAmt).subtract(WriteOffAmt);
            mTab.setValue("OverUnderAmt", (Object)OverUnderAmt);
        } else if (colName.equals("PayAmt") && mTab.get_ValueAsString("DocStatus").equals("DR")) {
            WriteOffAmt = InvoiceOpenAmt.subtract(PayAmt).subtract(DiscountAmt).subtract(OverUnderAmt);
            mTab.setValue("IsOverUnderPayment", (Object)"Y");
            mTab.setValue("OverUnderAmt", (Object)WriteOffAmt);
        } else if (colName.equals("IsOverUnderPayment") && mTab.get_ValueAsString("DocStatus").equals("DR")) {
            boolean overUnderPaymentActive = "Y".equals(Env.getContext(ctx, WindowNo, "IsOverUnderPayment"));
            if (overUnderPaymentActive) {
                OverUnderAmt = InvoiceOpenAmt.subtract(PayAmt).subtract(DiscountAmt);
                mTab.setValue("WriteOffAmt", (Object)Env.ZERO);
                mTab.setValue("OverUnderAmt", (Object)OverUnderAmt);
            } else {
                WriteOffAmt = InvoiceOpenAmt.subtract(PayAmt).subtract(DiscountAmt);
                mTab.setValue("WriteOffAmt", (Object)WriteOffAmt);
                mTab.setValue("OverUnderAmt", (Object)Env.ZERO);
            }
        } else if (mTab.get_ValueAsString("DocStatus").equals("DR")) {
            PayAmt = InvoiceOpenAmt.subtract(DiscountAmt).subtract(WriteOffAmt).subtract(OverUnderAmt);
            mTab.setValue("PayAmt", (Object)PayAmt);
        }
        return "";
    }

    public String invoiceNotDiscount(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Timestamp ts;
        Integer C_Invoice_ID = (Integer)value;
        if (this.isCalloutActive() || C_Invoice_ID == null || C_Invoice_ID == 0) {
            return "";
        }
        mTab.setValue("C_Order_ID", null);
        mTab.setValue("C_Charge_ID", null);
        mTab.setValue("IsPrepayment", (Object)Boolean.FALSE);
        mTab.setValue("DiscountAmt", (Object)Env.ZERO);
        mTab.setValue("WriteOffAmt", (Object)Env.ZERO);
        mTab.setValue("IsOverUnderPayment", (Object)Boolean.FALSE);
        mTab.setValue("OverUnderAmt", (Object)Env.ZERO);
        int C_InvoicePaySchedule_ID = 0;
        if (Env.getContextAsInt(ctx, WindowNo, 1113, "C_Invoice_ID") == C_Invoice_ID && Env.getContextAsInt(ctx, WindowNo, 1113, "C_InvoicePaySchedule_ID") != 0) {
            C_InvoicePaySchedule_ID = Env.getContextAsInt(ctx, WindowNo, 1113, "C_InvoicePaySchedule_ID");
        }
        if ((ts = (Timestamp)mTab.getValue("DateTrx")) == null) {
            ts = new Timestamp(System.currentTimeMillis());
        }
        String sql = "SELECT C_BPartner_ID,C_Currency_ID, invoiceOpen(C_Invoice_ID, ?), invoiceDiscount(C_Invoice_ID,?,?), IsSOTrx FROM C_Invoice WHERE C_Invoice_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, C_InvoicePaySchedule_ID);
                pstmt.setTimestamp(2, ts);
                pstmt.setInt(3, C_InvoicePaySchedule_ID);
                pstmt.setInt(4, C_Invoice_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    mTab.setValue("C_BPartner_ID", (Object)new Integer(rs.getInt(1)));
                    int C_Currency_ID = rs.getInt(2);
                    mTab.setValue("C_Currency_ID", (Object)new Integer(C_Currency_ID));
                    BigDecimal InvoiceOpen = rs.getBigDecimal(3);
                    if (InvoiceOpen == null) {
                        InvoiceOpen = Env.ZERO;
                    }
                    BigDecimal DiscountAmt = rs.getBigDecimal(4);
                    if (InvoiceOpen.signum() == 0) {
                        mTab.fireDataStatusEEvent("Factura Pagada", "Este Documento ya a sido pagado en su totalidad", false);
                    }
                    DiscountAmt = Env.ZERO;
                    mTab.setValue("PayAmt", (Object)InvoiceOpen.subtract(DiscountAmt));
                    mTab.setValue("DiscountAmt", (Object)DiscountAmt);
                    Env.setContext(ctx, WindowNo, "C_Invoice_ID", C_Invoice_ID.toString());
                    mTab.setValue("C_Invoice_ID", (Object)C_Invoice_ID);
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
                String string = e.getLocalizedMessage();
                DB.close(rs, pstmt);
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close(rs, pstmt);
        return this.docType(ctx, WindowNo, mTab, mField, value);
    }
}

