/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPricing;
import org.compiere.model.MRole;
import org.compiere.model.MSequence;
import org.compiere.model.MTax;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.model.Tax;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public class CalloutInvoice
extends CalloutEngine {
    public String docType(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_DocType_ID = (Integer)value;
        if (C_DocType_ID == null || C_DocType_ID == 0) {
            return "";
        }
        String sql = "SELECT d.HasCharges,'N',d.IsDocNoControlled,s.CurrentNext, d.DocBaseType, s.StartNewYear, s.DateColumn, s.AD_Sequence_ID FROM C_DocType d, AD_Sequence s WHERE C_DocType_ID=? AND d.DocNoSequence_ID=s.AD_Sequence_ID(+)";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, C_DocType_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    Env.setContext(ctx, WindowNo, "HasCharges", rs.getString(1));
                    if (rs.getString(3).equals("Y")) {
                        if ("Y".equals(rs.getString(6))) {
                            String dateColumn = rs.getString(7);
                            mTab.setValue("DocumentNo", (Object)("<" + MSequence.getPreliminaryNoByYear(mTab, rs.getInt(8), dateColumn, null) + ">"));
                        } else {
                            mTab.setValue("DocumentNo", (Object)("<" + rs.getString(4) + ">"));
                        }
                    }
                    String s = rs.getString(5);
                    Env.setContext(ctx, WindowNo, "DocBaseType", s);
                    if (s.startsWith("AP")) {
                        mTab.setValue("PaymentRule", (Object)"S");
                    } else if (s.endsWith("C")) {
                        mTab.setValue("PaymentRule", (Object)"P");
                    }
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
                String string = e.getLocalizedMessage();
                DB.close(rs, pstmt);
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close(rs, pstmt);
        return "";
    }

    public String bPartner(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_BPartner_ID = (Integer)value;
        if (C_BPartner_ID == null || C_BPartner_ID == 0) {
            return "";
        }
        String sql = "SELECT p.AD_Language,p.C_PaymentTerm_ID, COALESCE(p.M_PriceList_ID,g.M_PriceList_ID) AS M_PriceList_ID, p.PaymentRule,p.POReference, p.SO_Description,p.IsDiscountPrinted, p.SO_CreditLimit, p.SO_CreditLimit-p.SO_CreditUsed AS CreditAvailable, l.C_BPartner_Location_ID,c.AD_User_ID, COALESCE(p.PO_PriceList_ID,g.PO_PriceList_ID) AS PO_PriceList_ID, p.PaymentRulePO,p.PO_PaymentTerm_ID FROM C_BPartner p INNER JOIN C_BP_Group g ON (p.C_BP_Group_ID=g.C_BP_Group_ID) LEFT OUTER JOIN C_BPartner_Location l ON (p.C_BPartner_ID=l.C_BPartner_ID AND l.IsBillTo='Y' AND l.IsActive='Y') LEFT OUTER JOIN AD_User c ON (p.C_BPartner_ID=c.C_BPartner_ID) WHERE p.C_BPartner_ID=? AND p.IsActive='Y'";
        boolean IsSOTrx = Env.getContext(ctx, WindowNo, "IsSOTrx").equals("Y");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, C_BPartner_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    double CreditLimit;
                    String cont;
                    String loc;
                    Integer ii = new Integer(rs.getInt(IsSOTrx ? "M_PriceList_ID" : "PO_PriceList_ID"));
                    if (!rs.wasNull()) {
                        mTab.setValue("M_PriceList_ID", (Object)ii);
                    } else {
                        int i = Env.getContextAsInt(ctx, "#M_PriceList_ID");
                        if (i != 0) {
                            mTab.setValue("M_PriceList_ID", (Object)new Integer(i));
                        }
                    }
                    String s = rs.getString(IsSOTrx ? "PaymentRule" : "PaymentRulePO");
                    if (s != null && s.length() != 0) {
                        if (Env.getContext(ctx, WindowNo, "DocBaseType").endsWith("C")) {
                            s = "P";
                        } else if (IsSOTrx && (s.equals("S") || s.equals("U"))) {
                            s = "P";
                        }
                        mTab.setValue("PaymentRule", (Object)s);
                    }
                    ii = new Integer(rs.getInt(IsSOTrx ? "C_PaymentTerm_ID" : "PO_PaymentTerm_ID"));
                    if (!rs.wasNull()) {
                        mTab.setValue("C_PaymentTerm_ID", (Object)ii);
                    }
                    int locID = rs.getInt("C_BPartner_Location_ID");
                    if (C_BPartner_ID.toString().equals(Env.getContext(ctx, WindowNo, 1113, "C_BPartner_ID")) && (loc = Env.getContext(ctx, WindowNo, 1113, "C_BPartner_Location_ID")).length() > 0) {
                        locID = Integer.parseInt(loc);
                    }
                    if (locID == 0) {
                        mTab.setValue("C_BPartner_Location_ID", null);
                    } else {
                        mTab.setValue("C_BPartner_Location_ID", (Object)new Integer(locID));
                    }
                    int contID = rs.getInt("AD_User_ID");
                    if (C_BPartner_ID.toString().equals(Env.getContext(ctx, WindowNo, 1113, "C_BPartner_ID")) && (cont = Env.getContext(ctx, WindowNo, 1113, "AD_User_ID")).length() > 0) {
                        contID = Integer.parseInt(cont);
                    }
                    if (contID == 0) {
                        mTab.setValue("AD_User_ID", null);
                    } else {
                        mTab.setValue("AD_User_ID", (Object)new Integer(contID));
                    }
                    if (IsSOTrx && (CreditLimit = rs.getDouble("SO_CreditLimit")) != 0.0) {
                        double CreditAvailable = rs.getDouble("CreditAvailable");
                        if (!rs.wasNull() && CreditAvailable < 0.0) {
                            mTab.fireDataStatusEEvent("CreditLimitOver", DisplayType.getNumberFormat(12).format(CreditAvailable), false);
                        }
                    }
                    if ((s = rs.getString("POReference")) != null && s.length() != 0) {
                        mTab.setValue("POReference", (Object)s);
                    } else {
                        mTab.setValue("POReference", null);
                    }
                    s = rs.getString("SO_Description");
                    if (s != null && s.trim().length() != 0) {
                        mTab.setValue("Description", (Object)s);
                    }
                    if ((s = rs.getString("IsDiscountPrinted")) != null && s.length() != 0) {
                        mTab.setValue("IsDiscountPrinted", (Object)s);
                    } else {
                        mTab.setValue("IsDiscountPrinted", (Object)"N");
                    }
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, "bPartner", e);
                String string = e.getLocalizedMessage();
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return "";
    }

    public String paymentTerm(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_PaymentTerm_ID = (Integer)value;
        int C_Invoice_ID = Env.getContextAsInt(ctx, WindowNo, "C_Invoice_ID");
        if (C_PaymentTerm_ID == null || C_PaymentTerm_ID == 0 || C_Invoice_ID == 0) {
            return "";
        }
        MPaymentTerm pt = new MPaymentTerm(ctx, C_PaymentTerm_ID, null);
        if (pt.get_ID() == 0) {
            return "PaymentTerm not found";
        }
        boolean valid = pt.apply(C_Invoice_ID);
        mTab.setValue("IsPayScheduleValid", (Object)(valid ? 1 : 0));
        return "";
    }

    public String product(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String sql;
        Integer M_Product_ID = (Integer)value;
        if (M_Product_ID == null || M_Product_ID == 0) {
            return "";
        }
        mTab.setValue("C_Charge_ID", null);
        if (Env.getContextAsInt(ctx, WindowNo, 1113, "M_Product_ID") == M_Product_ID && Env.getContextAsInt(ctx, WindowNo, 1113, "M_AttributeSetInstance_ID") != 0) {
            mTab.setValue("M_AttributeSetInstance_ID", (Object)Env.getContextAsInt(ctx, WindowNo, 1113, "M_AttributeSetInstance_ID"));
        } else {
            mTab.setValue("M_AttributeSetInstance_ID", null);
        }
        boolean IsSOTrx = Env.getContext(ctx, WindowNo, "IsSOTrx").equals("Y");
        int C_BPartner_ID = Env.getContextAsInt(ctx, WindowNo, WindowNo, "C_BPartner_ID");
        BigDecimal Qty = (BigDecimal)mTab.getValue("QtyInvoiced");
        MProductPricing pp = new MProductPricing(M_Product_ID, C_BPartner_ID, Qty, IsSOTrx);
        int M_PriceList_ID = Env.getContextAsInt(ctx, WindowNo, "M_PriceList_ID");
        pp.setM_PriceList_ID(M_PriceList_ID);
        Timestamp invoiceDate = Env.getContextAsDate(ctx, WindowNo, "DateInvoiced");
        int M_PriceList_Version_ID = Env.getContextAsInt(ctx, WindowNo, "M_PriceList_Version_ID");
        if (M_PriceList_Version_ID == 0 && M_PriceList_ID > 0 && (M_PriceList_Version_ID = DB.getSQLValueEx(null, sql = "SELECT plv.M_PriceList_Version_ID FROM M_PriceList_Version plv WHERE plv.M_PriceList_ID=?  AND plv.ValidFrom <= ? ORDER BY plv.ValidFrom DESC", M_PriceList_ID, invoiceDate)) > 0) {
            Env.setContext(ctx, WindowNo, "M_PriceList_Version_ID", M_PriceList_Version_ID);
        }
        pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
        Timestamp date = Env.getContextAsDate(ctx, WindowNo, "DateInvoiced");
        pp.setPriceDate(date);
        mTab.setValue("PriceList", (Object)pp.getPriceList());
        mTab.setValue("PriceLimit", (Object)pp.getPriceLimit());
        mTab.setValue("PriceActual", (Object)pp.getPriceStd());
        mTab.setValue("PriceEntered", (Object)pp.getPriceStd());
        mTab.setValue("C_Currency_ID", (Object)new Integer(pp.getC_Currency_ID()));
        mTab.setValue("C_UOM_ID", (Object)new Integer(pp.getC_UOM_ID()));
        Env.setContext(ctx, WindowNo, "EnforcePriceLimit", pp.isEnforcePriceLimit() ? "Y" : "N");
        Env.setContext(ctx, WindowNo, "DiscountSchema", pp.isDiscountSchema() ? "Y" : "N");
        return this.tax(ctx, WindowNo, mTab, mField, value);
    }

    public String charge(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer C_Charge_ID = (Integer)value;
        if (C_Charge_ID == null || C_Charge_ID == 0) {
            return "";
        }
        if (mTab.getValue("M_Product_ID") != null) {
            mTab.setValue("C_Charge_ID", null);
            return "ChargeExclusively";
        }
        mTab.setValue("M_AttributeSetInstance_ID", null);
        mTab.setValue("S_ResourceAssignment_ID", null);
        mTab.setValue("C_UOM_ID", (Object)new Integer(100));
        Env.setContext(ctx, WindowNo, "DiscountSchema", "N");
        String sql = "SELECT ChargeAmt FROM C_Charge WHERE C_Charge_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, C_Charge_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    mTab.setValue("PriceEntered", (Object)rs.getBigDecimal(1));
                    mTab.setValue("PriceActual", (Object)rs.getBigDecimal(1));
                    mTab.setValue("PriceLimit", (Object)Env.ZERO);
                    mTab.setValue("PriceList", (Object)Env.ZERO);
                    mTab.setValue("Discount", (Object)Env.ZERO);
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, String.valueOf(sql) + e);
                String string = e.getLocalizedMessage();
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return this.tax(ctx, WindowNo, mTab, mField, value);
    }

    public String tax(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String column = mField.getColumnName();
        if (value == null) {
            return "";
        }
        int M_Product_ID = 0;
        M_Product_ID = column.equals("M_Product_ID") ? (Integer)value : Env.getContextAsInt(ctx, WindowNo, "M_Product_ID");
        int C_Charge_ID = 0;
        C_Charge_ID = column.equals("C_Charge_ID") ? (Integer)value : Env.getContextAsInt(ctx, WindowNo, "C_Charge_ID");
        this.log.fine("Product=" + M_Product_ID + ", C_Charge_ID=" + C_Charge_ID);
        if (M_Product_ID == 0 && C_Charge_ID == 0) {
            return this.amt(ctx, WindowNo, mTab, mField, value);
        }
        int shipC_BPartner_Location_ID = Env.getContextAsInt(ctx, WindowNo, "C_BPartner_Location_ID");
        if (shipC_BPartner_Location_ID == 0) {
            return this.amt(ctx, WindowNo, mTab, mField, value);
        }
        this.log.fine("Ship BP_Location=" + shipC_BPartner_Location_ID);
        int billC_BPartner_Location_ID = shipC_BPartner_Location_ID;
        this.log.fine("Bill BP_Location=" + billC_BPartner_Location_ID);
        Timestamp billDate = Env.getContextAsDate(ctx, WindowNo, "DateInvoiced");
        this.log.fine("Bill Date=" + billDate);
        Timestamp shipDate = billDate;
        this.log.fine("Ship Date=" + shipDate);
        int AD_Org_ID = Env.getContextAsInt(ctx, WindowNo, "AD_Org_ID");
        this.log.fine("Org=" + AD_Org_ID);
        int M_Warehouse_ID = Env.getContextAsInt(ctx, "#M_Warehouse_ID");
        this.log.fine("Warehouse=" + M_Warehouse_ID);
        int C_Tax_ID = Tax.get(ctx, M_Product_ID, C_Charge_ID, billDate, shipDate, AD_Org_ID, M_Warehouse_ID, billC_BPartner_Location_ID, shipC_BPartner_Location_ID, Env.getContext(ctx, WindowNo, "IsSOTrx").equals("Y"));
        this.log.info("Tax ID=" + C_Tax_ID);
        if (C_Tax_ID == 0) {
            mTab.fireDataStatusEEvent(CLogger.retrieveError());
        } else {
            mTab.setValue("C_Tax_ID", (Object)new Integer(C_Tax_ID));
        }
        return this.amt(ctx, WindowNo, mTab, mField, value);
    }

    public String amt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal LineNetAmt;
        boolean enforce;
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int C_UOM_To_ID = Env.getContextAsInt(ctx, WindowNo, "C_UOM_ID");
        int M_Product_ID = Env.getContextAsInt(ctx, WindowNo, "M_Product_ID");
        int M_PriceList_ID = Env.getContextAsInt(ctx, WindowNo, "M_PriceList_ID");
        int StdPrecision = MPriceList.getStandardPrecision(ctx, M_PriceList_ID);
        BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
        BigDecimal QtyInvoiced = (BigDecimal)mTab.getValue("QtyInvoiced");
        this.log.fine("QtyEntered=" + QtyEntered + ", Invoiced=" + QtyInvoiced + ", UOM=" + C_UOM_To_ID);
        BigDecimal PriceEntered = (BigDecimal)mTab.getValue("PriceEntered");
        BigDecimal PriceActual = (BigDecimal)mTab.getValue("PriceActual");
        BigDecimal PriceLimit = (BigDecimal)mTab.getValue("PriceLimit");
        BigDecimal PriceList = (BigDecimal)mTab.getValue("PriceList");
        this.log.fine("PriceList=" + PriceList + ", Limit=" + PriceLimit + ", Precision=" + StdPrecision);
        this.log.fine("PriceEntered=" + PriceEntered + ", Actual=" + PriceActual);
        if (M_Product_ID == 0) {
            if (mField.getColumnName().equals("PriceActual")) {
                mTab.setValue("PriceEntered", value);
            } else if (mField.getColumnName().equals("PriceEntered")) {
                mTab.setValue("PriceActual", value);
            }
        } else if ((mField.getColumnName().equals("QtyInvoiced") || mField.getColumnName().equals("QtyEntered") || mField.getColumnName().equals("M_Product_ID")) && !"N".equals(Env.getContext(ctx, WindowNo, "DiscountSchema"))) {
            int C_BPartner_ID = Env.getContextAsInt(ctx, WindowNo, "C_BPartner_ID");
            if (mField.getColumnName().equals("QtyEntered")) {
                QtyInvoiced = MUOMConversion.convertProductTo(ctx, M_Product_ID, C_UOM_To_ID, QtyEntered);
            }
            if (QtyInvoiced == null) {
                QtyInvoiced = QtyEntered;
            }
            boolean IsSOTrx = Env.getContext(ctx, WindowNo, "IsSOTrx").equals("Y");
            MProductPricing pp = new MProductPricing(M_Product_ID, C_BPartner_ID, QtyInvoiced, IsSOTrx);
            pp.setM_PriceList_ID(M_PriceList_ID);
            int M_PriceList_Version_ID = Env.getContextAsInt(ctx, WindowNo, "M_PriceList_Version_ID");
            pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
            Timestamp date = (Timestamp)mTab.getValue("DateInvoiced");
            pp.setPriceDate(date);
            PriceEntered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, pp.getPriceStd());
            if (PriceEntered == null) {
                PriceEntered = pp.getPriceStd();
            }
            this.log.fine("amt - QtyChanged -> PriceActual=" + pp.getPriceStd() + ", PriceEntered=" + PriceEntered + ", Discount=" + pp.getDiscount());
            mTab.setValue("PriceActual", (Object)pp.getPriceStd());
            mTab.setValue("PriceEntered", (Object)PriceEntered);
            Env.setContext(ctx, WindowNo, "DiscountSchema", pp.isDiscountSchema() ? "Y" : "N");
        } else if (mField.getColumnName().equals("PriceActual")) {
            PriceActual = (BigDecimal)value;
            PriceEntered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, PriceActual);
            if (PriceEntered == null) {
                PriceEntered = PriceActual;
            }
            this.log.fine("amt - PriceActual=" + PriceActual + " -> PriceEntered=" + PriceEntered);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
        } else if (mField.getColumnName().equals("PriceEntered")) {
            PriceEntered = (BigDecimal)value;
            PriceActual = MUOMConversion.convertProductTo(ctx, M_Product_ID, C_UOM_To_ID, PriceEntered);
            if (PriceActual == null) {
                PriceActual = PriceEntered;
            }
            this.log.fine("amt - PriceEntered=" + PriceEntered + " -> PriceActual=" + PriceActual);
            mTab.setValue("PriceActual", (Object)PriceActual);
        }
        String epl = Env.getContext(ctx, WindowNo, "EnforcePriceLimit");
        boolean bl = enforce = Env.isSOTrx(ctx, WindowNo) && epl != null && epl.equals("Y");
        if (enforce && MRole.getDefault().isOverwritePriceLimit()) {
            enforce = false;
        }
        if (enforce && PriceLimit.doubleValue() != 0.0 && PriceActual.compareTo(PriceLimit) < 0) {
            BigDecimal Discount;
            PriceActual = PriceLimit;
            PriceEntered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, PriceLimit);
            if (PriceEntered == null) {
                PriceEntered = PriceLimit;
            }
            this.log.fine("amt =(under) PriceEntered=" + PriceEntered + ", Actual" + PriceLimit);
            mTab.setValue("PriceActual", (Object)PriceLimit);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
            mTab.fireDataStatusEEvent("UnderLimitPrice", "", false);
            if (PriceList.intValue() != 0 && (Discount = new BigDecimal((PriceList.doubleValue() - PriceActual.doubleValue()) / PriceList.doubleValue() * 100.0)).scale() > 2) {
                Discount = Discount.setScale(2, 4);
            }
        }
        if ((LineNetAmt = QtyInvoiced.multiply(PriceActual)).scale() > StdPrecision) {
            LineNetAmt = LineNetAmt.setScale(StdPrecision, 4);
        }
        this.log.info("amt = LineNetAmt=" + LineNetAmt);
        mTab.setValue("LineNetAmt", (Object)LineNetAmt);
        boolean IsSOTrx = "Y".equals(Env.getContext(Env.getCtx(), WindowNo, "IsSOTrx"));
        if (!IsSOTrx) {
            BigDecimal TaxAmt = Env.ZERO;
            if (mField.getColumnName().equals("TaxAmt")) {
                TaxAmt = (BigDecimal)mTab.getValue("TaxAmt");
            } else {
                Integer taxID = (Integer)mTab.getValue("C_Tax_ID");
                if (taxID != null) {
                    int C_Tax_ID = taxID;
                    MTax tax = new MTax(ctx, C_Tax_ID, null);
                    TaxAmt = tax.calculateTax(LineNetAmt, this.isTaxIncluded(WindowNo), StdPrecision);
                    mTab.setValue("TaxAmt", (Object)TaxAmt);
                }
            }
            mTab.setValue("LineTotalAmt", (Object)LineNetAmt.add(TaxAmt));
        }
        return "";
    }

    private boolean isTaxIncluded(int WindowNo) {
        String ss = Env.getContext(Env.getCtx(), WindowNo, "IsTaxIncluded");
        if (ss.length() == 0) {
            int M_PriceList_ID = Env.getContextAsInt(Env.getCtx(), WindowNo, "M_PriceList_ID");
            if (M_PriceList_ID == 0) {
                return false;
            }
            ss = DB.getSQLValueString(null, "SELECT IsTaxIncluded FROM M_PriceList WHERE M_PriceList_ID=?", M_PriceList_ID);
            if (ss == null) {
                ss = "N";
            }
            Env.setContext(Env.getCtx(), WindowNo, "IsTaxIncluded", ss);
        }
        return "Y".equals(ss);
    }

    public String qty(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        int M_Product_ID = Env.getContextAsInt(ctx, WindowNo, "M_Product_ID");
        if (M_Product_ID == 0) {
            BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            mTab.setValue("QtyInvoiced", (Object)QtyEntered);
        } else if (mField.getColumnName().equals("C_UOM_ID")) {
            BigDecimal QtyInvoiced;
            BigDecimal QtyEntered1;
            int C_UOM_To_ID = (Integer)value;
            BigDecimal QtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            if (QtyEntered.compareTo(QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision(ctx, C_UOM_To_ID), 4)) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((QtyInvoiced = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, QtyEntered)) == null) {
                QtyInvoiced = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(QtyInvoiced) != 0;
            BigDecimal PriceActual = (BigDecimal)mTab.getValue("PriceActual");
            BigDecimal PriceEntered = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, PriceActual);
            if (PriceEntered == null) {
                PriceEntered = PriceActual;
            }
            this.log.fine("qty - UOM=" + C_UOM_To_ID + ", QtyEntered/PriceActual=" + QtyEntered + "/" + PriceActual + " -> " + conversion + " QtyInvoiced/PriceEntered=" + QtyInvoiced + "/" + PriceEntered);
            Env.setContext(ctx, WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("QtyInvoiced", (Object)QtyInvoiced);
            mTab.setValue("PriceEntered", (Object)PriceEntered);
        } else if (mField.getColumnName().equals("QtyEntered")) {
            BigDecimal QtyInvoiced;
            BigDecimal QtyEntered = (BigDecimal)value;
            int C_UOM_To_ID = Env.getContextAsInt(ctx, WindowNo, "C_UOM_ID");
            BigDecimal QtyEntered1 = QtyEntered.setScale(MUOM.getPrecision(ctx, C_UOM_To_ID), 4);
            if (QtyEntered.compareTo(QtyEntered1) != 0) {
                this.log.fine("Corrected QtyEntered Scale UOM=" + C_UOM_To_ID + "; QtyEntered=" + QtyEntered + "->" + QtyEntered1);
                QtyEntered = QtyEntered1;
                mTab.setValue("QtyEntered", (Object)QtyEntered);
            }
            if ((QtyInvoiced = MUOMConversion.convertProductFrom(ctx, M_Product_ID, C_UOM_To_ID, QtyEntered)) == null) {
                QtyInvoiced = QtyEntered;
            }
            boolean conversion = QtyEntered.compareTo(QtyInvoiced) != 0;
            this.log.fine("qty - UOM=" + C_UOM_To_ID + ", QtyEntered=" + QtyEntered + " -> " + conversion + " QtyInvoiced=" + QtyInvoiced);
            Env.setContext(ctx, WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("QtyInvoiced", (Object)QtyInvoiced);
        } else if (mField.getColumnName().equals("QtyInvoiced")) {
            BigDecimal QtyEntered;
            int C_UOM_To_ID = Env.getContextAsInt(ctx, WindowNo, "C_UOM_ID");
            BigDecimal QtyInvoiced = (BigDecimal)value;
            int precision = MProduct.get(ctx, M_Product_ID).getUOMPrecision();
            BigDecimal QtyInvoiced1 = QtyInvoiced.setScale(precision, 4);
            if (QtyInvoiced.compareTo(QtyInvoiced1) != 0) {
                this.log.fine("Corrected QtyInvoiced Scale " + QtyInvoiced + "->" + QtyInvoiced1);
                QtyInvoiced = QtyInvoiced1;
                mTab.setValue("QtyInvoiced", (Object)QtyInvoiced);
            }
            if ((QtyEntered = MUOMConversion.convertProductTo(ctx, M_Product_ID, C_UOM_To_ID, QtyInvoiced)) == null) {
                QtyEntered = QtyInvoiced;
            }
            boolean conversion = QtyInvoiced.compareTo(QtyEntered) != 0;
            this.log.fine("qty - UOM=" + C_UOM_To_ID + ", QtyInvoiced=" + QtyInvoiced + " -> " + conversion + " QtyEntered=" + QtyEntered);
            Env.setContext(ctx, WindowNo, "UOMConversion", conversion ? "Y" : "N");
            mTab.setValue("QtyEntered", (Object)QtyEntered);
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String pricelistReprice(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        int retValue;
        Timestamp priceDate;
        block19: {
            if (this.isCalloutActive() || value == null) {
                return "";
            }
            Integer pricelist_ID = (Integer)value;
            priceDate = null;
            priceDate = Env.getContextAsDate(Env.getCtx(), WindowNo, "DateInvoiced");
            if (priceDate == null) {
                return "";
            }
            retValue = 0;
            boolean M_PriceList_Version_ID = false;
            String sql = "SELECT plv.M_PriceList_Version_ID, plv.ValidFrom FROM M_PriceList pl, M_PriceList_Version plv WHERE pl.M_PriceList_ID=plv.M_PriceList_ID AND plv.IsActive='Y' and plv.Reprice='Y' AND pl.M_PriceList_ID=? ORDER BY plv.ValidFrom DESC";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, pricelist_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next() && retValue == 0) {
                        Timestamp plDate = rs.getTimestamp(2);
                        if (priceDate.before(plDate)) continue;
                        retValue = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block19;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue == 0) {
            this.log.info("No pricelistversion Reprice");
            return "";
        }
        int Invoice_ID = Env.getContextAsInt(ctx, WindowNo, "C_Invoice_ID");
        int CurrentCurrency_ID = DB.getSQLValue("C_Invoice", "SELECT C_CURRENCY_ID FROM C_INVOICE WHERE C_INVOICE_ID=" + Invoice_ID);
        if (CurrentCurrency_ID == 228) {
            return "";
        }
        int CurTo_ID = (Integer)mTab.getValue("C_Currency_ID");
        MCurrency curreTo = new MCurrency(ctx, CurTo_ID, null);
        BigDecimal MultiplyRate = (BigDecimal)mTab.getValue("MultiplyRate");
        if (MultiplyRate == null || MultiplyRate.signum() == 0) {
            MultiplyRate = MConversionRate.getRate(CurrentCurrency_ID, CurTo_ID, priceDate, (Integer)mTab.getValue("C_ConversionType_ID"), Env.getContextAsInt(ctx, WindowNo, "AD_Client_ID"), Env.getContextAsInt(ctx, WindowNo, "AD_Org_ID"));
        }
        this.log.config("currency=100 - To_Currency=" + CurTo_ID + "- Date=" + priceDate + "-Conversion=" + (Integer)mTab.getValue("C_ConversionType_ID"));
        if (MultiplyRate == null) {
            mTab.fireDataStatusEEvent("Conversion Monetaria", "por favor definir el tipo de cambio", false);
            return "";
        }
        if (MultiplyRate.compareTo(Env.ZERO) <= 0) {
            mTab.fireDataStatusEEvent("Conversion Monetaria", "por favor definir el tipo de cambio", false);
            return "";
        }
        String sql2 = "SELECT invl.C_InvoiceLine_ID  FROM C_InvoiceLine invl  WHERE invl.C_Invoice_ID=" + Invoice_ID;
        this.log.config("C_Invoice_ID:" + Invoice_ID + "-MultiplyRate:" + MultiplyRate);
        mTab.setValue("MultiplyRate", (Object)MultiplyRate);
        if (mTab.getValue("ForeignPrice") == null || ((BigDecimal)mTab.getValue("ForeignPrice")).signum() == 0) {
            mTab.setValue("ForeignPrice", mTab.getValue("GrandTotal"));
        }
        CPreparedStatement pstmt2 = null;
        try {
            pstmt2 = DB.prepareStatement(sql2, null);
            ResultSet rs2 = pstmt2.executeQuery();
            while (true) {
                if (!rs2.next()) {
                    return "";
                }
                MInvoiceLine line = new MInvoiceLine(Env.getCtx(), rs2.getInt(1), null);
                if (line.get_Value("ForeignPrice") != null && ((BigDecimal)line.get_Value("ForeignPrice")).intValue() > 0) {
                    rs2 = null;
                    pstmt2 = null;
                    mTab.fireDataStatusEEvent("Conversion Monetaria", "la conversion monetaria ya fue ejecutada con anterioridad para esta factura", false);
                    return "";
                }
                line.set_Value("ForeignPrice", (Object)line.getPriceEntered());
                this.log.config("setForeignPrice:" + line.getPriceActual().setScale(curreTo.getStdPrecision(), 6));
                line.setPriceList(line.getPriceList().multiply(MultiplyRate).setScale(curreTo.getStdPrecision(), 6));
                this.log.config("setPriceList:" + line.getPriceList().multiply(MultiplyRate));
                line.setPriceActual(line.getPriceActual().multiply(MultiplyRate).setScale(curreTo.getStdPrecision(), 6));
                line.setPriceEntered(line.getPriceEntered().multiply(MultiplyRate).setScale(curreTo.getStdPrecision(), 6));
                line.setTaxAmt(line.getTaxAmt().multiply(MultiplyRate).setScale(curreTo.getStdPrecision(), 6));
                line.save();
            }
        }
        catch (SQLException e2) {
            this.log.log(Level.SEVERE, sql2, e2);
        }
        return "";
    }

    public String compromiseType(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        String sql = "SELECT name from AD_Ref_List where AD_Reference_ID=1000047 and Value=?";
        String name = DB.getSQLValueString(null, sql, (String)value);
        mTab.setValue("Description", (Object)name);
        return "";
    }
}

