/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.impexp;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.impexp.ImpFormatRow;
import org.compiere.model.X_I_GLJournal;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public final class ImpFormat {
    private static CLogger log = CLogger.getCLogger(ImpFormat.class);
    private String m_name;
    private String m_formatType;
    private int m_AD_Table_ID;
    private String m_tableName;
    private String m_tablePK;
    private String m_tableUnique1;
    private String m_tableUnique2;
    private String m_tableUniqueParent;
    private String m_tableUniqueChild;
    private String m_BPartner;
    private ArrayList<ImpFormatRow> m_rows = new ArrayList();
    private String separatorChar;
    private String emision;
    private String folio;
    private String saldo;
    private String ccorriente;

    public ImpFormat(String name, int AD_Table_ID, String formatType) {
        this.setName(name);
        this.setTable(AD_Table_ID);
        this.setFormatType(formatType);
    }

    public void setName(String newName) {
        if (newName == null || newName.length() == 0) {
            throw new IllegalArgumentException("Name must be at least 1 char");
        }
        this.m_name = newName;
    }

    public String getName() {
        return this.m_name;
    }

    public void setSeparatorChar(String newChar) {
        if (newChar == null || newChar.length() == 0) {
            throw new IllegalArgumentException("Separator Character must be 1 char");
        }
        this.separatorChar = newChar;
    }

    public String getSeparatorChar() {
        return this.separatorChar;
    }

    public void setTable(int AD_Table_ID) {
        this.m_AD_Table_ID = AD_Table_ID;
        this.m_tableName = null;
        this.m_tablePK = null;
        String sql = "SELECT t.TableName,c.ColumnName FROM AD_Table t INNER JOIN AD_Column c ON (t.AD_Table_ID=c.AD_Table_ID AND c.IsKey='Y') WHERE t.AD_Table_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Table_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                this.m_tableName = rs.getString(1);
                this.m_tablePK = rs.getString(2);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "ImpFormat.setTable", e);
        }
        if (this.m_tableName == null || this.m_tablePK == null) {
            log.log(Level.SEVERE, "Data not found for AD_Table_ID=" + AD_Table_ID);
        }
        this.m_tableUnique1 = "";
        this.m_tableUnique2 = "";
        this.m_tableUniqueParent = "";
        this.m_tableUniqueChild = "";
        if (this.m_AD_Table_ID == 311) {
            this.m_tableUnique1 = "H_UPC";
            this.m_tableUnique2 = "Value";
            this.m_tableUniqueChild = "H_Commodity1";
            this.m_tableUniqueParent = "H_PartnrID";
        } else if (this.m_AD_Table_ID == 532) {
            this.m_tableUnique1 = "UPC";
            this.m_tableUnique2 = "Value";
            this.m_tableUniqueChild = "VendorProductNo";
            this.m_tableUniqueParent = "BPartner_Value";
        } else if (this.m_AD_Table_ID != 533) {
            if (this.m_AD_Table_ID == 534) {
                this.m_tableUniqueParent = "ElementName";
                this.m_tableUniqueChild = "Value";
            } else if (this.m_AD_Table_ID == 535) {
                this.m_tableUniqueParent = "ReportLineSetName";
                this.m_tableUniqueChild = "Name";
            }
        }
    }

    public int getAD_Table_ID() {
        return this.m_AD_Table_ID;
    }

    public void setFormatType(String newFormatType) {
        if (!(newFormatType.equals("F") || newFormatType.equals("C") || newFormatType.equals("T") || newFormatType.equals("X") || newFormatType.equals("U"))) {
            throw new IllegalArgumentException("FormatType must be F/C/T/X/U");
        }
        this.m_formatType = newFormatType;
    }

    public String getFormatType() {
        return this.m_formatType;
    }

    public void setBPartner(String newBPartner) {
        this.m_BPartner = newBPartner;
    }

    public String getBPartner() {
        return this.m_BPartner;
    }

    public void addRow(ImpFormatRow row) {
        this.m_rows.add(row);
    }

    public ImpFormatRow getRow(int index) {
        if (index >= 0 && index < this.m_rows.size()) {
            return this.m_rows.get(index);
        }
        return null;
    }

    public int getRowCount() {
        return this.m_rows.size();
    }

    public static ImpFormat load(String name) {
        log.config(name);
        ImpFormat retValue = null;
        String sql = "SELECT * FROM AD_ImpFormat WHERE Name=?";
        int ID = 0;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, name);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new ImpFormat(name, rs.getInt("AD_Table_ID"), rs.getString("FormatType"));
                ID = rs.getInt("AD_ImpFormat_ID");
                retValue.setSeparatorChar(rs.getString("SeparatorChar"));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
            return null;
        }
        ImpFormat.loadRows(retValue, ID);
        return retValue;
    }

    private static void loadRows(ImpFormat format, int ID) {
        String sql = "SELECT f.SeqNo,c.ColumnName,f.StartNo,f.EndNo,f.DataType,c.FieldLength,f.DataFormat,f.DecimalPoint,f.DivideBy100,f.ConstantValue,f.Callout FROM AD_ImpFormat_Row f,AD_Column c WHERE f.AD_ImpFormat_ID=? AND f.AD_Column_ID=c.AD_Column_ID AND f.IsActive='Y'ORDER BY f.SeqNo";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                ImpFormatRow row = new ImpFormatRow(rs.getInt(1), rs.getString(2), rs.getInt(3), rs.getInt(4), rs.getString(5), rs.getInt(6));
                row.setFormatInfo(rs.getString(7), rs.getString(8), rs.getString(9).equals("Y"), rs.getString(10), rs.getString(11));
                format.addRow(row);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
    }

    public String[] parseLine(String line, boolean withLabel, boolean trace, boolean ignoreEmpty) {
        if (trace) {
            log.config(line);
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < this.m_rows.size()) {
            ImpFormatRow row = this.m_rows.get(i);
            StringBuffer entry = new StringBuffer();
            if (withLabel) {
                entry.append(row.getColumnName());
                entry.append("=");
                if (row.isString()) {
                    entry.append("'");
                } else if (row.isDate()) {
                    entry.append("TO_DATE('");
                }
            }
            String info = null;
            if (row.isConstant()) {
                info = "Constant";
            } else if (this.m_formatType.equals("F")) {
                if (row.getStartNo() > 0 && row.getEndNo() <= line.length()) {
                    info = line.substring(row.getStartNo() - 1, row.getEndNo());
                }
            } else {
                info = this.parseFlexFormat(line, this.m_formatType, row.getStartNo());
            }
            if (info == null) {
                info = "";
            }
            entry.append(row.parse(info));
            if (withLabel) {
                if (row.isString()) {
                    entry.append("'");
                } else if (row.isDate()) {
                    entry.append("','YYYY-MM-DD HH24:MI:SS')");
                }
            }
            if (!ignoreEmpty || ignoreEmpty && info.length() != 0) {
                list.add(entry.toString());
            }
            if (trace) {
                log.fine(String.valueOf(info) + "=>" + entry.toString() + " (Length=" + info.length() + ")");
            }
            ++i;
        }
        String[] retValue = new String[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    /*
     * Unable to fully structure code
     */
    private String parseFlexFormat(String line, String formatType, int fieldNo) {
        QUOTE = 34;
        delimiter = ' ';
        if (formatType.equals("C")) {
            delimiter = ',';
        } else if (formatType.equals("T")) {
            delimiter = '\t';
        } else if (formatType.equals("U")) {
            delimiter = this.getSeparatorChar().charAt(0);
        } else {
            throw new IllegalArgumentException("ImpFormat.parseFlexFormat - unknown format: " + formatType);
        }
        if (line == null || line.length() == 0 || fieldNo < 0) {
            return "";
        }
        pos = 0;
        length = line.length();
        field = 1;
        while (field <= fieldNo && pos < length) {
            block15: {
                block16: {
                    block14: {
                        content = new StringBuffer();
                        if (line.charAt(pos) != delimiter) break block14;
                        ++pos;
                        break block15;
                    }
                    if (line.charAt(pos) != '\"') ** GOTO lbl44
                    ++pos;
                    while (pos < length) {
                        if (line.charAt(pos) == '\"' && pos + 1 < length && line.charAt(pos + 1) == '\"') {
                            content.append(line.charAt(pos++));
                            ++pos;
                            continue;
                        }
                        if (line.charAt(pos) == '\"') {
                            ++pos;
                            break;
                        }
                        content.append(line.charAt(pos++));
                    }
                    if (pos < length && line.charAt(pos) != delimiter) {
                        ImpFormat.log.info("Did not find delimiter at pos " + pos + " " + line);
                    }
                    ++pos;
                    break block16;
lbl-1000:
                    // 1 sources

                    {
                        content.append(line.charAt(pos++));
lbl44:
                        // 2 sources

                        ** while (pos < length && line.charAt((int)pos) != delimiter)
                    }
lbl45:
                    // 1 sources

                    ++pos;
                }
                if (field == fieldNo) {
                    return content.toString();
                }
            }
            ++field;
        }
        return "";
    }

    public boolean updateDB(Properties ctx, String line, String trxName) {
        if (line == null || line.trim().length() == 0) {
            log.finest("No Line");
            return false;
        }
        String[] nodes = this.parseLine(line, true, false, true);
        if (nodes.length == 0) {
            log.finest("Nothing parsed from: " + line);
            return false;
        }
        int AD_Client_ID = Env.getAD_Client_ID(ctx);
        int AD_Org_ID = Env.getAD_Org_ID(ctx);
        if (this.getAD_Table_ID() == X_I_GLJournal.Table_ID) {
            AD_Org_ID = 0;
        }
        int UpdatedBy = Env.getAD_User_ID(ctx);
        StringBuffer sql = new StringBuffer("SELECT COUNT(*), MAX(").append(this.m_tablePK).append(") FROM ").append(this.m_tableName).append(" WHERE AD_Client_ID=").append(AD_Client_ID).append(" AND (");
        String where1 = null;
        String where2 = null;
        String whereParentChild = null;
        int i = 0;
        while (i < nodes.length) {
            if (!nodes[i].endsWith("=''") && !nodes[i].endsWith("=0")) {
                if (nodes[i].startsWith(String.valueOf(this.m_tableUnique1) + "=")) {
                    where1 = nodes[i];
                } else if (nodes[i].startsWith(String.valueOf(this.m_tableUnique2) + "=")) {
                    where2 = nodes[i];
                } else if (nodes[i].startsWith(String.valueOf(this.m_tableUniqueParent) + "=") || nodes[i].startsWith(String.valueOf(this.m_tableUniqueChild) + "=")) {
                    whereParentChild = whereParentChild == null ? nodes[i] : String.valueOf(whereParentChild) + " AND " + nodes[i];
                }
            }
            ++i;
        }
        StringBuffer find = new StringBuffer();
        if (where1 != null) {
            find.append(where1);
        }
        if (where2 != null) {
            if (find.length() > 0) {
                find.append(" OR ");
            }
            find.append(where2);
        }
        if (whereParentChild != null && whereParentChild.indexOf(" AND ") != -1) {
            if (find.length() > 0) {
                find.append(" OR (").append(whereParentChild).append(")");
            } else {
                find.append(whereParentChild);
            }
        }
        sql.append(find).append(")");
        int count = 0;
        int ID = 0;
        try {
            if (find.length() > 0) {
                CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), trxName);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next() && (count = rs.getInt(1)) == 1) {
                    ID = rs.getInt(2);
                }
                rs.close();
                pstmt.close();
            }
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
            return false;
        }
        if (ID == 0) {
            ID = DB.getNextID(ctx, this.m_tableName, null);
            sql = new StringBuffer("INSERT INTO ").append(this.m_tableName).append("(").append(this.m_tablePK).append(",").append("AD_Client_ID,AD_Org_ID,Created,CreatedBy,Updated,UpdatedBy,IsActive").append(") VALUES (").append(ID).append(",").append(AD_Client_ID).append(",").append(AD_Org_ID).append(",SysDate,").append(UpdatedBy).append(",SysDate,").append(UpdatedBy).append(",'Y'").append(")");
            int no = DB.executeUpdate(sql.toString(), trxName);
            if (no != 1) {
                log.log(Level.SEVERE, "Insert records=" + no + "; SQL=" + sql.toString());
                return false;
            }
            log.finer("New ID=" + ID + " " + find);
        } else {
            log.finer("Old ID=" + ID + " " + find);
        }
        sql = new StringBuffer("UPDATE ").append(this.m_tableName).append(" SET ");
        int i2 = 0;
        while (i2 < nodes.length) {
            sql.append(nodes[i2]).append(",");
            ++i2;
        }
        sql.append("IsActive='Y',Processed='N',I_IsImported='N',Updated=SysDate,UpdatedBy=").append(UpdatedBy);
        sql.append(" WHERE ").append(this.m_tablePK).append("=").append(ID);
        int no = DB.executeUpdate(sql.toString(), trxName);
        if (no != 1) {
            log.log(Level.SEVERE, String.valueOf(this.m_tablePK) + "=" + ID + " - rows updated=" + no);
            return false;
        }
        return true;
    }

    public boolean updateDB(Properties ctx, String line, String trxName, int row) {
        if (line == null || line.trim().length() == 0) {
            log.finest("No Line");
            return false;
        }
        String[] nodes = this.parseLine(line, true, false, true, row);
        if (nodes.length == 0) {
            log.finest("Nothing parsed from: " + line);
            return false;
        }
        int AD_Client_ID = Env.getAD_Client_ID(ctx);
        int AD_Org_ID = Env.getAD_Org_ID(ctx);
        if (this.getAD_Table_ID() == X_I_GLJournal.Table_ID) {
            AD_Org_ID = 0;
        }
        int UpdatedBy = Env.getAD_User_ID(ctx);
        StringBuffer sql = new StringBuffer("SELECT COUNT(*), MAX(").append(this.m_tablePK).append(") FROM ").append(this.m_tableName).append(" WHERE AD_Client_ID=").append(AD_Client_ID).append(" AND (");
        String where1 = null;
        String where2 = null;
        String whereParentChild = null;
        int i = 0;
        while (i < nodes.length) {
            if (!nodes[i].endsWith("=''") && !nodes[i].endsWith("=0")) {
                if (nodes[i].startsWith(String.valueOf(this.m_tableUnique1) + "=")) {
                    where1 = nodes[i];
                } else if (nodes[i].startsWith(String.valueOf(this.m_tableUnique2) + "=")) {
                    where2 = nodes[i];
                } else if (nodes[i].startsWith(String.valueOf(this.m_tableUniqueParent) + "=") || nodes[i].startsWith(String.valueOf(this.m_tableUniqueChild) + "=")) {
                    whereParentChild = whereParentChild == null ? nodes[i] : String.valueOf(whereParentChild) + " AND " + nodes[i];
                }
            }
            ++i;
        }
        StringBuffer find = new StringBuffer();
        if (where1 != null) {
            find.append(where1);
        }
        if (where2 != null) {
            if (find.length() > 0) {
                find.append(" OR ");
            }
            find.append(where2);
        }
        if (whereParentChild != null && whereParentChild.indexOf(" AND ") != -1) {
            if (find.length() > 0) {
                find.append(" OR (").append(whereParentChild).append(")");
            } else {
                find.append(whereParentChild);
            }
        }
        sql.append(find).append(")");
        int count = 0;
        int ID = 0;
        try {
            if (find.length() > 0) {
                CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), trxName);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next() && (count = rs.getInt(1)) == 1) {
                    ID = rs.getInt(2);
                }
                rs.close();
                pstmt.close();
            }
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
            return false;
        }
        if (ID == 0) {
            ID = DB.getNextID(ctx, this.m_tableName, null);
            sql = new StringBuffer("INSERT INTO ").append(this.m_tableName).append("(").append(this.m_tablePK).append(",").append("AD_Client_ID,AD_Org_ID,Created,CreatedBy,Updated,UpdatedBy,IsActive").append(") VALUES (").append(ID).append(",").append(AD_Client_ID).append(",").append(AD_Org_ID).append(",SysDate,").append(UpdatedBy).append(",SysDate,").append(UpdatedBy).append(",'Y'").append(")");
            int no = DB.executeUpdate(sql.toString(), trxName);
            if (no != 1) {
                log.log(Level.SEVERE, "Insert records=" + no + "; SQL=" + sql.toString());
                return false;
            }
            log.finer("New ID=" + ID + " " + find);
        } else {
            log.finer("Old ID=" + ID + " " + find);
        }
        sql = new StringBuffer("UPDATE ").append(this.m_tableName).append(" SET ");
        int i2 = 0;
        while (i2 < nodes.length) {
            sql.append(nodes[i2]).append(",");
            ++i2;
        }
        sql.append("IsActive='Y',Processed='N',I_IsImported='N',Updated=SysDate,UpdatedBy=").append(UpdatedBy);
        sql.append(" WHERE ").append(this.m_tablePK).append("=").append(ID);
        int no = DB.executeUpdate(sql.toString(), trxName);
        if (no != 1) {
            log.log(Level.SEVERE, String.valueOf(this.m_tablePK) + "=" + ID + " - rows updated=" + no);
            return false;
        }
        return true;
    }

    public String[] parseLine(String line, boolean withLabel, boolean trace, boolean ignoreEmpty, int fila) {
        if (trace) {
            log.config(line);
        }
        ArrayList<String> list = new ArrayList<String>();
        if (this.m_name.toUpperCase().indexOf("SANTIAGO") > -1 && fila == 0) {
            this.emision = line.substring(161, 170);
            this.folio = line.substring(81, 85);
            this.saldo = line.substring(145, 160);
            this.ccorriente = line.substring(69, 81);
        } else if (this.m_name.toUpperCase().indexOf("CHILE") > -1 && fila == 2) {
            this.saldo = line.substring(36, 48);
        } else if (this.m_name.toUpperCase().indexOf("BCI") > -1 && fila == 0) {
            this.emision = line.substring(13, 22);
            this.folio = line.substring(21, 26);
            this.saldo = line.substring(74, 87);
        }
        int i = 0;
        while (i < this.m_rows.size()) {
            ImpFormatRow row = this.m_rows.get(i);
            StringBuffer entry = new StringBuffer();
            if (withLabel) {
                entry.append(row.getColumnName());
                entry.append("=");
                if (row.isString()) {
                    entry.append("'");
                } else if (row.isDate()) {
                    entry.append("TO_DATE('");
                }
            }
            String info = null;
            if (row.isConstant()) {
                info = "Constant";
            } else if (this.m_formatType.equals("F")) {
                if (row.getStartNo() > 0 && row.getEndNo() <= line.length()) {
                    info = line.substring(row.getStartNo() - 1, row.getEndNo());
                }
            } else {
                info = this.parseFlexFormat(line, this.m_formatType, row.getStartNo());
            }
            if (info == null) {
                info = "";
            }
            entry.append(row.parse(info));
            if (withLabel) {
                if (row.isString()) {
                    entry.append("'");
                } else if (row.isDate()) {
                    entry.append("','YYYY-MM-DD HH24:MI:SS')");
                }
            }
            if (!ignoreEmpty || ignoreEmpty && info.length() != 0) {
                list.add(entry.toString());
            }
            if (trace) {
                log.fine(String.valueOf(info) + "=>" + entry.toString() + " (Length=" + info.length() + ")");
            }
            ++i;
        }
        if (this.saldo != null && this.saldo.length() > 0) {
            list.add("SaldoInicial = " + this.parseNumber(this.saldo));
        }
        if (this.folio != null && this.folio.length() > 0) {
            list.add("Folio = " + this.parseNumber(this.folio));
        }
        if (this.emision != null && this.emision.length() > 0) {
            list.add("documentdate = TO_DATE('" + this.parseDate(this.emision) + "','YYYY-MM-DD HH24:MI:SS')");
        }
        if (this.ccorriente != null && this.ccorriente.length() > 0) {
            list.add("bankaccountno = '" + this.ccorriente + "'");
        }
        String[] retValue = new String[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    private String parseDate(String info) {
        SimpleDateFormat m_dformat = null;
        try {
            m_dformat = new SimpleDateFormat("yyyyMMdd");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "ImpFormatRow.parseDate Format=yyyyMMdd", e);
        }
        if (m_dformat == null) {
            m_dformat = (SimpleDateFormat)DateFormat.getDateInstance();
        }
        m_dformat.setLenient(true);
        Timestamp ts = null;
        try {
            ts = new Timestamp(m_dformat.parse(info).getTime());
        }
        catch (ParseException pe) {
            log.log(Level.SEVERE, "ImpFormatRow.parseDate - " + info, pe);
        }
        if (ts == null) {
            ts = new Timestamp(System.currentTimeMillis());
        }
        String dateString = ts.toString();
        return dateString.substring(0, dateString.indexOf(46));
    }

    private String parseNumber(String info) {
        boolean hasComma;
        boolean hasPoint = info.indexOf(46) != -1;
        boolean bl = hasComma = info.indexOf(44) != -1;
        if (hasComma && ",".equals(".")) {
            info = info.replace(',', ' ');
        }
        if (hasPoint && ",".equals(",")) {
            info = info.replace('.', ' ');
        }
        boolean bl2 = hasComma = info.indexOf(44) != -1;
        if (hasComma && ",".equals(",")) {
            info = info.replace(',', '.');
        }
        char[] charArray = info.toCharArray();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < charArray.length) {
            if (Character.isDigit(charArray[i]) || charArray[i] == '.' || charArray[i] == '-') {
                sb.append(charArray[i]);
            }
            ++i;
        }
        if (sb.length() == 0) {
            return "0";
        }
        BigDecimal bd = new BigDecimal(sb.toString());
        return bd.toString();
    }
}

