/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.grid.ed.MDocString;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VOvrCaret;
import org.compiere.model.GridField;
import org.compiere.swing.CPassword;

public final class VPassword
extends CPassword
implements VEditor,
KeyListener,
ActionListener,
FocusListener {
    private static final long serialVersionUID = -1251556129161613098L;
    private GridField m_mField = null;
    private String m_columnName;
    private String m_oldText;
    private String m_VFormat;
    private int m_fieldLength;
    private volatile boolean m_setting = false;

    public VPassword() {
        this("Password", false, false, true, 30, 30, "");
    }

    public VPassword(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, int displayLength, int fieldLength, String VFormat) {
        super(displayLength > 60 ? 60 : displayLength);
        super.setName(columnName);
        this.m_columnName = columnName;
        if (VFormat == null) {
            VFormat = "";
        }
        this.m_VFormat = VFormat;
        this.m_fieldLength = fieldLength;
        if (this.m_VFormat.length() != 0 || this.m_fieldLength != 0) {
            this.setDocument(new MDocString(this.m_VFormat, this.m_fieldLength, this));
        }
        if (this.m_VFormat.length() != 0) {
            this.setCaret(new VOvrCaret());
        }
        this.setMandatory(mandatory);
        if (isReadOnly || !isUpdateable) {
            this.setEditable(false);
            this.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        }
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.addActionListener(this);
        this.setForeground(AdempierePLAF.getTextColor_Normal());
        this.setBackground(AdempierePLAF.getFieldBackground_Normal());
    }

    @Override
    public void dispose() {
        this.m_mField = null;
    }

    @Override
    public void setValue(Object value) {
        this.m_oldText = value == null ? "" : value.toString();
        if (!this.m_setting) {
            this.setText(this.m_oldText);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    @Override
    public Object getValue() {
        return String.valueOf(this.getPassword());
    }

    @Override
    public String getDisplay() {
        return String.valueOf(this.getPassword());
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String newText = String.valueOf(this.getPassword());
        try {
            this.fireVetoableChange(this.m_columnName, this.m_oldText, newText);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    public void setField(GridField mField) {
        this.m_mField = mField;
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        String newText = String.valueOf(this.getPassword());
        this.m_setting = true;
        try {
            this.fireVetoableChange(this.m_columnName, this.m_oldText, newText);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.m_setting = false;
    }
}

