/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.search.InfoSchedule;
import org.compiere.grid.ed.VComboBox;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VNumber;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MResourceAssignment;
import org.compiere.model.MRole;
import org.compiere.model.MUOMConversion;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;

public class VAssignmentDialog
extends CDialog
implements ActionListener {
    private static final long serialVersionUID = 4130085811212412204L;
    private MResourceAssignment m_mAssignment;
    private Frame m_frame;
    private boolean m_setting = false;
    private static CLogger log = CLogger.getCLogger(VAssignmentDialog.class);
    private HashMap<KeyNamePair, KeyNamePair> m_lookup = new HashMap();
    private CPanel mainPanel = new CPanel();
    private GridBagLayout mainLayout = new GridBagLayout();
    private CLabel lResource = new CLabel(Msg.translate(Env.getCtx(), "S_Resource_ID"));
    private VComboBox fResource = new VComboBox(this.getResources());
    private CLabel lDate = new CLabel(Msg.translate(Env.getCtx(), "DateFrom"));
    private VDate fDateFrom = new VDate(16);
    private CLabel lQty = new CLabel(Msg.translate(Env.getCtx(), "Qty"));
    private VNumber fQty = new VNumber();
    private CLabel lUOM = new CLabel();
    private CLabel lName = new CLabel(Msg.translate(Env.getCtx(), "Name"));
    private CLabel lDescription = new CLabel(Msg.translate(Env.getCtx(), "Description"));
    private CTextField fName = new CTextField(30);
    private CTextField fDescription = new CTextField(30);
    private ConfirmPanel confirmPanel = new ConfirmPanel(true, false, false, false, false, true, true);
    private JButton delete = ConfirmPanel.createDeleteButton(true);
    private CLabel bpartnerLabel = new CLabel(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
    int AD_Column_ID = 3499;
    MLookup lookupBP = MLookupFactory.get(Env.getCtx(), 0, 0, this.AD_Column_ID, 30);
    private VLookup bpartnerSearch = new VLookup("C_BPartner_ID", true, false, true, this.lookupBP);
    private JCheckBox isConfirmed = new JCheckBox();
    private CLabel lTipo = new CLabel("Tipo Repetici\u00f3n");
    private VComboBox fTipo = new VComboBox(this.getTipos());
    private CLabel lReservation = new CLabel("Repetir Planificaci\u00f3n");
    private VNumber fReservation = new VNumber();

    public VAssignmentDialog(Frame frame, MResourceAssignment mAssignment, boolean allowZoom, boolean allowDelete) {
        super(frame, Msg.getMsg(Env.getCtx(), "VAssignmentDialog"), true);
        log.config(mAssignment.toString());
        this.m_mAssignment = mAssignment;
        this.m_frame = frame;
        try {
            this.jbInit();
            if (!allowZoom) {
                this.confirmPanel.getZoomButton().setVisible(false);
            }
            this.delete.setVisible(allowDelete);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
        this.setDisplay();
        AEnv.showCenterScreen(this);
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(2);
        this.fResource.addActionListener(this);
        this.delete.addActionListener(this);
        this.confirmPanel.addButton(this.delete);
        this.confirmPanel.addActionListener(this);
        this.mainPanel.setLayout(this.mainLayout);
        this.mainPanel.add((Component)this.lResource, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(8, 8, 4, 4), 0, 0));
        this.mainPanel.add((Component)this.fResource, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 0, 4, 4), 0, 0));
        this.mainPanel.add((Component)this.lDate, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 8, 4, 4), 0, 0));
        this.mainPanel.add((Component)this.fDateFrom, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 4, 8), 100, 0));
        this.mainPanel.add((Component)this.lQty, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 8, 4, 4), 0, 0));
        this.mainPanel.add((Component)this.fQty, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 0, 4, 4), 0, 0));
        this.mainPanel.add((Component)this.lUOM, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 4, 4, 8), 0, 0));
        this.mainPanel.add((Component)this.lName, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 8, 4, 4), 0, 0));
        this.mainPanel.add((Component)this.lDescription, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 8, 8, 4), 0, 0));
        this.mainPanel.add((Component)this.fName, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 4, 8), 0, 0));
        this.mainPanel.add((Component)this.fDescription, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 8, 8), 0, 0));
        this.mainPanel.add((Component)this.bpartnerLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(8, 8, 4, 4), 0, 0));
        this.mainPanel.add((Component)this.bpartnerSearch, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 0, 4, 4), 0, 0));
        this.isConfirmed.setText("Confirmado?");
        this.mainPanel.add((Component)this.isConfirmed, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 0, 4, 4), 0, 0));
        this.mainPanel.add((Component)this.lTipo, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 8, 4, 4), 0, 0));
        this.mainPanel.add((Component)this.fTipo, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 4, 8), 0, 0));
        this.mainPanel.add((Component)this.lReservation, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 8, 4, 4), 0, 0));
        this.mainPanel.add((Component)this.fReservation, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 8, 4, 4), 0, 0));
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.getContentPane().add((Component)this.confirmPanel, "South");
    }

    private void setDisplay() {
        this.m_setting = true;
        int S_Resource_ID = this.m_mAssignment.getS_Resource_ID();
        KeyNamePair[] resources = new KeyNamePair[this.m_lookup.size()];
        this.m_lookup.keySet().toArray(resources);
        int i = 0;
        while (i < resources.length) {
            if (resources[i].getKey() == S_Resource_ID) {
                this.fResource.setSelectedItem(resources[i]);
                break;
            }
            ++i;
        }
        KeyNamePair check = (KeyNamePair)this.fResource.getSelectedItem();
        if (check == null || check.getKey() != S_Resource_ID) {
            if (this.m_mAssignment.getS_ResourceAssignment_ID() == 0) {
                this.fResource.setSelectedItem(this.fResource.getSelectedItem());
            } else {
                log.log(Level.SEVERE, "Resource not found ID=" + S_Resource_ID);
            }
        }
        this.fDateFrom.setValue(this.m_mAssignment.getAssignDateFrom());
        this.fQty.setValue(this.m_mAssignment.getQty());
        this.fName.setValue(this.m_mAssignment.getName());
        this.fDescription.setValue(this.m_mAssignment.getDescription());
        boolean readWrite = true;
        if (this.m_mAssignment.isConfirmed()) {
            readWrite = false;
        }
        this.confirmPanel.getCancelButton().setVisible(readWrite);
        this.fResource.setReadWrite(readWrite);
        this.fDateFrom.setReadWrite(readWrite);
        this.fQty.setReadWrite(readWrite);
        this.fTipo.setSelectedIndex(0);
        this.isConfirmed.setSelected(this.m_mAssignment.isConfirmed());
        this.bpartnerSearch.setValue(this.m_mAssignment.get_Value("C_BPartner_ID"));
        this.bpartnerSearch.setReadWrite(readWrite);
        this.fReservation.setValue(Env.ZERO);
        this.m_setting = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        BigDecimal qty;
        Timestamp assignDateFrom;
        if (this.m_setting) {
            return;
        }
        KeyNamePair resource = (KeyNamePair)this.fResource.getSelectedItem();
        if (resource != null) {
            int S_Resource_ID = resource.getKey();
            this.m_mAssignment.setS_Resource_ID(S_Resource_ID);
        }
        if ((assignDateFrom = this.fDateFrom.getTimestamp()) != null) {
            this.m_mAssignment.setAssignDateFrom(assignDateFrom);
        }
        if ((qty = (BigDecimal)this.fQty.getValue()) != null) {
            this.m_mAssignment.setQty(qty);
        }
        this.m_mAssignment.setName((String)this.fName.getValue());
        this.m_mAssignment.setDescription((String)this.fDescription.getValue());
        if (e.getSource() == this.fResource) {
            KeyNamePair o = this.m_lookup.get(this.fResource.getSelectedItem());
            if (o == null) {
                this.lUOM.setText(" ? ");
            } else {
                this.lUOM.setText(((Object)o).toString());
            }
        } else if (e.getActionCommand().equals("Zoom")) {
            InfoSchedule is = new InfoSchedule(this.m_frame, this.m_mAssignment, true);
            if (is.getMResourceAssignment() != null) {
                this.m_mAssignment = is.getMResourceAssignment();
                this.dispose();
            }
            is = null;
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        } else if (e.getActionCommand().equals("Delete")) {
            if (this.m_mAssignment.delete(true)) {
                this.m_mAssignment = null;
                this.dispose();
            } else {
                ADialog.error(0, this, "ResourceAssignmentNotDeleted");
            }
        } else if (e.getActionCommand().equals("Ok")) {
            boolean ok = true;
            if (this.fQty.getValue() == null || ((BigDecimal)this.fQty.getValue()).signum() <= 0) {
                ok = false;
                ADialog.error(0, this, "Valor no Valido");
            }
            if (this.bpartnerSearch.getValue() == null || (Integer)this.bpartnerSearch.getValue() <= 0) {
                ok = false;
                ADialog.error(0, this, "Debe indicar una Persona");
            }
            if (ok && this.cmd_save()) {
                this.dispose();
            }
        }
    }

    public MResourceAssignment getMResourceAssignment() {
        return this.m_mAssignment;
    }

    private boolean cmd_save() {
        log.config("");
        Timestamp assignDateFrom = this.fDateFrom.getTimestamp();
        BigDecimal qty = (BigDecimal)this.fQty.getValue();
        KeyNamePair uom = this.m_lookup.get(this.fResource.getSelectedItem());
        int minutes = MUOMConversion.convertToMinutes(Env.getCtx(), uom.getKey(), qty);
        Timestamp assignDateTo = TimeUtil.addMinutess(assignDateFrom, minutes);
        this.m_mAssignment.setDescription(String.valueOf(minutes) + " Minutos");
        this.m_mAssignment.set_CustomColumn("C_BPartner_ID", (Integer)this.bpartnerSearch.getValue());
        this.m_mAssignment.setIsConfirmed(this.isConfirmed.isSelected());
        this.m_mAssignment.setAssignDateTo(assignDateTo);
        this.m_mAssignment.save();
        this.saveReservation();
        return true;
    }

    private KeyNamePair[] getResources() {
        if (this.m_lookup.size() == 0) {
            String sql = MRole.getDefault().addAccessSQL("SELECT r.S_Resource_ID, r.Name, r.IsActive,uom.C_UOM_ID,uom.UOMSymbol FROM S_Resource r, S_ResourceType rt, C_UOM uom WHERE r.S_ResourceType_ID=rt.S_ResourceType_ID AND rt.C_UOM_ID=uom.C_UOM_ID", "r", true, false);
            try {
                CPreparedStatement pstmt = DB.prepareStatement(sql, null);
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    StringBuffer sb = new StringBuffer(rs.getString(2));
                    if (!"Y".equals(rs.getString(3))) {
                        sb.insert(0, '~').append('~');
                    }
                    KeyNamePair key = new KeyNamePair(rs.getInt(1), sb.toString());
                    KeyNamePair value = new KeyNamePair(rs.getInt(4), rs.getString(5).trim());
                    this.m_lookup.put(key, value);
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                log.log(Level.SEVERE, sql, e);
            }
        }
        Object[] retValue = new KeyNamePair[this.m_lookup.size()];
        this.m_lookup.keySet().toArray(retValue);
        Arrays.sort(retValue);
        return retValue;
    }

    private void saveReservation() {
        if (this.fTipo.getSelectedIndex() == 0) {
            return;
        }
        if (this.fReservation.getValue() != null && ((BigDecimal)this.fReservation.getValue()).signum() < 0) {
            ADialog.error(0, this, "La proyeccion de reserva no puede ser negativa");
        }
        if (((BigDecimal)this.fReservation.getValue()).intValue() > 5) {
            ADialog.error(0, this, "El ciclo no puede proyectarse mas de 5 veces");
        }
        int Resource_ID = ((KeyNamePair)this.fResource.getSelectedItem()).getKey();
        String sql = "SELECT * FROM S_ResourceAssignment WHERE S_Resource_ID=? AND assigndatefrom = ? and assigndateto=?  and C_BPartner_ID=?";
        Timestamp assignDateFrom = this.fDateFrom.getTimestamp();
        BigDecimal qty = (BigDecimal)this.fQty.getValue();
        KeyNamePair uom = this.m_lookup.get(this.fResource.getSelectedItem());
        int minutes = MUOMConversion.convertToMinutes(Env.getCtx(), uom.getKey(), qty);
        Timestamp assignDateTo = TimeUtil.addMinutess(assignDateFrom, minutes);
        int i = 1;
        while (i < ((BigDecimal)this.fReservation.getValue()).intValue()) {
            Timestamp newDateFrom = null;
            Timestamp newDateTo = null;
            if (this.fTipo.getSelectedIndex() == 1) {
                newDateFrom = TimeUtil.addMinutess(assignDateFrom, i * 1440);
                newDateTo = TimeUtil.addMinutess(assignDateTo, i * 1440);
            } else if (this.fTipo.getSelectedIndex() == 2) {
                newDateFrom = TimeUtil.addMinutess(assignDateFrom, i * 7 * 1440);
                newDateTo = TimeUtil.addMinutess(assignDateTo, i * 7 * 1440);
            } else if (this.fTipo.getSelectedIndex() == 3) {
                newDateFrom = TimeUtil.addMinutess(assignDateFrom, i * 30 * 1440);
                newDateTo = TimeUtil.addMinutess(assignDateTo, i * 30 * 1440);
            }
            int encontrar = DB.getSQLValue(this.m_mAssignment.get_TrxName(), sql, Resource_ID, newDateFrom, newDateTo, (Integer)this.bpartnerSearch.getValue());
            if (encontrar <= 0) {
                MResourceAssignment reserva = new MResourceAssignment(Env.getCtx(), 0, this.m_mAssignment.get_TrxName());
                reserva.setDescription(String.valueOf(minutes) + " Minutos");
                reserva.set_CustomColumn("C_BPartner_ID", (Integer)this.bpartnerSearch.getValue());
                reserva.setIsConfirmed(this.isConfirmed.isSelected());
                reserva.setAssignDateFrom(newDateFrom);
                reserva.setAssignDateTo(newDateTo);
                reserva.setS_Resource_ID(Resource_ID);
                reserva.save();
            }
            ++i;
        }
    }

    private KeyNamePair[] getTipos() {
        KeyNamePair[] tipos = new KeyNamePair[]{new KeyNamePair(0, "Sin Repeticion"), new KeyNamePair(1, "Diario"), new KeyNamePair(2, "Semanal"), new KeyNamePair(3, "Mensual")};
        return tipos;
    }
}

