/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.grid.CreateFrom;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.MWarehouse;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class CreateFromShipment
extends CreateFrom {
    private MInvoice m_invoice = null;
    private MRMA m_rma = null;
    private int defaultLocator_ID = 0;
    String IsSOTrx;

    public CreateFromShipment(GridTab mTab) {
        super(mTab);
        this.log.info(mTab.toString());
        this.IsSOTrx = mTab.get_ValueAsString("IsSOTrx");
    }

    @Override
    public boolean dynInit() throws Exception {
        this.log.config("");
        this.setTitle(String.valueOf(Msg.getElement(Env.getCtx(), "M_InOut_ID", false)) + " .. " + Msg.translate(Env.getCtx(), "CreateFrom"));
        return true;
    }

    protected ArrayList<KeyNamePair> loadRMAData(int C_BPartner_ID) {
        ArrayList<KeyNamePair> list;
        block13: {
            list = new ArrayList<KeyNamePair>();
            String sqlStmt = "SELECT r.M_RMA_ID, r.DocumentNo || '-' || r.Amt from M_RMA r WHERE ISSOTRX='Y' AND r.DocStatus in ('CO', 'CL') AND r.C_BPartner_ID=? AND r.M_RMA_ID in (SELECT rl.M_RMA_ID FROM M_RMALine rl WHERE rl.M_RMA_ID=r.M_RMA_ID AND rl.QtyDelivered < rl.Qty AND rl.M_InOutLine_ID IS NOT NULL)";
            CPreparedStatement pstmt = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sqlStmt, null);
                    pstmt.setInt(1, C_BPartner_ID);
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
                    }
                    rs.close();
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sqlStmt.toString(), e);
                    if (pstmt == null) break block13;
                    try {
                        pstmt.close();
                    }
                    catch (Exception ex) {
                        this.log.severe("Could not close prepared statement");
                    }
                }
            }
            finally {
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (Exception ex) {
                        this.log.severe("Could not close prepared statement");
                    }
                }
            }
        }
        return list;
    }

    protected ArrayList<KeyNamePair> loadInvoiceData(int C_BPartner_ID) {
        ArrayList<KeyNamePair> list = new ArrayList<KeyNamePair>();
        StringBuffer display = new StringBuffer("i.DocumentNo||' - '||").append(DB.TO_CHAR("DateInvoiced", 15, Env.getAD_Language(Env.getCtx()))).append("|| ' - ' ||").append(DB.TO_CHAR("GrandTotal", 12, Env.getAD_Language(Env.getCtx())));
        StringBuffer sql = new StringBuffer("SELECT i.C_Invoice_ID,").append(display).append(" FROM C_Invoice i WHERE i.C_BPartner_ID=? AND i.IsSOTrx='N' AND i.DocStatus IN ('CL','CO') AND i.C_Invoice_ID IN (SELECT il.C_Invoice_ID FROM C_InvoiceLine il LEFT OUTER JOIN M_MatchInv mi ON (il.C_InvoiceLine_ID=mi.C_InvoiceLine_ID)  JOIN C_Invoice i2 ON (il.C_Invoice_ID = i2.C_Invoice_ID)  WHERE i2.C_BPartner_ID=? AND i2.IsSOTrx='N' AND i2.DocStatus IN ('CL','CO') GROUP BY il.C_Invoice_ID,mi.C_InvoiceLine_ID,il.QtyInvoiced HAVING (il.QtyInvoiced<>SUM(mi.Qty) AND mi.C_InvoiceLine_ID IS NOT NULL) OR mi.C_InvoiceLine_ID IS NULL) ORDER BY i.DateInvoiced");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, C_BPartner_ID);
            pstmt.setInt(2, C_BPartner_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        return list;
    }

    @Override
    protected Vector<Vector<Object>> getOrderData(int C_Order_ID, boolean forInvoice) {
        Vector<Vector<Object>> data;
        block12: {
            this.log.config("C_Order_ID=" + C_Order_ID);
            this.p_order = new MOrder(Env.getCtx(), C_Order_ID, null);
            data = new Vector<Vector<Object>>();
            StringBuffer sql = new StringBuffer("SELECT ");
            if (forInvoice) {
                sql.append("l.QtyOrdered-SUM(COALESCE(invl.QTYINVOICED,0)),");
            } else {
                sql.append("l.QtyOrdered-SUM(COALESCE(inout.MovementQty,0)),");
            }
            sql.append("CASE WHEN l.QtyOrdered=0 THEN 0 ELSE l.QtyEntered/l.QtyOrdered END, l.C_UOM_ID,COALESCE(uom.UOMSymbol,uom.Name), p.M_Locator_ID, loc.Value,  COALESCE(l.M_Product_ID,0),COALESCE(p.Name,c.Name),  po.VendorProductNo,  l.C_OrderLine_ID,l.Line,l.datepromised,l.description FROM C_OrderLine l LEFT OUTER JOIN M_Product_PO po ON (l.M_Product_ID = po.M_Product_ID AND l.C_BPartner_ID = po.C_BPartner_ID)  LEFT OUTER JOIN M_Product p ON (l.M_Product_ID=p.M_Product_ID) LEFT OUTER JOIN M_Locator loc on (p.M_Locator_ID=loc.M_Locator_ID) LEFT OUTER JOIN C_Charge c ON (l.C_Charge_ID=c.C_Charge_ID)");
            if (Env.isBaseLanguage(Env.getCtx(), "C_UOM")) {
                sql.append(" LEFT OUTER JOIN C_UOM uom ON (l.C_UOM_ID=uom.C_UOM_ID)");
            } else {
                sql.append(" LEFT OUTER JOIN C_UOM_Trl uom ON (l.C_UOM_ID=uom.C_UOM_ID AND uom.AD_Language='").append(Env.getAD_Language(Env.getCtx())).append("')");
            }
            if (!forInvoice) {
                sql.append(" LEFT OUTER JOIN M_InOutLine inout ON (l.C_OrderLine_ID=inout.C_OrderLine_ID)");
            } else {
                sql.append(" LEFT OUTER JOIN C_InvoiceLine invl ON (l.C_OrderLine_ID=invl.C_OrderLine_ID)");
            }
            sql.append(" WHERE l.C_Order_ID=? GROUP BY l.QtyOrdered,CASE WHEN l.QtyOrdered=0 THEN 0 ELSE l.QtyEntered/l.QtyOrdered END, l.C_UOM_ID,COALESCE(uom.UOMSymbol,uom.Name), p.M_Locator_ID, loc.Value, po.VendorProductNo, l.M_Product_ID,COALESCE(p.Name,c.Name), l.Line,l.C_OrderLine_ID,l.datepromised,l.description ORDER BY l.Line");
            this.log.finer(sql.toString());
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), null);
                    pstmt.setInt(1, C_Order_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>();
                        line.add(new Boolean(false));
                        BigDecimal qtyOrdered = rs.getBigDecimal(1);
                        BigDecimal multiplier = rs.getBigDecimal(2);
                        BigDecimal qtyEntered = qtyOrdered.multiply(multiplier);
                        if (qtyEntered.equals(Env.ZERO) && !this.isRangeActive()) continue;
                        line.add(qtyEntered);
                        KeyNamePair pp = new KeyNamePair(rs.getInt(3), rs.getString(4).trim());
                        line.add(pp);
                        line.add(rs.getTimestamp(12));
                        line.add(this.getLocatorKeyNamePair(rs.getInt(5)));
                        pp = new KeyNamePair(rs.getInt(7), rs.getString(8));
                        line.add(pp);
                        line.add(rs.getString(9));
                        pp = new KeyNamePair(rs.getInt(10), rs.getString(11));
                        line.add(pp);
                        line.add(null);
                        line.add(null);
                        line.add(rs.getString("description"));
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql.toString(), e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block12;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    protected Vector<Vector<Object>> getRMAData(int M_RMA_ID) {
        Vector<Vector<Object>> data;
        block10: {
            this.m_invoice = null;
            this.p_order = null;
            this.m_rma = new MRMA(Env.getCtx(), M_RMA_ID, null);
            data = new Vector<Vector<Object>>();
            StringBuffer sqlStmt = new StringBuffer();
            sqlStmt.append("SELECT rl.M_RMALine_ID, rl.line, rl.Qty - rl.QtyDelivered, iol.M_Product_ID, p.Name, uom.C_UOM_ID, COALESCE(uom.UOMSymbol,uom.Name), rl.created ");
            sqlStmt.append("FROM M_RMALine rl INNER JOIN M_InOutLine iol ON rl.M_InOutLine_ID=iol.M_InOutLine_ID ");
            if (Env.isBaseLanguage(Env.getCtx(), "C_UOM")) {
                sqlStmt.append("LEFT OUTER JOIN C_UOM uom ON (uom.C_UOM_ID=iol.C_UOM_ID) ");
            } else {
                sqlStmt.append("LEFT OUTER JOIN C_UOM_Trl uom ON (uom.C_UOM_ID=iol.C_UOM_ID AND uom.AD_Language='");
                sqlStmt.append(Env.getAD_Language(Env.getCtx())).append("') ");
            }
            sqlStmt.append("LEFT OUTER JOIN M_Product p ON p.M_Product_ID=iol.M_Product_ID ");
            sqlStmt.append("WHERE rl.M_RMA_ID=? ");
            sqlStmt.append("AND rl.M_INOUTLINE_ID IS NOT NULL");
            sqlStmt.append(" UNION ");
            sqlStmt.append("SELECT rl.M_RMALine_ID, rl.line, rl.Qty - rl.QtyDelivered, 0, c.Name, uom.C_UOM_ID, COALESCE(uom.UOMSymbol,uom.Name), rl.created ");
            sqlStmt.append("FROM M_RMALine rl INNER JOIN C_Charge c ON c.C_Charge_ID = rl.C_Charge_ID ");
            if (Env.isBaseLanguage(Env.getCtx(), "C_UOM")) {
                sqlStmt.append("LEFT OUTER JOIN C_UOM uom ON (uom.C_UOM_ID=100) ");
            } else {
                sqlStmt.append("LEFT OUTER JOIN C_UOM_Trl uom ON (uom.C_UOM_ID=100 AND uom.AD_Language='");
                sqlStmt.append(Env.getAD_Language(Env.getCtx())).append("') ");
            }
            sqlStmt.append("WHERE rl.M_RMA_ID=? ");
            sqlStmt.append("AND rl.C_Charge_ID IS NOT NULL");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sqlStmt.toString(), null);
                    pstmt.setInt(1, M_RMA_ID);
                    pstmt.setInt(2, M_RMA_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Comparable<Boolean>> line = new Vector<Comparable<Boolean>>(7);
                        line.add(new Boolean(false));
                        line.add(rs.getBigDecimal(3));
                        KeyNamePair pp = new KeyNamePair(rs.getInt(6), rs.getString(7));
                        line.add(pp);
                        line.add(rs.getTimestamp("created"));
                        line.add(this.getLocatorKeyNamePair(0));
                        pp = new KeyNamePair(rs.getInt(4), rs.getString(5));
                        line.add(pp);
                        line.add(null);
                        line.add(null);
                        pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                        line.add(pp);
                        line.add(null);
                        data.add(line);
                    }
                }
                catch (Exception ex) {
                    this.log.log(Level.SEVERE, sqlStmt.toString(), ex);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    protected Vector<Vector<Object>> getInvoiceData(int C_Invoice_ID) {
        Vector<Vector<Object>> data;
        block10: {
            this.m_invoice = new MInvoice(Env.getCtx(), C_Invoice_ID, null);
            this.p_order = null;
            this.m_rma = null;
            data = new Vector<Vector<Object>>();
            StringBuffer sql = new StringBuffer("SELECT l.QtyInvoiced-SUM(NVL(mi.Qty,0)),l.QtyEntered/l.QtyInvoiced, l.C_UOM_ID,COALESCE(uom.UOMSymbol,uom.Name), p.M_Locator_ID, loc.Value,  l.M_Product_ID,p.Name, po.VendorProductNo, l.C_InvoiceLine_ID,l.Line, l.C_OrderLine_ID, inv.DateInvoiced,l.description  FROM C_InvoiceLine l ");
            if (Env.isBaseLanguage(Env.getCtx(), "C_UOM")) {
                sql.append(" LEFT OUTER JOIN C_UOM uom ON (l.C_UOM_ID=uom.C_UOM_ID)");
            } else {
                sql.append(" LEFT OUTER JOIN C_UOM_Trl uom ON (l.C_UOM_ID=uom.C_UOM_ID AND uom.AD_Language='").append(Env.getAD_Language(Env.getCtx())).append("')");
            }
            sql.append(" LEFT OUTER JOIN M_Product p ON (l.M_Product_ID=p.M_Product_ID)").append(" LEFT OUTER JOIN M_Locator loc on (p.M_Locator_ID=loc.M_Locator_ID)").append(" INNER JOIN C_Invoice inv ON (l.C_Invoice_ID=inv.C_Invoice_ID)").append(" LEFT OUTER JOIN M_Product_PO po ON (l.M_Product_ID = po.M_Product_ID AND inv.C_BPartner_ID = po.C_BPartner_ID)").append(" LEFT OUTER JOIN M_MatchInv mi ON (l.C_InvoiceLine_ID=mi.C_InvoiceLine_ID)").append(" LEFT OUTER JOIN M_InOutLine inoutl ON (l.C_InvoiceLine_ID=inoutl.C_InvoiceLine_ID)").append(" WHERE l.C_Invoice_ID=? AND l.QtyInvoiced<>0 ").append("GROUP BY l.QtyInvoiced,l.QtyEntered/l.QtyInvoiced,l.C_UOM_ID,COALESCE(uom.UOMSymbol,uom.Name),p.M_Locator_ID, loc.Value, l.M_Product_ID,p.Name, po.VendorProductNo, l.C_InvoiceLine_ID,l.Line,l.C_OrderLine_ID,inv.DateInvoiced,l.description ").append("ORDER BY l.Line");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), null);
                    pstmt.setInt(1, C_Invoice_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>(7);
                        line.add(new Boolean(false));
                        BigDecimal qtyInvoiced = rs.getBigDecimal(1);
                        BigDecimal multiplier = rs.getBigDecimal(2);
                        BigDecimal qtyEntered = qtyInvoiced.multiply(multiplier);
                        line.add(qtyEntered);
                        KeyNamePair pp = new KeyNamePair(rs.getInt(3), rs.getString(4).trim());
                        line.add(pp);
                        line.add(rs.getTimestamp(13));
                        line.add(this.getLocatorKeyNamePair(rs.getInt(5)));
                        pp = new KeyNamePair(rs.getInt(7), rs.getString(8));
                        line.add(pp);
                        line.add(rs.getString(9));
                        int C_OrderLine_ID = rs.getInt(12);
                        if (rs.wasNull()) {
                            line.add(null);
                        } else {
                            line.add(new KeyNamePair(C_OrderLine_ID, "."));
                        }
                        line.add(null);
                        pp = new KeyNamePair(rs.getInt(10), rs.getString(11));
                        line.add(pp);
                        line.add(rs.getString("description"));
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql.toString(), e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    protected KeyNamePair getLocatorKeyNamePair(int M_Locator_ID) {
        MWarehouse wh;
        MLocator locator = null;
        if (M_Locator_ID > 0 && (locator = MLocator.get(Env.getCtx(), M_Locator_ID)) != null && locator.getM_Warehouse_ID() != this.getM_Warehouse_ID()) {
            locator = null;
        }
        if (locator == null && this.p_order != null && this.p_order.getM_Warehouse_ID() == this.getM_Warehouse_ID() && (wh = MWarehouse.get(Env.getCtx(), this.p_order.getM_Warehouse_ID())) != null) {
            locator = wh.getDefaultLocator();
        }
        if (locator == null && this.defaultLocator_ID > 0) {
            locator = MLocator.get(Env.getCtx(), this.defaultLocator_ID);
        }
        if (locator == null || locator.getM_Warehouse_ID() != this.getM_Warehouse_ID()) {
            locator = MWarehouse.get(Env.getCtx(), this.getM_Warehouse_ID()).getDefaultLocator();
        }
        KeyNamePair pp = null;
        if (locator != null) {
            pp = new KeyNamePair(locator.get_ID(), locator.getValue());
        }
        return pp;
    }

    @Override
    public void info() {
    }

    protected void configureMiniTable(IMiniTable miniTable) {
        miniTable.setColumnClass(0, Boolean.class, false);
        miniTable.setColumnClass(1, BigDecimal.class, false);
        miniTable.setColumnClass(2, String.class, true);
        miniTable.setColumnClass(3, Timestamp.class, true);
        miniTable.setColumnClass(4, String.class, false);
        miniTable.setColumnClass(5, String.class, true);
        miniTable.setColumnClass(6, String.class, true);
        miniTable.setColumnClass(7, String.class, true);
        miniTable.setColumnClass(8, String.class, true);
        miniTable.setColumnClass(9, String.class, true);
        miniTable.setColumnClass(10, String.class, true);
        miniTable.autoSize();
    }

    @Override
    public boolean save(IMiniTable miniTable, String trxName) {
        int M_Locator_ID = this.defaultLocator_ID;
        if (M_Locator_ID == 0) {
            return false;
        }
        int M_InOut_ID = (Integer)this.getGridTab().getValue("M_InOut_ID");
        MInOut inout = new MInOut(Env.getCtx(), M_InOut_ID, trxName);
        this.log.config(inout + ", C_Locator_ID=" + M_Locator_ID);
        int i = 0;
        while (i < miniTable.getRowCount()) {
            if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) {
                MOrderLine ol;
                BigDecimal QtyEntered = (BigDecimal)miniTable.getValueAt(i, 1);
                KeyNamePair pp = (KeyNamePair)miniTable.getValueAt(i, 2);
                int C_UOM_ID = pp.getKey();
                pp = (KeyNamePair)miniTable.getValueAt(i, 4);
                M_Locator_ID = pp != null && pp.getKey() != 0 ? pp.getKey() : this.defaultLocator_ID;
                pp = (KeyNamePair)miniTable.getValueAt(i, 5);
                int M_Product_ID = pp.getKey();
                int C_OrderLine_ID = 0;
                pp = (KeyNamePair)miniTable.getValueAt(i, 7);
                if (pp != null) {
                    C_OrderLine_ID = pp.getKey();
                }
                int M_RMALine_ID = 0;
                pp = (KeyNamePair)miniTable.getValueAt(i, 8);
                if (pp != null) {
                    M_RMALine_ID = pp.getKey();
                }
                int C_InvoiceLine_ID = 0;
                MInvoiceLine il = null;
                pp = (KeyNamePair)miniTable.getValueAt(i, 9);
                if (pp != null) {
                    C_InvoiceLine_ID = pp.getKey();
                }
                if (C_InvoiceLine_ID != 0) {
                    il = new MInvoiceLine(Env.getCtx(), C_InvoiceLine_ID, trxName);
                }
                int precision = 2;
                if (M_Product_ID != 0) {
                    MProduct product = MProduct.get(Env.getCtx(), M_Product_ID);
                    precision = product.getUOMPrecision();
                }
                QtyEntered = QtyEntered.setScale(precision, 5);
                this.log.fine("Line QtyEntered=" + QtyEntered + ", Product=" + M_Product_ID + ", OrderLine=" + C_OrderLine_ID + ", InvoiceLine=" + C_InvoiceLine_ID);
                if (C_OrderLine_ID != 0 && (ol = new MOrderLine(Env.getCtx(), C_OrderLine_ID, trxName)).getC_Charge_ID() > 0 && ol.getC_Charge().getC_ChargeType_ID() > 0 && ol.getC_Charge().getC_ChargeType().getValue().equals("TCAF")) {
                    int x = 0;
                    while (x < QtyEntered.intValue()) {
                        MInOutLine iol = new MInOutLine(inout);
                        iol.setM_Product_ID(M_Product_ID, C_UOM_ID);
                        iol.setQty(Env.ONE);
                        iol.setC_OrderLine_ID(C_OrderLine_ID);
                        ol = new MOrderLine(Env.getCtx(), C_OrderLine_ID, trxName);
                        iol.setM_AttributeSetInstance_ID(ol.getM_AttributeSetInstance_ID());
                        iol.setDescription(ol.getDescription());
                        iol.setC_Project_ID(ol.getC_Project_ID());
                        iol.setC_ProjectPhase_ID(ol.getC_ProjectPhase_ID());
                        iol.setC_ProjectTask_ID(ol.getC_ProjectTask_ID());
                        iol.setC_Activity_ID(ol.getC_Activity_ID());
                        iol.setC_Campaign_ID(ol.getC_Campaign_ID());
                        iol.setAD_OrgTrx_ID(ol.getAD_OrgTrx_ID());
                        iol.setUser1_ID(ol.getUser1_ID());
                        iol.setUser2_ID(ol.getUser2_ID());
                        if (M_Product_ID == 0) {
                            iol.setC_Charge_ID(ol.getC_Charge_ID());
                        }
                        iol.setM_Locator_ID(M_Locator_ID);
                        if (!iol.save()) {
                            this.log.log(Level.SEVERE, "Line NOT created #" + i);
                        }
                        ++x;
                    }
                } else {
                    MInOutLine iol = new MInOutLine(inout);
                    iol.setM_Product_ID(M_Product_ID, C_UOM_ID);
                    iol.setQty(QtyEntered);
                    MOrderLine ol2 = null;
                    MRMALine rmal = null;
                    if (C_OrderLine_ID != 0) {
                        iol.setC_OrderLine_ID(C_OrderLine_ID);
                        ol2 = new MOrderLine(Env.getCtx(), C_OrderLine_ID, trxName);
                        if (ol2.getQtyEntered().compareTo(ol2.getQtyOrdered()) != 0) {
                            iol.setMovementQty(QtyEntered.multiply(ol2.getQtyOrdered()).divide(ol2.getQtyEntered(), 12, 4));
                            iol.setC_UOM_ID(ol2.getC_UOM_ID());
                        }
                        iol.setM_AttributeSetInstance_ID(ol2.getM_AttributeSetInstance_ID());
                        iol.setDescription(ol2.getDescription());
                        iol.setC_Project_ID(ol2.getC_Project_ID());
                        iol.setC_ProjectPhase_ID(ol2.getC_ProjectPhase_ID());
                        iol.setC_ProjectTask_ID(ol2.getC_ProjectTask_ID());
                        iol.setC_Activity_ID(ol2.getC_Activity_ID());
                        iol.setC_Campaign_ID(ol2.getC_Campaign_ID());
                        iol.setAD_OrgTrx_ID(ol2.getAD_OrgTrx_ID());
                        iol.setUser1_ID(ol2.getUser1_ID());
                        iol.setUser2_ID(ol2.getUser2_ID());
                    } else if (il != null) {
                        if (il.getQtyEntered().compareTo(il.getQtyInvoiced()) != 0) {
                            iol.setQtyEntered(QtyEntered.multiply(il.getQtyInvoiced()).divide(il.getQtyEntered(), 12, 4));
                            iol.setC_UOM_ID(il.getC_UOM_ID());
                        }
                        iol.setDescription(il.getDescription());
                        iol.setC_Project_ID(il.getC_Project_ID());
                        iol.setC_ProjectPhase_ID(il.getC_ProjectPhase_ID());
                        iol.setC_ProjectTask_ID(il.getC_ProjectTask_ID());
                        iol.setC_Activity_ID(il.getC_Activity_ID());
                        iol.setC_Campaign_ID(il.getC_Campaign_ID());
                        iol.setAD_OrgTrx_ID(il.getAD_OrgTrx_ID());
                        iol.setUser1_ID(il.getUser1_ID());
                        iol.setUser2_ID(il.getUser2_ID());
                    } else if (M_RMALine_ID != 0) {
                        rmal = new MRMALine(Env.getCtx(), M_RMALine_ID, trxName);
                        iol.setM_RMALine_ID(M_RMALine_ID);
                        iol.setQtyEntered(QtyEntered);
                        iol.setDescription(rmal.getDescription());
                        iol.setM_AttributeSetInstance_ID(rmal.getM_AttributeSetInstance_ID());
                        iol.setC_Project_ID(rmal.getC_Project_ID());
                        iol.setC_ProjectPhase_ID(rmal.getC_ProjectPhase_ID());
                        iol.setC_ProjectTask_ID(rmal.getC_ProjectTask_ID());
                        iol.setC_Activity_ID(rmal.getC_Activity_ID());
                        iol.setAD_OrgTrx_ID(rmal.getAD_OrgTrx_ID());
                        iol.setUser1_ID(rmal.getUser1_ID());
                        iol.setUser2_ID(rmal.getUser2_ID());
                    }
                    if (M_Product_ID == 0) {
                        if (ol2 != null && ol2.getC_Charge_ID() != 0) {
                            iol.setC_Charge_ID(ol2.getC_Charge_ID());
                        } else if (il != null && il.getC_Charge_ID() != 0) {
                            iol.setC_Charge_ID(il.getC_Charge_ID());
                        } else if (rmal != null && rmal.getC_Charge_ID() != 0) {
                            iol.setC_Charge_ID(rmal.getC_Charge_ID());
                        }
                    }
                    iol.setM_Locator_ID(M_Locator_ID);
                    if (!iol.save()) {
                        this.log.log(Level.SEVERE, "Line NOT created #" + i);
                    } else if (il != null) {
                        il.setM_InOutLine_ID(iol.getM_InOutLine_ID());
                        il.saveEx();
                    }
                }
            }
            ++i;
        }
        if (this.p_order != null && this.p_order.getC_Order_ID() != 0) {
            inout.setC_Order_ID(this.p_order.getC_Order_ID());
            inout.setAD_OrgTrx_ID(this.p_order.getAD_OrgTrx_ID());
            inout.setC_Project_ID(this.p_order.getC_Project_ID());
            inout.setC_Campaign_ID(this.p_order.getC_Campaign_ID());
            inout.setC_Activity_ID(this.p_order.getC_Activity_ID());
            inout.setUser1_ID(this.p_order.getUser1_ID());
            inout.setUser2_ID(this.p_order.getUser2_ID());
            if (this.p_order.isDropShip()) {
                inout.setM_Warehouse_ID(this.p_order.getM_Warehouse_ID());
                inout.setIsDropShip(this.p_order.isDropShip());
                inout.setDropShip_BPartner_ID(this.p_order.getDropShip_BPartner_ID());
                inout.setDropShip_Location_ID(this.p_order.getDropShip_Location_ID());
                inout.setDropShip_User_ID(this.p_order.getDropShip_User_ID());
            }
        }
        if (this.m_invoice != null && this.m_invoice.getC_Invoice_ID() != 0) {
            if (inout.getC_Order_ID() == 0) {
                inout.setC_Order_ID(this.m_invoice.getC_Order_ID());
            }
            inout.setC_Invoice_ID(this.m_invoice.getC_Invoice_ID());
            inout.setAD_OrgTrx_ID(this.m_invoice.getAD_OrgTrx_ID());
            inout.setC_Project_ID(this.m_invoice.getC_Project_ID());
            inout.setC_Campaign_ID(this.m_invoice.getC_Campaign_ID());
            inout.setC_Activity_ID(this.m_invoice.getC_Activity_ID());
            inout.setUser1_ID(this.m_invoice.getUser1_ID());
            inout.setUser2_ID(this.m_invoice.getUser2_ID());
        }
        if (this.m_rma != null && this.m_rma.getM_RMA_ID() != 0) {
            MInOut originalIO = this.m_rma.getShipment();
            inout.setIsSOTrx(this.m_rma.isSOTrx());
            inout.setC_Order_ID(0);
            inout.setC_Invoice_ID(0);
            inout.setM_RMA_ID(this.m_rma.getM_RMA_ID());
            inout.setAD_OrgTrx_ID(originalIO.getAD_OrgTrx_ID());
            inout.setC_Project_ID(originalIO.getC_Project_ID());
            inout.setC_Campaign_ID(originalIO.getC_Campaign_ID());
            inout.setC_Activity_ID(originalIO.getC_Activity_ID());
            inout.setUser1_ID(originalIO.getUser1_ID());
            inout.setUser2_ID(originalIO.getUser2_ID());
        }
        inout.saveEx();
        return true;
    }

    protected Vector<String> getOISColumnNames() {
        Vector<String> columnNames = new Vector<String>(7);
        columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
        columnNames.add(Msg.translate(Env.getCtx(), "Quantity"));
        columnNames.add(Msg.translate(Env.getCtx(), "C_UOM_ID"));
        columnNames.add("Fecha Prom");
        columnNames.add(Msg.translate(Env.getCtx(), "M_Locator_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "M_Product_ID"));
        columnNames.add(Msg.getElement(Env.getCtx(), "VendorProductNo", false));
        columnNames.add(Msg.getElement(Env.getCtx(), "Order", false));
        columnNames.add(Msg.getElement(Env.getCtx(), "M_RMA_ID", false));
        columnNames.add(Msg.getElement(Env.getCtx(), "C_Invoice_ID", false));
        columnNames.add(Msg.getElement(Env.getCtx(), "Description", false));
        return columnNames;
    }

    protected Vector<Vector<Object>> getOrderData(int C_Order_ID, boolean forInvoice, int M_Locator_ID) {
        this.defaultLocator_ID = M_Locator_ID;
        return this.getOrderData(C_Order_ID, forInvoice);
    }

    protected Vector<Vector<Object>> getRMAData(int M_RMA_ID, int M_Locator_ID) {
        this.defaultLocator_ID = M_Locator_ID;
        return this.getRMAData(M_RMA_ID);
    }

    protected Vector<Vector<Object>> getInvoiceData(int C_Invoice_ID, int M_Locator_ID) {
        this.defaultLocator_ID = M_Locator_ID;
        return this.getInvoiceData(C_Invoice_ID);
    }
}

