/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Vector;
import org.compiere.grid.CreateFrom;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.X_C_PaymentListLine;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class CreateFromPaymentList
extends CreateFrom {
    public CreateFromPaymentList(GridTab mTab) {
        super(mTab);
        this.log.info(mTab.toString());
    }

    @Override
    public boolean dynInit() throws Exception {
        this.log.config("");
        this.setTitle(String.valueOf(Msg.getElement(Env.getCtx(), "C_Payment_ID", false)) + " .. " + Msg.translate(Env.getCtx(), "CreateFrom"));
        return true;
    }

    @Override
    public void info() {
    }

    protected void configureMiniTable(IMiniTable miniTable) {
        miniTable.setColumnClass(0, Boolean.class, false);
        miniTable.setColumnClass(1, Timestamp.class, true);
        miniTable.setColumnClass(2, String.class, true);
        miniTable.setColumnClass(3, String.class, true);
        miniTable.setColumnClass(4, BigDecimal.class, true);
        miniTable.setColumnClass(5, String.class, true);
        miniTable.autoSize();
    }

    @Override
    public boolean save(IMiniTable miniTable, String trxName) {
        this.log.info("save..");
        int header_ID = (Integer)this.getGridTab().getValue("C_PaymentList_ID");
        BigDecimal total = new BigDecimal(0);
        int i = 0;
        while (i < miniTable.getRowCount()) {
            if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) {
                X_C_PaymentListLine line = new X_C_PaymentListLine(Env.getCtx(), 0, trxName);
                KeyNamePair document = (KeyNamePair)miniTable.getValueAt(i, 3);
                BigDecimal amt = (BigDecimal)miniTable.getValueAt(i, 4);
                String desc = (String)miniTable.getValueAt(i, 5);
                line.setC_PaymentList_ID(header_ID);
                line.setAmt(amt);
                line.setDescription(desc);
                line.setC_Payment_ID(document.getKey());
                line.save();
                total = total.add(amt);
            }
            ++i;
        }
        return true;
    }

    protected Vector<String> getOISColumnNames() {
        Vector<String> columnNames = new Vector<String>(10);
        columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
        columnNames.add(Msg.getElement(Env.getCtx(), "DateTrx"));
        columnNames.add(Msg.getElement(Env.getCtx(), "C_BPartner_ID"));
        columnNames.add(Msg.getElement(Env.getCtx(), "DocumentNo"));
        columnNames.add(Msg.getElement(Env.getCtx(), "Amt"));
        columnNames.add(Msg.translate(Env.getCtx(), "Description"));
        return columnNames;
    }
}

