/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.logging.Level;
import javax.sql.DataSource;
import oracle.jdbc.OracleDriver;
import org.adempiere.exceptions.DBException;
import org.compiere.Adempiere;
import org.compiere.db.AdempiereDatabase;
import org.compiere.db.CConnection;
import org.compiere.db.Database;
import org.compiere.dbPort.Convert;
import org.compiere.dbPort.Convert_Oracle;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Util;

public class DB_Oracle
implements AdempiereDatabase {
    private static OracleDriver s_driver = null;
    public static final String DRIVER = "oracle.jdbc.OracleDriver";
    public static final int DEFAULT_PORT = 1521;
    public static final int DEFAULT_CM_PORT = 1630;
    private String m_connectionURL;
    private static final String MAX_STATEMENTS = "200";
    private ComboPooledDataSource m_ds = null;
    private String m_userName = null;
    private Convert m_convert = new Convert_Oracle();
    private static CLogger log = CLogger.getCLogger(DB_Oracle.class);
    private static int m_maxbusyconnections = 0;

    public DB_Oracle() {
        try {
            System.setProperty("oracle.jdbc.V8Compatible", "true");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage());
        }
    }

    @Override
    public String getName() {
        return Database.DB_ORACLE;
    }

    @Override
    public String getDescription() {
        try {
            if (s_driver == null) {
                this.getDriver();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (s_driver != null) {
            return s_driver.toString();
        }
        return "No Driver";
    }

    @Override
    public int getStandardPort() {
        return 1521;
    }

    @Override
    public Driver getDriver() throws SQLException {
        if (s_driver == null) {
            System.setProperty("oracle.jdbc.TcpNoDelay", "true");
            System.setProperty("oracle.jdbc.defaultNChar", "true");
            s_driver = new OracleDriver();
            DriverManager.registerDriver((Driver)s_driver);
            DriverManager.setLoginTimeout(Database.CONNECTION_TIMEOUT);
        }
        return s_driver;
    }

    @Override
    public String getConnectionURL(CConnection connection) {
        StringBuffer sb = null;
        if (connection.isBequeath()) {
            sb = new StringBuffer("jdbc:oracle:oci8:@");
        } else {
            sb = new StringBuffer("jdbc:oracle:thin:@");
            if (connection.isViaFirewall()) {
                sb.append("(DESCRIPTION=(ADDRESS_LIST=").append("(SOURCE_ROUTE=YES)").append("(ADDRESS=(PROTOCOL=TCP)(HOST=").append(connection.getFwHost()).append(")(PORT=").append(connection.getFwPort()).append("))").append("(ADDRESS=(PROTOCOL=TCP)(HOST=").append(connection.getDbHost()).append(")(PORT=").append(connection.getDbPort()).append(")))").append("(CONNECT_DATA=(SERVICE_NAME=").append(connection.getDbName()).append(")))");
            } else {
                sb.append("//").append(connection.getDbHost()).append(":").append(connection.getDbPort()).append("/").append(connection.getDbName());
            }
        }
        this.m_connectionURL = sb.toString();
        this.m_userName = connection.getDbUid();
        return this.m_connectionURL;
    }

    @Override
    public String getConnectionURL(String dbHost, int dbPort, String dbName, String userName) {
        this.m_userName = userName;
        this.m_connectionURL = "jdbc:oracle:thin:@//" + dbHost + ":" + dbPort + "/" + dbName;
        return this.m_connectionURL;
    }

    @Override
    public String getConnectionURL(String connectionURL, String userName) {
        this.m_userName = userName;
        this.m_connectionURL = connectionURL;
        return this.m_connectionURL;
    }

    @Override
    public String getCatalog() {
        return null;
    }

    @Override
    public String getSchema() {
        if (this.m_userName != null) {
            return this.m_userName.toUpperCase();
        }
        log.severe("User Name not set (yet) - call getConnectionURL first");
        return null;
    }

    @Override
    public boolean supportsBLOB() {
        return true;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("DB_Oracle[");
        sb.append(this.m_connectionURL);
        try {
            StringBuffer logBuffer = new StringBuffer(50);
            logBuffer.append("# Connections: ").append(this.m_ds.getNumConnections());
            logBuffer.append(" , # Busy Connections: ").append(this.m_ds.getNumBusyConnections());
            logBuffer.append(" , # Idle Connections: ").append(this.m_ds.getNumIdleConnections());
            logBuffer.append(" , # Orphaned Connections: ").append(this.m_ds.getNumUnclosedOrphanedConnections());
        }
        catch (Exception e) {
            sb.append("=").append(e.getLocalizedMessage());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getStatus() {
        if (this.m_ds == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("# Connections: ").append(this.m_ds.getNumConnections());
            sb.append(" , # Busy Connections: ").append(this.m_ds.getNumBusyConnections());
            sb.append(" , # Idle Connections: ").append(this.m_ds.getNumIdleConnections());
            sb.append(" , # Orphaned Connections: ").append(this.m_ds.getNumUnclosedOrphanedConnections());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    @Override
    public String convertStatement(String oraStatement) {
        Convert.logMigrationScript(oraStatement, null);
        return oraStatement;
    }

    @Override
    public boolean isSupported(String sql) {
        return true;
    }

    @Override
    public String getConstraintType(Connection conn, String tableName, String IXName) {
        if (IXName == null || IXName.length() == 0) {
            return "0";
        }
        if (IXName.endsWith("_KEY")) {
            return "1" + IXName;
        }
        return "0";
    }

    @Override
    public String getSystemUser() {
        return "system";
    }

    @Override
    public String getSystemDatabase(String databaseName) {
        return databaseName;
    }

    @Override
    public String TO_DATE(Timestamp time, boolean dayOnly) {
        if (time == null) {
            if (dayOnly) {
                return "TRUNC(SysDate)";
            }
            return "SysDate";
        }
        StringBuffer dateString = new StringBuffer("TO_DATE('");
        String myDate = time.toString();
        if (dayOnly) {
            dateString.append(myDate.substring(0, 10));
            dateString.append("','YYYY-MM-DD')");
        } else {
            dateString.append(myDate.substring(0, myDate.indexOf(46)));
            dateString.append("','YYYY-MM-DD HH24:MI:SS')");
        }
        return dateString.toString();
    }

    @Override
    public String TO_CHAR(String columnName, int displayType, String AD_Language) {
        StringBuffer retValue = new StringBuffer("TRIM(TO_CHAR(");
        retValue.append(columnName);
        if (DisplayType.isNumeric(displayType)) {
            if (displayType == 12) {
                retValue.append(",'999G999G999G990D00'");
            } else {
                retValue.append(",'TM9'");
            }
            if (!Language.isDecimalPoint(AD_Language)) {
                retValue.append(",'NLS_NUMERIC_CHARACTERS='',.'''");
            }
        } else if (DisplayType.isDate(displayType)) {
            retValue.append(",'").append(Language.getLanguage(AD_Language).getDBdatePattern()).append("'");
        }
        retValue.append("))");
        return retValue.toString();
    }

    @Override
    public String TO_NUMBER(BigDecimal number, int displayType) {
        if (number == null) {
            return "NULL";
        }
        BigDecimal result = number;
        int scale = DisplayType.getDefaultPrecision(displayType);
        if (scale > number.scale()) {
            try {
                result = number.setScale(scale, 4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result.toString();
    }

    @Override
    public String[] getCommands(int cmdType) {
        if (cmdType == 0) {
            return new String[0];
        }
        if (1 == cmdType) {
            return new String[0];
        }
        if (2 == cmdType) {
            return new String[0];
        }
        return null;
    }

    @Override
    public DataSource getDataSource(CConnection connection) {
        if (this.m_ds != null) {
            return this.m_ds;
        }
        try {
            System.setProperty("com.mchange.v2.log.MLog", "com.mchange.v2.log.FallbackMLog");
            ComboPooledDataSource cpds = new ComboPooledDataSource();
            cpds.setDataSourceName("AdempiereDS");
            cpds.setDriverClass(DRIVER);
            cpds.setJdbcUrl(this.getConnectionURL(connection));
            cpds.setUser(connection.getDbUid());
            cpds.setPassword(connection.getDbPwd());
            cpds.setPreferredTestQuery("SELECT Version FROM AD_System");
            cpds.setIdleConnectionTestPeriod(1200);
            cpds.setAcquireRetryAttempts(2);
            if (Ini.isClient()) {
                cpds.setInitialPoolSize(1);
                cpds.setMinPoolSize(1);
                cpds.setMaxPoolSize(150);
                cpds.setMaxIdleTimeExcessConnections(1200);
                cpds.setMaxIdleTime(1200);
                m_maxbusyconnections = 120;
            } else {
                cpds.setInitialPoolSize(10);
                cpds.setMinPoolSize(5);
                cpds.setMaxPoolSize(150);
                cpds.setMaxIdleTimeExcessConnections(1200);
                cpds.setMaxIdleTime(1200);
                m_maxbusyconnections = 120;
            }
            this.m_ds = cpds;
        }
        catch (Exception ex) {
            this.m_ds = null;
            System.err.println("Could not initialise C3P0 Datasource: " + ex.getLocalizedMessage());
        }
        return this.m_ds;
    }

    @Override
    public Connection getCachedConnection(CConnection connection, boolean autoCommit, int transactionIsolation) throws Exception {
        Connection conn = null;
        Exception exception = null;
        try {
            block13: {
                if (this.m_ds == null) {
                    this.getDataSource(connection);
                }
                try {
                    conn = this.m_ds.getConnection();
                    if (conn != null) {
                        if (conn.getTransactionIsolation() != transactionIsolation) {
                            conn.setTransactionIsolation(transactionIsolation);
                        }
                        if (conn.getAutoCommit() != autoCommit) {
                            conn.setAutoCommit(autoCommit);
                        }
                    }
                }
                catch (Exception e) {
                    exception = e;
                    conn = null;
                    if (!DBException.isInvalidUserPassError(e)) break block13;
                    System.err.println("Cannot connect to database: " + this.getConnectionURL(connection) + " - UserID=" + connection.getDbUid());
                }
            }
            if (conn == null && exception != null) {
                System.err.println(exception.toString());
            }
        }
        catch (Exception e) {
            exception = e;
        }
        try {
            int numConnections;
            if (conn != null && (numConnections = this.m_ds.getNumBusyConnections()) >= m_maxbusyconnections && m_maxbusyconnections > 0) {
                log.warning(this.getStatus());
                Runtime.getRuntime().runFinalization();
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
        if (exception != null) {
            throw exception;
        }
        return conn;
    }

    @Override
    public Connection getDriverConnection(CConnection connection) throws SQLException {
        this.getDriver();
        return DriverManager.getConnection(this.getConnectionURL(connection), connection.getDbUid(), connection.getDbPwd());
    }

    @Override
    public Connection getDriverConnection(String dbUrl, String dbUid, String dbPwd) throws SQLException {
        this.getDriver();
        return DriverManager.getConnection(dbUrl, dbUid, dbPwd);
    }

    @Override
    public void close() {
        log.config(this.toString());
        if (this.m_ds != null) {
            try {
                this.m_ds.close();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not close Data Source");
            }
        }
        this.m_ds = null;
    }

    public void cleanup() {
    }

    public String getDataType(String columnName, int displayType, int precision, boolean defaultValue) {
        String retValue = null;
        if (columnName != null && displayType == 28 && columnName.endsWith("_ID")) {
            retValue = "NUMBER(10)";
        }
        if (retValue == null) {
            switch (displayType) {
                case 13: 
                case 18: 
                case 19: 
                case 21: 
                case 25: 
                case 27: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 35: {
                    retValue = "NUMBER(10)";
                    break;
                }
                case 12: {
                    retValue = "NUMBER";
                    if (!defaultValue) break;
                    retValue = String.valueOf(retValue) + " DEFAULT 0";
                    break;
                }
                case 23: {
                    retValue = "BLOB";
                    break;
                }
                case 28: {
                    retValue = "CHAR(1)";
                    break;
                }
                case 37: {
                    retValue = "NUMBER";
                    if (!defaultValue) break;
                    retValue = String.valueOf(retValue) + " DEFAULT 0";
                    break;
                }
                case 15: 
                case 16: 
                case 24: {
                    retValue = "DATE";
                    if (!defaultValue) break;
                    retValue = String.valueOf(retValue) + " DEFAULT SYSDATE";
                    break;
                }
                case 11: {
                    retValue = "NUMBER(10)";
                    break;
                }
                case 17: {
                    retValue = "CHAR(" + precision + ")";
                    break;
                }
                case 10: 
                case 14: 
                case 34: {
                    retValue = "NVARCHAR(" + precision + ")";
                    break;
                }
                case 36: {
                    retValue = "CLOB";
                    break;
                }
                case 29: {
                    retValue = "NUMBER";
                    break;
                }
                case 20: {
                    retValue = "CHAR(1)";
                    break;
                }
                default: {
                    log.severe("Unknown: " + displayType);
                }
            }
        }
        return retValue;
    }

    @Override
    public String getAlternativeSQL(int reExNo, String msg, String sql) {
        return null;
    }

    public static void main(String[] args) {
        Adempiere.startupEnvironment(true);
        CConnection cc = CConnection.get();
        DB_Oracle db = (DB_Oracle)cc.getDatabase();
        db.cleanup();
        try {
            Connection conn = null;
            DataSource ds = db.getDataSource(cc);
            System.out.println("DS=" + ds.getConnection());
            conn = db.getCachedConnection(cc, true, 2);
            System.out.println("Cached=" + conn);
            System.out.println(db);
            System.out.println("JAVA classpath: [\n" + System.getProperty("java.class.path") + "\n]");
            DatabaseMetaData dmd = conn.getMetaData();
            System.out.println("DriverVersion: [" + dmd.getDriverVersion() + "]");
            System.out.println("DriverMajorVersion: [" + dmd.getDriverMajorVersion() + "]");
            System.out.println("DriverMinorVersion: [" + dmd.getDriverMinorVersion() + "]");
            System.out.println("DriverName: [" + dmd.getDriverName() + "]");
            System.out.println("ProductName: [" + dmd.getDatabaseProductName() + "]");
            System.out.println("ProductVersion: [\n" + dmd.getDatabaseProductVersion() + "\n]");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        db.cleanup();
        System.out.println("--------------------------------------------------");
        try {
            String myString1 = "123456789 12345678";
            String myString = "";
            int i = 0;
            while (i < 99) {
                myString = String.valueOf(myString) + myString1 + (char)(97 + i) + "\n";
                ++i;
            }
            System.out.println(myString.length());
            System.out.println(Util.size(myString));
            myString = Util.trimSize(myString, 2000);
            System.out.println(myString.length());
            System.out.println(Util.size(myString));
            Connection conn2 = db.getCachedConnection(cc, true, 2);
            PreparedStatement pstmt = conn2.prepareStatement("INSERT INTO X_Test(Text1, Text2) values(?,?)");
            pstmt.setString(1, myString);
            pstmt.setString(2, myString);
            System.out.println(pstmt.executeUpdate());
            Statement stmt = conn2.createStatement();
            System.out.println(stmt.executeUpdate("INSERT INTO X_Test(Text1, Text2) values('" + myString + "','" + myString + "')"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        db.cleanup();
        System.out.println("--------------------------------------------------");
        System.exit(0);
        System.out.println("--------------------------------------------------");
        try {
            Connection conn1 = db.getCachedConnection(cc, false, 2);
            Connection conn2 = db.getCachedConnection(cc, true, 2);
            Connection conn3 = db.getCachedConnection(cc, false, 2);
            System.out.println("3 -> " + db);
            conn1.close();
            conn2.close();
            conn1 = db.getCachedConnection(cc, true, 2);
            conn2 = db.getCachedConnection(cc, true, 2);
            System.out.println("3 -> " + db);
            conn1.close();
            conn2.close();
            conn3.close();
            System.out.println("0 -> " + db);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        db.cleanup();
        System.out.println("--------------------------------------------------");
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.getConnectionRO());
        System.out.println(DB.getConnectionRW());
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.createConnection(false, 2));
        System.out.println(DB.createConnection(false, 2));
        System.out.println(db);
        try {
            System.out.println("-- Sleeping --");
            Thread.sleep(60000L);
            System.out.println(db);
            db.close();
            db.cleanup();
            System.out.println(db);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public Convert getConvert() {
        return this.m_convert;
    }

    @Override
    public int getNextID(String Name) {
        int m_sequence_id = DB.getSQLValue(null, "SELECT " + Name.toUpperCase() + ".nextval FROM DUAL");
        return m_sequence_id;
    }

    @Override
    public boolean createSequence(String name, int increment, int minvalue, int maxvalue, int start, String trxName) {
        int no = DB.executeUpdate("DROP SEQUENCE " + name.toUpperCase(), trxName);
        no = DB.executeUpdateEx("CREATE SEQUENCE " + name.toUpperCase() + " MINVALUE " + minvalue + " MAXVALUE " + maxvalue + " START WITH " + start + " INCREMENT BY " + increment + " CACHE 20", trxName);
        return no != -1;
    }

    @Override
    public boolean isQueryTimeoutSupported() {
        return true;
    }

    @Override
    public String addPagingSQL(String sql, int start, int end) {
        return sql;
    }

    @Override
    public boolean isPagingSupported() {
        return false;
    }
}

