/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.Component;
import java.awt.Frame;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.search.Info;
import org.compiere.apps.search.Info_Column;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VNumber;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MQuery;
import org.compiere.swing.CLabel;
import org.compiere.swing.CTextField;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class InfoPayment
extends Info {
    private static final long serialVersionUID = -2917241055484901704L;
    private Info_Column[] m_generalLayout;
    private ArrayList m_queryColumns = new ArrayList();
    private String m_tableName;
    private String m_keyColumn;
    private CLabel lDocumentNo = new CLabel(Msg.translate(Env.getCtx(), "DocumentNo"));
    private CTextField fDocumentNo = new CTextField(10);
    private CLabel lBPartner_ID = new CLabel(Msg.translate(Env.getCtx(), "BPartner"));
    private VLookup fBPartner_ID;
    private CLabel lDateFrom = new CLabel(Msg.translate(Env.getCtx(), "DateTrx"));
    private VDate fDateFrom = new VDate("DateFrom", false, false, true, 15, Msg.translate(Env.getCtx(), "DateFrom"));
    private CLabel lDateTo = new CLabel("-");
    private VDate fDateTo = new VDate("DateTo", false, false, true, 15, Msg.translate(Env.getCtx(), "DateTo"));
    private CLabel lAmtFrom = new CLabel(Msg.translate(Env.getCtx(), "PayAmt"));
    private VNumber fAmtFrom = new VNumber("AmtFrom", false, false, true, 12, Msg.translate(Env.getCtx(), "AmtFrom"));
    private CLabel lAmtTo = new CLabel("-");
    private VNumber fAmtTo = new VNumber("AmtTo", false, false, true, 12, Msg.translate(Env.getCtx(), "AmtTo"));
    private VCheckBox fIsReceipt = new VCheckBox("IsReceipt", false, false, true, Msg.translate(Env.getCtx(), "IsReceipt"), "", false);
    private static final Info_Column[] s_paymentLayout = new Info_Column[]{new Info_Column(" ", "p.C_Payment_ID", IDColumn.class), new Info_Column(Msg.translate(Env.getCtx(), "C_BankAccount_ID"), "(SELECT b.Name || ' ' || ba.AccountNo FROM C_Bank b, C_BankAccount ba WHERE b.C_Bank_ID=ba.C_Bank_ID AND ba.C_BankAccount_ID=p.C_BankAccount_ID)", String.class), new Info_Column(Msg.translate(Env.getCtx(), "C_BPartner_ID"), "(SELECT Name FROM C_BPartner bp WHERE bp.C_BPartner_ID=p.C_BPartner_ID)", String.class), new Info_Column(Msg.translate(Env.getCtx(), "DateTrx"), "p.DateTrx", Timestamp.class), new Info_Column(Msg.translate(Env.getCtx(), "DocumentNo"), "p.DocumentNo", String.class), new Info_Column(Msg.translate(Env.getCtx(), "IsReceipt"), "p.IsReceipt", Boolean.class), new Info_Column(Msg.translate(Env.getCtx(), "C_Currency_ID"), "(SELECT ISO_Code FROM C_Currency c WHERE c.C_Currency_ID=p.C_Currency_ID)", String.class), new Info_Column(Msg.translate(Env.getCtx(), "PayAmt"), "p.PayAmt", BigDecimal.class), new Info_Column(Msg.translate(Env.getCtx(), "ConvertedAmount"), "currencyBase(p.PayAmt,p.C_Currency_ID,p.DateTrx, p.AD_Client_ID,p.AD_Org_ID)", BigDecimal.class), new Info_Column(Msg.translate(Env.getCtx(), "DiscountAmt"), "p.DiscountAmt", BigDecimal.class), new Info_Column(Msg.translate(Env.getCtx(), "WriteOffAmt"), "p.WriteOffAmt", BigDecimal.class), new Info_Column(Msg.translate(Env.getCtx(), "IsAllocated"), "p.IsAllocated", Boolean.class)};

    protected InfoPayment(Frame frame, boolean modal, int WindowNo, String value, boolean multiSelection, String whereClause) {
        super(frame, modal, WindowNo, "p", "C_Payment_ID", multiSelection, whereClause);
        this.log.info("InfoPayment");
        this.setTitle(Msg.getMsg(Env.getCtx(), "InfoPayment"));
        try {
            this.statInit();
            this.p_loadedOK = this.initInfo();
        }
        catch (Exception e) {
            return;
        }
        int no = this.p_table.getRowCount();
        this.setStatusLine(Integer.toString(no) + " " + Msg.getMsg(Env.getCtx(), "SearchRows_EnterQuery"), false);
        this.setStatusDB(Integer.toString(no));
        if (value != null && value.length() > 0) {
            this.fDocumentNo.setValue(value);
            this.executeQuery();
        }
        this.pack();
        this.fDocumentNo.requestFocus();
    }

    private void statInit() throws Exception {
        this.lDocumentNo.setLabelFor(this.fDocumentNo);
        this.fDocumentNo.setBackground(AdempierePLAF.getInfoBackground());
        this.fDocumentNo.addActionListener(this);
        this.fIsReceipt.setSelected(!"N".equals(Env.getContext(Env.getCtx(), this.p_WindowNo, "IsSOTrx")));
        this.fIsReceipt.addActionListener(this);
        this.fBPartner_ID = new VLookup("C_BPartner_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, 3499, 30));
        this.lBPartner_ID.setLabelFor(this.fBPartner_ID);
        this.fBPartner_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.lDateFrom.setLabelFor(this.fDateFrom);
        this.fDateFrom.setBackground(AdempierePLAF.getInfoBackground());
        this.fDateFrom.setToolTipText(Msg.translate(Env.getCtx(), "DateFrom"));
        this.lDateTo.setLabelFor(this.fDateTo);
        this.fDateTo.setBackground(AdempierePLAF.getInfoBackground());
        this.fDateTo.setToolTipText(Msg.translate(Env.getCtx(), "DateTo"));
        this.lAmtFrom.setLabelFor(this.fAmtFrom);
        this.fAmtFrom.setBackground(AdempierePLAF.getInfoBackground());
        this.fAmtFrom.setToolTipText(Msg.translate(Env.getCtx(), "AmtFrom"));
        this.lAmtTo.setLabelFor(this.fAmtTo);
        this.fAmtTo.setBackground(AdempierePLAF.getInfoBackground());
        this.fAmtTo.setToolTipText(Msg.translate(Env.getCtx(), "AmtTo"));
        this.parameterPanel.setLayout(new ALayout());
        this.parameterPanel.add((Component)this.lDocumentNo, new ALayoutConstraint(0, 0));
        this.parameterPanel.add((Component)this.fDocumentNo, null);
        this.parameterPanel.add((Component)this.lBPartner_ID, null);
        this.parameterPanel.add((Component)this.fBPartner_ID, null);
        this.parameterPanel.add((Component)this.fIsReceipt, new ALayoutConstraint(0, 5));
        this.parameterPanel.add((Component)this.lDateFrom, new ALayoutConstraint(1, 2));
        this.parameterPanel.add((Component)this.fDateFrom, null);
        this.parameterPanel.add((Component)this.lDateTo, null);
        this.parameterPanel.add((Component)this.fDateTo, null);
        this.parameterPanel.add((Component)this.lAmtFrom, new ALayoutConstraint(2, 2));
        this.parameterPanel.add((Component)this.fAmtFrom, null);
        this.parameterPanel.add((Component)this.lAmtTo, null);
        this.parameterPanel.add((Component)this.fAmtTo, null);
    }

    private boolean initInfo() {
        String bp = Env.getContext(Env.getCtx(), this.p_WindowNo, "C_BPartner_ID");
        if (bp != null && bp.length() != 0) {
            this.fBPartner_ID.setValue(new Integer(bp));
        }
        StringBuffer where = new StringBuffer("p.IsActive='Y'");
        if (this.p_whereClause.length() > 0) {
            where.append(" AND ").append(Util.replace(this.p_whereClause, "C_Payment.", "p."));
        }
        this.prepareTable(s_paymentLayout, " C_Payment_v p", where.toString(), "2,3,4");
        return true;
    }

    @Override
    protected String getSQLWhere() {
        Comparable<Date> to;
        Comparable<Date> from;
        StringBuffer sql = new StringBuffer();
        if (this.fDocumentNo.getText().length() > 0) {
            sql.append(" AND UPPER(p.DocumentNo) LIKE ?");
        }
        if (this.fBPartner_ID.getValue() != null) {
            sql.append(" AND p.C_BPartner_ID=?");
        }
        if (this.fDateFrom.getValue() != null || this.fDateTo.getValue() != null) {
            from = (Timestamp)this.fDateFrom.getValue();
            to = (Timestamp)this.fDateTo.getValue();
            if (from == null && to != null) {
                sql.append(" AND TRUNC(p.DateTrx) <= ?");
            } else if (from != null && to == null) {
                sql.append(" AND TRUNC(p.DateTrx) >= ?");
            } else if (from != null && to != null) {
                sql.append(" AND TRUNC(p.DateTrx) BETWEEN ? AND ?");
            }
        }
        if (this.fAmtFrom.getValue() != null || this.fAmtTo.getValue() != null) {
            from = (BigDecimal)this.fAmtFrom.getValue();
            to = (BigDecimal)this.fAmtTo.getValue();
            if (from == null && to != null) {
                sql.append(" AND p.PayAmt <= ?");
            } else if (from != null && to == null) {
                sql.append(" AND p.PayAmt >= ?");
            } else if (from != null && to != null) {
                sql.append(" AND p.PayAmt BETWEEN ? AND ?");
            }
        }
        sql.append(" AND p.IsReceipt=?");
        this.log.fine(sql.toString());
        return sql.toString();
    }

    @Override
    protected void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        Comparable<Date> to;
        Comparable<Date> from;
        int index = 1;
        if (this.fDocumentNo.getText().length() > 0) {
            pstmt.setString(index++, this.getSQLText(this.fDocumentNo));
        }
        if (this.fBPartner_ID.getValue() != null) {
            Integer bp = (Integer)this.fBPartner_ID.getValue();
            pstmt.setInt(index++, bp);
            this.log.fine("BPartner=" + bp);
        }
        if (this.fDateFrom.getValue() != null || this.fDateTo.getValue() != null) {
            from = (Timestamp)this.fDateFrom.getValue();
            to = (Timestamp)this.fDateTo.getValue();
            this.log.fine("Date From=" + from + ", To=" + to);
            if (from == null && to != null) {
                pstmt.setTimestamp(index++, (Timestamp)to);
            } else if (from != null && to == null) {
                pstmt.setTimestamp(index++, (Timestamp)from);
            } else if (from != null && to != null) {
                pstmt.setTimestamp(index++, (Timestamp)from);
                pstmt.setTimestamp(index++, (Timestamp)to);
            }
        }
        if (this.fAmtFrom.getValue() != null || this.fAmtTo.getValue() != null) {
            from = (BigDecimal)this.fAmtFrom.getValue();
            to = (BigDecimal)this.fAmtTo.getValue();
            this.log.fine("Amt From=" + from + ", To=" + to);
            if (from == null && to != null) {
                pstmt.setBigDecimal(index++, (BigDecimal)to);
            } else if (from != null && to == null) {
                pstmt.setBigDecimal(index++, (BigDecimal)from);
            } else if (from != null && to != null) {
                pstmt.setBigDecimal(index++, (BigDecimal)from);
                pstmt.setBigDecimal(index++, (BigDecimal)to);
            }
        }
        pstmt.setString(index++, this.fIsReceipt.isSelected() ? "Y" : "N");
    }

    private String getSQLText(CTextField f) {
        String s = f.getText().toUpperCase();
        if (!s.endsWith("%")) {
            s = s + "%";
        }
        this.log.fine("String=" + s);
        return s;
    }

    @Override
    protected void zoom() {
        this.log.info("InfoPayment.zoom");
        Integer C_Payment_ID = this.getSelectedRowKey();
        if (C_Payment_ID == null) {
            return;
        }
        MQuery query = new MQuery("C_Payment");
        query.addRestriction("C_Payment_ID", "=", C_Payment_ID);
        query.setRecordCount(1);
        int AD_WindowNo = this.getAD_Window_ID("C_Payment", this.fIsReceipt.isSelected());
        this.zoom(AD_WindowNo, query);
    }

    @Override
    protected boolean hasZoom() {
        return true;
    }
}

