/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import org.compiere.apps.ADialog;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.Allocation;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MInOut;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.compiere.util.Util;

public class VPickingManWindsord
extends Allocation
implements FormPanel,
ActionListener,
VetoableChangeListener {
    private CPanel panel = new CPanel();
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel parameterPanel = new CPanel();
    private CPanel allocationPanel = new CPanel();
    private GridBagLayout parameterLayout = new GridBagLayout();
    private JLabel bpartnerLabel = new JLabel();
    private VLookup bpartnerSearch = null;
    private MiniTable inoutTable = new MiniTable();
    private CPanel inoutPanel = new CPanel();
    private JLabel inoutLabel = new JLabel();
    private BorderLayout inoutLayout = new BorderLayout();
    private JLabel inoutInfo = new JLabel();
    private JScrollPane inoutScrollPane = new JScrollPane();
    private GridBagLayout allocationLayout = new GridBagLayout();
    private JButton setButton = new JButton();
    private StatusBar statusBar = new StatusBar();
    private CLabel dateFromLabel = new CLabel(Msg.translate(Env.getCtx(), "DateOrdered"));
    protected VDate dateFromField = new VDate("DateFrom", false, false, true, 15, Msg.translate(Env.getCtx(), "DateFrom"));
    private CLabel dateToLabel = new CLabel("-");
    protected VDate dateToField = new VDate("DateTo", false, false, true, 15, Msg.translate(Env.getCtx(), "DateTo"));
    private JLabel organizationLabel = new JLabel();
    private VLookup organizationPick = null;
    private JLabel pickmanLabel = new JLabel();
    private VLookup pickmanPick = null;

    @Override
    public void init(int WindowNo, FormFrame frame) {
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        Env.setContext(Env.getCtx(), this.m_WindowNo, "IsSOTrx", "Y");
        try {
            super.dynInit();
            this.dynInit();
            this.jbInit();
            frame.getContentPane().add((Component)this.mainPanel, "Center");
            frame.getContentPane().add((Component)this.statusBar, "South");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    private void jbInit() throws Exception {
        CompiereColor.setBackground(this.panel);
        this.mainPanel.setLayout(this.mainLayout);
        this.parameterPanel.setLayout(this.parameterLayout);
        this.allocationPanel.setLayout(this.allocationLayout);
        this.bpartnerLabel.setText(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        this.inoutLabel.setRequestFocusEnabled(false);
        this.inoutLabel.setText("Despachos");
        this.pickmanLabel.setText("Pickeador");
        this.inoutPanel.setLayout(this.inoutLayout);
        this.inoutInfo.setHorizontalAlignment(4);
        this.inoutInfo.setHorizontalTextPosition(4);
        this.inoutInfo.setText(".");
        this.setButton.setText(Msg.getMsg(Env.getCtx(), "Set Pickeador"));
        this.setButton.addActionListener(this);
        this.inoutScrollPane.setPreferredSize(new Dimension(200, 200));
        this.mainPanel.add((Component)this.parameterPanel, "North");
        this.organizationLabel.setText(Msg.translate(Env.getCtx(), "AD_Org_ID"));
        this.parameterPanel.add((Component)this.organizationLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.organizationPick, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.bpartnerLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.bpartnerSearch, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateFromLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateFromField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateToLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateToField, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.allocationPanel, "South");
        this.allocationPanel.add((Component)this.pickmanLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.allocationPanel.add((Component)this.pickmanPick, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.allocationPanel.add((Component)this.setButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.inoutPanel.add((Component)this.inoutLabel, "North");
        this.inoutPanel.add((Component)this.inoutInfo, "South");
        this.inoutPanel.add((Component)this.inoutScrollPane, "Center");
        this.inoutScrollPane.getViewport().add((Component)this.inoutTable, null);
        this.mainPanel.add((Component)this.inoutPanel, "Center");
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void dynInit() throws Exception {
        int AD_Column_ID = 839;
        MLookup lookupOrg = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, AD_Column_ID, 19);
        this.organizationPick = new VLookup("AD_Org_ID", true, false, true, lookupOrg);
        this.organizationPick.setValue(Env.getAD_Org_ID(Env.getCtx()));
        this.organizationPick.addVetoableChangeListener(this);
        AD_Column_ID = 1009452;
        MLookup lookuppickman = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, AD_Column_ID, 19);
        this.pickmanPick = new VLookup("M_SHIPMAN_ID", true, false, true, lookuppickman);
        AD_Column_ID = 3499;
        MLookup lookupBP = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, AD_Column_ID, 30);
        this.bpartnerSearch = new VLookup("C_BPartner_ID", true, false, true, lookupBP);
        this.bpartnerSearch.addVetoableChangeListener(this);
        this.statusBar.setStatusDB("");
        this.dateFromField.addVetoableChangeListener(this);
        this.dateToField.addVetoableChangeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.config("");
        if (e.getSource().equals(this.setButton)) {
            if (this.pickmanPick.getValue() == null) {
                ADialog.warn(this.m_WindowNo, this.panel, "Debe seleccionar Pickeador");
            } else {
                this.setButton.setEnabled(false);
                this.saveData();
                this.loadInOut();
                this.setButton.setEnabled(true);
            }
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        log.config(String.valueOf(name) + "=" + value);
        if (value == null) {
            return;
        }
        if (name.equals("AD_Org_ID")) {
            this.m_AD_Org_ID = value == null ? 0 : (Integer)value;
            this.loadInOut();
        }
        if (name.equals("C_BPartner_ID")) {
            this.bpartnerSearch.setValue(value);
            this.m_C_BPartner_ID = (Integer)value;
            this.loadInOut();
        }
        if (e.equals(this.dateToField) || e.equals(this.dateFromField)) {
            this.loadInOut();
        }
    }

    public void loadInOut() {
        this.checkBPartner();
        Vector<Vector<Object>> data = this.getInOutData();
        Vector<String> columnNames = this.getInOutColumnNames();
        DefaultTableModel modelI = new DefaultTableModel(data, columnNames);
        this.inoutTable.setModel(modelI);
        this.setInOutColumnClass();
    }

    public void saveData() {
        try {
            Trx.run(new TrxRunnable(){

                @Override
                public void run(String trxName) {
                    VPickingManWindsord.this.statusBar.setStatusLine(VPickingManWindsord.this.saveData(trxName));
                }
            });
        }
        catch (Exception e) {
            ADialog.error(this.m_WindowNo, this.panel, "Error", e.getLocalizedMessage());
            return;
        }
    }

    public String saveData(String trxName) {
        int i = 0;
        while (i < this.inoutTable.getRowCount()) {
            if (((Boolean)this.inoutTable.getValueAt(i, 0)).booleanValue()) {
                KeyNamePair pp = (KeyNamePair)this.inoutTable.getValueAt(i, 2);
                int InOut_ID = pp.getKey();
                MInOut out = new MInOut(Env.getCtx(), InOut_ID, trxName);
                out.set_CustomColumn("M_SHIPMAN_ID", (Integer)this.pickmanPick.getValue());
                if (!out.save()) {
                    log.log(Level.SEVERE, "InOut not saved" + i);
                }
            }
            ++i;
        }
        return "";
    }

    public Vector<Vector<Object>> getInOutData() {
        Vector<Vector<Object>> data = new Vector<Vector<Object>>();
        StringBuffer sql = new StringBuffer("SELECT o.M_InOut_ID, o.Ad_Org_ID, o.DocumentNo, o.DateOrdered, bp.name, w.Name as Warehouse, s.Name as Shipper, c.Documentno as SalesOrder FROM M_InOut o INNER JOIN C_BPartner bp ON (o.C_BPartner_ID=bp.C_BPartner_ID)  INNER join M_Warehouse w ON (o.M_Warehouse_ID=w.M_Warehouse_ID)  Left Outer join M_SHIPMAN s ON (s.M_SHIPMAN_ID=o.M_SHIPMAN_ID)  Left Outer join C_Order c ON (o.C_Order_ID=c.C_Order_ID)  WHERE o.DocStatus = 'IP' and o.MovementType='C-'");
        if (this.m_AD_Org_ID > 0) {
            sql.append(" and o.AD_Org_ID=?");
        }
        if (this.m_C_BPartner_ID > 0) {
            sql.append(" and o.C_BPartner_ID=?");
        }
        if (this.dateFromField != null || this.dateToField != null) {
            Timestamp from = (Timestamp)this.dateFromField.getValue();
            Timestamp to = (Timestamp)this.dateToField.getValue();
            if (from == null && to != null) {
                sql.append(" AND TRUNC(o.DateOrdered) <= ?");
            } else if (from != null && to == null) {
                sql.append(" AND TRUNC(o.DateOrdered) >= ?");
            } else if (from != null && to != null) {
                sql.append(" AND TRUNC(o.DateOrdered) BETWEEN ? AND ?");
            }
        }
        log.fine("PaySQL=" + sql.toString());
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            int i = 1;
            if (this.m_AD_Org_ID > 0) {
                pstmt.setInt(i++, this.m_AD_Org_ID);
            }
            if (this.m_C_BPartner_ID > 0) {
                pstmt.setInt(i++, this.m_C_BPartner_ID);
            }
            if (this.dateFromField != null || this.dateToField != null) {
                Timestamp from = (Timestamp)this.dateFromField.getValue();
                Timestamp to = (Timestamp)this.dateToField.getValue();
                log.fine("Date From=" + from + ", To=" + to);
                if (from == null && to != null) {
                    pstmt.setTimestamp(i++, to);
                } else if (from != null && to == null) {
                    pstmt.setTimestamp(i++, from);
                } else if (from != null && to != null) {
                    pstmt.setTimestamp(i++, from);
                    pstmt.setTimestamp(i++, to);
                }
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>();
                line.add(new Boolean(false));
                line.add(rs.getTimestamp(4));
                KeyNamePair pp = new KeyNamePair(rs.getInt(1), rs.getString(3));
                line.add(pp);
                line.add(rs.getString(6));
                line.add(rs.getString(5));
                line.add(rs.getString(8));
                line.add(rs.getString(7));
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        return data;
    }

    public Vector<String> getInOutColumnNames() {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
        columnNames.add(Msg.translate(Env.getCtx(), "Date"));
        columnNames.add(Util.cleanAmp(Msg.translate(Env.getCtx(), "DocumentNo")));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Bodega"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Cliente"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Orden de Venta"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Pickeador"));
        return columnNames;
    }

    public void setInOutColumnClass() {
        int i = 0;
        this.inoutTable.setColumnClass(i++, Boolean.class, false);
        this.inoutTable.setColumnClass(i++, Timestamp.class, true);
        this.inoutTable.setColumnClass(i++, String.class, true);
        this.inoutTable.setColumnClass(i++, String.class, false);
        this.inoutTable.setColumnClass(i++, String.class, false);
        this.inoutTable.setColumnClass(i++, String.class, false);
        this.inoutTable.setColumnClass(i++, String.class, false);
        this.inoutTable.autoSize();
    }
}

