/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.logging.Level;
import javax.swing.JSplitPane;
import org.adempiere.pdf.Document;
import org.adempiere.pdf.viewer.PDFViewerBean;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.Archive;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VString;
import org.compiere.grid.ed.VText;
import org.compiere.model.MArchive;
import org.compiere.swing.CButton;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTabbedPane;
import org.compiere.swing.CTextField;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class ArchiveViewer
extends Archive
implements FormPanel,
ActionListener,
VetoableChangeListener {
    private static final long serialVersionUID = 876677286190292132L;
    private CTabbedPane panel = new CTabbedPane();
    private FormFrame m_frame;
    private CPanel queryPanel = new CPanel(new GridBagLayout());
    private CCheckBox reportField = new CCheckBox(Msg.translate(Env.getCtx(), "IsReport"));
    private CLabel processLabel = new CLabel(Msg.translate(Env.getCtx(), "AD_Process_ID"));
    private CComboBox processField = null;
    private CLabel tableLabel = new CLabel(Msg.translate(Env.getCtx(), "AD_Table_ID"));
    private CComboBox tableField = null;
    private CLabel bPartnerLabel = new CLabel(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
    private VLookup bPartnerField = null;
    private CLabel nameQLabel = new CLabel(Msg.translate(Env.getCtx(), "Name"));
    private CTextField nameQField = new CTextField(15);
    private CLabel descriptionQLabel = new CLabel(Msg.translate(Env.getCtx(), "Description"));
    private CTextField descriptionQField = new CTextField(15);
    private CLabel helpQLabel = new CLabel(Msg.translate(Env.getCtx(), "Help"));
    private CTextField helpQField = new CTextField(15);
    private CLabel createdByQLabel = new CLabel(Msg.translate(Env.getCtx(), "CreatedBy"));
    private CComboBox createdByQField = null;
    private CLabel createdQLabel = new CLabel(Msg.translate(Env.getCtx(), "Created"));
    private VDate createdQFrom = new VDate();
    private VDate createdQTo = new VDate();
    private CPanel viewPanel = new CPanel(new BorderLayout(5, 5));
    private JSplitPane viewPanelSplit = new JSplitPane(1);
    private PDFViewerBean pdfViewer = Document.getViewer();
    private CPanel viewEnterPanel = new CPanel(new GridBagLayout());
    private CButton bBack = new CButton(Env.getImageIcon("wfBack24.gif"));
    private CButton bNext = new CButton(Env.getImageIcon("wfNext24.gif"));
    private CLabel positionInfo = new CLabel(".");
    private CLabel createdByLabel = new CLabel(Msg.translate(Env.getCtx(), "CreatedBy"));
    private CTextField createdByField = new CTextField(20);
    private VDate createdField = new VDate();
    private CLabel nameLabel = new CLabel(Msg.translate(Env.getCtx(), "Name"));
    private VString nameField = new VString("Name", true, false, true, 20, 60, null, null);
    private CLabel descriptionLabel = new CLabel(Msg.translate(Env.getCtx(), "Description"));
    private VText descriptionField = new VText("Description", false, false, true, 20, 255);
    private CLabel helpLabel = new CLabel(Msg.translate(Env.getCtx(), "Help"));
    private VText helpField = new VText("Help", false, false, true, 20, 2000);
    private CButton updateArchive = ConfirmPanel.createOKButton(Msg.getMsg(Env.getCtx(), "Update"));
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);

    @Override
    public void init(int WindowNo, FormFrame frame) {
        log.info("");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        try {
            this.dynInit();
            this.jbInit();
            frame.getContentPane().add((Component)this.panel, "Center");
            frame.getContentPane().add((Component)this.confirmPanel, "South");
            this.m_frame.setIconImage(Env.getImage("Archive16.gif"));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "init", e);
        }
    }

    private void dynInit() {
        this.processField = new CComboBox(this.getProcessData());
        this.tableField = new CComboBox(this.getTableData());
        this.createdByQField = new CComboBox(this.getUserData());
        this.bPartnerField = VLookup.createBPartner(this.m_WindowNo);
    }

    private void jbInit() throws Exception {
        int line = 0;
        this.queryPanel.add((Component)this.reportField, new GridBagConstraints(0, line, 3, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.reportField.addActionListener(this);
        this.queryPanel.add((Component)this.processLabel, new GridBagConstraints(0, ++line, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.queryPanel.add((Component)this.processField, new GridBagConstraints(1, line, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.queryPanel.add((Component)this.bPartnerLabel, new GridBagConstraints(0, ++line, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.queryPanel.add((Component)this.bPartnerField, new GridBagConstraints(1, line, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.queryPanel.add((Component)this.tableLabel, new GridBagConstraints(0, ++line, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.queryPanel.add((Component)this.tableField, new GridBagConstraints(1, line, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.queryPanel.add((Component)this.nameQLabel, new GridBagConstraints(0, ++line, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 0, 5), 0, 0));
        this.queryPanel.add((Component)this.nameQField, new GridBagConstraints(1, line, 2, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.queryPanel.add((Component)this.descriptionQLabel, new GridBagConstraints(0, ++line, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.queryPanel.add((Component)this.descriptionQField, new GridBagConstraints(1, line, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.queryPanel.add((Component)this.helpQLabel, new GridBagConstraints(0, ++line, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.queryPanel.add((Component)this.helpQField, new GridBagConstraints(1, line, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.queryPanel.add((Component)this.createdByQLabel, new GridBagConstraints(0, ++line, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 0, 5), 0, 0));
        this.queryPanel.add((Component)this.createdByQField, new GridBagConstraints(1, line, 2, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        this.queryPanel.add((Component)this.createdQLabel, new GridBagConstraints(0, ++line, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.queryPanel.add((Component)this.createdQFrom, new GridBagConstraints(1, line, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.queryPanel.add((Component)this.createdQTo, new GridBagConstraints(2, line, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.queryPanel, "Query");
        line = 0;
        this.viewPanel.add((Component)this.viewPanelSplit, "Center");
        this.viewPanelSplit.setLeftComponent(this.pdfViewer);
        this.bBack.addActionListener(this);
        this.bNext.addActionListener(this);
        this.positionInfo.setFontBold(true);
        this.positionInfo.setHorizontalAlignment(0);
        this.viewEnterPanel.add((Component)this.bBack, new GridBagConstraints(0, line, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.viewEnterPanel.add((Component)this.positionInfo, new GridBagConstraints(1, line, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.viewEnterPanel.add((Component)this.bNext, new GridBagConstraints(2, line, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.createdByField.setReadWrite(false);
        this.createdField.setReadWrite(false);
        this.nameField.addVetoableChangeListener(this);
        this.descriptionField.addVetoableChangeListener(this);
        this.helpField.addVetoableChangeListener(this);
        this.viewEnterPanel.add((Component)this.createdByLabel, new GridBagConstraints(0, ++line, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.viewEnterPanel.add((Component)this.createdByField, new GridBagConstraints(0, ++line, 3, 1, 0.0, 0.0, 17, 2, new Insets(2, 0, 0, 5), 0, 0));
        this.viewEnterPanel.add((Component)this.createdField, new GridBagConstraints(0, ++line, 3, 1, 0.0, 0.0, 13, 0, new Insets(2, 0, 0, 5), 0, 0));
        this.viewEnterPanel.add((Component)this.nameLabel, new GridBagConstraints(0, ++line, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.viewEnterPanel.add((Component)this.nameField, new GridBagConstraints(0, ++line, 3, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 5), 0, 0));
        this.viewEnterPanel.add((Component)this.descriptionLabel, new GridBagConstraints(0, ++line, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.viewEnterPanel.add((Component)this.descriptionField, new GridBagConstraints(0, ++line, 3, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 5), 0, 0));
        this.viewEnterPanel.add((Component)this.helpLabel, new GridBagConstraints(0, ++line, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.viewEnterPanel.add((Component)this.helpField, new GridBagConstraints(0, ++line, 3, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 5), 0, 0));
        this.viewEnterPanel.add((Component)this.updateArchive, new GridBagConstraints(0, ++line, 3, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.viewEnterPanel.setPreferredSize(new Dimension(220, 500));
        this.updateArchive.addActionListener(this);
        this.viewPanelSplit.setRightComponent(this.viewEnterPanel);
        this.panel.add((Component)this.viewPanel, "View");
        this.confirmPanel.addActionListener(this);
        this.updateQDisplay();
        this.panel.setPreferredSize(new Dimension(720, 500));
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.info(e.getActionCommand());
        if (e.getSource() == this.updateArchive) {
            this.cmd_updateArchive();
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        } else if (e.getActionCommand().equals("Ok")) {
            if (this.panel.getSelectedIndex() == 1) {
                this.dispose();
            } else {
                this.cmd_query();
            }
        } else if (e.getSource() == this.reportField) {
            this.updateQDisplay();
        } else if (e.getSource() == this.bBack) {
            this.updateVDisplay(false);
        } else if (e.getSource() == this.bNext) {
            this.updateVDisplay(true);
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (this.m_archives.length > 0) {
            this.updateArchive.setEnabled(true);
        }
    }

    private void updateQDisplay() {
        boolean reports = this.reportField.isSelected();
        log.config("Reports=" + reports);
        this.processLabel.setVisible(reports);
        this.processField.setVisible(reports);
        this.bPartnerLabel.setVisible(!reports);
        this.bPartnerField.setVisible(!reports);
    }

    private void updateVDisplay(boolean next) {
        if (this.m_archives == null) {
            this.m_archives = new MArchive[0];
        }
        this.m_index = next ? ++this.m_index : --this.m_index;
        if (this.m_index >= this.m_archives.length - 1) {
            this.m_index = this.m_archives.length - 1;
        }
        if (this.m_index < 0) {
            this.m_index = 0;
        }
        this.bBack.setEnabled(this.m_index > 0);
        this.bNext.setEnabled(this.m_index < this.m_archives.length - 1);
        this.updateArchive.setEnabled(false);
        log.info("Index=" + this.m_index + ", Length=" + this.m_archives.length);
        if (this.m_archives.length == 0) {
            this.positionInfo.setText("No Record Found");
            this.createdByField.setText("");
            this.createdField.setValue(null);
            this.nameField.setText("");
            this.descriptionField.setText("");
            this.helpField.setText("");
            this.pdfViewer.clearDocument();
            return;
        }
        this.positionInfo.setText(this.m_index + 1 + " of " + this.m_archives.length);
        MArchive ar = this.m_archives[this.m_index];
        this.createdByField.setText(ar.getCreatedByName());
        this.createdField.setValue(ar.getCreated());
        this.nameField.setText(ar.getName());
        this.descriptionField.setText(ar.getDescription());
        this.helpField.setText(ar.getHelp());
        try {
            InputStream in = ar.getInputStream();
            this.pdfViewer.setScale(this.reportField.isSelected() ? 50 : 75);
            if (in != null) {
                this.pdfViewer.loadPDF(in);
            } else {
                this.pdfViewer.clearDocument();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "pdf", e);
            this.pdfViewer.clearDocument();
        }
    }

    private void cmd_updateArchive() {
        String newText;
        MArchive ar = this.m_archives[this.m_index];
        boolean update = false;
        if (!this.isSame(this.nameField.getText(), ar.getName()) && (newText = this.nameField.getText()) != null && newText.length() > 0) {
            ar.setName(newText);
            update = true;
        }
        if (!this.isSame(this.descriptionField.getText(), ar.getDescription())) {
            ar.setDescription(this.descriptionField.getText());
            update = true;
        }
        if (!this.isSame(this.helpField.getText(), ar.getHelp())) {
            ar.setHelp(this.helpField.getText());
            update = true;
        }
        log.info("Update=" + update);
        if (update) {
            ar.save();
        }
        ++this.m_index;
        this.updateVDisplay(false);
    }

    public void query(boolean isReport, int AD_Table_ID, int Record_ID) {
        log.config("Report=" + isReport + ", AD_Table_ID=" + AD_Table_ID + ",Record_ID=" + Record_ID);
        this.reportField.setSelected(isReport);
        this.m_AD_Table_ID = AD_Table_ID;
        this.m_Record_ID = Record_ID;
        this.cmd_query();
    }

    private void cmd_query() {
        boolean reports = this.reportField.isSelected();
        KeyNamePair process = (KeyNamePair)this.processField.getSelectedItem();
        KeyNamePair table2 = (KeyNamePair)this.tableField.getSelectedItem();
        Integer C_BPartner_ID = (Integer)this.bPartnerField.getValue();
        String name = this.nameQField.getText();
        String description = this.descriptionQField.getText();
        String help = this.helpQField.getText();
        KeyNamePair createdBy = (KeyNamePair)this.createdByQField.getSelectedItem();
        Timestamp createdFrom = this.createdQFrom.getTimestamp();
        Timestamp createdTo = this.createdQTo.getTimestamp();
        this.cmd_query(reports, process, table2, C_BPartner_ID, name, description, help, createdBy, createdFrom, createdTo);
        this.panel.setSelectedIndex(1);
        this.m_index = 1;
        this.updateVDisplay(false);
    }
}

