/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.Component;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JFileChooser;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.ExtensionFileFilter;
import org.compiere.util.Msg;

public class ScreenShot {
    private static CLogger log = CLogger.getCLogger(ScreenShot.class);

    public static boolean createJPEG(Window window, String fileName) {
        Iterator<ImageWriter> writers;
        ImageWriter writer;
        File file;
        if (window == null || fileName == null) {
            new IllegalArgumentException("ScreenShot.createJPEG Window os NULL");
        }
        if ((file = ScreenShot.getJPGFile(window)) == null) {
            return false;
        }
        log.config("File=" + file);
        if (file.exists()) {
            file.delete();
        }
        if ((writer = (writers = ImageIO.getImageWritersByFormatName("jpg")).next()) == null) {
            log.log(Level.SEVERE, "no ImageWriter");
            return false;
        }
        BufferedImage bi = ScreenShot.getImage(window);
        try {
            ImageOutputStream ios = ImageIO.createImageOutputStream(file);
            writer.setOutput(ios);
            writer.write(bi);
            ios.flush();
            ios.close();
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, "ex", ex);
            return false;
        }
        return true;
    }

    protected static File getJPGFile(Component parent) {
        JFileChooser fc = new JFileChooser();
        fc.addChoosableFileFilter(new ExtensionFileFilter("jpg", Msg.getMsg(Env.getCtx(), "FileJPEG")));
        if (fc.showSaveDialog(parent) != 0) {
            return null;
        }
        File file = fc.getSelectedFile();
        if (file == null) {
            return null;
        }
        String fileName = file.getAbsolutePath();
        if (!fileName.toUpperCase().equals(".JPG") && !fileName.toUpperCase().equals(".JPEG")) {
            fileName = fileName + ".jpg";
        }
        return new File(fileName);
    }

    protected static BufferedImage getImage(Window window) {
        BufferedImage bi = new BufferedImage(window.getWidth(), window.getHeight(), 1);
        window.paintAll(bi.createGraphics());
        return bi;
    }
}

