/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.JLabel;
import org.adempiere.exceptions.DBException;
import org.compiere.apps.ADialog;
import org.compiere.apps.IProcessParameter;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VEditorFactory;
import org.compiere.model.GridField;
import org.compiere.model.GridFieldVO;
import org.compiere.model.MClient;
import org.compiere.model.MPInstancePara;
import org.compiere.process.ProcessInfo;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ProcessParameterPanel
extends CPanel
implements VetoableChangeListener,
IProcessParameter {
    private int m_WindowNo;
    private ProcessInfo m_processInfo;
    private static CLogger log = CLogger.getCLogger(ProcessParameterPanel.class);
    private GridBagConstraints gbc = new GridBagConstraints();
    private Insets nullInset = new Insets(0, 0, 0, 0);
    private Insets labelInset = new Insets(2, 12, 2, 0);
    private Insets fieldInset = new Insets(2, 5, 2, 0);
    private Insets fieldInsetRight = new Insets(2, 5, 2, 12);
    private int m_line = 0;
    private ArrayList<VEditor> m_vEditors = new ArrayList();
    private ArrayList<VEditor> m_vEditors2 = new ArrayList();
    private ArrayList<GridField> m_mFields = new ArrayList();
    private ArrayList<GridField> m_mFields2 = new ArrayList();
    private ArrayList<JLabel> m_separators = new ArrayList();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel centerPanel = new CPanel();
    private GridBagLayout centerLayout = new GridBagLayout();

    public ProcessParameterPanel(int WindowNo, ProcessInfo pi) {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage());
        }
        this.m_WindowNo = WindowNo;
        this.m_processInfo = pi;
    }

    void jbInit() throws Exception {
        this.setLayout(this.mainLayout);
        this.centerPanel.setLayout(this.centerLayout);
        this.add((Component)this.centerPanel, "Center");
    }

    public void dispose() {
        this.m_vEditors.clear();
        this.m_vEditors2.clear();
        this.m_mFields.clear();
        this.m_mFields2.clear();
        this.m_separators.clear();
        this.removeAll();
    }

    public boolean init() {
        log.config("");
        this.gbc.anchor = 18;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.gridy = this.m_line++;
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 1;
        this.gbc.insets = this.nullInset;
        this.gbc.fill = 2;
        this.centerPanel.add(Box.createVerticalStrut(10), this.gbc);
        MClient client = MClient.get(Env.getCtx());
        String ASPFilter = "";
        if (client.isUseASP()) {
            ASPFilter = "   AND (   p.AD_Process_Para_ID IN (               SELECT pp.AD_Process_Para_ID                 FROM ASP_Process_Para pp, ASP_Process p, ASP_Level l, ASP_ClientLevel cl                WHERE p.ASP_Level_ID = l.ASP_Level_ID                  AND cl.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND cl.ASP_Level_ID = l.ASP_Level_ID " + "                 AND pp.ASP_Process_ID = p.ASP_Process_ID " + "                 AND pp.IsActive = 'Y' " + "                 AND p.IsActive = 'Y' " + "                 AND l.IsActive = 'Y' " + "                 AND cl.IsActive = 'Y' " + "                 AND pp.ASP_Status = 'S') " + "        OR p.AD_Process_Para_ID IN ( " + "              SELECT AD_Process_Para_ID " + "                FROM ASP_ClientException ce " + "               WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "                 AND ce.IsActive = 'Y' " + "                 AND ce.AD_Process_Para_ID IS NOT NULL " + "                 AND ce.AD_Tab_ID IS NULL " + "                 AND ce.AD_Field_ID IS NULL " + "                 AND ce.ASP_Status = 'S') " + "       ) " + "   AND p.AD_Process_Para_ID NOT IN ( " + "          SELECT AD_Process_Para_ID " + "            FROM ASP_ClientException ce " + "           WHERE ce.AD_Client_ID = " + client.getAD_Client_ID() + "             AND ce.IsActive = 'Y' " + "             AND ce.AD_Process_Para_ID IS NOT NULL " + "             AND ce.AD_Tab_ID IS NULL " + "             AND ce.AD_Field_ID IS NULL " + "             AND ce.ASP_Status = 'H')";
        }
        String sql = null;
        sql = Env.isBaseLanguage(Env.getCtx(), "AD_Process_Para") ? "SELECT p.Name, p.Description, p.Help, p.AD_Reference_ID, p.AD_Process_Para_ID, p.FieldLength, p.IsMandatory, p.IsRange, p.ColumnName, p.DefaultValue, p.DefaultValue2, p.VFormat, p.ValueMin, p.ValueMax, p.SeqNo, p.AD_Reference_Value_ID, vr.Code AS ValidationCode, p.ReadOnlyLogic, p.DisplayLogic FROM AD_Process_Para p LEFT OUTER JOIN AD_Val_Rule vr ON (p.AD_Val_Rule_ID=vr.AD_Val_Rule_ID) WHERE p.AD_Process_ID=? AND p.IsActive='Y' " + ASPFilter + " ORDER BY SeqNo" : "SELECT t.Name, t.Description, t.Help, p.AD_Reference_ID, p.AD_Process_Para_ID, p.FieldLength, p.IsMandatory, p.IsRange, p.ColumnName, p.DefaultValue, p.DefaultValue2, p.VFormat, p.ValueMin, p.ValueMax, p.SeqNo, p.AD_Reference_Value_ID, vr.Code AS ValidationCode, p.ReadOnlyLogic, p.DisplayLogic FROM AD_Process_Para p INNER JOIN AD_Process_Para_Trl t ON (p.AD_Process_Para_ID=t.AD_Process_Para_ID) LEFT OUTER JOIN AD_Val_Rule vr ON (p.AD_Val_Rule_ID=vr.AD_Val_Rule_ID) WHERE p.AD_Process_ID=? AND t.AD_Language='" + Env.getAD_Language(Env.getCtx()) + "'" + " AND p.IsActive='Y' " + ASPFilter + " ORDER BY SeqNo";
        boolean hasFields = false;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.m_processInfo.getAD_Process_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                hasFields = true;
                this.createField(rs);
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (this.m_mFields.size() != this.m_mFields2.size() || this.m_mFields.size() != this.m_vEditors.size() || this.m_mFields2.size() != this.m_vEditors2.size()) {
            log.log(Level.SEVERE, "View & Model vector size is different");
        }
        if (hasFields) {
            this.gbc.gridy = this.m_line++;
            this.centerPanel.add(Box.createVerticalStrut(10), this.gbc);
            this.gbc.gridx = 3;
            this.centerPanel.add(Box.createHorizontalStrut(12), this.gbc);
            this.dynamicDisplay();
        } else {
            this.dispose();
        }
        return hasFields;
    }

    private void createField(ResultSet rs) {
        GridFieldVO voF = GridFieldVO.createParameter(Env.getCtx(), this.m_WindowNo, rs);
        GridField mField = new GridField(voF);
        this.m_mFields.add(mField);
        this.gbc.gridy = this.m_line++;
        this.gbc.gridwidth = 1;
        this.gbc.fill = 2;
        this.gbc.gridx = 0;
        this.gbc.weightx = 0.0;
        CLabel label = VEditorFactory.getLabel(mField);
        if (label == null) {
            this.gbc.insets = this.nullInset;
            this.centerPanel.add(Box.createHorizontalStrut(12), this.gbc);
        } else {
            this.gbc.insets = this.labelInset;
            this.centerPanel.add((Component)label, this.gbc);
        }
        this.gbc.insets = this.fieldInset;
        this.gbc.fill = 2;
        this.gbc.gridwidth = 1;
        this.gbc.gridx = 1;
        this.gbc.weightx = 1.0;
        VEditor vEditor = VEditorFactory.getEditor(mField, false);
        vEditor.addVetoableChangeListener(this);
        mField.addPropertyChangeListener(vEditor);
        this.centerPanel.add((Component)((Object)vEditor), this.gbc);
        this.m_vEditors.add(vEditor);
        Object defaultObject = mField.getDefault();
        mField.setValue(defaultObject, true);
        if (voF.isRange) {
            this.gbc.gridx = 2;
            this.gbc.weightx = 0.0;
            this.gbc.fill = 0;
            JLabel dash = new JLabel(" - ");
            this.centerPanel.add((Component)dash, this.gbc);
            this.m_separators.add(dash);
            this.gbc.gridx = 3;
            this.gbc.insets = this.fieldInsetRight;
            this.gbc.weightx = 1.0;
            this.gbc.fill = 2;
            this.gbc.anchor = 17;
            GridFieldVO voF2 = GridFieldVO.createParameter(voF);
            GridField mField2 = new GridField(voF2);
            this.m_mFields2.add(mField2);
            VEditor vEditor2 = VEditorFactory.getEditor(mField2, false);
            mField2.addPropertyChangeListener(vEditor2);
            this.centerPanel.add((Component)((Object)vEditor2), this.gbc);
            this.m_vEditors2.add(vEditor2);
            Object defaultObject2 = mField2.getDefault();
            mField2.setValue(defaultObject2, true);
        } else {
            this.m_separators.add(null);
            this.m_mFields2.add(null);
            this.m_vEditors2.add(null);
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        this.processNewValue(evt.getNewValue(), evt.getPropertyName());
    }

    private void processNewValue(Object value, String name) {
        if (value == null) {
            value = new String("");
        }
        if (value instanceof String) {
            Env.setContext(Env.getCtx(), this.m_WindowNo, name, (String)value);
        } else if (value instanceof Integer) {
            Env.setContext(Env.getCtx(), this.m_WindowNo, name, (Integer)value);
        } else if (value instanceof Boolean) {
            Env.setContext(Env.getCtx(), this.m_WindowNo, name, (Boolean)value);
        } else if (value instanceof Timestamp) {
            Env.setContext(Env.getCtx(), this.m_WindowNo, name, (Timestamp)value);
        } else {
            Env.setContext(Env.getCtx(), this.m_WindowNo, name, value.toString());
        }
        this.dynamicDisplay();
    }

    public void dynamicDisplay() {
        Component[] comps = this.centerPanel.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            int index;
            Component comp = comps[i];
            String columnName = comp.getName();
            if (columnName == null || columnName.length() <= 0 || this.m_mFields.get(index = this.getIndex(columnName)) == null) continue;
            if (this.m_mFields.get(index).isDisplayed(true)) {
                if (!comp.isVisible()) {
                    comp.setVisible(true);
                    if (this.m_mFields.get((int)index).getVO().isRange) {
                        this.m_separators.get(index).setText(" - ");
                    }
                }
                boolean rw = this.m_mFields.get(index).isEditablePara(true);
                this.m_vEditors.get(index).setReadWrite(rw);
                if (!this.m_mFields.get((int)index).getVO().isRange) continue;
                this.m_vEditors2.get(index).setReadWrite(rw);
                continue;
            }
            if (!comp.isVisible()) continue;
            comp.setVisible(false);
            if (!this.m_mFields.get((int)index).getVO().isRange) continue;
            this.m_separators.get(index).setText("");
        }
    }

    private int getIndex(String columnName) {
        for (int i = 0; i < this.m_mFields.size(); ++i) {
            if (!this.m_mFields.get(i).getColumnName().equals(columnName)) continue;
            return i;
        }
        return 0;
    }

    @Override
    public boolean saveParameters() {
        int i;
        log.config("");
        StringBuffer sb = new StringBuffer();
        int size = this.m_mFields.size();
        for (i = 0; i < size; ++i) {
            GridField field = this.m_mFields.get(i);
            if (!field.isMandatory(true)) continue;
            VEditor vEditor = this.m_vEditors.get(i);
            Object data = vEditor.getValue();
            if (data == null || data.toString().length() == 0) {
                field.setInserting(true);
                field.setError(true);
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(field.getHeader());
            } else {
                field.setError(false);
            }
            VEditor vEditor2 = this.m_vEditors2.get(i);
            if (vEditor2 == null) continue;
            Object data2 = vEditor.getValue();
            GridField field2 = this.m_mFields2.get(i);
            if (data2 == null || data2.toString().length() == 0) {
                field.setInserting(true);
                field2.setError(true);
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(field.getHeader());
                continue;
            }
            field2.setError(false);
        }
        if (sb.length() != 0) {
            ADialog.error(this.m_WindowNo, this, "FillMandatory", sb.toString());
            return false;
        }
        for (i = 0; i < this.m_mFields.size(); ++i) {
            VEditor editor = this.m_vEditors.get(i);
            VEditor editor2 = this.m_vEditors2.get(i);
            Object result = editor.getValue();
            Object result2 = null;
            if (editor2 != null) {
                result2 = editor2.getValue();
            }
            MPInstancePara para = new MPInstancePara(Env.getCtx(), this.m_processInfo.getAD_PInstance_ID(), i);
            GridField mField = this.m_mFields.get(i);
            para.setParameterName(mField.getColumnName());
            if (result instanceof Timestamp || result2 instanceof Timestamp) {
                para.setP_Date((Timestamp)result);
                if (editor2 != null && result2 != null) {
                    para.setP_Date_To((Timestamp)result2);
                }
            } else if (result instanceof Integer || result2 instanceof Integer) {
                Integer ii;
                if (result != null) {
                    ii = (Integer)result;
                    para.setP_Number((int)ii);
                }
                if (editor2 != null && result2 != null) {
                    ii = (Integer)result2;
                    para.setP_Number_To((int)ii);
                }
            } else if (result instanceof BigDecimal || result2 instanceof BigDecimal) {
                para.setP_Number((BigDecimal)result);
                if (editor2 != null && result2 != null) {
                    para.setP_Number_To((BigDecimal)result2);
                }
            } else if (result instanceof Boolean) {
                Boolean bb = (Boolean)result;
                String value = bb != false ? "Y" : "N";
                para.setP_String(value);
            } else {
                if (result != null) {
                    para.setP_String(result.toString());
                }
                if (editor2 != null && result2 != null) {
                    para.setP_String_To(result2.toString());
                }
            }
            para.setInfo(editor.getDisplay());
            if (editor2 != null) {
                para.setInfo_To(editor2.getDisplay());
            }
            para.save();
            log.fine(para.toString());
        }
        return true;
    }

    protected void restoreContext() {
        for (GridField f : this.m_mFields) {
            if (f == null) continue;
            f.restoreValue();
        }
        for (GridField f : this.m_mFields2) {
            if (f == null) continue;
            f.restoreValue();
        }
    }
}

