/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import org.compiere.acct.DocLine;
import org.compiere.acct.Doc_HRProcess;
import org.compiere.model.MBPartner;
import org.compiere.util.Env;
import org.eevolution.model.MHRConcept;
import org.eevolution.model.MHRMovement;

public class DocLine_Payroll
extends DocLine {
    private int m_HR_Process_ID = 0;
    private int m_HR_Concept_ID = 0;
    private int m_C_BPartner_ID = 0;
    private int m_C_Activity_ID = 0;
    private String m_AccountSign = "";
    private BigDecimal m_Amount = Env.ZERO;
    private int m_HR_Department_ID = 0;
    private int m_C_BP_Group_ID = 0;

    public DocLine_Payroll(MHRMovement line, Doc_HRProcess doc) {
        super(line, doc);
        int C_BPartner_ID = line.getC_BPartner_ID();
        MBPartner bpartner = new MBPartner(Env.getCtx(), C_BPartner_ID, null);
        MHRConcept concept = MHRConcept.get(Env.getCtx(), line.getHR_Concept_ID());
        this.m_HR_Concept_ID = concept.getHR_Concept_ID();
        this.m_HR_Process_ID = line.getHR_Process_ID();
        this.m_C_BPartner_ID = C_BPartner_ID;
        this.m_HR_Department_ID = line.getHR_Department_ID();
        this.m_C_BP_Group_ID = bpartner.getC_BP_Group_ID();
        this.m_AccountSign = concept.getAccountSign();
        this.m_Amount = line.getAmount();
        this.setAmount(line.getAmount());
    }

    public int getHR_Process_ID() {
        return this.m_HR_Process_ID;
    }

    public int getHR_Concept_ID() {
        return this.m_HR_Concept_ID;
    }

    public String getAccountSign() {
        return this.m_AccountSign;
    }

    @Override
    public int getC_BPartner_ID() {
        return this.m_C_BPartner_ID;
    }

    @Override
    public int getC_Activity_ID() {
        return this.m_C_Activity_ID;
    }

    public BigDecimal getAmount() {
        return this.m_Amount;
    }

    public int getHR_Department_ID() {
        return this.m_HR_Department_ID;
    }

    public int getC_BP_Group_ID() {
        return this.m_C_BP_Group_ID;
    }
}

