/*
 * Decompiled with CFR 0.152.
 */
package org.compiere;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.model.MProductDownload;
import org.compiere.print.PrintFormatUtil;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MigrateData {
    private static CLogger log = CLogger.getCLogger(MigrateData.class);

    public MigrateData() {
        this.release252c();
        PrintFormatUtil pfu = new PrintFormatUtil(Env.getCtx());
        pfu.addMissingColumns((String)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release252c() {
        String sql = "SELECT COUNT(*) FROM M_ProductDownload";
        int no = DB.getSQLValue(null, sql);
        if (no > 0) {
            log.finer("No Need - Downloads #" + no);
            return;
        }
        int count = 0;
        sql = "SELECT AD_Client_ID, AD_Org_ID, M_Product_ID, Name, DownloadURL FROM M_Product WHERE DownloadURL IS NOT NULL";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int AD_Client_ID = rs.getInt(1);
                int AD_Org_ID = rs.getInt(2);
                int M_Product_ID = rs.getInt(3);
                String Name2 = rs.getString(4);
                String DownloadURL = rs.getString(5);
                Properties ctx = new Properties(Env.getCtx());
                Env.setContext(ctx, "#AD_Client_ID", AD_Client_ID);
                Env.setContext(ctx, "AD_Client_ID", AD_Client_ID);
                Env.setContext(ctx, "#AD_Org_ID", AD_Org_ID);
                Env.setContext(ctx, "AD_Org_ID", AD_Org_ID);
                MProductDownload pdl = new MProductDownload(ctx, 0, null);
                pdl.setM_Product_ID(M_Product_ID);
                pdl.setName(Name2);
                pdl.setDownloadURL(DownloadURL);
                if (pdl.save()) {
                    ++count;
                    String sqlUpdate = "UPDATE M_Product SET DownloadURL = NULL WHERE M_Product_ID=" + M_Product_ID;
                    int updated = DB.executeUpdate(sqlUpdate, null);
                    if (updated == 1) continue;
                    log.warning("Product not updated");
                    continue;
                }
                log.warning("Product Download not created M_Product_ID=" + M_Product_ID);
            }
        }
        catch (Exception e) {
            try {
                log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        log.info("#" + count);
    }

    public static void main(String[] args) {
        Adempiere.startup(true);
        new MigrateData();
    }
}

