/*
 * Decompiled with CFR 0.152.
 */
package org.blumos.model;

import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.blumos.model.BlumosUtilities;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MMovement;
import org.compiere.model.MOrder;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_C_ProjectOFB;
import org.compiere.model.X_T_SEGUIMIENTO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.ofb.utils.DateUtils;

public class ModBlumosEnvioCorreos
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModBlumosEnvioCorreos.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Order", this);
        engine.addModelChange("T_SEGUIMIENTO", this);
        engine.addModelChange("C_ProjectOFB", this);
        engine.addDocValidate("M_InOut", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        MUser usuarioactivo;
        CPreparedStatement pstmtSM;
        String sendMail;
        CPreparedStatement pstmtSM2;
        String sendMail2;
        MOrder order;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 2 || type == 1) && po.get_Table_ID() == MOrder.Table_ID && po.is_ValueChanged("vigila_eta") && po.getAD_Client_ID() != 1000005) {
            int id_correo;
            String el_correo;
            order = (MOrder)po;
            String subjet = "";
            String v_query = "";
            String v_via = "VIA DESCONOCIDA";
            if (order.get_ValueAsString("inco_via").compareTo("I00") == 0) {
                v_via = "AEREO";
            } else if (order.get_ValueAsString("inco_via").compareTo("I10") == 0) {
                v_via = "MARITIMO";
            } else if (order.get_ValueAsString("inco_via").compareTo("I20") == 0) {
                v_via = "TERRESTRE";
            }
            String lista = "";
            v_query = "Select substr(mp.name,0,30) as cod_blumos, col.qtyordered, cu.name from c_orderline col inner join m_product mp on (col.m_product_id=mp.m_product_id) inner join c_uom cu on (mp.c_uom_id=cu.c_uom_id) where col.c_order_id=" + order.get_ID();
            String el_detalle = "";
            MUser user = new MUser(po.getCtx(), Env.getAD_User_ID(po.getCtx()), po.get_TrxName());
            CPreparedStatement pstmt = null;
            pstmt = DB.prepareStatement(v_query, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                lista = String.valueOf(lista) + rs.getString("cod_blumos") + ", Cantidad: " + rs.getBigDecimal("qtyordered") + " " + rs.getString("name") + " \n ";
            }
            if ((order.getDocStatus().compareTo("CO") == 0 || order.getDocStatus().compareTo("IP") == 0) && order.get_ValueAsBoolean("vigila_eta") && !order.isSOTrx()) {
                subjet = "ACTIVADO CONTROL ETA_BODEGA EN OC : " + order.getDocumentNo();
                el_detalle = "<pre>Se ha Activado Control sobre ETA_BODEGA de la Orden " + order.getDocumentNo() + ", cuya ETA_BODEGA actual es " + BlumosUtilities.formatDate((Timestamp)order.get_Value("eta_bodega"), true) + " \n " + v_via + " \n " + "<b>Proveedor: " + order.getC_BPartner().getName().replace("'", "''") + "</b>" + " \n \n " + "</b>Productos afectados: \n " + lista + " \n " + "Cambio generado por <b>" + user.getName() + "</b></pre>";
                el_correo = String.valueOf(subjet) + el_detalle;
                id_correo = 1000003;
                sendMail2 = "SELECT send_mail('adempiere@blumos.cl',DAMECORREO(" + id_correo + ",'to'),DAMECORREO(" + id_correo + ",'cc'),'cmendoza@blumos.cl','" + subjet + "','" + el_correo + "')";
                pstmtSM2 = DB.prepareStatement(sendMail2, null);
                pstmtSM2.execute();
            } else if (!(order.getDocStatus().compareTo("CO") != 0 && order.getDocStatus().compareTo("IP") != 0 || order.get_ValueAsBoolean("vigila_eta") || order.isSOTrx())) {
                subjet = "DESACTIVADO CONTROL ETA_BODEGA EN OC : " + order.getDocumentNo();
                el_detalle = "<pre>Se ha DESACTIVADO Control sobre ETA_BODEGA de la Orden " + order.getDocumentNo() + ", cuya ETA_BODEGA actual es " + BlumosUtilities.formatDate((Timestamp)order.get_Value("eta_bodega"), true) + " \n " + v_via + " \n " + "<b>Proveedor: " + order.getC_BPartner().getName().replace("'", "''") + "</b>" + " \n \n " + "</b>Productos afectados: \n " + lista + " \n " + "Cambio generado por <b>" + user.getName() + "</b></pre>";
                el_correo = String.valueOf(subjet) + el_detalle;
                id_correo = 1000004;
                sendMail2 = "SELECT send_mail('adempiere@blumos.cl',DAMECORREO(" + id_correo + ",'to'),DAMECORREO(" + id_correo + ",'cc'),'cmendoza@blumos.cl','" + subjet + "','" + el_correo + "')";
                pstmtSM2 = DB.prepareStatement(sendMail2, null);
                pstmtSM2.execute();
            }
        }
        if (!(type != 2 && type != 1 || po.get_Table_ID() != MOrder.Table_ID || !po.is_ValueChanged("ETA_Bodega") || po.getAD_Client_ID() == 1000005 || (order = (MOrder)po).getDocStatus().compareTo("CO") != 0 && order.getDocStatus().compareTo("IP") != 0 || order.isSOTrx())) {
            Timestamp newEta = (Timestamp)order.get_Value("ETA_Bodega");
            Timestamp oldEta = (Timestamp)order.get_ValueOld("ETA_Bodega");
            int dif_dias = (int)DateUtils.getDifferenceDays(newEta, oldEta);
            String la_frase = "Dias de Atraso: ";
            if (newEta.compareTo(oldEta) < 0) {
                la_frase = "Dias de ADELANTO ";
            } else {
                dif_dias *= -1;
            }
            if ((dif_dias > 2 && order.get_ValueAsString("inco_via").compareTo("I10") != 0 || dif_dias > 6 && order.get_ValueAsString("inco_via").compareTo("I10") == 0 || order.get_ValueAsBoolean("vigila_eta")) && order.getAD_Client_ID() == 1000000) {
                MUser user = new MUser(po.getCtx(), Env.getAD_User_ID(po.getCtx()), po.get_TrxName());
                String v_via = "VIA DESCONOCIDA";
                if (order.get_ValueAsString("inco_via").compareTo("I00") == 0) {
                    v_via = "AEREO";
                } else if (order.get_ValueAsString("inco_via").compareTo("I10") == 0) {
                    v_via = "MARITIMO";
                } else if (order.get_ValueAsString("inco_via").compareTo("I20") == 0) {
                    v_via = "TERRESTRE";
                }
                String v_texto = "";
                v_texto = order.get_ValueAsBoolean("vigila_eta") ? " (Sujeta a Control de ETA_Bodega)" : "";
                String el_subjet = "CAMBIO ETA_BODEGA OC: " + order.getDocumentNo();
                String v_query = "";
                String lista = "";
                v_query = "Select substr(mp.name,0,30) as cod_blumos, col.qtyordered, cu.name from c_orderline col inner join m_product mp on (col.m_product_id=mp.m_product_id) inner join c_uom cu on (mp.c_uom_id=cu.c_uom_id) where col.c_order_id=" + order.get_ID();
                CPreparedStatement pstmt = null;
                pstmt = DB.prepareStatement(v_query, null);
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    lista = String.valueOf(lista) + rs.getString("cod_blumos") + ", Cantidad: " + rs.getBigDecimal("qtyordered") + " " + rs.getString("name") + " \n ";
                }
                String el_detalle = "<pre>Se ha cambiado la ETA_BODEGA de la Orden " + order.getDocumentNo() + v_texto + ", desde <b>" + BlumosUtilities.formatDate(oldEta, true) + " a " + BlumosUtilities.formatDate(newEta, true) + " \n " + la_frase + Math.abs(dif_dias) + " , Via: " + v_via + " \n " + "<b>Proveedor: " + order.getC_BPartner().getName().replace("'", "''") + "</b>" + " \n \n" + "</b>Productos afectados: \n" + lista + " \n " + "Cambio generado por <b>" + user.getName() + "</b></pre>";
                String el_correo = String.valueOf(el_subjet) + el_detalle;
                int id_correo = 1000002;
                String sendMail3 = "SELECT send_mail('adempiere@blumos.cl',DAMECORREO(" + id_correo + ",'to'),DAMECORREO(" + id_correo + ",'cc'),'cmendoza@blumos.cl','" + el_subjet + "','" + el_correo + "')";
                CPreparedStatement pstmtSM3 = DB.prepareStatement(sendMail3, null);
                pstmtSM3.execute();
            }
        }
        if ((type == 2 || type == 1) && po.get_Table_ID() == MOrder.Table_ID && po.is_ValueChanged("ISAPPROVED") && po.getAD_Client_ID() != 1000005) {
            order = (MOrder)po;
            String el_subjet = "";
            String el_detalle = "";
            String el_correo = "";
            String v_query = "";
            int id_correo = 0;
            String desc = " ";
            if (order.getDescription() != null && order.getDescription().trim().length() > 0) {
                desc = order.getDescription();
            }
            if (order.get_ValueAsBoolean("ISAPPROVED") && (order.getDocStatus().compareTo("DR") == 0 || order.getDocStatus().compareTo("IP") == 0)) {
                String sendMail4;
                ResultSet rs2;
                CPreparedStatement pstmt2;
                MUser user = new MUser(po.getCtx(), Env.getAD_User_ID(po.getCtx()), po.get_TrxName());
                String v_turno = "";
                v_turno = (DateUtils.now().getHours() == 9 && DateUtils.now().getMinutes() > 0 || DateUtils.now().getHours() > 9) && DateUtils.now().getHours() < 15 ? (order.getDeliveryViaRule().compareTo("V") == 0 ? "TARDE" : "MA\u00d1ANA") : (order.getDeliveryViaRule().compareTo("V") == 0 ? "MA\u00d1ANA" : "TARDE");
                v_query = "Select mp.m_product_id, mp.name as producto, mp.solutec, col.qtyordered, col.priceentered, col.datepromised  from c_orderline col inner join m_product mp ON (col.m_product_id=mp.m_product_id) where mp.solutec='Y' AND col.C_ORDER_ID=" + order.get_ID();
                int v_control = 0;
                el_subjet = "Venta Solutec NV " + order.getDocumentNo();
                CPreparedStatement pstmt = null;
                pstmt = DB.prepareStatement(v_query, null);
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    ++v_control;
                    el_detalle = String.valueOf(el_detalle) + "\n Fecha Prometida linea: " + BlumosUtilities.formatDate(rs.getTimestamp("datepromised"), true) + " Producto: " + rs.getString("producto") + " - Cantidad ordenada: " + rs.getBigDecimal("qtyordered").setScale(2, RoundingMode.HALF_EVEN).toString().replace(".", ",") + " - Valor Unitario: " + rs.getBigDecimal("priceentered") + " " + order.getC_Currency().getISO_Code();
                }
                el_detalle = String.valueOf(el_detalle) + "\n" + "Orden generada por " + user.getName() + " el " + BlumosUtilities.formatDateFull(DateUtils.now(), true);
                el_correo = "<pre>" + el_subjet + ", Fecha de la Orden: " + BlumosUtilities.formatDate(order.getDateOrdered(), true) + ", Fecha Prometida: " + BlumosUtilities.formatDate(order.getDatePromised(), true) + " Turno: " + v_turno + " \n " + "Cliente: " + order.getC_BPartner().getName().replace("'", "''") + ". Vendedor: " + order.getSalesRep().getName() + "\n" + "Descripci\u00f3n: " + desc + " \n\n" + "Detalle de la Orden: " + " \n" + el_detalle;
                if (v_control > 0) {
                    id_correo = 1000005;
                    sendMail = "SELECT send_mail('adempiere@blumos.cl',DAMECORREO(" + id_correo + ",'to'),damemail(" + user.get_ID() + ",0)||','|| DAMECORREO(" + id_correo + ",'cc'),'cmendoza@blumos.cl','" + el_subjet + "','" + el_correo + "</pre>')";
                    pstmtSM = DB.prepareStatement(sendMail, null);
                    pstmtSM.execute();
                }
                if (order.getM_Warehouse_ID() == 1000070 && order.isSOTrx()) {
                    v_query = "Select mp.m_product_id, mp.name as producto, mp.solutec, col.qtyordered, col.priceentered from c_orderline col inner join m_product mp ON (col.m_product_id=mp.m_product_id) where col.C_ORDER_ID=" + order.get_ID();
                    el_subjet = "Venta FARMA: " + order.getDocumentNo();
                    el_detalle = "";
                    pstmt2 = null;
                    pstmt2 = DB.prepareStatement(v_query, null);
                    rs2 = pstmt2.executeQuery();
                    while (rs2.next()) {
                        el_detalle = " Producto: " + rs2.getString("producto") + " - Cantidad ordenada: " + rs2.getBigDecimal("qtyordered").setScale(2, RoundingMode.HALF_EVEN).toString().replace(".", ",") + " - Valor Unitario: " + rs2.getBigDecimal("priceentered") + " " + order.getC_Currency().getISO_Code() + " \n";
                    }
                    el_detalle = String.valueOf(el_detalle) + "\n" + "Orden generada por " + user.getName() + " el " + BlumosUtilities.formatDateFull(DateUtils.now(), true);
                    el_correo = "<pre>" + el_subjet + ", Fecha de la Orden: " + BlumosUtilities.formatDate(order.getDateOrdered(), true) + ", Fecha Prometida: " + BlumosUtilities.formatDate(order.getDatePromised(), true) + "\n" + "Cliente: " + order.getC_BPartner().getName().replace("'", "''") + ". Vendedor: " + order.getSalesRep().getName() + "\n" + "Descripci\u00f3n: " + desc + "\n \n" + "Detalle de la Orden: " + "\n" + el_detalle;
                    id_correo = 1000047;
                    sendMail4 = "SELECT send_mail('adempiere@blumos.cl',DAMECORREO(" + id_correo + ",'to'),damemail(" + user.get_ID() + ",0)||','||DAMECORREO(" + id_correo + ",'cc'),'cmendoza@blumos.cl','" + el_subjet + "','" + el_correo + "</pre>')";
                    CPreparedStatement pstmtSM4 = DB.prepareStatement(sendMail4, null);
                    pstmtSM4.execute();
                }
                if (order.getDeliveryViaRule().compareTo("P") == 0) {
                    v_query = "Select mp.m_product_id, mp.name as producto, mp.solutec, col.qtyordered, col.priceentered from c_orderline col inner join m_product mp ON (col.m_product_id=mp.m_product_id) where col.C_ORDER_ID=" + order.get_ID();
                    el_subjet = "Venta RETIRA NV: " + order.getDocumentNo();
                    el_detalle = "";
                    pstmt2 = null;
                    pstmt2 = DB.prepareStatement(v_query, null);
                    rs2 = pstmt2.executeQuery();
                    while (rs2.next()) {
                        el_detalle = "Producto: " + rs2.getString("producto") + " - Cantidad ordenada: " + rs2.getBigDecimal("qtyordered") + " - Valor Unitario: " + rs2.getBigDecimal("priceentered") + " " + order.getC_Currency().getISO_Code() + " \n";
                    }
                    el_detalle = String.valueOf(el_detalle) + "\n" + "Orden generada por " + user.getName() + " el " + BlumosUtilities.formatDateFull(DateUtils.now(), true);
                    el_correo = "<pre>" + el_subjet + ", Fecha de la Orden: " + BlumosUtilities.formatDate(order.getDateOrdered(), true) + ", Fecha Prometida: " + BlumosUtilities.formatDate(order.getDatePromised(), true) + "\n" + "Cliente: " + order.getC_BPartner().getName().replace("'", "''") + ". Vendedor: " + order.getSalesRep().getName() + "\n" + "Descripci\u00f3n: " + desc + "\n \n" + "Detalle de la Orden: " + "\n" + el_detalle;
                    id_correo = 1000006;
                    sendMail4 = "SELECT send_mail('adempiere@blumos.cl',DAMECORREO(" + id_correo + ",'to'),DAMECORREO(" + id_correo + ",'cc'),'cmendoza@blumos.cl','" + el_subjet + "','" + el_correo + "</pre>')";
                    CPreparedStatement pstmtSM5 = DB.prepareStatement(sendMail4, null);
                    pstmtSM5.execute();
                }
            }
        }
        if ((type == 2 || type == 1) && po.get_Table_ID() == X_T_SEGUIMIENTO.Table_ID) {
            X_T_SEGUIMIENTO seg = (X_T_SEGUIMIENTO)po;
            usuarioactivo = new MUser(po.getCtx(), Env.getAD_User_ID(po.getCtx()), po.get_TrxName());
            String destinos = "";
            String copiados = BlumosUtilities.DameMail(usuarioactivo.get_ID(), 0, po.getCtx(), po.get_TrxName());
            copiados = String.valueOf(copiados) + "," + BlumosUtilities.DameMail(seg.getC_ProjectOFB().getSalesRep_ID(), 0, po.getCtx(), po.get_TrxName());
            copiados = String.valueOf(copiados) + "," + BlumosUtilities.DameMail(seg.getC_ProjectOFB().getSalesRep().getSupervisor_ID(), 0, po.getCtx(), po.get_TrxName());
            copiados = String.valueOf(copiados) + "," + BlumosUtilities.DameMail(seg.getC_ProjectOFB_ID(), 3, po.getCtx(), po.get_TrxName());
            String subject = "Proy. " + seg.getC_ProjectOFB().getValue();
            String mensaje = "";
            String desc = "";
            String casillas_activadas = "";
            if (seg.getDescription() != null && seg.getDescription().trim().length() > 0) {
                desc = seg.getDescription();
            }
            if (seg.isSOLICITAR_MUESTRA() && !seg.isCORREO_ENVIADO()) {
                if (seg.getQTY_DELIVERED().compareTo(Env.ZERO) <= 0) {
                    return "Debe ingresar un valor positivo en campo Cantidad";
                }
                if (seg.isORIGEN_MUESTRA()) {
                    if (seg.getM_PriceList_ID().compareTo("1001715") != 0) {
                        subject = "Proy. " + seg.getC_ProjectOFB().getValue();
                        subject = "FAVOR Despachar Muestra " + subject;
                        mensaje = "<pre>" + subject + "\n\n" + "Se ha generado una solicitud de muestra para el Proyecto " + seg.getC_ProjectOFB().getValue() + "\n" + "Producto: " + seg.getM_Product().getName() + " Codigo: " + seg.getM_Product().getValue() + "\n" + "Cantidad: " + seg.getQTY_DELIVERED().setScale(2, RoundingMode.HALF_EVEN).toString().replace(".", ",") + " " + seg.getC_UOM().getName() + "\n" + "Vendedor: " + seg.getC_ProjectOFB().getSalesRep().getName() + "\n" + "Comentarios: " + desc + "\n" + "Nombre del Cliente: " + seg.getC_ProjectOFB().getC_BPartner().getName() + "\n\n" + "Solicitud generada por " + usuarioactivo.getName();
                        int id_correo = 1000010;
                        String sendMail5 = "SELECT send_mail('adempiere@blumos.cl',DAMECORREO(" + id_correo + ",'to'),'" + copiados + "','cmendoza@blumos.cl','" + subject + "','" + mensaje + "</pre>')";
                        CPreparedStatement pstmtSM6 = DB.prepareStatement(sendMail5, null);
                        pstmtSM6.execute();
                        seg.setCORREO_ENVIADO(true);
                    } else {
                        subject = "Proy. " + seg.getC_ProjectOFB().getValue();
                        subject = "FAVOR Despachar Muestra " + subject;
                        mensaje = "<pre>" + subject + "\n\n" + "Se ha generado una solicitud de muestra para el Proyecto " + seg.getC_ProjectOFB().getValue() + "\n" + "Producto: " + seg.getM_Product().getName() + " Codigo: " + seg.getM_Product().getValue() + "\n" + "Cantidad: " + seg.getQTY_DELIVERED().setScale(2, RoundingMode.HALF_EVEN).toString().replace(".", ",") + " " + seg.getC_UOM().getName() + "\n" + "Vendedor: " + seg.getC_ProjectOFB().getSalesRep().getName() + "\n" + "Comentarios: " + desc + "\n" + "Nombre del Cliente: " + seg.getC_ProjectOFB().getC_BPartner().getName() + "\n\n" + "Solicitud generada por " + usuarioactivo.getName();
                        int id_correo = 1000048;
                        String sendMail6 = "SELECT send_mail('adempiere@blumos.cl',DAMECORREO(" + id_correo + ",'to'),'" + copiados + "'||','||DAMECORREO(" + id_correo + ",'cc'),'cmendoza@blumos.cl','" + subject + "','" + mensaje + "</pre>')";
                        CPreparedStatement pstmtSM7 = DB.prepareStatement(sendMail6, null);
                        pstmtSM7.execute();
                        seg.setCORREO_ENVIADO(true);
                    }
                }
                if (seg.isBODEGA_SOLUTEC() && !seg.isORIGEN_MUESTRA()) {
                    subject = "Proy. " + seg.getC_ProjectOFB().getValue();
                    subject = "Solicitud Muestra " + subject;
                    mensaje = "<pre>Se ha generado una solicitud de muestra para el Proyecto " + seg.getC_ProjectOFB().getName().replace("'", "''") + "\n" + "Producto: " + seg.getNOMBRE_MUESTRA() + "\n" + "Cantidad: " + seg.getQTY_DELIVERED().setScale(2, RoundingMode.HALF_EVEN).toString().replace(".", ",") + " " + seg.getC_UOM().getName() + "\n" + "Vendedor: " + seg.getC_ProjectOFB().getSalesRep().getName() + "\n" + "Comentarios: " + desc + "\n\n" + "Solicitud generada por " + usuarioactivo.getName();
                    int id_correo = 1000049;
                    String sendMail7 = "SELECT send_mail('adempiere@blumos.cl',DAMECORREO(" + id_correo + ",'to'),'" + copiados + "','cmendoza@blumos.cl','" + subject + "','" + mensaje + "</pre>')";
                    CPreparedStatement pstmtSM8 = DB.prepareStatement(sendMail7, null);
                    pstmtSM8.execute();
                    seg.setCORREO_ENVIADO(true);
                    seg.setProcessed(true);
                }
            }
            if (seg.isSOLICITAR_MUESTRA() && seg.isCORREO_ENVIADO() && seg.isDESPACHADO_BODEGA()) {
                destinos = copiados;
                subject = "Proy. " + seg.getC_ProjectOFB().getValue();
                subject = "Muestra Preparada " + subject;
                mensaje = "<pre>" + subject + "\n\n" + "La Muestra solicitada ya ha sido preparada y se encuentra en bodega para su retiro. Proyecto: " + seg.getC_ProjectOFB().getName() + "\n" + "Producto: " + seg.getM_Product().getName() + " Codigo: " + seg.getM_Product().getValue() + "\n" + "Cantidad: " + seg.getQTY_DELIVERED().setScale(2, RoundingMode.HALF_EVEN).toString().replace(".", ",") + " " + seg.getC_UOM().getName() + "\n" + "Vendedor: " + seg.getC_ProjectOFB().getSalesRep().getName() + "\n" + "Comentarios: " + desc + "\n\n" + "Respuesta generada por " + usuarioactivo.getName();
                int id_correo = 1000011;
                String sendMail8 = "SELECT send_mail('adempiere@blumos.cl','" + destinos + "',DAMECORREO(" + id_correo + ",'cc'),'cmendoza@blumos.cl','" + subject + "','" + mensaje + "</pre>')";
                CPreparedStatement pstmtSM9 = DB.prepareStatement(sendMail8, null);
                pstmtSM9.execute();
                seg.setProcessed(true);
            }
            if ((seg.isVISITA() || seg.isLLAMADA() || seg.isEMail()) && (seg.getDescription() != null || seg.getRESPUESTA() != null) && !seg.isMotivo()) {
                casillas_activadas = "Marco las casillas ";
                destinos = copiados;
                copiados = "";
                X_C_ProjectOFB proOFB = new X_C_ProjectOFB(po.getCtx(), seg.getC_ProjectOFB_ID(), po.get_TrxName());
                String id_solutec1 = proOFB.get_ValueAsString("ad_user_id_solu1");
                String id_solutec2 = proOFB.get_ValueAsString("ad_user_id_solu2");
                if (id_solutec1 != null && id_solutec1.trim().length() > 0 && id_solutec2 != null && id_solutec2.trim().length() > 0) {
                    copiados = String.valueOf(BlumosUtilities.DameMail(Integer.parseInt(id_solutec1), 0, po.getCtx(), po.get_TrxName())) + "," + BlumosUtilities.DameMail(Integer.parseInt(id_solutec2), 0, po.getCtx(), po.get_TrxName());
                }
                if (id_solutec1 != null && id_solutec1.trim().length() > 0 && (id_solutec2 == null || id_solutec2.trim().length() < 1)) {
                    copiados = BlumosUtilities.DameMail(Integer.parseInt(id_solutec1), 0, po.getCtx(), po.get_TrxName());
                }
                if ((id_solutec1 == null || id_solutec1.trim().length() < 1) && id_solutec2 != null && id_solutec2.trim().length() > 0) {
                    copiados = BlumosUtilities.DameMail(Integer.parseInt(id_solutec2), 0, po.getCtx(), po.get_TrxName());
                }
                subject = "Proy. " + seg.getC_ProjectOFB().getValue();
                subject = "Nuevo Comentario en " + subject;
                if (seg.isVISITA()) {
                    casillas_activadas = String.valueOf(casillas_activadas) + " *Visita* ";
                }
                if (seg.isLLAMADA()) {
                    casillas_activadas = String.valueOf(casillas_activadas) + " *Llamada* ";
                }
                if (seg.isEMail()) {
                    casillas_activadas = String.valueOf(casillas_activadas) + " *Email* ";
                }
                mensaje = "<pre>El usuario " + usuarioactivo.getName() + " ha ingresado un nuevo comentario en el Proyecto " + seg.getC_ProjectOFB().getName() + "\n" + casillas_activadas + "\n" + "Comentario: " + desc + "\n" + "Respuesta del Cliente: " + seg.getRESPUESTA() + "\n" + "Fecha: " + BlumosUtilities.formatDate(seg.getFECHA(), true);
                seg.setProcessed(true);
                seg.setCORREO_ENVIADO(true);
                int id_correo = 1000049;
                sendMail = "SELECT send_mail('adempiere@blumos.cl','" + destinos + "','" + copiados + "','cmendoza@blumos.cl','" + subject + "','" + mensaje + "</pre>')";
                pstmtSM = DB.prepareStatement(sendMail, null);
                pstmtSM.execute();
                seg.setCORREO_ENVIADO(true);
                seg.setProcessed(true);
            }
        }
        if ((type == 5 || type == 4) && po.get_Table_ID() == X_C_ProjectOFB.Table_ID) {
            String soluName1;
            String soluNew;
            String soluOld;
            String proyName;
            String id_solutec2;
            String id_solutec1;
            X_C_ProjectOFB proy = (X_C_ProjectOFB)po;
            usuarioactivo = new MUser(po.getCtx(), Env.getAD_User_ID(po.getCtx()), po.get_TrxName());
            String destino = "";
            String copiados = "";
            String subject = "";
            String mensaje = "";
            destino = String.valueOf(BlumosUtilities.DameMail(proy.getSalesRep_ID(), 0, po.getCtx(), po.get_TrxName())) + "," + BlumosUtilities.DameMail(proy.getSalesRep().getSupervisor_ID(), 0, po.getCtx(), po.get_TrxName()) + "," + BlumosUtilities.DameMail(usuarioactivo.get_ID(), 0, po.getCtx(), po.get_TrxName()) + "," + BlumosUtilities.DameMail(proy.get_ID(), 3, po.getCtx(), po.get_TrxName());
            if (po.is_ValueChanged("projectstate")) {
                copiados = BlumosUtilities.DameMail(usuarioactivo.get_ID(), 0, po.getCtx(), po.get_TrxName());
                id_solutec1 = proy.get_ValueAsString("ad_user_id_solu1");
                id_solutec2 = proy.get_ValueAsString("ad_user_id_solu2");
                if (!BlumosUtilities.isStringNull(id_solutec1) && !BlumosUtilities.isStringNull(id_solutec2)) {
                    copiados = String.valueOf(BlumosUtilities.DameMail(Integer.parseInt(id_solutec1), 0, po.getCtx(), po.get_TrxName())) + "," + BlumosUtilities.DameMail(Integer.parseInt(id_solutec2), 0, po.getCtx(), String.valueOf(po.get_TrxName()) + "," + BlumosUtilities.DameMail(usuarioactivo.get_ID(), 0, po.getCtx(), po.get_TrxName()));
                } else if (!BlumosUtilities.isStringNull(id_solutec1) && BlumosUtilities.isStringNull(id_solutec2)) {
                    copiados = String.valueOf(BlumosUtilities.DameMail(Integer.parseInt(id_solutec1), 0, po.getCtx(), po.get_TrxName())) + "," + BlumosUtilities.DameMail(usuarioactivo.get_ID(), 0, po.getCtx(), po.get_TrxName());
                } else if (BlumosUtilities.isStringNull(id_solutec1) && !BlumosUtilities.isStringNull(id_solutec2)) {
                    copiados = String.valueOf(BlumosUtilities.DameMail(Integer.parseInt(id_solutec2), 0, po.getCtx(), po.get_TrxName())) + "," + BlumosUtilities.DameMail(usuarioactivo.get_ID(), 0, po.getCtx(), po.get_TrxName());
                }
                subject = "Proyecto " + proy.getValue() + ": Cambio ESTADO";
                proyName = proy.getName();
                if (proy.getName() != null) {
                    proyName = proyName.replace("'", "''");
                }
                mensaje = "<pre>" + subject + "\n\n" + "Ha cambiado el ESTADO del proyecto: " + proyName + "\n\n" + "Cambio desde: " + proy.get_ValueOld("projectstate") + " a: *" + proy.get_Value("projectstate") + "*" + "\n\n" + "Registro generado por: *" + usuarioactivo.getName() + "*";
                String sendMail9 = "SELECT send_mail('adempiere@blumos.cl','" + destino + "','" + copiados + "','cmendoza@blumos.cl','" + subject + "','" + mensaje + "</pre>')";
                CPreparedStatement pstmtSM10 = DB.prepareStatement(sendMail9, null);
                pstmtSM10.execute();
            }
            if (po.is_ValueChanged("etapa")) {
                copiados = BlumosUtilities.DameMail(usuarioactivo.get_ID(), 0, po.getCtx(), po.get_TrxName());
                id_solutec1 = proy.get_ValueAsString("ad_user_id_solu1");
                id_solutec2 = proy.get_ValueAsString("ad_user_id_solu2");
                if (!BlumosUtilities.isStringNull(id_solutec1) && !BlumosUtilities.isStringNull(id_solutec2)) {
                    copiados = String.valueOf(BlumosUtilities.DameMail(Integer.parseInt(id_solutec1), 0, po.getCtx(), po.get_TrxName())) + "," + BlumosUtilities.DameMail(Integer.parseInt(id_solutec2), 0, po.getCtx(), String.valueOf(po.get_TrxName()) + "," + BlumosUtilities.DameMail(usuarioactivo.get_ID(), 0, po.getCtx(), po.get_TrxName()));
                } else if (!BlumosUtilities.isStringNull(id_solutec1) && BlumosUtilities.isStringNull(id_solutec2)) {
                    copiados = String.valueOf(BlumosUtilities.DameMail(Integer.parseInt(id_solutec1), 0, po.getCtx(), po.get_TrxName())) + "," + BlumosUtilities.DameMail(usuarioactivo.get_ID(), 0, po.getCtx(), po.get_TrxName());
                } else if (BlumosUtilities.isStringNull(id_solutec1) && !BlumosUtilities.isStringNull(id_solutec2)) {
                    copiados = String.valueOf(BlumosUtilities.DameMail(Integer.parseInt(id_solutec2), 0, po.getCtx(), po.get_TrxName())) + "," + BlumosUtilities.DameMail(usuarioactivo.get_ID(), 0, po.getCtx(), po.get_TrxName());
                }
                subject = "Proyecto " + proy.getValue() + ": Cambio ETAPA";
                proyName = proy.getName();
                if (proy.getName() != null) {
                    proyName = proyName.replace("'", "''");
                }
                mensaje = "<pre>" + subject + "\n\n" + "Ha cambiado la Etapa para el proyecto: " + proyName + "\n\n" + "Cambio desde: " + proy.get_ValueOld("etapa") + " a: *" + proy.get_Value("etapa") + "*" + "\n\n" + "Registro generado por: *" + usuarioactivo.getName() + "*";
                String sendMail10 = "SELECT send_mail('adempiere@blumos.cl','" + destino + "','" + copiados + "','cmendoza@blumos.cl','" + subject + "','" + mensaje + "</pre>')";
                CPreparedStatement pstmtSM11 = DB.prepareStatement(sendMail10, null);
                pstmtSM11.execute();
            }
            if (po.is_ValueChanged("ad_user_id_solu1")) {
                soluOld = po.get_ValueOld("ad_user_id_solu1") == null ? " " : po.get_ValueOld("ad_user_id_solu1").toString();
                soluNew = po.get_Value("ad_user_id_solu1") == null ? " " : po.get_Value("ad_user_id_solu1").toString();
                soluName1 = "";
                String soluName2 = "";
                copiados = BlumosUtilities.DameMail(usuarioactivo.get_ID(), 0, po.getCtx(), po.get_TrxName());
                subject = "Proyecto " + proy.getValue() + ": Cambio Jefe SOLUTEC1";
                if (!BlumosUtilities.isStringNull(soluOld) && !BlumosUtilities.isStringNull(soluNew)) {
                    MUser userSolu1 = new MUser(po.getCtx(), Integer.parseInt(soluOld), po.get_TrxName());
                    soluName1 = userSolu1.getName();
                    MUser userSolu2 = new MUser(po.getCtx(), Integer.parseInt(soluNew), po.get_TrxName());
                    soluName2 = userSolu2.getName();
                    copiados = String.valueOf(copiados) + "," + BlumosUtilities.DameMail(Integer.parseInt(soluOld), 0, po.getCtx(), po.get_TrxName()) + "," + BlumosUtilities.DameMail(Integer.parseInt(soluNew), 0, po.getCtx(), po.get_TrxName());
                    mensaje = "<pre>" + subject + "\n\n" + "Se ha cambiado al Jefe de Proyecto de Solutec1 para el proyecto " + proy.getValue() + ":" + proy.getName().replace("'", "''") + "\n\n" + "Nuevo asignado: " + soluName2 + ". Antiguo asignado: " + soluName1 + "\n\n" + "Registro generado por: *" + usuarioactivo.getName();
                }
                if (BlumosUtilities.isStringNull(soluOld) && !BlumosUtilities.isStringNull(soluNew)) {
                    MUser userSoluNew = new MUser(po.getCtx(), Integer.parseInt(soluNew), po.get_TrxName());
                    soluName2 = userSoluNew.getName();
                    copiados = String.valueOf(copiados) + "," + BlumosUtilities.DameMail(Integer.parseInt(soluNew), 0, po.getCtx(), po.get_TrxName());
                    String proyName2 = proy.getName();
                    if (proy.getName() != null) {
                        proyName2 = proyName2.replace("'", "''");
                    }
                    mensaje = "<pre>" + subject + "\n\n" + "Se ha asignado al Jefe de Proyecto de Solutec1 para el proyecto " + proy.getValue() + ":" + proyName2 + "\n\n" + "Nuevo asignado: " + soluName2 + "\n\n" + "Registro generado por: *" + usuarioactivo.getName();
                }
                String sendMail11 = "SELECT send_mail('adempiere@blumos.cl','" + destino + "','" + copiados + "','cmendoza@blumos.cl','" + subject + "','" + mensaje + "</pre>')";
                CPreparedStatement pstmtSM12 = DB.prepareStatement(sendMail11, null);
                pstmtSM12.execute();
            }
            if (po.is_ValueChanged("ad_user_id_solu2")) {
                soluOld = "";
                soluNew = "";
                if (po.get_ValueOld("ad_user_id_solu2") != null) {
                    soluOld = po.get_ValueOld("ad_user_id_solu2").toString();
                }
                if (proy.get_Value("ad_user_id_solu2") != null) {
                    soluNew = proy.get_Value("ad_user_id_solu2").toString();
                }
                soluName1 = "";
                String soluName2 = "";
                copiados = BlumosUtilities.DameMail(usuarioactivo.get_ID(), 0, po.getCtx(), po.get_TrxName());
                subject = "Proyecto " + proy.getValue() + ": Cambio Jefe SOLUTEC1";
                String proyName3 = proy.getName();
                if (proy.getName() != null) {
                    proyName3 = proyName3.replace("'", "''");
                }
                if (!BlumosUtilities.isStringNull(soluOld) && !BlumosUtilities.isStringNull(soluNew)) {
                    MUser userSolu1 = new MUser(po.getCtx(), Integer.parseInt(soluOld), po.get_TrxName());
                    soluName1 = userSolu1.getName();
                    MUser userSolu2 = new MUser(po.getCtx(), Integer.parseInt(soluNew), po.get_TrxName());
                    soluName2 = userSolu2.getName();
                    copiados = String.valueOf(copiados) + "," + BlumosUtilities.DameMail(Integer.parseInt(soluOld), 0, po.getCtx(), po.get_TrxName()) + "," + BlumosUtilities.DameMail(Integer.parseInt(soluNew), 0, po.getCtx(), po.get_TrxName());
                    mensaje = "<pre>" + subject + "\n\n" + "Se ha cambiado al Jefe de Proyecto de Solutec1 para el proyecto " + proy.getValue() + ":" + proyName3 + "\n\n" + "Nuevo asignado: " + soluName2 + ". Antiguo asignado: " + soluName1 + "\n\n" + "Registro generado por: *" + usuarioactivo.getName();
                }
                if (BlumosUtilities.isStringNull(soluOld) && !BlumosUtilities.isStringNull(soluNew)) {
                    MUser userSoluNew = new MUser(po.getCtx(), Integer.parseInt(soluNew), po.get_TrxName());
                    soluName2 = userSoluNew.getName();
                    copiados = String.valueOf(copiados) + "," + BlumosUtilities.DameMail(Integer.parseInt(soluNew), 0, po.getCtx(), po.get_TrxName());
                    mensaje = "<pre>" + subject + "\n\n" + "Se ha asignado al Jefe de Proyecto de Solutec1 para el proyecto " + proy.getValue() + ":" + proyName3 + "\n\n" + "Nuevo asignado: " + soluName2 + "\n\n" + "Registro generado por: *" + usuarioactivo.getName();
                }
                sendMail2 = "SELECT send_mail('adempiere@blumos.cl','" + destino + "','" + copiados + "','cmendoza@blumos.cl','" + subject + "','" + mensaje + "</pre>')";
                pstmtSM2 = DB.prepareStatement(sendMail2, null);
                pstmtSM2.execute();
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MMovement mov;
        CPreparedStatement pstmtSM;
        String sendMail;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if ((timing == 7 || timing == 2) && po.get_Table_ID() == MInOut.Table_ID) {
            int v_control;
            ResultSet rs;
            CPreparedStatement pstmt;
            String v_query;
            MInOut inOut = (MInOut)po;
            String desc = " ";
            if (inOut.getDescription() != null && inOut.getDescription().trim().length() > 0) {
                desc = inOut.getDescription();
            }
            MUser user = new MUser(po.getCtx(), Env.getAD_User_ID(po.getCtx()), po.get_TrxName());
            String el_subject = "";
            String el_detalle = "";
            String el_correo = "";
            int id_correo = 0;
            if (inOut.getAD_Client_ID() == 1000005 && inOut.isSOTrx()) {
                v_query = "Select mp.m_product_id, mp.name as producto, mil.movementqty from m_inoutline mil inner join m_product mp ON (mil.m_product_id=mp.m_product_id) where mil.m_inout_id=" + inOut.get_ID();
                el_subject = "Despacho Solutec " + inOut.getDocumentNo();
                try {
                    pstmt = null;
                    pstmt = DB.prepareStatement(v_query, null);
                    rs = pstmt.executeQuery();
                    v_control = 0;
                    while (rs.next()) {
                        ++v_control;
                        el_detalle = String.valueOf(el_detalle) + "Producto: " + rs.getString("producto") + " - Cantidad despachada: " + rs.getBigDecimal("movementqty") + "\n";
                    }
                    el_detalle = String.valueOf(el_detalle) + "\n" + "Despacho generado por " + user.getName() + " el " + DateUtils.today().toString();
                    el_correo = "<pre>" + el_subject + ", Fecha de Despacho: " + inOut.getMovementDate() + "\n" + "Cliente: " + inOut.getC_BPartner().getName() + "\n" + "Descripcion: " + desc + "\n\n" + "Detalle del Despacho: " + "\n" + el_detalle;
                    if (v_control > 0) {
                        id_correo = 1000008;
                        sendMail = "SELECT send_mail('adempiere@blumos.cl',DAMECORREO(" + id_correo + ",'to'),DAMECORREO(" + id_correo + ",'cc'),'cmendoza@blumos.cl','" + el_subject + "','" + el_correo + "</pre>')";
                        pstmtSM = DB.prepareStatement(sendMail, null);
                        pstmtSM.execute();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (!(inOut.getAD_Client_ID() != 1000000 && inOut.getAD_Client_ID() != 1000001 || inOut.isSOTrx())) {
                v_query = "Select mp.m_product_id, mp.name as producto, mil.movementqty from m_inoutline mil inner join m_product mp ON (mil.m_product_id=mp.m_product_id) where mil.m_inout_id=" + inOut.get_ID();
                el_subject = "RECIBO " + inOut.getDocumentNo();
                try {
                    pstmt = null;
                    pstmt = DB.prepareStatement(v_query, null);
                    rs = pstmt.executeQuery();
                    el_detalle = "";
                    el_detalle = String.valueOf(el_detalle) + "CARPETA " + inOut.getC_Order().getDocumentNo() + "\n";
                    v_control = 0;
                    while (rs.next()) {
                        ++v_control;
                        el_detalle = String.valueOf(el_detalle) + "Producto: " + rs.getString("producto") + " - Cantidad Recibida: " + rs.getBigDecimal("movementqty") + "\n";
                    }
                    el_detalle = String.valueOf(el_detalle) + "\n" + "Despacho generado por " + user.getName() + " el " + DateUtils.today().toString();
                    el_correo = "<pre>" + el_subject + ", Fecha de Despacho: " + inOut.getMovementDate() + "\n" + "Cliente: " + inOut.getC_BPartner().getName() + "\n" + "Descripcion: " + desc + "\n\n" + "Detalle del Despacho: " + "\n" + el_detalle;
                    if (v_control > 0) {
                        id_correo = 1000009;
                        sendMail = "SELECT send_mail('adempiere@blumos.cl',DAMECORREO(" + id_correo + ",'to'),DAMECORREO(" + id_correo + ",'cc'),'cmendoza@blumos.cl','" + el_subject + "','" + el_correo + "</pre>')";
                        pstmtSM = DB.prepareStatement(sendMail, null);
                        pstmtSM.execute();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        if (timing == 7 && po.get_Table_ID() == MMovement.Table_ID && (mov = (MMovement)po).getAD_Client_ID() == 1000005) {
            int id_correo = 0;
            String desc = " ";
            if (mov.getDescription() != null && mov.getDescription().trim().length() > 0) {
                desc = mov.getDescription();
            }
            MUser user = new MUser(po.getCtx(), Env.getAD_User_ID(po.getCtx()), po.get_TrxName());
            String v_query = "Select mp.m_product_id, mp.name as producto, mp.solutec, mml.movementqty, mml.m_locator_id, mml.m_locatorto_id, mml.m_attributesetinstance_id, mml.line FROM m_movementline mml INNER JOIN m_product mp ON (mml.m_product_id=mp.m_product_id) WHERE mml.m_movement_id= " + mov.get_ID() + " order by mml.line";
            String el_subject = "Traspaso N\u00b0 " + mov.getDocumentNo();
            try {
                CPreparedStatement pstmt = null;
                pstmt = DB.prepareStatement(v_query, null);
                ResultSet rs = pstmt.executeQuery();
                String el_detalle = "";
                int v_control = 0;
                while (rs.next()) {
                    ++v_control;
                    String v_ubicacion = DB.getSQLValueString(po.get_TrxName(), "select value from m_locator where m_locator_id=" + rs.getInt("m_locator_id"), new Object[0]);
                    String v_ubicacionTO = DB.getSQLValueString(po.get_TrxName(), "select value from m_locator where m_locator_id=" + rs.getInt("m_locatorto_id"), new Object[0]);
                    String el_lote = DB.getSQLValueString(po.get_TrxName(), "select LOT from m_attributesetinstance where m_attributesetinstance_id=" + rs.getInt("m_attributesetinstance_id"), new Object[0]);
                    el_detalle = String.valueOf(el_detalle) + "L\u00ednea: " + rs.getString("line") + " - Desde: " + v_ubicacion + " - Hacia -->: " + v_ubicacionTO + "\n" + "Producto: " + rs.getString("name") + " - Lote: " + el_lote + " - Cantidad: " + rs.getBigDecimal("movementqty").toString() + "\n\n";
                    el_detalle = String.valueOf(el_detalle) + "Producto: " + rs.getString("producto") + " - Cantidad Recibida: " + rs.getBigDecimal("movementqty") + "\n";
                }
                el_detalle = String.valueOf(el_detalle) + "\n" + "Movimiento generado por " + user.getName() + " el " + DateUtils.today().toString();
                String el_correo = "<pre>" + el_subject + ", Fecha: " + mov.getMovementDate() + "\n" + "Descripci\u00f3n: " + desc + "\n\n" + "Detalle del Traspaso: " + "\n\n" + el_detalle;
                if (v_control > 0) {
                    id_correo = 1000015;
                    sendMail = "SELECT send_mail('adempiere@blumos.cl',DAMECORREO(" + id_correo + ",'to'),damemail(" + user.get_ID() + ",0)||','||DAMECORREO(" + id_correo + ",'cc'),'cmendoza@blumos.cl','" + el_subject + "','" + el_correo + "</pre>')";
                    pstmtSM = DB.prepareStatement(sendMail, null);
                    pstmtSM.execute();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }
}

