/*
 * Decompiled with CFR 0.152.
 */
package org.baskakow.model;

import java.math.BigDecimal;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class ModBaskakowValidSO_Credit
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModBaskakowValidSO_Credit.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("M_InOut", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 7 && po.get_Table_ID() == MInOut.Table_ID) {
            MInOut ship = (MInOut)po;
            MBPartner bp = new MBPartner(po.getCtx(), ship.getC_BPartner_ID(), po.get_TrxName());
            BigDecimal invAmt = Env.ZERO;
            MInOutLine[] fromLines = ship.getLines(false);
            int i = 0;
            while (i < fromLines.length) {
                MInOutLine sLine = fromLines[i];
                if (sLine.getC_OrderLine_ID() > 0) {
                    BigDecimal amtTax = Env.ZERO;
                    BigDecimal amtTemp = Env.ZERO;
                    amtTemp = sLine.getQtyEntered().multiply(sLine.getC_OrderLine().getPriceEntered());
                    amtTax = amtTemp.multiply(sLine.getC_OrderLine().getC_Tax().getRate().divide(Env.ONEHUNDRED));
                    amtTemp = amtTemp.add(amtTax);
                    amtTemp = amtTemp.setScale(sLine.getC_OrderLine().getC_Order().getC_Currency().getStdPrecision(), 4);
                    invAmt = invAmt.add(amtTemp);
                }
                ++i;
            }
            BigDecimal open = (BigDecimal)bp.get_Value("TotalOpenBalanceOFB");
            if (open == null) {
                open = Env.ZERO;
            }
            if (invAmt == null) {
                invAmt = Env.ZERO;
            }
            if (open.subtract(invAmt).compareTo(Env.ZERO) < 0) {
                return "Error Credito Insuficiente - Saldo Actual=" + (BigDecimal)bp.get_Value("TotalOpenBalanceOFB") + ";" + " Monto documento=" + invAmt;
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

