/*
 * Decompiled with CFR 0.152.
 */
package org.andes.process;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.compiere.model.MBank;
import org.compiere.model.X_C_AccountCredentials;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.ofb.model.OFBForward;

public class AndesFullProcessCD4
extends SvrProcess {
    private Timestamp p_dateTrx;
    private int p_NumSec;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DateTrx")) {
                this.p_dateTrx = (Timestamp)para[i].getParameter();
            } else if (name.equals("correlativo")) {
                this.p_NumSec = para[i].getParameterAsInt();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        String BCIFile;
        X_C_AccountCredentials aCr = new X_C_AccountCredentials(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (aCr.get_ValueAsString("FileNameCD4") != null && aCr.get_ValueAsString("FileNameCD4").trim().length() > 2) {
            String rutaBat = OFBForward.PathBatIMacroCD4();
            this.ejecucion(aCr.get_ValueAsString("FileNameCD4"), rutaBat);
            try {
                Thread.sleep(180000L);
            }
            catch (Exception e) {
                this.log.config("Error al esperar tiempo");
            }
        }
        int contador = 0;
        MBank bank = new MBank(this.getCtx(), aCr.get_ValueAsInt("C_Bank_ID"), this.get_TrxName());
        int indiceCicloArchivo = 1;
        String comodin = "\\";
        String[] cuentasSec = new String[]{"2773101", "2773133"};
        String[] cuentasCorp = new String[]{"1094016", "27477217"};
        if (bank.getDescription().compareToIgnoreCase("security") == 0) {
            indiceCicloArchivo = 2;
        }
        if (bank.getDescription().compareToIgnoreCase("Corpbanca") == 0) {
            indiceCicloArchivo = 2;
        }
        if (bank.getDescription().compareToIgnoreCase("BCI") == 0 && (BCIFile = OFBForward.PathFileBCICD4()) != null && BCIFile.trim().length() > 5) {
            File filenew = new File(BCIFile);
            String dirOut = String.valueOf(OFBForward.PathDataIMacroCD4()) + comodin;
            AndesFullProcessCD4.unZipFiles(filenew, dirOut);
        }
        int ia = 1;
        while (ia <= indiceCicloArchivo) {
            String Val_FileName = DB.getSQLValueString(this.get_TrxName(), "SELECT MAX(FileName) FROM C_BankAccount WHERE IsActive = 'Y'  AND FileName IS NOT NULL AND C_Bank_ID = ?", bank.get_ID());
            String Val_FileNameNew = DB.getSQLValueString(this.get_TrxName(), "SELECT MAX(FileNameNew) FROM C_BankAccount WHERE IsActive = 'Y'  AND FileName IS NOT NULL AND C_Bank_ID = ?", bank.get_ID());
            if (Val_FileName != null && Val_FileName.trim().length() > 3) {
                ArrayList<String[]> datos = new ArrayList<String[]>();
                String ruta = OFBForward.PathDataIMacroCD4();
                String pFile = String.valueOf(ruta) + comodin + Val_FileName.replace("--", Integer.toString(ia));
                if (bank.getDescription().compareToIgnoreCase("BCI") == 0) {
                    SimpleDateFormat dateFormatBCI = new SimpleDateFormat("MMdd");
                    Date BCIdate1 = new Date();
                    String fechaStrBCI = dateFormatBCI.format(BCIdate1);
                    pFile = String.valueOf(ruta) + comodin + Val_FileName.replace("-MESDIA-", fechaStrBCI);
                }
                if (bank.getDescription().compareToIgnoreCase("security") == 0) {
                    pFile = pFile.replace("-CCTA-", cuentasSec[ia - 1]);
                }
                if (bank.getDescription().compareToIgnoreCase("Corpbanca") == 0) {
                    pFile = pFile.replace("X", Integer.toString(ia)).replace("CC", cuentasCorp[ia - 1]);
                }
                try {
                    File archivo;
                    String rutaArchivo;
                    BufferedWriter bw;
                    String numAccount;
                    FileInputStream fis = new FileInputStream(pFile);
                    InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                    BufferedReader br = new BufferedReader(isr);
                    String linea = br.readLine();
                    int cantLines = 0;
                    while (linea != null) {
                        datos.add(linea.split(";"));
                        linea = br.readLine();
                        ++cantLines;
                    }
                    br.close();
                    isr.close();
                    fis.close();
                    this.log.config(datos.toString());
                    StringBuffer newLine = null;
                    SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyy");
                    Date date1 = new Date();
                    String fechaStr = dateFormat.format(date1);
                    if (bank.getDescription().compareToIgnoreCase("Santander") == 0) {
                        this.copiarArchivo(pFile, String.valueOf(OFBForward.PathDataOutIMacroCD4()) + comodin);
                        ++contador;
                    } else if (bank.getDescription().compareToIgnoreCase("BCI") == 0) {
                        numAccount = "-";
                        bw = null;
                        int indice = 0;
                        int x = 0;
                        while (x < cantLines) {
                            if (numAccount.compareToIgnoreCase(((String[])datos.get(x))[0].substring(5, 13)) != 0) {
                                String rutaArchivo2;
                                File archivo2;
                                ++contador;
                                if (bw != null) {
                                    bw.close();
                                }
                                if ((archivo2 = new File(rutaArchivo2 = String.valueOf(OFBForward.PathDataOutIMacroCD4()) + comodin + Val_FileNameNew.replace("FECHA", fechaStr).replace("--", this.rellenarCadena(Integer.toString(++indice), 2, "0")).replace("-CCTA-", ((String[])datos.get(x))[0].substring(5, 13)))).exists()) {
                                    archivo2.delete();
                                }
                                bw = new BufferedWriter(new FileWriter(archivo2));
                            }
                            newLine = new StringBuffer();
                            newLine.append(((String[])datos.get(x))[0]);
                            bw.write(newLine.toString());
                            bw.newLine();
                            numAccount = ((String[])datos.get(x))[0].substring(5, 13);
                            ++x;
                        }
                        bw.close();
                    } else if (bank.getDescription().compareToIgnoreCase("de Chile") == 0) {
                        this.copiarArchivo(pFile, String.valueOf(OFBForward.PathDataOutIMacroCD4()) + comodin);
                        ++contador;
                    } else if (bank.getDescription().compareToIgnoreCase("Bice") == 0) {
                        rutaArchivo = String.valueOf(OFBForward.PathDataOutIMacroCD4()) + comodin + Val_FileNameNew.replace("FECHA", fechaStr);
                        archivo = new File(rutaArchivo);
                        SimpleDateFormat dateFormatBice = new SimpleDateFormat("yyyyMMdd");
                        String fechaStrBice = dateFormatBice.format(this.p_dateTrx);
                        if (archivo.exists()) {
                            archivo.delete();
                        }
                        BufferedWriter bw2 = new BufferedWriter(new FileWriter(archivo));
                        int x = 0;
                        while (x < cantLines) {
                            newLine = new StringBuffer();
                            if (x == 0) {
                                newLine.append(((String[])datos.get(x))[0].trim());
                                bw2.write(newLine.toString());
                                bw2.newLine();
                            } else if (x == cantLines - 2) {
                                newLine.append(((String[])datos.get(x))[0].trim());
                                bw2.write(newLine.toString());
                                bw2.newLine();
                            } else if (x == cantLines - 1) {
                                this.log.config("Linea en blanco no agregada");
                            } else if (fechaStrBice.compareTo(((String[])datos.get(x))[0].trim().substring(7, 15)) == 0) {
                                if (((String[])datos.get(x))[0].length() < 84) {
                                    int dif = 84 - ((String[])datos.get(x))[0].length();
                                    newLine.append(((String[])datos.get(x))[0].trim().substring(0, 42));
                                    newLine.append(((String[])datos.get(x))[0].trim().substring(43, 49));
                                    newLine.append(this.rellenarCadena(((String[])datos.get(x))[0].trim().substring(49, 57), 16, "0"));
                                    newLine.append(((String[])datos.get(x))[0].trim().substring(57, 84 - dif));
                                    bw2.write(newLine.toString());
                                    bw2.newLine();
                                } else if (((String[])datos.get(x))[0].length() == 84) {
                                    newLine.append(((String[])datos.get(x))[0].trim().substring(0, 84));
                                    bw2.write(newLine.toString());
                                    bw2.newLine();
                                } else {
                                    newLine.append(((String[])datos.get(x))[0].trim().substring(0, 48));
                                    newLine.append(this.rellenarCadena(((String[])datos.get(x))[0].trim().substring(49, 63), 22, "0"));
                                    newLine.append(this.rellenarCadena(((String[])datos.get(x))[0].trim().substring(76, 77), 14, " "));
                                    bw2.write(newLine.toString());
                                    bw2.newLine();
                                }
                            }
                            ++x;
                        }
                        bw2.close();
                        ++contador;
                    } else if (bank.getDescription().compareToIgnoreCase("Estado") == 0) {
                        numAccount = "-";
                        bw = null;
                        int indice = 0;
                        boolean flag = false;
                        int x = 0;
                        while (x < cantLines) {
                            if (numAccount.compareToIgnoreCase(((String[])datos.get(x))[0].substring(0, 11)) != 0) {
                                String rutaArchivo3;
                                File archivo3;
                                ++contador;
                                if (bw != null) {
                                    bw.close();
                                }
                                if ((archivo3 = new File(rutaArchivo3 = String.valueOf(OFBForward.PathDataOutIMacroCD4()) + comodin + Val_FileNameNew.replace("FECHA", fechaStr).replace("--", this.rellenarCadena(Integer.toString(++indice), 2, "0")).replace("-CCTA-", ((String[])datos.get(x))[0].substring(0, 11)))).exists()) {
                                    archivo3.delete();
                                }
                                bw = new BufferedWriter(new FileWriter(archivo3));
                                flag = true;
                            }
                            newLine = new StringBuffer();
                            String lineStr = ((String[])datos.get(x))[0];
                            if (flag) {
                                SimpleDateFormat dateFormatHead = new SimpleDateFormat("ddMMyy");
                                Date dateHead = new Date();
                                dateHead.setTime(this.p_dateTrx.getTime());
                                String fechaStrHead = dateFormatHead.format(dateHead);
                                lineStr = String.valueOf(((String[])datos.get(x))[0].substring(0, 33)) + this.rellenarCadena(fechaStrHead, 6, "0") + ((String[])datos.get(x))[0].substring(39, ((String[])datos.get(x))[0].length());
                            }
                            newLine.append(lineStr);
                            bw.write(newLine.toString());
                            bw.newLine();
                            numAccount = ((String[])datos.get(x))[0].substring(0, 11);
                            flag = false;
                            ++x;
                        }
                        bw.close();
                        ++contador;
                    } else if (bank.getDescription().compareToIgnoreCase("Corpbanca") == 0) {
                        rutaArchivo = String.valueOf(OFBForward.PathDataOutIMacroCD4()) + comodin + Val_FileNameNew.replace("FECHA", fechaStr).replace("_", Integer.toString(ia));
                        archivo = new File(rutaArchivo);
                        if (archivo.exists()) {
                            archivo.delete();
                        }
                        BufferedWriter bw3 = new BufferedWriter(new FileWriter(archivo));
                        String numAccount2 = "";
                        String numCartola = "";
                        String referencia = "+";
                        int x = 4;
                        while (x < cantLines) {
                            if (x == 4) {
                                numAccount2 = ((String[])datos.get(x))[1].trim();
                            }
                            if (x == 5) {
                                numCartola = ((String[])datos.get(x))[1].trim();
                            }
                            if (x >= 10 && ((String[])datos.get(x))[0] != null && !((String[])datos.get(x))[0].trim().toUpperCase().contains("SIN MOV")) {
                                String movType = "4";
                                String signoSaldo = "+";
                                if (((String[])datos.get(x))[1].trim().toUpperCase().contains("CHEQUE")) {
                                    movType = "4";
                                } else if (((String[])datos.get(x))[4] != null && ((String[])datos.get(x))[4].trim().length() > 0) {
                                    movType = "3";
                                } else if (((String[])datos.get(x))[5] != null && ((String[])datos.get(x))[5].trim().length() > 0) {
                                    movType = "2";
                                }
                                if (((String[])datos.get(x))[6] != null && ((String[])datos.get(x))[6].trim().contains("-")) {
                                    signoSaldo = "-";
                                }
                                referencia = this.rellenarCadena(((String[])datos.get(x))[2], 9, "0");
                                String dateLine = String.valueOf(((String[])datos.get(x))[0].substring(6, 10)) + ((String[])datos.get(x))[0].substring(3, 5) + ((String[])datos.get(x))[0].substring(0, 2);
                                newLine = new StringBuffer();
                                newLine.append("027001CLP" + numAccount2.substring(6, numAccount2.length()) + dateLine);
                                newLine.append(this.rellenarCadena(Integer.toString(this.p_NumSec), 7, "0"));
                                newLine.append(referencia);
                                newLine.append(dateLine);
                                newLine.append(this.codigoCorpBanca(((String[])datos.get(x))[1].trim().toUpperCase(), movType));
                                newLine.append(movType);
                                newLine.append(this.rellenarCadenaDerecha(((String[])datos.get(x))[1].trim(), 30, " "));
                                newLine.append(this.rellenarCadena(((String[])datos.get(x))[4].replace("$", "").replace(".", "").trim(), 13, "0"));
                                newLine.append("00");
                                newLine.append(this.rellenarCadena(((String[])datos.get(x))[5].replace("$", "").replace(".", "").trim(), 13, "0"));
                                newLine.append("00");
                                newLine.append(this.rellenarCadena(((String[])datos.get(x))[6].replace("$", "").replace(".", "").trim(), 13, "0"));
                                newLine.append("00");
                                newLine.append(signoSaldo);
                                newLine.append(this.rellenarCadena(" ", 8, " "));
                                bw3.write(newLine.toString());
                                bw3.newLine();
                            }
                            ++x;
                        }
                        bw3.close();
                        ++contador;
                    } else if (bank.getDescription().compareToIgnoreCase("security") == 0) {
                        rutaArchivo = String.valueOf(OFBForward.PathDataOutIMacroCD4()) + comodin + Val_FileNameNew.replace("FECHA", fechaStr).replace("--", Integer.toString(ia)).replace("-CCTA-", cuentasSec[ia - 1]);
                        archivo = new File(rutaArchivo);
                        if (archivo.exists()) {
                            archivo.delete();
                        }
                        BufferedWriter bw4 = new BufferedWriter(new FileWriter(archivo));
                        int x = 0;
                        while (x < cantLines) {
                            String cod;
                            String desc;
                            String tipo;
                            newLine = new StringBuffer();
                            if (x == 0) {
                                String strLine = "1E-" + ((String[])datos.get(x))[0].trim().substring(4, 11) + "-" + ((String[])datos.get(x))[0].trim().substring(11, 13) + ((String[])datos.get(x))[0].trim().substring(13, 70) + "+" + ((String[])datos.get(x))[0].trim().substring(71, 86) + this.rellenarCadena(((String[])datos.get(x))[0].trim().substring(86, 130), 45, " ") + ((String[])datos.get(x))[0].trim().substring(130, 131) + ((String[])datos.get(x))[0].trim().substring(132, 147) + "+" + ((String[])datos.get(x))[0].trim().substring(149, 164) + ((String[])datos.get(x))[0].trim().substring(164, 174);
                                newLine.append(this.rellenarCadenaDerecha(strLine, 300, " "));
                            } else if (x == cantLines - 1) {
                                String signo = ((String[])datos.get(x))[0].trim().substring(1, 2);
                                String strLine = String.valueOf(((String[])datos.get(x))[0].trim().substring(0, 2)) + ((String[])datos.get(x))[0].trim().substring(3, 18) + signo + ((String[])datos.get(x))[0].trim().substring(18, 33) + signo + ((String[])datos.get(x))[0].trim().substring(33, 48) + signo + ((String[])datos.get(x))[0].trim().substring(49, 64);
                                newLine.append(this.rellenarCadenaDerecha(strLine, 300, " "));
                            } else if (x == cantLines - 2) {
                                tipo = ((String[])datos.get(x))[0].trim().substring(70, 71);
                                desc = ((String[])datos.get(x))[0].trim().substring(11, 61);
                                cod = "42";
                                if (desc.toUpperCase().contains("CHEQUE") && tipo.toUpperCase().compareTo("C") == 0) {
                                    cod = "42";
                                } else if (desc.toUpperCase().contains("TRANSFERENCIA") && tipo.toUpperCase().compareTo("C") == 0) {
                                    cod = "28";
                                } else if (desc.toUpperCase().contains("CARGO") && tipo.toUpperCase().compareTo("C") == 0) {
                                    cod = "28";
                                } else if (desc.toUpperCase().contains("TRANSFERENCIA") && tipo.toUpperCase().compareTo("A") == 0) {
                                    cod = "78";
                                } else if (desc.toUpperCase().contains("DEPOSITO") && tipo.toUpperCase().compareTo("A") == 0) {
                                    cod = "51";
                                } else if (desc.toUpperCase().contains("ABONO") && tipo.toUpperCase().compareTo("A") == 0) {
                                    cod = "78";
                                }
                                String signo = ((String[])datos.get(x))[0].trim().substring(71, 72);
                                String strLine = String.valueOf(((String[])datos.get(x))[0].trim().substring(0, 11)) + cod + " " + ((String[])datos.get(x))[0].trim().substring(11, 58) + ((String[])datos.get(x))[0].trim().substring(61, 72) + ((String[])datos.get(x))[0].trim().substring(72, 87) + signo + ((String[])datos.get(x))[0].trim().substring(87, 102);
                                newLine.append(this.rellenarCadenaDerecha(strLine, 300, " "));
                            } else {
                                tipo = ((String[])datos.get(x))[0].trim().substring(70, 71);
                                desc = ((String[])datos.get(x))[0].trim().substring(11, 61);
                                cod = "42";
                                if (desc.toUpperCase().contains("CHEQUE") && tipo.toUpperCase().compareTo("C") == 0) {
                                    cod = "42";
                                } else if (desc.toUpperCase().contains("TRANSFERENCIA") && tipo.toUpperCase().compareTo("C") == 0) {
                                    cod = "28";
                                } else if (desc.toUpperCase().contains("CARGO") && tipo.toUpperCase().compareTo("C") == 0) {
                                    cod = "28";
                                } else if (desc.toUpperCase().contains("TRANSFERENCIA") && tipo.toUpperCase().compareTo("A") == 0) {
                                    cod = "78";
                                } else if (desc.toUpperCase().contains("DEPOSITO") && tipo.toUpperCase().compareTo("A") == 0) {
                                    cod = "51";
                                } else if (desc.toUpperCase().contains("ABONO") && tipo.toUpperCase().compareTo("A") == 0) {
                                    cod = "78";
                                }
                                String strLine = String.valueOf(((String[])datos.get(x))[0].trim().substring(0, 11)) + cod + " " + ((String[])datos.get(x))[0].trim().substring(11, 58) + ((String[])datos.get(x))[0].trim().substring(61, 72) + ((String[])datos.get(x))[0].trim().substring(72, 87);
                                newLine.append(this.rellenarCadenaDerecha(strLine, 300, " "));
                            }
                            bw4.write(newLine.toString());
                            bw4.newLine();
                            ++x;
                        }
                        bw4.close();
                        ++contador;
                    }
                }
                catch (Exception e) {
                    this.log.config("No se pudo cargar archivo:" + pFile);
                }
                this.commitEx();
            }
            ++ia;
        }
        return "OK";
    }

    public String ejecucion(String rutaIM, String rutaBat) {
        Runtime aplicacion = Runtime.getRuntime();
        try {
            String eje = "cmd.exe /K " + rutaBat + " " + rutaIM;
            aplicacion.exec(eje);
        }
        catch (Exception e) {
            return e.toString();
        }
        return "Proceso OK";
    }

    private String rellenarCadena(String string, int largo, String caracter) {
        String ceros = "";
        int cantidad = largo - string.length();
        if (cantidad >= 1) {
            int i = 0;
            while (i < cantidad) {
                ceros = String.valueOf(ceros) + caracter;
                ++i;
            }
            return String.valueOf(ceros) + string;
        }
        return string;
    }

    private String copiarArchivo(String archivoOrigen, String RutaDestino) {
        Runtime aplicacion = Runtime.getRuntime();
        try {
            String eje = "cmd.exe /K copy " + archivoOrigen + " " + RutaDestino;
            aplicacion.exec(eje);
        }
        catch (Exception e) {
            return e.toString();
        }
        return "Proceso OK";
    }

    private String rellenarCadenaDerecha(String string, int largo, String caracter) {
        String ceros = "";
        int cantidad = largo - string.length();
        if (cantidad >= 1) {
            int i = 0;
            while (i < cantidad) {
                ceros = String.valueOf(ceros) + caracter;
                ++i;
            }
            return String.valueOf(string) + ceros;
        }
        return string;
    }

    public static void unZipFiles(File zipfile, String descDir) {
        File file = new File(descDir);
        if (!file.exists()) {
            try {
                file.mkdir();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            ZipFile zf = new ZipFile(zipfile);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                int len;
                ZipEntry entry = entries.nextElement();
                String zipEntryName = entry.getName();
                InputStream in = zf.getInputStream(entry);
                FileOutputStream out = new FileOutputStream(String.valueOf(descDir) + zipEntryName);
                byte[] buf1 = new byte[1024];
                while ((len = in.read(buf1)) > 0) {
                    ((OutputStream)out).write(buf1, 0, len);
                }
                in.close();
                ((OutputStream)out).close();
                System.out.println("Descompresi\u00f3n completa.");
            }
            zf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String codigoCorpBanca(String desc, String type) {
        String cod = "CK";
        if (desc.trim().toUpperCase().contains("PROTESTO DE CHEQUES")) {
            cod = "AG";
        } else if (desc.trim().toUpperCase().contains("CHEQUE POR CAMARA")) {
            cod = "CQ";
        } else if (desc.trim().toUpperCase().contains("CHEQUE")) {
            cod = "CK";
        } else if (desc.trim().toUpperCase().contains("N/CREDITO")) {
            cod = "CR";
        } else if (desc.trim().toUpperCase().contains("DEBITO")) {
            cod = "DB";
        } else if (desc.trim().toUpperCase().contains("DISMINUCION DE PRINCIPAL")) {
            cod = "DD";
        } else if (desc.trim().toUpperCase().contains("DEPOSITO EN EFECTIVO")) {
            cod = "DE";
        } else if (desc.trim().toUpperCase().contains("DEPOSITO CON CHEQUE")) {
            cod = "DM";
        } else if (desc.trim().toUpperCase().contains("DEPOSITO")) {
            cod = "DP";
        } else if (desc.trim().toUpperCase().contains("N/DEBITO")) {
            cod = "DR";
        } else if (desc.trim().toUpperCase().contains("TRASPASO")) {
            cod = "FT";
        } else if (desc.trim().toUpperCase().contains("CAMBIO DE MONEDA EXTRANJERA")) {
            cod = "FX";
        } else if (desc.trim().toUpperCase().contains("GIRO POR CAJA")) {
            cod = "GI";
        } else if (desc.trim().toUpperCase().contains("COMISION CTA. VISTA POR GIROS")) {
            cod = "G1";
        } else if (desc.trim().toUpperCase().contains("TRANSFERENCIA INTERNAS")) {
            cod = "IT";
        } else if (desc.trim().toUpperCase().contains("NEGOCIACION CARTA DE CREDITO")) {
            cod = "LA";
        } else if (desc.trim().toUpperCase().contains("NEGOCIACION CARTA DE CREDITO")) {
            cod = "LN";
        } else if (desc.trim().toUpperCase().contains("PAGO DE PRESTAMO")) {
            cod = "LP";
        } else if (desc.trim().toUpperCase().contains("TRANSACCION DE CREDITO")) {
            cod = "MC";
        } else if (desc.trim().toUpperCase().contains("TRANSACCION DE DEBITO")) {
            cod = "MD";
        } else if (desc.trim().toUpperCase().contains("CHEQUE DE GERENCIA")) {
            cod = "OF";
        } else if (desc.trim().toUpperCase().contains("PAGO DE REMUNERACIONES")) {
            cod = "PR";
        } else if (desc.trim().toUpperCase().contains("CARGO POR CHEQUE DEVUELTO")) {
            cod = "RD";
        } else if (desc.trim().toUpperCase().contains("RENOVACION AUTOMATICA")) {
            cod = "RL";
        } else if (desc.trim().toUpperCase().contains("CARGO POR CHEQUES VIAJEROS")) {
            cod = "TF";
        } else if (desc.trim().toUpperCase().contains("IMPUESTO POR SOBREGIRO")) {
            cod = "TX";
        } else if (desc.trim().toUpperCase().contains("TRANFERENCIA POR TELEX/CREDITO")) {
            cod = "WC";
        } else if (desc.trim().toUpperCase().contains("TRANSFERENCIA POR TELEX/CREDITO")) {
            cod = "WD";
        } else if (desc.trim().toUpperCase().contains("GIRO")) {
            cod = "WH";
        } else if (desc.trim().toUpperCase().contains("ND APERTURA L/C")) {
            cod = "01";
        } else if (desc.trim().toUpperCase().contains("COMISION MANTENCION DE CUENTA")) {
            cod = "01";
        } else if (desc.trim().toUpperCase().contains("COMISION TARJETA")) {
            cod = "10";
        } else if (desc.trim().toUpperCase().contains("COMISI\u00d3N CARTOLA EXTRA MES\u00d3N")) {
            cod = "15";
        } else if (desc.trim().toUpperCase().contains("COMIS. MENSUAL TARJETA CLIENTE")) {
            cod = "16";
        } else if (desc.trim().toUpperCase().contains("COMISION SOBREGIRO CHEQUES")) {
            cod = "17";
        } else if (desc.trim().toUpperCase().contains("COMISION SOBREGIRO CHEQUES")) {
            cod = "18";
        } else if (desc.trim().toUpperCase().contains("COMISION SEMESTRAL PLAN PYME")) {
            cod = "20";
        } else if (desc.trim().toUpperCase().contains("INTERESES POR SOBREGIRO")) {
            cod = "3E";
        } else if (desc.trim().toUpperCase().contains("PAGO DE INTERES SOBRE CUENTA CTE")) {
            cod = "3O";
        } else if (desc.trim().toUpperCase().contains("COMISION LINEA DE CREDITO")) {
            cod = "3P";
        } else if (desc.trim().toUpperCase().contains("RETIRO DE INTERESES")) {
            cod = "3Q";
        } else if (desc.trim().toUpperCase().contains("TRANSFERENCIA DE TELEX")) {
            cod = "3V";
        } else if (desc.trim().toUpperCase().contains("APERTURA DE CONTRATO")) {
            cod = "3X";
        } else if (desc.trim().toUpperCase().contains("PAGO A PRESTAMOS")) {
            cod = "3Y";
        } else if (desc.trim().toUpperCase().contains("COMISION DIGICORP")) {
            cod = "31";
        } else if (desc.trim().toUpperCase().contains("RETIRO DE CAJERO AUTOMATICO")) {
            cod = "33";
        } else if (desc.trim().toUpperCase().contains("TRANSFERENCIA CAJERO AUTOMATICO")) {
            cod = "35";
        } else if (desc.trim().toUpperCase().contains("COMISION USO INTERNACIONAL")) {
            cod = "36";
        } else if (desc.trim().toUpperCase().contains("COMISIONES/DEBITO")) {
            cod = "59";
        } else if (desc.trim().toUpperCase().contains("COMISION POR MANEJO")) {
            cod = "7M";
        } else if (desc.trim().toUpperCase().contains("COMISI\u00d3N LINEA RESPALDO EXTRA")) {
            cod = "75";
        } else if (desc.trim().toUpperCase().contains("SEG DESGRAVAMEN POR USO LRE")) {
            cod = "81";
        } else if (desc.trim().toUpperCase().contains("TRANSF. DESDE LINEA DE SOBREG")) {
            cod = "9A";
        } else if (desc.trim().toUpperCase().contains("ABONO")) {
            cod = "FT";
        } else if (desc.trim().toUpperCase().contains("TRANSF.")) {
            cod = "FT";
        } else if (desc.trim().toUpperCase().contains("TRANSFERENCIA POR TELEX/CREDI")) {
            cod = "FT";
        }
        return cod;
    }
}

