/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.compiere.model.X_AD_WF_NextCondition;
import org.compiere.model.X_AD_WF_NodeNext;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.wf.MWFNodeNext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class WorkflowNodeNextElementHandler
extends AbstractElementHandler {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        Attributes atts = element.attributes;
        String entitytype = atts.getValue("EntityType");
        this.log.info("entitytype " + atts.getValue("EntityType"));
        if (!this.isProcessElement(ctx, entitytype)) {
            element.skip = true;
            return;
        }
        if (element.parent != null && element.parent.skip) {
            element.skip = true;
            return;
        }
        String workflowName = atts.getValue("ADWorkflowNameID");
        int workflowId = this.get_IDWithColumn(ctx, "AD_Workflow", "name", workflowName);
        if (workflowId <= 0) {
            element.defer = true;
            element.unresolved = "AD_Workflow: " + workflowName;
            return;
        }
        String workflowNodeName = atts.getValue("ADWorkflowNodeNameID").trim();
        String workflowNodeNextName = atts.getValue("ADWorkflowNodeNextNameID").trim();
        StringBuffer sqlB = new StringBuffer("SELECT ad_wf_node_id FROM AD_WF_Node WHERE AD_Workflow_ID=? and Name =?");
        int wfNodeId = DB.getSQLValue(this.getTrxName(ctx), sqlB.toString(), workflowId, workflowNodeName);
        if (wfNodeId <= 0) {
            element.defer = true;
            element.unresolved = "AD_WF_Node: " + workflowNodeName;
            return;
        }
        int wfNodeNextId = DB.getSQLValue(this.getTrxName(ctx), sqlB.toString(), workflowId, workflowNodeNextName);
        if (wfNodeNextId <= 0) {
            element.defer = true;
            element.unresolved = "AD_WF_Node: " + workflowNodeNextName;
            return;
        }
        sqlB = new StringBuffer("SELECT  ad_wf_nodenext_id FROM AD_WF_NodeNext  WHERE ad_wf_node_id =? and ad_wf_next_id =?");
        int id = DB.getSQLValue(this.getTrxName(ctx), sqlB.toString(), wfNodeId, wfNodeNextId);
        MWFNodeNext m_WFNodeNext = new MWFNodeNext(ctx, id, this.getTrxName(ctx));
        int AD_Backup_ID = -1;
        String Object_Status = null;
        if (id <= 0 && atts.getValue("AD_WF_NodeNext_ID") != null && Integer.parseInt(atts.getValue("AD_WF_NodeNext_ID")) <= 999999) {
            m_WFNodeNext.setAD_WF_NodeNext_ID(Integer.parseInt(atts.getValue("AD_WF_NodeNext_ID")));
        }
        if (id > 0) {
            AD_Backup_ID = this.copyRecord(ctx, "AD_WF_NodeNext", m_WFNodeNext);
            Object_Status = "Update";
        } else {
            Object_Status = "New";
            AD_Backup_ID = 0;
        }
        m_WFNodeNext.setAD_WF_Node_ID(wfNodeId);
        m_WFNodeNext.setAD_WF_Next_ID(wfNodeNextId);
        m_WFNodeNext.setEntityType(atts.getValue("EntityType"));
        m_WFNodeNext.setSeqNo(Integer.valueOf(atts.getValue("SeqNo")));
        m_WFNodeNext.setIsActive(atts.getValue("isActive") != null ? Boolean.valueOf(atts.getValue("isActive")) : true);
        m_WFNodeNext.setIsStdUserWorkflow(atts.getValue("IsStdUserWorkflow") != null ? Boolean.valueOf(atts.getValue("IsStdUserWorkflow")) : true);
        this.log.info("about to execute m_WFNodeNext.save");
        if (m_WFNodeNext.save(this.getTrxName(ctx))) {
            this.log.info("m_WFNodeNext save success");
            this.record_log(ctx, 1, String.valueOf(m_WFNodeNext.get_ID()), "WFNodeNext", m_WFNodeNext.get_ID(), AD_Backup_ID, Object_Status, "AD_WF_NodeNext", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_WF_NodeNext"));
            return;
        }
        this.log.info("m_WFNodeNext save failure");
        this.record_log(ctx, 0, String.valueOf(m_WFNodeNext.get_ID()), "WFNodeNext", m_WFNodeNext.get_ID(), AD_Backup_ID, Object_Status, "AD_WF_NodeNext", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_WF_NodeNext"));
        throw new POSaveFailedException("WorkflowNodeNext");
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        int ad_wf_nodenext_id = Env.getContextAsInt(ctx, "AD_WF_NodeNext_ID");
        X_AD_WF_NodeNext m_WF_NodeNext = new X_AD_WF_NodeNext(ctx, ad_wf_nodenext_id, null);
        AttributesImpl atts = new AttributesImpl();
        this.createWorkflowNodeNextBinding(atts, m_WF_NodeNext);
        document.startElement("", "", "workflowNodeNext", atts);
        document.endElement("", "", "workflowNodeNext");
    }

    private AttributesImpl createWorkflowNodeNextBinding(AttributesImpl atts, X_AD_WF_NodeNext m_WF_NodeNext) {
        String sql = null;
        String name = null;
        atts.clear();
        if (m_WF_NodeNext.getAD_WF_NodeNext_ID() <= 999999) {
            atts.addAttribute("", "", "AD_WF_NodeNext_ID", "CDATA", Integer.toString(m_WF_NodeNext.getAD_WF_NodeNext_ID()));
        }
        if (m_WF_NodeNext.getAD_WF_Node_ID() > 0) {
            sql = "SELECT AD_Workflow.Name FROM AD_Workflow, AD_WF_Node WHERE  AD_Workflow.AD_Workflow_ID = AD_WF_Node.AD_Workflow_ID and AD_WF_Node.AD_WF_Node_ID =?";
            name = DB.getSQLValueString(null, sql, m_WF_NodeNext.getAD_WF_Node_ID());
            atts.addAttribute("", "", "ADWorkflowNameID", "CDATA", name);
            sql = "SELECT Name FROM AD_WF_Node WHERE AD_WF_Node_ID=?";
            name = DB.getSQLValueString(null, sql, m_WF_NodeNext.getAD_WF_Node_ID());
            atts.addAttribute("", "", "ADWorkflowNodeNameID", "CDATA", name);
        }
        if (m_WF_NodeNext.getAD_WF_Next_ID() > 0) {
            sql = "SELECT Name FROM AD_WF_Node WHERE AD_WF_Node_ID=?";
            name = DB.getSQLValueString(null, sql, m_WF_NodeNext.getAD_WF_Next_ID());
            atts.addAttribute("", "", "ADWorkflowNodeNextNameID", "CDATA", name);
        }
        atts.addAttribute("", "", "isActive", "CDATA", m_WF_NodeNext.isActive() ? "true" : "false");
        atts.addAttribute("", "", "EntityType", "CDATA", m_WF_NodeNext.getEntityType() != null ? m_WF_NodeNext.getEntityType() : "");
        atts.addAttribute("", "", "Description", "CDATA", m_WF_NodeNext.getDescription() != null ? m_WF_NodeNext.getDescription() : "");
        atts.addAttribute("", "", "SeqNo", "CDATA", String.valueOf(m_WF_NodeNext.getSeqNo()) != null ? String.valueOf(m_WF_NodeNext.getSeqNo()) : "");
        atts.addAttribute("", "", "IsStdUserWorkflow", "CDATA", String.valueOf(m_WF_NodeNext.isStdUserWorkflow()) != null ? String.valueOf(m_WF_NodeNext.isStdUserWorkflow()) : "");
        return atts;
    }

    private AttributesImpl createWorkflowNodeNextConditionBinding(AttributesImpl atts, X_AD_WF_NextCondition m_WF_NodeNextCondition) {
        String sql = null;
        String name = null;
        atts.clear();
        if (m_WF_NodeNextCondition.getAD_WF_NodeNext_ID() > 0) {
            sql = "SELECT AD_Workflow.Name FROM AD_Workflow, AD_WF_Node, AD_WF_NodeNext WHERE  AD_Workflow.AD_Workflow_ID = AD_WF_Node.AD_Workflow_ID and AD_WF_Node.AD_WF_Node_ID = AD_WF_NodeNext.AD_WF_Node_ID and AD_WF_NodeNext.AD_WF_NodeNext_ID = ? group by AD_Workflow.Name";
            name = DB.getSQLValueString(null, sql, m_WF_NodeNextCondition.getAD_WF_NodeNext_ID());
            atts.addAttribute("", "", "ADWorkflowNameID", "CDATA", name);
            sql = "SELECT AD_WF_Node.Name FROM AD_WF_Node, AD_WF_NodeNext WHERE AD_WF_Node.AD_WF_Node_ID = AD_WF_NodeNext.AD_WF_Node_ID and AD_WF_NodeNext.AD_WF_NodeNext_ID =  ? group by AD_WF_Node.Name";
            name = DB.getSQLValueString(null, sql, m_WF_NodeNextCondition.getAD_WF_NodeNext_ID());
            atts.addAttribute("", "", "ADWorkflowNodeNameID", "CDATA", name);
            sql = "SELECT AD_WF_Node.Name FROM AD_WF_Node, AD_WF_NodeNext, AD_WF_NextCondition WHERE AD_WF_Node.AD_WF_Node_ID = AD_WF_NodeNext.AD_WF_Next_ID and AD_WF_NodeNext.AD_WF_NodeNext_ID =  ? group by AD_WF_Node.Name";
            name = DB.getSQLValueString(null, sql, m_WF_NodeNextCondition.getAD_WF_NodeNext_ID());
            atts.addAttribute("", "", "ADWorkflowNodeNextNameID", "CDATA", name);
        }
        if (m_WF_NodeNextCondition.getAD_Column_ID() > 0) {
            sql = "SELECT AD_Table.TableName FROM AD_Table, AD_Column, AD_WF_NextCondition  WHERE AD_Column.AD_Table_ID=AD_Table.AD_Table_ID and AD_Column.AD_Column_ID = ?";
            name = DB.getSQLValueString(null, sql, m_WF_NodeNextCondition.getAD_Column_ID());
            atts.addAttribute("", "", "ADTableNameID", "CDATA", name);
            sql = "SELECT ColumnName FROM AD_Column WHERE AD_Column_ID=?";
            name = DB.getSQLValueString(null, sql, m_WF_NodeNextCondition.getAD_Column_ID());
            atts.addAttribute("", "", "ADColumnNameID", "CDATA", name);
        } else {
            atts.addAttribute("", "", "ADTableNameID", "CDATA", name);
            atts.addAttribute("", "", "ADColumnNameID", "CDATA", "");
        }
        atts.addAttribute("", "", "isActive", "CDATA", m_WF_NodeNextCondition.isActive() ? "true" : "false");
        atts.addAttribute("", "", "EntityType", "CDATA", m_WF_NodeNextCondition.getEntityType() != null ? m_WF_NodeNextCondition.getEntityType() : "");
        atts.addAttribute("", "", "AndOr", "CDATA", m_WF_NodeNextCondition.getAndOr() != null ? m_WF_NodeNextCondition.getAndOr() : "");
        atts.addAttribute("", "", "Operation", "CDATA", m_WF_NodeNextCondition.getOperation() != null ? m_WF_NodeNextCondition.getOperation() : "");
        atts.addAttribute("", "", "Value", "CDATA", m_WF_NodeNextCondition.getValue() != null ? m_WF_NodeNextCondition.getValue() : "");
        atts.addAttribute("", "", "Value2", "CDATA", m_WF_NodeNextCondition.getValue2() != null ? m_WF_NodeNextCondition.getValue2() : "");
        atts.addAttribute("", "", "SeqNo", "CDATA", String.valueOf(m_WF_NodeNextCondition.getSeqNo()) != null ? String.valueOf(m_WF_NodeNextCondition.getSeqNo()) : "");
        return atts;
    }
}

