/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.exception.DatabaseAccessException;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class TaskAccessElementHandler
extends AbstractElementHandler {
    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        String name;
        String elementValue = element.getElementValue();
        this.log.info(elementValue);
        int roleid = 0;
        int taskid = 0;
        StringBuffer sqlB = null;
        Attributes atts = element.attributes;
        if (this.getStringValue(atts, "rolename") != null) {
            name = atts.getValue("rolename");
            sqlB = new StringBuffer("SELECT AD_Role_ID FROM AD_Role WHERE Name= ?");
            roleid = DB.getSQLValue(this.getTrxName(ctx), sqlB.toString(), name);
        }
        if (this.getStringValue(atts, "taskname") != null) {
            name = atts.getValue("taskname");
            sqlB = new StringBuffer("SELECT AD_Task_ID FROM AD_Task WHERE Name= ?");
            taskid = DB.getSQLValue(this.getTrxName(ctx), sqlB.toString(), name);
        }
        sqlB = new StringBuffer("SELECT count(*) FROM AD_Task_Access WHERE AD_Role_ID=? and AD_Task_ID=?");
        int count = DB.getSQLValue(this.getTrxName(ctx), sqlB.toString(), roleid, taskid);
        int AD_Backup_ID = -1;
        String Object_Status = null;
        if (count > 0) {
            Object_Status = "Update";
            sqlB = new StringBuffer("UPDATE AD_Task_Access ").append("SET isActive = '" + atts.getValue("isActive")).append("', isReadWrite = '" + atts.getValue("isReadWrite")).append("' WHERE AD_Role_ID = " + roleid).append(" and AD_Task_ID = " + taskid);
            int no = DB.executeUpdate(sqlB.toString(), this.getTrxName(ctx));
            if (no == -1) {
                this.log.info("Update to task access failed");
                throw new DatabaseAccessException("Update to task access failed");
            }
        } else {
            Object_Status = "New";
            AD_Backup_ID = 0;
            sqlB = new StringBuffer("INSERT INTO AD_Task_Access").append("(AD_Client_ID, AD_Org_ID, CreatedBy, UpdatedBy, ").append("AD_Role_ID, AD_Task_ID, isActive, isReadWrite) ").append("VALUES(").append(" " + Env.getAD_Client_ID(ctx)).append(", " + Env.getAD_Org_ID(ctx)).append(", " + Env.getAD_User_ID(ctx)).append(", " + Env.getAD_User_ID(ctx)).append(", " + roleid).append(", " + taskid).append(", '" + atts.getValue("isActive")).append("', '" + atts.getValue("isReadWrite") + "')");
            int no = DB.executeUpdate(sqlB.toString(), this.getTrxName(ctx));
            if (no == -1) {
                this.log.info("Insert to task access failed");
                throw new DatabaseAccessException("Insert to task access failed");
            }
        }
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        int AD_Task_ID = Env.getContextAsInt(ctx, "AD_Task_ID");
        int AD_Role_ID = Env.getContextAsInt(ctx, "AD_Role_ID");
        AttributesImpl atts = new AttributesImpl();
        this.createTaskAccessBinding(atts, AD_Task_ID, AD_Role_ID);
        document.startElement("", "", "taskaccess", atts);
        document.endElement("", "", "taskaccess");
    }

    private AttributesImpl createTaskAccessBinding(AttributesImpl atts, int task_id, int role_id) {
        String sql = null;
        String name = null;
        atts.clear();
        sql = "SELECT Name FROM AD_Task WHERE AD_Task_ID=?";
        name = DB.getSQLValueString(null, sql, task_id);
        atts.addAttribute("", "", "taskname", "CDATA", name);
        sql = "SELECT Name FROM AD_Role WHERE AD_Role_ID=?";
        name = DB.getSQLValueString(null, sql, role_id);
        atts.addAttribute("", "", "rolename", "CDATA", name);
        sql = "SELECT isActive FROM AD_Task_Access WHERE AD_Task_ID=" + task_id + " and AD_Role_ID=?";
        String TrueFalse = DB.getSQLValueString(null, sql, role_id);
        atts.addAttribute("", "", "isActive", "CDATA", TrueFalse);
        sql = "SELECT isReadWrite FROM AD_Task_Access WHERE AD_Task_ID=" + task_id + " and AD_Role_ID=?";
        String isReadWrite = DB.getSQLValueString(null, sql, role_id);
        atts.addAttribute("", "", "isReadWrite", "CDATA", isReadWrite);
        return atts;
    }
}

