/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.compiere.model.X_AD_Ref_List;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ReferenceListElementHandler
extends AbstractElementHandler {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        String elementValue = element.getElementValue();
        int AD_Backup_ID = -1;
        String Object_Status = null;
        Attributes atts = element.attributes;
        this.log.info(elementValue + " " + atts.getValue("Name"));
        String entitytype = atts.getValue("EntityType");
        if (!this.isProcessElement(ctx, entitytype)) {
            element.skip = true;
            return;
        }
        if (element.parent != null && element.parent.skip) {
            element.skip = true;
            return;
        }
        String name = atts.getValue("Name");
        String value = atts.getValue("Value");
        int AD_Reference_ID = 0;
        AD_Reference_ID = element.parent != null && element.parent.getElementValue().equals("reference") && element.parent.recordId > 0 ? element.parent.recordId : this.get_IDWithColumn(ctx, "AD_Reference", "Name", atts.getValue("ADRefenceNameID"));
        int AD_Ref_List_ID = this.get_IDWithMasterAndColumn(ctx, "AD_Ref_List", "Value", value, "AD_Reference", AD_Reference_ID);
        X_AD_Ref_List m_Ref_List = new X_AD_Ref_List(ctx, AD_Ref_List_ID, this.getTrxName(ctx));
        if (AD_Ref_List_ID <= 0 && atts.getValue("AD_Ref_List_ID") != null && Integer.parseInt(atts.getValue("AD_Ref_List_ID")) <= 999999) {
            m_Ref_List.setAD_Ref_List_ID(Integer.parseInt(atts.getValue("AD_Ref_List_ID")));
        }
        if (AD_Ref_List_ID > 0) {
            AD_Backup_ID = this.copyRecord(ctx, "AD_Ref_List", m_Ref_List);
            Object_Status = "Update";
        } else {
            Object_Status = "New";
            AD_Backup_ID = 0;
        }
        m_Ref_List.setAD_Reference_ID(AD_Reference_ID);
        m_Ref_List.setDescription(this.getStringValue(atts, "Description"));
        m_Ref_List.setEntityType(atts.getValue("EntityType"));
        m_Ref_List.setName(atts.getValue("Name"));
        m_Ref_List.setValue(value);
        m_Ref_List.setIsActive(atts.getValue("isActive") != null ? Boolean.valueOf(atts.getValue("isActive")) : true);
        if (m_Ref_List.save(this.getTrxName(ctx))) {
            this.record_log(ctx, 1, m_Ref_List.getName(), "Reference List", m_Ref_List.get_ID(), AD_Backup_ID, Object_Status, "AD_Ref_List", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Ref_List"));
            return;
        }
        this.record_log(ctx, 0, m_Ref_List.getName(), "Reference List", m_Ref_List.get_ID(), AD_Backup_ID, Object_Status, "AD_Ref_List", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Ref_List"));
        throw new POSaveFailedException("ReferenceList");
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        int AD_Ref_List_ID = Env.getContextAsInt(ctx, "AD_Ref_List_ID");
        X_AD_Ref_List m_Ref_List = new X_AD_Ref_List(ctx, AD_Ref_List_ID, this.getTrxName(ctx));
        AttributesImpl atts = new AttributesImpl();
        this.createRefListBinding(atts, m_Ref_List);
        document.startElement("", "", "referencelist", atts);
        document.endElement("", "", "referencelist");
    }

    private AttributesImpl createRefListBinding(AttributesImpl atts, X_AD_Ref_List m_Ref_List) {
        String sql = null;
        String name = null;
        atts.clear();
        if (m_Ref_List.getAD_Ref_List_ID() <= 999999) {
            atts.addAttribute("", "", "AD_Ref_List_ID", "CDATA", Integer.toString(m_Ref_List.getAD_Ref_List_ID()));
        }
        if (m_Ref_List.getAD_Ref_List_ID() > 0) {
            sql = "SELECT Name FROM AD_Ref_List WHERE AD_Ref_List_ID=?";
            name = DB.getSQLValueString(null, sql, m_Ref_List.getAD_Ref_List_ID());
            if (name != null) {
                atts.addAttribute("", "", "ADReflistNameID", "CDATA", name);
            } else {
                atts.addAttribute("", "", "ADReflistNameID", "CDATA", "");
            }
        } else {
            atts.addAttribute("", "", "ADReflistNameID", "CDATA", "");
        }
        if (m_Ref_List.getAD_Reference_ID() > 0) {
            sql = "SELECT Name FROM AD_Reference WHERE AD_Reference_ID=?";
            name = DB.getSQLValueString(null, sql, m_Ref_List.getAD_Reference_ID());
            if (name != null) {
                atts.addAttribute("", "", "ADRefenceNameID", "CDATA", name);
            } else {
                atts.addAttribute("", "", "ADRefenceNameID", "CDATA", "");
            }
        } else {
            atts.addAttribute("", "", "ADRefenceNameID", "CDATA", "");
        }
        atts.addAttribute("", "", "Description", "CDATA", m_Ref_List.getDescription() != null ? m_Ref_List.getDescription() : "");
        atts.addAttribute("", "", "EntityType", "CDATA", m_Ref_List.getEntityType() != null ? m_Ref_List.getEntityType() : "");
        atts.addAttribute("", "", "Name", "CDATA", m_Ref_List.getName() != null ? m_Ref_List.getName() : "");
        atts.addAttribute("", "", "isActive", "CDATA", m_Ref_List.isActive() ? "true" : "false");
        atts.addAttribute("", "", "Value", "CDATA", m_Ref_List.getValue() != null ? m_Ref_List.getValue() : "");
        return atts;
    }
}

