/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.PackOut;
import org.adempiere.pipo.exception.DatabaseAccessException;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.adempiere.pipo.handler.PrintFormatItemElementHandler;
import org.compiere.model.MTable;
import org.compiere.model.X_AD_PrintFormat;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PrintFormatElementHandler
extends AbstractElementHandler {
    private PrintFormatItemElementHandler itemHandler = new PrintFormatItemElementHandler();
    private List<Integer> formats = new ArrayList<Integer>();

    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        String elementValue = element.getElementValue();
        int AD_Backup_ID = -1;
        String Object_Status = null;
        Attributes atts = element.attributes;
        this.log.info(elementValue + " " + atts.getValue("Name"));
        String name = atts.getValue("Name");
        int id = this.get_IDWithColumn(ctx, "AD_PrintFormat", "Name", name);
        X_AD_PrintFormat m_PrintFormat = new X_AD_PrintFormat(ctx, id, this.getTrxName(ctx));
        if (id <= 0 && atts.getValue("AD_PrintFormat_ID") != null && Integer.parseInt(atts.getValue("AD_PrintFormat_ID")) <= 999999) {
            m_PrintFormat.setAD_PrintFormat_ID(Integer.parseInt(atts.getValue("AD_PrintFormat_ID")));
        }
        if (id > 0) {
            AD_Backup_ID = this.copyRecord(ctx, "AD_PrintFormat", m_PrintFormat);
            Object_Status = "Update";
        } else {
            Object_Status = "New";
            AD_Backup_ID = 0;
        }
        name = atts.getValue("ADReportviewnameID");
        if (name != null && name.trim().length() > 0) {
            id = this.get_IDWithColumn(ctx, "AD_ReportView", "Name", name);
            if (id <= 0) {
                element.defer = true;
                return;
            }
            m_PrintFormat.setAD_ReportView_ID(id);
        }
        if ((id = this.get_IDWithColumn(ctx, "AD_Table", "TableName", name = atts.getValue("ADTableNameID"))) == 0) {
            MTable m_Table = new MTable(ctx, 0, this.getTrxName(ctx));
            m_Table.setAccessLevel("3");
            m_Table.setName(name);
            m_Table.setTableName(name);
            if (m_Table.save(this.getTrxName(ctx))) {
                this.record_log(ctx, 1, m_Table.getName(), "Table", m_Table.get_ID(), 0, "New", "AD_Table", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Table"));
            } else {
                this.record_log(ctx, 0, m_Table.getName(), "Table", m_Table.get_ID(), 0, "New", "AD_Table", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Table"));
            }
            id = this.get_IDWithColumn(ctx, "AD_Table", "TableName", name);
        }
        m_PrintFormat.setAD_Table_ID(id);
        name = atts.getValue("ADPrintTableFormatID");
        if (name != null && name.trim().length() > 0) {
            id = this.get_IDWithColumn(ctx, "AD_PrintTableFormat", "Name", name);
            if (id <= 0) {
                element.defer = true;
                return;
            }
            m_PrintFormat.setAD_PrintTableFormat_ID(id);
        }
        if ((name = atts.getValue("ADPrintColorID")) != null && name.trim().length() > 0) {
            id = this.get_IDWithColumn(ctx, "AD_PrintColor", "Name", name);
            if (id <= 0) {
                element.defer = true;
                return;
            }
            m_PrintFormat.setAD_PrintColor_ID(id);
        }
        if ((name = atts.getValue("ADPrintFontID")) != null && name.trim().length() > 0) {
            id = this.get_IDWithColumn(ctx, "AD_PrintFont", "Name", name);
            if (id <= 0) {
                element.defer = true;
                return;
            }
            m_PrintFormat.setAD_PrintFont_ID(id);
        }
        if ((name = atts.getValue("ADPrintPaperID")) != null && name.trim().length() > 0) {
            id = this.get_IDWithColumn(ctx, "AD_PrintPaper", "Name", name);
            if (id <= 0) {
                element.defer = true;
                return;
            }
            m_PrintFormat.setAD_PrintPaper_ID(id);
        }
        m_PrintFormat.setDescription(this.getStringValue(atts, "Description"));
        m_PrintFormat.setName(atts.getValue("Name"));
        m_PrintFormat.setPrinterName(this.getStringValue(atts, "PrinterName"));
        m_PrintFormat.setFooterMargin(Integer.parseInt(atts.getValue("FooterMargin")));
        m_PrintFormat.setHeaderMargin(Integer.parseInt(atts.getValue("HeaderMargin")));
        m_PrintFormat.setCreateCopy(atts.getValue("CreateCopy"));
        m_PrintFormat.setIsActive(atts.getValue("isActive") != null ? Boolean.valueOf(atts.getValue("isActive")) : true);
        m_PrintFormat.setIsTableBased(Boolean.valueOf(atts.getValue("isTableBased")));
        m_PrintFormat.setIsForm(Boolean.valueOf(atts.getValue("isForm")));
        m_PrintFormat.setIsStandardHeaderFooter(Boolean.valueOf(atts.getValue("isStandardHeader")));
        m_PrintFormat.setIsDefault(Boolean.valueOf(atts.getValue("isDefault")));
        if (!m_PrintFormat.save(this.getTrxName(ctx))) {
            this.record_log(ctx, 0, m_PrintFormat.getName(), "PrintFormat", m_PrintFormat.get_ID(), AD_Backup_ID, Object_Status, "AD_PrintFormat", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_PrintFormat"));
            throw new POSaveFailedException("Failed to save Print Format");
        }
        this.record_log(ctx, 1, m_PrintFormat.getName(), "PrintFormat", m_PrintFormat.get_ID(), AD_Backup_ID, Object_Status, "AD_PrintFormat", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_PrintFormat"));
        element.recordId = m_PrintFormat.getAD_PrintFormat_ID();
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        int AD_PrintFormat_ID = Env.getContextAsInt(ctx, "AD_PrintFormat_ID");
        PackOut packOut = (PackOut)ctx.get("PackOutProcess");
        if (this.formats.contains(AD_PrintFormat_ID)) {
            return;
        }
        this.formats.add(AD_PrintFormat_ID);
        AttributesImpl atts = new AttributesImpl();
        String sql = null;
        sql = "SELECT AD_PrintFormat_ID FROM AD_PrintFormat WHERE (AD_PrintFormat_ID IN (SELECT AD_PrintFormatChild_ID FROM AD_PrintFormatItem WHERE AD_PrintFormat_ID = " + AD_PrintFormat_ID + " AND PrintFormatType = 'P' GROUP BY AD_PrintFormatChild_ID) OR AD_PrintFormat_ID = " + AD_PrintFormat_ID + ")";
        CPreparedStatement pstmt = null;
        pstmt = DB.prepareStatement(sql, this.getTrxName(ctx));
        try {
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_AD_PrintFormat m_Printformat = new X_AD_PrintFormat(ctx, rs.getInt("AD_PrintFormat_ID"), null);
                if (m_Printformat.getAD_PrintPaper_ID() > 0) {
                    packOut.createPrintPaper(m_Printformat.getAD_PrintPaper_ID(), document);
                }
                this.createPrintFormatBinding(atts, m_Printformat);
                document.startElement("", "", "printformat", atts);
                String sql2 = "SELECT * FROM AD_PrintFormatItem WHERE AD_PrintFormat_ID= " + m_Printformat.getAD_PrintFormat_ID() + " ORDER BY " + "SeqNo" + "," + "AD_PrintFormatItem_ID";
                CPreparedStatement pstmt2 = null;
                pstmt2 = DB.prepareStatement(sql2, this.getTrxName(ctx));
                try {
                    ResultSet rs2 = pstmt2.executeQuery();
                    while (rs2.next()) {
                        this.createItem(ctx, document, rs2.getInt("AD_PrintFormatItem_ID"));
                    }
                    rs2.close();
                    pstmt2.close();
                    pstmt2 = null;
                }
                finally {
                    try {
                        if (pstmt2 != null) {
                            pstmt2.close();
                        }
                    }
                    catch (Exception e) {}
                    pstmt2 = null;
                }
                document.endElement("", "", "printformat");
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getLocalizedMessage(), e);
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            if (e instanceof SQLException) {
                throw new DatabaseAccessException("Failed to export print format.", e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Failed to export print format.", e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
    }

    private void createItem(Properties ctx, TransformerHandler document, int AD_PrintFormatItem_ID) throws SAXException {
        Env.setContext(ctx, "AD_PrintFormatItem_ID", AD_PrintFormatItem_ID);
        this.itemHandler.create(ctx, document);
        ctx.remove("AD_PrintFormatItem_ID");
    }

    private AttributesImpl createPrintFormatBinding(AttributesImpl atts, X_AD_PrintFormat m_Printformat) {
        String sql = null;
        String name = null;
        atts.clear();
        if (m_Printformat.getAD_PrintFormat_ID() <= 999999) {
            atts.addAttribute("", "", "AD_PrintFormat_ID", "CDATA", Integer.toString(m_Printformat.getAD_PrintFormat_ID()));
        }
        if (m_Printformat.getAD_ReportView_ID() > 0) {
            sql = "SELECT Name FROM AD_ReportView WHERE AD_ReportView_ID=?";
            name = DB.getSQLValueString(null, sql, m_Printformat.getAD_ReportView_ID());
            atts.addAttribute("", "", "ADReportviewnameID", "CDATA", name);
        } else {
            atts.addAttribute("", "", "ADReportviewnameID", "CDATA", "");
        }
        if (m_Printformat.getAD_Table_ID() > 0) {
            sql = "SELECT TableName FROM AD_Table WHERE AD_Table_ID=?";
            name = DB.getSQLValueString(null, sql, m_Printformat.getAD_Table_ID());
            atts.addAttribute("", "", "ADTableNameID", "CDATA", name);
        } else {
            atts.addAttribute("", "", "ADTableNameID", "CDATA", "");
        }
        if (m_Printformat.getAD_PrintTableFormat_ID() > 0) {
            sql = "SELECT Name FROM AD_PrintTableFormat WHERE AD_PrintTableFormat_ID=?";
            name = DB.getSQLValueString(null, sql, m_Printformat.getAD_PrintTableFormat_ID());
            atts.addAttribute("", "", "ADPrintTableFormatID", "CDATA", name);
        } else {
            atts.addAttribute("", "", "ADPrintTableFormatID", "CDATA", "");
        }
        if (m_Printformat.getAD_PrintColor_ID() > 0) {
            sql = "SELECT Name FROM AD_PrintColor WHERE AD_PrintColor_ID=?";
            name = DB.getSQLValueString(null, sql, m_Printformat.getAD_PrintColor_ID());
            atts.addAttribute("", "", "ADPrintColorID", "CDATA", name);
        } else {
            atts.addAttribute("", "", "ADPrintColorID", "CDATA", "");
        }
        if (m_Printformat.getAD_PrintFont_ID() > 0) {
            sql = "SELECT Name FROM AD_PrintFont WHERE AD_PrintFont_ID=?";
            name = DB.getSQLValueString(null, sql, m_Printformat.getAD_PrintFont_ID());
            atts.addAttribute("", "", "ADPrintFontID", "CDATA", name);
        } else {
            atts.addAttribute("", "", "ADPrintFontID", "CDATA", "");
        }
        if (m_Printformat.getAD_PrintPaper_ID() > 0) {
            sql = "SELECT Name FROM AD_PrintPaper WHERE AD_PrintPaper_ID=?";
            name = DB.getSQLValueString(null, sql, m_Printformat.getAD_PrintPaper_ID());
            atts.addAttribute("", "", "ADPrintPaperID", "CDATA", name);
        } else {
            atts.addAttribute("", "", "ADPrintPaperID", "CDATA", "");
        }
        atts.addAttribute("", "", "Description", "CDATA", m_Printformat.getDescription() != null ? m_Printformat.getDescription() : "");
        atts.addAttribute("", "", "Name", "CDATA", m_Printformat.getName() != null ? m_Printformat.getName() : "");
        atts.addAttribute("", "", "PrinterName", "CDATA", m_Printformat.getPrinterName() != null ? m_Printformat.getPrinterName() : "");
        atts.addAttribute("", "", "FooterMargin", "CDATA", "" + m_Printformat.getFooterMargin());
        atts.addAttribute("", "", "HeaderMargin", "CDATA", "" + m_Printformat.getHeaderMargin());
        atts.addAttribute("", "", "CreateCopy", "CDATA", m_Printformat.getCreateCopy() != null ? m_Printformat.getCreateCopy() : "");
        atts.addAttribute("", "", "isActive", "CDATA", m_Printformat.isActive() ? "true" : "false");
        atts.addAttribute("", "", "isTableBased", "CDATA", m_Printformat.isTableBased() ? "true" : "false");
        atts.addAttribute("", "", "isForm", "CDATA", m_Printformat.isForm() ? "true" : "false");
        atts.addAttribute("", "", "isStandardHeader", "CDATA", m_Printformat.isStandardHeaderFooter() ? "true" : "false");
        atts.addAttribute("", "", "isDefault", "CDATA", m_Printformat.isDefault() ? "true" : "false");
        return atts;
    }
}

