/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.compiere.model.MPreference;
import org.compiere.model.X_AD_Preference;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PreferenceElementHandler
extends AbstractElementHandler {
    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        String elementValue = element.getElementValue();
        this.log.info(elementValue);
        Attributes atts = element.attributes;
        int windowid = this.get_ID(ctx, "AD_Window", atts.getValue("ADWindowNameID"));
        if (windowid <= 0) {
            element.defer = true;
            return;
        }
        StringBuffer sqlB = new StringBuffer("select AD_Preference_ID from AD_Preference where ").append(" Attribute = '" + atts.getValue("Attribute") + "'").append(" and AD_Window_ID = ?");
        int id = DB.getSQLValue(this.getTrxName(ctx), sqlB.toString(), windowid);
        MPreference m_Preference = new MPreference(ctx, id, this.getTrxName(ctx));
        int AD_Backup_ID = -1;
        String Object_Status = null;
        if (id <= 0 && atts.getValue("AD_Preference_ID") != null && Integer.parseInt(atts.getValue("AD_Preference_ID")) <= 999999) {
            m_Preference.setAD_Preference_ID(Integer.parseInt(atts.getValue("AD_Preference_ID")));
        }
        if (id > 0) {
            AD_Backup_ID = this.copyRecord(ctx, "AD_Preference", m_Preference);
            Object_Status = "Update";
        } else {
            Object_Status = "New";
            AD_Backup_ID = 0;
        }
        sqlB = null;
        m_Preference.setAD_Window_ID(windowid);
        m_Preference.setAttribute(atts.getValue("Attribute"));
        m_Preference.setValue(atts.getValue("Value"));
        if (!m_Preference.save(this.getTrxName(ctx))) {
            this.record_log(ctx, 0, m_Preference.getAttribute(), "Preference", m_Preference.get_ID(), AD_Backup_ID, Object_Status, "AD_Preference", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Preference"));
            throw new POSaveFailedException("Failed to save Preference");
        }
        this.record_log(ctx, 1, m_Preference.getAttribute(), "Preference", m_Preference.get_ID(), AD_Backup_ID, Object_Status, "AD_Preference", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Preference"));
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        int AD_Preference_ID = Env.getContextAsInt(ctx, "AD_Preference_ID");
        X_AD_Preference m_Preference = new X_AD_Preference(ctx, AD_Preference_ID, this.getTrxName(ctx));
        AttributesImpl atts = new AttributesImpl();
        this.createPreferenceBinding(atts, m_Preference);
        document.startElement("", "", "preference", atts);
        document.endElement("", "", "preference");
    }

    private AttributesImpl createPreferenceBinding(AttributesImpl atts, X_AD_Preference m_Preference) {
        String sql = null;
        String name = null;
        atts.clear();
        if (m_Preference.getAD_Preference_ID() <= 999999) {
            atts.addAttribute("", "", "AD_Preference_ID", "CDATA", Integer.toString(m_Preference.getAD_Preference_ID()));
        }
        sql = "SELECT Name FROM AD_Window WHERE AD_Window_ID=?";
        name = DB.getSQLValueString(null, sql, m_Preference.getAD_Window_ID());
        atts.addAttribute("", "", "ADWindowNameID", "CDATA", name);
        sql = "SELECT Name FROM AD_User WHERE AD_User_ID=?";
        name = DB.getSQLValueString(null, sql, m_Preference.getAD_User_ID());
        atts.addAttribute("", "", "ADUserNameID", "CDATA", name);
        atts.addAttribute("", "", "Attribute", "CDATA", m_Preference.getAttribute());
        atts.addAttribute("", "", "Value", "CDATA", m_Preference.getValue());
        return atts;
    }
}

